/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.options.ColoringBean;
import org.netbeans.modules.editor.options.ColoringEditorPanel;

public class ColoringEditor
extends PropertyEditorSupport {
    private ColoringEditorPanel editor;

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
        throw new IllegalArgumentException();
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.editor != null) {
            this.editor.setValue((ColoringBean)this.getValue());
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ColoringEditorPanel();
            this.editor.setValue((ColoringBean)this.getValue());
            this.editor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "value") {
                        ColoringEditor.this.superSetValue(ColoringEditor.this.editor.getValue());
                    }
                }
            });
        }
        return this.editor;
    }

    void superSetValue(Object object) {
        super.setValue(object);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Coloring coloring = this.getAppliedColoring();
        if (coloring != null) {
            graphics.setColor(coloring.getBackColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(coloring.getForeColor());
            graphics.setFont(coloring.getFont());
            String string = ((ColoringBean)this.getValue()).example;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = Math.max((rectangle.width - fontMetrics.stringWidth(string)) / 2, 0);
            int n2 = Math.max((rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent(), 0);
            graphics.drawString(string, n, n2);
        }
    }

    private Coloring getAppliedColoring() {
        ColoringBean coloringBean = (ColoringBean)this.getValue();
        if (coloringBean == null) {
            return null;
        }
        Coloring coloring = coloringBean.defaultColoring;
        Coloring coloring2 = coloringBean.coloring;
        Coloring coloring3 = null;
        if (coloring != null && coloring2 != null) {
            coloring3 = coloring2.apply(coloring);
        }
        return coloring3;
    }
}

