/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.editor.options.ColoringBean;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.NbBundle;

public class ColoringEditorPanel
extends JPanel {
    public static final String PROP_COLORING = "Coloring";
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$options$ColoringEditorPanel == null ? (class$org$netbeans$modules$editor$options$ColoringEditorPanel = ColoringEditorPanel.class$("org.netbeans.modules.editor.options.ColoringEditorPanel")) : class$org$netbeans$modules$editor$options$ColoringEditorPanel));
    private ColoringBean value = new ColoringBean(SettingsDefaults.defaultColoring, "null", SettingsDefaults.defaultColoring, true);
    private PropWithDefaultPanel fontPanel;
    private PropWithDefaultPanel fgColorPanel;
    private PropWithDefaultPanel bgColorPanel;
    private ColoringPreview preview;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$ColoringEditorPanel;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FontEditor;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ColorEditor;

    public ColoringEditorPanel() {
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.fontPanel = new PropWithDefaultPanel(class$java$awt$Font == null ? (class$java$awt$Font = ColoringEditorPanel.class$("java.awt.Font")) : class$java$awt$Font, class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor, bundle.getString("CEP_FontTitle"), bundle.getString("ACSD_CEP_Font"), bundle.getString("CEP_FontTrans"), bundle.getString("CEP_FontTrans_Mnemonic").charAt(0), bundle.getString("ACSD_CEP_FontTrans"));
        this.fontPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("RealValue".equals(propertyChangeEvent.getPropertyName())) {
                    Font font = (Font)ColoringEditorPanel.this.fontPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeFont(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, font));
                }
            }
        });
        this.add((Component)this.fontPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.fgColorPanel = new PropWithDefaultPanel(class$java$awt$Color == null ? (class$java$awt$Color = ColoringEditorPanel.class$("java.awt.Color")) : class$java$awt$Color, class$org$netbeans$beaninfo$editors$ColorEditor == null ? (class$org$netbeans$beaninfo$editors$ColorEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.ColorEditor")) : class$org$netbeans$beaninfo$editors$ColorEditor, bundle.getString("CEP_FgTitle"), bundle.getString("ACSD_CEP_Fg"), bundle.getString("CEP_FgTrans"), bundle.getString("CEP_FgTrans_Mnemonic").charAt(0), bundle.getString("ACSD_CEP_FgTrans"));
        this.fgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("RealValue".equals(propertyChangeEvent.getPropertyName())) {
                    Color color = (Color)ColoringEditorPanel.this.fgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeForeColor(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, color));
                }
            }
        });
        this.add((Component)this.fgColorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.bgColorPanel = new PropWithDefaultPanel(class$java$awt$Color == null ? (class$java$awt$Color = ColoringEditorPanel.class$("java.awt.Color")) : class$java$awt$Color, class$org$netbeans$beaninfo$editors$ColorEditor == null ? (class$org$netbeans$beaninfo$editors$ColorEditor = ColoringEditorPanel.class$("org.netbeans.beaninfo.editors.ColorEditor")) : class$org$netbeans$beaninfo$editors$ColorEditor, bundle.getString("CEP_BgTitle"), bundle.getString("ACSD_CEP_Bg"), bundle.getString("CEP_BgTrans"), bundle.getString("CEP_BgTrans_Mnemonic").charAt(0), bundle.getString("ACSD_CEP_BgTrans"));
        this.bgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("RealValue".equals(propertyChangeEvent.getPropertyName())) {
                    Color color = (Color)ColoringEditorPanel.this.bgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeBackColor(((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, color));
                }
            }
        });
        this.add((Component)this.bgColorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CEP_PreviewTitle")), new EmptyBorder(new Insets(9, 12, 11, 11))));
        this.preview = new ColoringPreview();
        this.preview.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CEP_Preview"));
        this.preview.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CEP_Preview"));
        jPanel.add(this.preview);
        this.add((Component)jPanel, gridBagConstraints);
        this.updateEditors();
        Dimension dimension = this.getPreferredSize();
        dimension.width *= 2;
        dimension.height = (int)((double)dimension.height * 1.4);
        this.setPreferredSize(dimension);
    }

    public ColoringBean getValue() {
        return this.value;
    }

    public void setValue(ColoringBean coloringBean) {
        if (coloringBean == null || coloringBean.coloring == null) {
            return;
        }
        if (this.value != coloringBean) {
            this.value = coloringBean;
            this.updateEditors();
            this.preview.setValue(coloringBean);
            this.firePropertyChange("value", null, null);
        }
    }

    private void setValueImpl(Coloring coloring) {
        this.value = this.value.changeColoring(coloring);
        this.preview.setValue(this.value);
        this.firePropertyChange("value", null, null);
    }

    private void updateEditors() {
        if (this.value == null) {
            return;
        }
        this.fontPanel.setValue(this.value.coloring.getFont());
        this.fontPanel.setDefaultValue(this.value.defaultColoring.getFont());
        this.fontPanel.setDefault(this.value.isDefault);
        this.fgColorPanel.setValue(this.value.coloring.getForeColor());
        this.fgColorPanel.setDefaultValue(this.value.defaultColoring.getForeColor());
        this.fgColorPanel.setDefault(this.value.isDefault);
        this.bgColorPanel.setValue(this.value.coloring.getBackColor());
        this.bgColorPanel.setDefaultValue(this.value.defaultColoring.getBackColor());
        this.bgColorPanel.setDefault(this.value.isDefault);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PropWithDefaultPanel
    extends JPanel {
        public static final String PROP_VALUE = "RealValue";
        Object value;
        Object defaultValue;
        PropertyModel model;
        JCheckBox defaultCheckBox;

        public PropWithDefaultPanel(Class clazz, Class clazz2, String string, String string2, String string3, char c, String string4) {
            this.setLayout(new BorderLayout());
            this.setBorder(new CompoundBorder(new TitledBorder(string), new EmptyBorder(new Insets(8, 12, 6, 11))));
            this.model = new PropertyModelSupport(clazz, clazz2);
            this.model.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ PropWithDefaultPanel this$0;
                {
                    this.this$0 = propWithDefaultPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("value".equals(propertyChangeEvent.getPropertyName())) {
                        Object object;
                        block4: {
                            object = null;
                            try {
                                object = this.this$0.model.getValue();
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                if (!Boolean.getBoolean("org.netbeans.exceptions")) break block4;
                                invocationTargetException.printStackTrace();
                            }
                        }
                        if (this.this$0.value == null && object.equals(this.this$0.defaultValue)) {
                            return;
                        }
                        this.this$0.value = object;
                        this.this$0.defaultCheckBox.setSelected(false);
                        this.this$0.firePropertyChange("RealValue", null, null);
                        this.this$0.repaint();
                    }
                }
            });
            PropertyPanel propertyPanel = new PropertyPanel(this.model, 0);
            propertyPanel.getAccessibleContext().setAccessibleName(string);
            propertyPanel.getAccessibleContext().setAccessibleDescription(string2);
            this.add((Component)propertyPanel, "Center");
            this.defaultCheckBox = new JCheckBox();
            this.defaultCheckBox.setText(string3);
            this.defaultCheckBox.setMnemonic(c);
            this.defaultCheckBox.getAccessibleContext().setAccessibleDescription(string4);
            this.defaultCheckBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropWithDefaultPanel this$0;
                {
                    this.this$0 = propWithDefaultPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!this.this$0.defaultCheckBox.isSelected()) {
                        this.this$0.value = this.this$0.defaultValue;
                    } else {
                        this.this$0.value = null;
                        PropWithDefaultPanel.access$600(this.this$0, this.this$0.defaultValue);
                        this.this$0.firePropertyChange("RealValue", null, null);
                    }
                }
            });
            this.add((Component)this.defaultCheckBox, "South");
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        public void setValue(Object object) {
            this.value = object;
            if (object == null) {
                this.modelSetValue(this.defaultValue);
                this.defaultCheckBox.setSelected(true);
            } else {
                this.modelSetValue(object);
                this.defaultCheckBox.setSelected(false);
            }
        }

        Object getValue() {
            return this.value;
        }

        public void setDefaultValue(Object object) {
            this.defaultValue = object;
            if (this.value == null) {
                this.modelSetValue(this.defaultValue);
            }
        }

        public void setDefault(boolean bl) {
            this.defaultCheckBox.setEnabled(!bl);
            if (bl) {
                this.defaultCheckBox.setSelected(false);
            }
        }

        private void modelSetValue(Object object) {
            block2: {
                try {
                    this.model.setValue(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!Boolean.getBoolean("org.netbeans.exceptions")) break block2;
                    invocationTargetException.printStackTrace();
                }
            }
            this.repaint();
        }

        static /* synthetic */ void access$600(PropWithDefaultPanel propWithDefaultPanel, Object object) {
            propWithDefaultPanel.modelSetValue(object);
        }

        private class PropertyModelSupport
        implements PropertyModel {
            public static final String PROP_MOD_VALUE = "value";
            private PropertyChangeSupport support = new PropertyChangeSupport(this);
            Class type;
            Class editor;
            Object value;

            public PropertyModelSupport(Class clazz, Class clazz2) {
                this.type = clazz;
                this.editor = clazz2;
            }

            public Class getPropertyType() {
                return this.type;
            }

            public Class getPropertyEditorClass() {
                return this.editor;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object object) {
                if (object != null && !object.equals(this.value)) {
                    this.value = object;
                    this.support.firePropertyChange(PROP_MOD_VALUE, null, null);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.support.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.support.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private class ColoringPreview
    extends JComponent
    implements Accessible {
        ColoringBean value;

        private ColoringPreview() {
        }

        void setValue(ColoringBean coloringBean) {
            this.value = coloringBean;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.value != null) {
                Coloring coloring = this.value.coloring.apply(this.value.defaultColoring);
                Rectangle rectangle = this.getBounds();
                graphics.setColor(coloring.getBackColor());
                graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(coloring.getForeColor());
                graphics.setFont(coloring.getFont());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = Math.max((rectangle.width - fontMetrics.stringWidth(this.value.example)) / 2, 0);
                int n2 = Math.max((rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent(), 0);
                graphics.drawString(this.value.example, n, n2);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(this){
                    private final /* synthetic */ ColoringPreview this$1;
                    {
                        this.this$1 = coloringPreview;
                    }

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.PANEL;
                    }
                };
            }
            return this.accessibleContext;
        }
    }
}

