/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEProcessor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class MIMEOptionFile {
    protected BaseOptions base;
    protected MIMEProcessor processor;
    protected Document dom;
    protected Map properties;
    private boolean loaded = false;
    private boolean wasSaved = false;
    private ModuleInfo editorMI;
    private final FileChangeListener fileListener = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            MIMEOptionFile.this.reloadSettings();
        }
    };
    private final PropertyChangeListener moduleListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"enabled".endsWith(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof ModuleInfo)) {
                return;
            }
            if ((ModuleInfo)propertyChangeEvent.getSource() != null && !((ModuleInfo)propertyChangeEvent.getSource()).isEnabled()) {
                MIMEOptionFile.this.editorUninstalled();
            }
        }
    };
    private final ErrorCatcher ERROR_CATCHER = new ErrorCatcher();
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    public MIMEOptionFile(BaseOptions baseOptions, Object object) {
        this.base = baseOptions;
        this.processor = (MIMEProcessor)object;
        try {
            this.properties = new HashMap();
            this.dom = this.processor.getXMLDataObject().getDocument();
            this.processor.getXMLDataObject().getPrimaryFile().addFileChangeListener(this.fileListener);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addEditorModuleListener();
    }

    private void addEditorModuleListener() {
        Lookup.Template template = new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = MIMEOptionFile.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            if (!"org.netbeans.modules.editor".equals(moduleInfo.getCodeNameBase())) continue;
            moduleInfo.addPropertyChangeListener(this.moduleListener);
            this.editorMI = moduleInfo;
            break;
        }
    }

    private void editorUninstalled() {
        block2: {
            this.processor.getXMLDataObject().getPrimaryFile().removeFileChangeListener(this.fileListener);
            try {
                this.processor.getXMLDataObject().setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                propertyVetoException.printStackTrace();
            }
        }
        this.editorMI.removePropertyChangeListener(this.moduleListener);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public synchronized void reloadSettings() {
        if (this.wasSaved) {
            this.wasSaved = false;
            return;
        }
        Document document = this.dom;
        this.setLoaded(false);
        try {
            String string = this.processor.getXMLDataObject().getPrimaryFile().getURL().toExternalForm();
            this.dom = XMLUtil.parse((InputSource)new InputSource(string), (boolean)true, (boolean)false, (ErrorHandler)this.ERROR_CATCHER, (EntityResolver)EntityCatalog.getDefault());
            this.loadSettings();
        }
        catch (SAXException sAXException) {
            this.dom = document;
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            this.dom = document;
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void saveSettings(Document document) {
        try {
            FileLock fileLock = this.processor.getXMLDataObject().getPrimaryFile().lock();
            try {
                try {
                    block11: {
                        OutputStream outputStream = this.processor.getXMLDataObject().getPrimaryFile().getOutputStream(fileLock);
                        try {
                            try {
                                this.wasSaved = true;
                                XMLUtil.write((Document)document, (OutputStream)outputStream, null);
                                outputStream.flush();
                            }
                            catch (Exception exception) {
                                this.wasSaved = false;
                                exception.printStackTrace();
                                Object var6_7 = null;
                                outputStream.close();
                                break block11;
                            }
                            Object var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            outputStream.close();
                            throw throwable;
                        }
                        outputStream.close();
                    }
                    Object var8_11 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var8_12 = null;
                    fileLock.releaseLock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected abstract void loadSettings(boolean var1);

    protected void loadSettings() {
        this.loadSettings(true);
    }

    protected abstract void updateSettings(Map var1);

    public Map getAllProperties() {
        if (!this.isLoaded()) {
            this.loadSettings(false);
        }
        return this.properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            System.err.println("Error level:" + string);
            System.err.println("Line number:" + sAXParseException.getLineNumber());
            System.err.println("Column number:" + sAXParseException.getColumnNumber());
            System.err.println("Public ID:" + sAXParseException.getPublicId());
            System.err.println("System ID:" + sAXParseException.getSystemId());
            System.err.println("Error message:" + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            this.message("ERROR", sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.message("WARNING", sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.message("FATAL", sAXParseException);
        }
    }
}

