/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.options.MacroInputPanel;
import org.netbeans.modules.editor.options.MacrosEditor;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MacrosEditorPanel
extends JPanel {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$options$MacrosEditorPanel == null ? (class$org$netbeans$modules$editor$options$MacrosEditorPanel = MacrosEditorPanel.class$("org.netbeans.modules.editor.options.MacrosEditorPanel")) : class$org$netbeans$modules$editor$options$MacrosEditorPanel));
    PairStringModel model;
    private MacrosEditor editor;
    private JButton addButton;
    private JTable macrosTable;
    private JButton editButton;
    private JScrollPane macrosPane;
    private JButton removeButton;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$MacrosEditorPanel;

    public MacrosEditorPanel(MacrosEditor macrosEditor) {
        this.editor = macrosEditor;
        this.model = new PairStringModel();
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MEP"));
        this.macrosTable.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_MEP_Table"));
        this.macrosTable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MEP_Table"));
        this.addButton.setMnemonic(bundle.getString("MEP_Add_Mnemonic").charAt(0));
        this.editButton.setMnemonic(bundle.getString("MEP_Edit_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(bundle.getString("MEP_Remove_Mnemonic").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MEP_Add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MEP_Edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MEP_Remove"));
    }

    public void setValue(Map map) {
        HashMap hashMap = new HashMap(map);
        if (hashMap.containsKey(null)) {
            hashMap.remove(null);
        }
        this.model.setData(new TreeMap(hashMap));
        if (this.model.getRowCount() > 0) {
            this.macrosTable.setRowSelectionInterval(0, 0);
        }
    }

    public Map getValue() {
        return this.model.getData();
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void initComponents() {
        this.macrosPane = new JScrollPane();
        this.macrosTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.macrosTable.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.macrosTable.setModel(this.model);
        this.macrosTable.setShowVerticalLines(false);
        this.macrosTable.setShowHorizontalLines(false);
        this.macrosTable.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.macrosTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(3000);
        tableColumnModel.getColumn(0).setPreferredWidth(30);
        tableColumnModel.getColumn(1).setMaxWidth(7000);
        tableColumnModel.getColumn(1).setPreferredWidth(70);
        this.macrosPane.setViewportView(this.macrosTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.macrosPane, gridBagConstraints);
        this.addButton.setText(bundle.getString("MEP_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setText(bundle.getString("MEP_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(bundle.getString("MEP_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getMacro(null);
        if (stringArray == null) {
            return;
        }
        int n = this.model.putPair(stringArray);
        this.macrosTable.setRowSelectionInterval(n, n);
        this.notifyEditor();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.macrosTable.getSelectedRow();
        if (n != -1) {
            String[] stringArray = this.model.getPair(n);
            if ((stringArray = this.getMacro(stringArray)) != null) {
                this.model.removePair(n);
                n = this.model.putPair(stringArray);
                this.macrosTable.setRowSelectionInterval(n, n);
                this.notifyEditor();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.macrosTable.getSelectedRow();
        if (n != -1) {
            this.model.removePair(n);
            if (n >= this.model.getRowCount()) {
                --n;
            }
            if (n >= 0) {
                this.macrosTable.setRowSelectionInterval(n, n);
            }
            this.notifyEditor();
        }
    }

    private String[] getMacro(String[] stringArray) {
        String[] stringArray2;
        MacroInputPanel macroInputPanel = new MacroInputPanel();
        HelpCtx.setHelpIDString((JComponent)macroInputPanel, HelpCtx.findHelp((Component)this) != null ? HelpCtx.findHelp((Component)this).getHelpID() : null);
        if (stringArray != null) {
            macroInputPanel.setMacro(stringArray);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)macroInputPanel, bundle.getString("MEP_EnterMacro"));
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        macroInputPanel.requestFocus();
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && !"".equals((stringArray2 = macroInputPanel.getMacro())[0])) {
            return stringArray2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ResourceBundle access$300() {
        return bundle;
    }

    private class PairStringModel
    extends AbstractTableModel {
        String[] columns = new String[]{MacrosEditorPanel.access$300().getString("MEP_MacroTitle"), MacrosEditorPanel.access$300().getString("MEP_ExpandTitle")};
        TreeMap data = new TreeMap();
        String[] keys = new String[0];

        public void setData(TreeMap treeMap) {
            this.data = treeMap;
            this.updateKeys();
        }

        private void updateKeys() {
            this.keys = this.data.keySet().toArray(new String[0]);
            this.fireTableDataChanged();
        }

        public TreeMap getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.keys[n];
            }
            return this.data.get(this.keys[n]);
        }

        public int putPair(String[] stringArray) {
            this.data.put(stringArray[0], stringArray[1]);
            this.updateKeys();
            return Arrays.binarySearch(this.keys, stringArray[0]);
        }

        public void removePair(int n) {
            this.data.remove(this.getValueAt(n, 0));
            this.updateKeys();
        }

        public String[] getPair(int n) {
            String string = (String)this.getValueAt(n, 0);
            String[] stringArray = new String[]{string, (String)this.data.get(string)};
            return stringArray;
        }
    }
}

