/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsThread;
import org.netbeans.modules.debugger.debug.ToolsThreadGroup;
import org.netbeans.modules.debugger.debug.ToolsVariable;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.MethodBreakpointEvent;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Protector;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;

public class MethodBreakpoint
extends MethodBreakpointEvent
implements StopEvent,
InfoProducer {
    static final long serialVersionUID = 4718302661899335262L;
    private transient List breakpoints;
    private transient RemoteThread thread;

    public CoreBreakpoint.Event getNewInstance() {
        return new MethodBreakpoint();
    }

    private RemoteField[] findMethodsByName(RemoteClass remoteClass, String string) throws Exception {
        String[] stringArray = remoteClass.getMethodNames();
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (stringArray[n3].equals(string)) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return new RemoteField[0];
        }
        if (n2 == 1) {
            RemoteField remoteField = remoteClass.getMethod(string);
            if (remoteField == null) {
                return new RemoteField[0];
            }
            return new RemoteField[]{remoteField};
        }
        RemoteField[] remoteFieldArray = remoteClass.getMethods();
        ArrayList<RemoteField> arrayList = new ArrayList<RemoteField>(n2);
        int n4 = remoteFieldArray.length;
        int n5 = 0;
        while (n5 < n4) {
            RemoteField remoteField = remoteFieldArray[n5];
            if (remoteField.getName().equals(string)) {
                arrayList.add(remoteField);
            }
            ++n5;
        }
        return arrayList.toArray(new RemoteField[0]);
    }

    private String[] findClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string = this.getClassName();
        arrayList.add(string);
        String string2 = Utils.getClassName((String)string);
        FileObject fileObject = TopManager.getDefault().getRepository().find(Utils.getPackageName((String)string), string2, "class");
        FileObject[] fileObjectArray = fileObject.getParent().getChildren();
        String string3 = string2 + '$';
        int n = string3.length();
        int n2 = fileObjectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4;
            if (fileObjectArray[n3].getExt().equals("class") && (string4 = fileObjectArray[n3].getName()).startsWith(string3) && !Character.isJavaIdentifierStart(string4.charAt(n))) {
                arrayList.add(fileObjectArray[n3].getPackageName('.'));
            }
            ++n3;
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof ToolsDebugger)) {
            return false;
        }
        final ToolsDebugger toolsDebugger = (ToolsDebugger)debugger;
        if (toolsDebugger.synchronizer == null) {
            return false;
        }
        if (this.breakpoints != null) {
            this.remove();
        }
        try {
            return (Boolean)new Protector("JavaDebugger.addBreakpoint"){
                static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsDebugger;

                public Object protect() throws Exception {
                    boolean bl = false;
                    String string = MethodBreakpoint.this.getMethodName();
                    String[] stringArray = MethodBreakpoint.this.getApplyToAnonymousInnerClasses() ? MethodBreakpoint.this.findClassNames() : new String[]{MethodBreakpoint.this.getClassName()};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RemoteField[] remoteFieldArray;
                        String string2 = stringArray[n2];
                        RemoteClass remoteClass = toolsDebugger.remoteDebugger.findClass(stringArray[n2]);
                        if (remoteClass != null && (remoteFieldArray = MethodBreakpoint.this.findMethodsByName(remoteClass, string)).length != 0) {
                            int n3 = remoteFieldArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String string3 = remoteClass.setBreakpointMethod(remoteFieldArray[n4]);
                                if (string3.length() == 0) {
                                    if (MethodBreakpoint.this.breakpoints == null) {
                                        MethodBreakpoint.this.breakpoints = new ArrayList(5);
                                    }
                                    MethodBreakpoint.this.breakpoints.add(new BreakpointInfo(remoteClass, remoteFieldArray[n4]));
                                    bl = true;
                                } else {
                                    toolsDebugger.getIOManager().println(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsDebugger == null ? 1.class$("org.netbeans.modules.debugger.debug.ToolsDebugger") : class$org$netbeans$modules$debugger$debug$ToolsDebugger)).getString("CTL_Cannot_set_breakpoint") + ": " + string3, 1);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    return new Boolean(bl);
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }.throwAndWait(toolsDebugger.synchronizer, toolsDebugger.killer);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void remove() {
        if (this.breakpoints == null) {
            return;
        }
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof ToolsDebugger)) {
            return;
        }
        final ToolsDebugger toolsDebugger = (ToolsDebugger)debugger;
        if (toolsDebugger.synchronizer == null) {
            return;
        }
        try {
            new Protector("JavaDebugger.addBreakpoint"){
                static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsDebugger;

                public Object protect() throws Exception {
                    Iterator iterator = MethodBreakpoint.this.breakpoints.iterator();
                    while (iterator.hasNext()) {
                        BreakpointInfo breakpointInfo = (BreakpointInfo)iterator.next();
                        String string = breakpointInfo.clazz.clearBreakpointMethod(breakpointInfo.method);
                        if (string.length() > 0) {
                            toolsDebugger.getIOManager().println(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsDebugger == null ? 2.class$("org.netbeans.modules.debugger.debug.ToolsDebugger") : class$org$netbeans$modules$debugger$debug$ToolsDebugger)).getString("CTL_Cannot_clear_breakpoint") + ": " + string, 1);
                        }
                        breakpointInfo.clazz = null;
                        breakpointInfo.method = null;
                    }
                    MethodBreakpoint.this.breakpoints = null;
                    return null;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }.throwAndWait(toolsDebugger.synchronizer, toolsDebugger.killer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Line[] getLines() {
        return null;
    }

    public CoreBreakpoint.Action[] getActions() {
        CoreBreakpoint.Action[] actionArray = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_METHOD_TEXT)};
        CoreBreakpoint.Action[] actionArray2 = new CoreBreakpoint.Action[super.getActions().length + actionArray.length];
        System.arraycopy(super.getActions(), 0, actionArray2, 0, super.getActions().length);
        System.arraycopy(actionArray, 0, actionArray2, super.getActions().length, actionArray.length);
        return actionArray2;
    }

    public JavaThread getThread() {
        ToolsDebugger toolsDebugger = (ToolsDebugger)this.getDebugger();
        ToolsThread toolsThread = ((ToolsThreadGroup)toolsDebugger.getThreadsRoot()).getThread(this.thread);
        if (toolsThread != null) {
            return toolsThread;
        }
        toolsDebugger.lastCurrentThread = this.thread;
        return new ToolsThread((ToolsDebugger)this.getDebugger(), null, this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((ToolsThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        try {
            RemoteStackVariable remoteStackVariable = this.thread.getCurrentFrame().getLocalVariable("this");
            return new ToolsVariable((ToolsDebugger)this.getDebugger(), remoteStackVariable.getName(), remoteStackVariable.getValue(), remoteStackVariable.getType().toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void stop(boolean bl) {
        ((ToolsDebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    void perform(RemoteThread remoteThread) {
        this.thread = remoteThread;
        this.perform();
    }

    private static class BreakpointInfo {
        RemoteClass clazz;
        RemoteField method;

        public BreakpointInfo(RemoteClass remoteClass, RemoteField remoteField) {
            this.clazz = remoteClass;
            this.method = remoteField;
        }
    }
}

