/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.SocketException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.debug.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.debug.ToolsCallback;
import org.netbeans.modules.debugger.debug.ToolsDebugger11Info;
import org.netbeans.modules.debugger.debug.ToolsThread;
import org.netbeans.modules.debugger.debug.ToolsThreadGroup;
import org.netbeans.modules.debugger.debug.ToolsWatch;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.ProcessDebuggerType;
import org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction;
import org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Protector;
import org.netbeans.modules.debugger.support.util.RequestSynchronizer;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.debugger.Watch;
import org.openide.execution.NbProcessDescriptor;
import org.openide.text.Line;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import sun.tools.debug.DebuggerCallback;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteDebugger;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteThread;
import sun.tools.java.Type;

public class ToolsDebugger
extends JavaDebugger {
    static final long serialVersionUID = 2791375515739651906L;
    static ResourceBundle bundle = null;
    static final int TIMEOUT = 5000;
    transient RequestSynchronizer synchronizer;
    transient RemoteDebugger remoteDebugger = null;
    private transient Process process;
    private transient String hostName;
    private transient String password;
    private transient String mainClassName;
    private transient String stopClassName;
    private transient ToolsThread currentThread = null;
    transient RemoteThread lastCurrentThread = null;
    protected transient ToolsThreadGroup threadGroup = new ToolsThreadGroup(this, null);
    private transient Thread debuggerThread;
    private transient DebuggerInfo debuggerInfo;
    transient RequestSynchronizer.RequestWaiter killer = new RequestSynchronizer.RequestWaiter(){

        public void run(Thread thread) {
            if (ToolsDebugger.this.process != null) {
                if (System.getProperty("netbeans.full.hack") == null) {
                    ToolsDebugger.this.process.destroy();
                    thread.stop();
                }
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)new MessageFormat(ToolsDebugger.getLocString("EXC_Deadlock")).format(new Object[]{thread.getName()})));
            }
        }
    };
    transient boolean stopOnMainFlag;
    protected transient Breakpoint runToCursorBreakpoint;
    private transient boolean debuggerSuspended = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsDebugger;

    static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsDebugger == null ? (class$org$netbeans$modules$debugger$debug$ToolsDebugger = ToolsDebugger.class$("org.netbeans.modules.debugger.debug.ToolsDebugger")) : class$org$netbeans$modules$debugger$debug$ToolsDebugger));
        }
        return bundle.getString(string);
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        RemoteClass remoteClass;
        RemoteField[] remoteFieldArray;
        NbProcessDescriptor nbProcessDescriptor;
        String[] stringArray;
        boolean bl;
        this.debuggerInfo = debuggerInfo;
        if (this.remoteDebugger != null) {
            this.finishDebugger();
        }
        this.hostName = null;
        this.password = null;
        boolean bl2 = true;
        if (debuggerInfo instanceof ReconnectDebuggerInfo) {
            ReconnectDebuggerInfo reconnectDebuggerInfo = (ReconnectDebuggerInfo)debuggerInfo;
            this.hostName = reconnectDebuggerInfo.getHostName();
            this.password = reconnectDebuggerInfo.getPassword();
            bl2 = false;
        } else if (debuggerInfo instanceof RemoteDebuggerInfo) {
            this.hostName = ((RemoteDebuggerInfo)debuggerInfo).getHostName();
            this.password = ((RemoteDebuggerInfo)debuggerInfo).getPassword();
            bl2 = false;
        }
        this.stopOnMainFlag = bl = debuggerInfo.getStopClassName() != null;
        this.synchronizer = new RequestSynchronizer();
        if (!(debuggerInfo instanceof RemoteDebuggerInfo) && !this.compile(debuggerInfo)) {
            this.finishDebugger();
            return;
        }
        super.startDebugger(debuggerInfo);
        if (bl2) {
            stringArray = null;
            if (debuggerInfo instanceof ProcessDebuggerInfo) {
                nbProcessDescriptor = ((ProcessDebuggerInfo)debuggerInfo).getDebuggerProcess();
                stringArray = ((ProcessDebuggerInfo)debuggerInfo).getWorkingDirectory();
            } else {
                nbProcessDescriptor = ProcessDebuggerType.DEFAULT_DEBUGGER_PROCESS;
            }
            if (debuggerInfo instanceof ToolsDebugger11Info) {
                remoteFieldArray = ((ToolsDebugger11Info)debuggerInfo).getJavaHome();
                if (remoteFieldArray == null || remoteFieldArray.trim().length() == 0) {
                    this.finishDebugger();
                    throw new DebuggerException(ToolsDebugger.getLocString("EXC_JDK11_home_is_not_set"));
                }
                remoteClass = Utils.processDebuggerInfo((DebuggerInfo)debuggerInfo, (String)(Utilities.isWindows() ? "-debug -nojit" : "-debug"), (String)"sun.tools.debug.EmptyApp");
                remoteClass.put("jdk11.java.home", remoteFieldArray);
            } else {
                remoteClass = Utils.processDebuggerInfo((DebuggerInfo)debuggerInfo, (String)"-Xdebug", (String)"sun.tools.agent.EmptyApp");
            }
            remoteFieldArray = new MapFormat((Map)remoteClass);
            String string = remoteFieldArray.format(nbProcessDescriptor.getProcessName() + " " + nbProcessDescriptor.getArguments());
            this.getIOManager().println(string, 1);
            try {
                this.process = nbProcessDescriptor.exec((Format)remoteFieldArray, null, (File)stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                this.password = bufferedReader.readLine();
                this.getIOManager().showOutput(this.process, 2, 1);
                this.getIOManager().connectInput(this.process);
            }
            catch (Exception exception) {
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_While_create_debuggee")).format(new Object[]{remoteFieldArray.format(nbProcessDescriptor.getProcessName()), exception.toString()}), (Throwable)exception);
            }
            if (this.password == null) {
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_While_connect_to_debuggee")).format(new Object[]{remoteFieldArray.format(nbProcessDescriptor.getProcessName())}));
            }
            if (this.password.indexOf("=") < 0) {
                this.getIOManager().println(ToolsDebugger.getLocString("CTL_Unexpected_reply") + ": " + this.password, 1);
                this.getIOManager().showOutput(this.process, 3, 1);
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_Unecpected_debugger_reply")).format(new Object[]{this.password}));
            }
            this.password = this.password.substring(this.password.indexOf("=") + 1);
            this.getIOManager().println(ToolsDebugger.getLocString("CTL_Password") + ' ' + this.password, 1);
            this.hostName = "127.0.0.1";
        } else if (debuggerInfo instanceof ReconnectDebuggerInfo) {
            this.getIOManager().println(ToolsDebugger.getLocString("CTL_Reconnecting"), 3);
        } else {
            this.getIOManager().println(ToolsDebugger.getLocString("CTL_Connecting_to") + " " + this.hostName + ":" + this.password, 1);
        }
        try {
            this.remoteDebugger = new RemoteDebugger(this.hostName, this.password.length() < 1 ? null : this.password, (DebuggerCallback)new ToolsCallback(this), false);
        }
        catch (ConnectException connectException) {
            this.finishDebugger();
            throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_Cannot_connect_to_debuggee")).format(new Object[]{connectException.toString()}), (Throwable)connectException);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.finishDebugger();
            throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_Cannot_connect_to_debuggee")).format(new Object[]{throwable.toString()}), throwable);
        }
        this.mainClassName = debuggerInfo.getClassName();
        stringArray = null;
        if (this.mainClassName != null && this.mainClassName.length() > 0) {
            remoteClass = debuggerInfo.getArguments();
            stringArray = new String[((String[])remoteClass).length + 1];
            stringArray[0] = this.mainClassName;
            System.arraycopy(remoteClass, 0, stringArray, 1, ((RemoteClass)remoteClass).length);
            try {
                nbProcessDescriptor = this.remoteDebugger.findClass(this.mainClassName);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_Cannot_find_class")).format(new Object[]{this.mainClassName, throwable.toString()}), throwable);
            }
            if (nbProcessDescriptor == null) {
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_Cannot_find_class")).format(new Object[]{this.mainClassName, new ClassNotFoundException().toString()}));
            }
        }
        if (bl) {
            remoteClass = null;
            try {
                this.stopClassName = debuggerInfo.getStopClassName();
                remoteClass = this.remoteDebugger.findClass(this.stopClassName);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.getIOManager().println(ToolsDebugger.getLocString("MSG_Exc_while_finding_class") + this.stopClassName + '\n' + throwable, 1);
            }
            if (remoteClass == null) {
                this.getIOManager().println(ToolsDebugger.getLocString("CTL_No_such_class") + ": " + this.stopClassName, 1);
            } else {
                try {
                    remoteFieldArray = remoteClass.getMethods();
                    int n = remoteFieldArray.length;
                    Type type = Type.tMethod((Type)Type.tVoid, (Type[])new Type[]{Type.tArray((Type)Type.tString)});
                    Type type2 = Type.tMethod((Type)Type.tVoid);
                    RemoteField remoteField = null;
                    RemoteField remoteField2 = null;
                    RemoteField remoteField3 = null;
                    int n2 = 0;
                    while (n2 < n) {
                        if (remoteFieldArray[n2].getName().equals("main") && remoteFieldArray[n2].getType().equals(type)) break;
                        if (remoteFieldArray[n2].getName().equals("start") && remoteFieldArray[n2].getType().equals(type2)) {
                            remoteField = remoteFieldArray[n2];
                        } else if (remoteFieldArray[n2].getName().equals("init") && remoteFieldArray[n2].getType().equals(type2)) {
                            remoteField2 = remoteFieldArray[n2];
                        } else if (remoteFieldArray[n2].getName().equals("<init>") && remoteFieldArray[n2].getType().equals(type2)) {
                            remoteField3 = remoteFieldArray[n2];
                        }
                        ++n2;
                    }
                    if (n2 < n) {
                        remoteClass.setBreakpointMethod(remoteFieldArray[n2]);
                    } else if (remoteField2 != null) {
                        remoteClass.setBreakpointMethod(remoteField2);
                    } else if (remoteField != null) {
                        remoteClass.setBreakpointMethod(remoteField);
                    } else if (remoteField3 != null) {
                        remoteClass.setBreakpointMethod(remoteField3);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    this.getIOManager().println(ToolsDebugger.getLocString("MSG_Exc_while_setting_breakpoint") + '\n' + throwable, 1);
                }
            }
        }
        this.getIOManager().println(ToolsDebugger.getLocString("CTL_Debugger_running"), 4);
        this.setState(3);
        if (stringArray != null) {
            remoteClass = null;
            try {
                remoteClass = this.remoteDebugger.run(stringArray.length, stringArray);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_While_calling_run")).format(new Object[]{this.mainClassName, throwable.toString()}), throwable);
            }
            if (remoteClass == null) {
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(ToolsDebugger.getLocString("EXC_While_calling_run")).format(new Object[]{this.mainClassName, ""}));
            }
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.stop();
        }
        this.debuggerThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (ToolsDebugger.this.getState() != 3) continue;
                    try {
                        ToolsDebugger.this.threadGroup.threadChanged();
                        continue;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            if (throwable instanceof ThreadDeath) {
                                throw (ThreadDeath)throwable;
                            }
                            if (!(throwable instanceof SocketException)) continue;
                            ToolsDebugger.this.debuggerThread = null;
                            try {
                                ToolsDebugger.this.finishDebugger();
                            }
                            catch (Throwable throwable2) {
                                if (!(throwable2 instanceof ThreadDeath)) break block8;
                                throw (ThreadDeath)throwable2;
                            }
                        }
                        Thread.currentThread().stop();
                        continue;
                    }
                    break;
                }
            }
        }, "Debugger refresh thread");
        this.debuggerThread.setPriority(1);
        this.debuggerThread.start();
    }

    public void finishDebugger() throws DebuggerException {
        if (this.runToCursorBreakpoint != null) {
            this.runToCursorBreakpoint.remove();
        }
        this.threadGroup.setRemoteThreadGroup(null);
        if (this.remoteDebugger != null) {
            if (this.debuggerInfo instanceof RemoteDebuggerInfo) {
                try {
                    Breakpoint[] breakpointArray = TopManager.getDefault().getDebugger().getBreakpoints();
                    int n = 0;
                    while (n < breakpointArray.length) {
                        ((CoreBreakpoint)breakpointArray[n]).getEvent((Debugger)this).remove();
                        ++n;
                    }
                    this.remoteDebugger.cont();
                    this.setSuspended(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.threadGroup.setRemoteThreadGroup(null);
            this.remoteDebugger.close();
            this.remoteDebugger = null;
        }
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.interrupt();
            this.debuggerThread.stop();
        }
        super.finishDebugger();
        this.threadGroup.refreshStacks();
        this.debuggerSuspended = false;
        this.synchronizer = null;
    }

    public void traceInto() throws DebuggerException {
        if (this.currentThread == null) {
            return;
        }
        this.setLastAction(3);
        this.currentThread.setLastAction(3);
        new Protector("AbstractDebugger.traceInto"){

            public Object protect() throws Exception {
                ToolsDebugger.this.currentThread.getRemoteThread().step(true);
                ToolsDebugger.super.traceInto();
                return null;
            }
        }.go(this.synchronizer, this.killer);
    }

    public void traceOver() throws DebuggerException {
        if (this.currentThread == null) {
            return;
        }
        this.setLastAction(2);
        this.currentThread.setLastAction(2);
        new Protector("AbstractDebugger.traceOver"){

            public Object protect() throws Exception {
                ToolsDebugger.this.currentThread.getRemoteThread().next();
                ToolsDebugger.super.traceOver();
                return null;
            }
        }.go(this.synchronizer, this.killer);
    }

    public void go() throws DebuggerException {
        this.setLastAction(5);
        if (this.currentThread != null) {
            this.currentThread.setLastAction(5);
        }
        new Protector("AbstractDebugger.go"){

            public Object protect() throws Exception {
                if (ToolsDebugger.this.debuggerSuspended) {
                    ToolsDebugger.this.debuggerSuspended = false;
                    ToolsDebugger.this.setSuspended(false);
                } else {
                    ToolsDebugger.this.remoteDebugger.cont();
                }
                ToolsDebugger.super.go();
                return null;
            }
        }.go(this.synchronizer, this.killer);
    }

    public void stepOut() throws DebuggerException {
        if (this.currentThread == null) {
            return;
        }
        this.setLastAction(4);
        this.currentThread.setLastAction(4);
        new Protector("AbstractDebugger.stepOut"){

            public Object protect() throws Exception {
                ToolsDebugger.this.currentThread.getRemoteThread().stepOut();
                ToolsDebugger.super.stepOut();
                return null;
            }
        }.go(this.synchronizer, this.killer);
    }

    public void runToCursor(final Line line) {
        if (this.currentThread == null) {
            return;
        }
        this.setLastAction(3);
        this.currentThread.setLastAction(3);
        try {
            Debugger debugger = TopManager.getDefault().getDebugger();
            this.runToCursorBreakpoint = debugger.createBreakpoint(line, true);
            CoreBreakpoint.Action[] actionArray = ((CoreBreakpoint)this.runToCursorBreakpoint).getActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (actionArray[n2] instanceof PrintAction) {
                    ((PrintAction)actionArray[n2]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
                }
                ++n2;
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        new Protector("AbstractDebugger.traceInto"){

            public Object protect() throws Exception {
                if (ToolsDebugger.this.debuggerSuspended) {
                    ToolsDebugger.this.debuggerSuspended = false;
                    ToolsDebugger.this.setSuspended(false);
                } else {
                    ToolsDebugger.this.remoteDebugger.cont();
                }
                ToolsDebugger.super.runToCursor(line);
                return null;
            }
        }.go(this.synchronizer, this.killer);
    }

    public void pause() {
        this.setSuspended(true);
    }

    protected void setState(int n) {
        super.setState(n);
    }

    public void setSuspended(boolean bl) {
        this.debuggerSuspended = bl;
        this.threadGroup.setSuspended(bl);
        if (bl) {
            ToolsThread toolsThread;
            if (this.currentThread == null && (toolsThread = this.threadGroup.getDefaultThread()) != null) {
                toolsThread.setCurrent(true);
            }
            this.setState(4);
            toolsThread = this.getIOManager();
            SwingUtilities.invokeLater(new Runnable((IOManager)toolsThread){
                private final /* synthetic */ IOManager val$ioManager;
                {
                    this.val$ioManager = iOManager;
                }

                public void run() {
                    this.val$ioManager.println(ToolsDebugger.getLocString("CTL_Debugger_paused"), 4);
                }
            });
            this.threadGroup.refreshStacks();
        } else {
            this.setState(3);
        }
    }

    public Watch createWatch() {
        ToolsWatch toolsWatch = new ToolsWatch(this, false);
        this.addWatch((Watch)toolsWatch);
        return toolsWatch;
    }

    public Watch createWatch(String string, boolean bl) {
        ToolsWatch toolsWatch = new ToolsWatch(this, bl);
        toolsWatch.setVariableName(string);
        this.addWatch((Watch)toolsWatch);
        return toolsWatch;
    }

    public String getLocationName(DebuggerInfo debuggerInfo) {
        if (debuggerInfo instanceof RemoteDebuggerInfo) {
            return ((RemoteDebuggerInfo)debuggerInfo).getHostName();
        }
        return "localhost";
    }

    public ThreadsProducer getThreadsRoot() {
        return this.threadGroup;
    }

    public AbstractThread getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(AbstractThread abstractThread) {
        if (this.currentThread == abstractThread) {
            return;
        }
        ToolsThread toolsThread = this.currentThread;
        this.currentThread = (ToolsThread)abstractThread;
        this.updateCurrentStackPosition();
        this.updateStoppedState();
        this.firePropertyChange("currentThread", (Object)toolsThread, abstractThread);
    }

    public void disconnect() throws DebuggerException {
        this.threadGroup.setRemoteThreadGroup(null);
        if (this.remoteDebugger != null) {
            this.remoteDebugger.close();
            this.remoteDebugger = null;
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.interrupt();
            this.debuggerThread.stop();
        }
        super.finishDebugger();
        this.synchronizer = null;
    }

    public void reconnect() throws DebuggerException {
        this.startDebugger((DebuggerInfo)new ReconnectDebuggerInfo(this.hostName, this.password));
    }

    boolean addBreakpoint(final String string, final String string2) {
        if (this.synchronizer == null) {
            return false;
        }
        try {
            return (Boolean)new Protector("AbstractDebugger.addBreakpoint1"){

                public Object protect() throws Exception {
                    RemoteClass remoteClass = ToolsDebugger.this.remoteDebugger.findClass(string);
                    if (remoteClass == null) {
                        return new Integer(0);
                    }
                    RemoteField remoteField = remoteClass.getMethod(string2);
                    if (remoteField == null) {
                        return new Integer(0);
                    }
                    String string3 = remoteClass.setBreakpointMethod(remoteField);
                    if (string3.trim().equals("")) {
                        new Integer(1);
                    }
                    ToolsDebugger.this.getIOManager().println(ToolsDebugger.getLocString("CTL_Cannot_set_breakpoint") + ": " + string3, 1);
                    return new Boolean(false);
                }
            }.throwAndWait(this.synchronizer, this.killer);
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean removeBreakpoint(final String string, final String string2) {
        if (this.synchronizer == null) {
            return false;
        }
        try {
            return (Boolean)new Protector("AbstractDebugger.removeBreakpoint"){

                public Object protect() throws Exception {
                    RemoteClass remoteClass = ToolsDebugger.this.remoteDebugger.findClass(string);
                    if (remoteClass == null) {
                        return new Boolean(false);
                    }
                    RemoteField remoteField = remoteClass.getMethod(string2);
                    if (remoteField == null) {
                        return new Boolean(false);
                    }
                    String string3 = remoteClass.clearBreakpointMethod(remoteField);
                    if (string3.trim().equals("")) {
                        return new Boolean(true);
                    }
                    ToolsDebugger.this.getIOManager().println(ToolsDebugger.getLocString("CTL_Cannot_clear_breakpoint") + ": " + string3, 1);
                    return new Boolean(false);
                }
            }.throwAndWait(this.synchronizer, this.killer);
        }
        catch (Exception exception) {
            return false;
        }
    }

    Line getLine(final RemoteStackFrame remoteStackFrame) {
        return (Line)new Protector("AbstractDebugger.showInEditor"){

            public Object protect() throws Exception {
                try {
                    return Utils.getLineForSource((String)remoteStackFrame.getRemoteClass().getName(), (String)remoteStackFrame.getRemoteClass().getSourceFileName(), (int)remoteStackFrame.getLineNumber());
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    return null;
                }
            }
        }.wait(this.synchronizer, this.killer);
    }

    void stop(boolean bl, final AbstractThread abstractThread) {
        if (bl) {
            this.setLastAction(1);
            this.setState(4);
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
                static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;

                public void run() {
                    try {
                        ToolsDebugger.this.threadGroup.threadChanged();
                        ToolsThread toolsThread = ToolsDebugger.this.threadGroup.getThread(((ToolsThread)abstractThread).getRemoteThread());
                        if (toolsThread == null) {
                            toolsThread = abstractThread;
                        }
                        toolsThread.setCurrent(true);
                        toolsThread.setLastAction(1);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        ToolsDebugger.this.getIOManager().println(ToolsDebugger.getLocString("EXC_Debugger") + ": " + throwable, 1);
                        return;
                    }
                    ToolsDebugger.this.threadGroup.refreshStacks();
                    ((GoToCalledMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = 12.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction))).setEnabled(ToolsDebugger.this.getDebuggerState().isGoToCalledMethodEnabled());
                    ((GoToCallingMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = 12.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction))).setEnabled(ToolsDebugger.this.getDebuggerState().isGoToCallingMethodEnabled());
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        } else {
            int n = ((ToolsThread)abstractThread).getLastAction();
            if (n == 2 || n == 4) {
                new Protector("AbstractDebugger.stepOut"){

                    public Object protect() throws Exception {
                        ((ToolsThread)abstractThread).getRemoteThread().stepOut();
                        return null;
                    }
                }.go(this.synchronizer, this.killer);
            } else {
                new Protector("AbstractDebugger.go"){

                    public Object protect() throws Exception {
                        ToolsDebugger.this.remoteDebugger.cont();
                        return null;
                    }
                }.go(this.synchronizer, this.killer);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReconnectDebuggerInfo
    extends RemoteDebuggerInfo {
        private ReconnectDebuggerInfo(String string, String string2) {
            super(string, string2);
        }
    }
}

