/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsThread;
import org.netbeans.modules.debugger.debug.ToolsVariable;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Protector;
import org.openide.util.NbBundle;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteValue;

public class ToolsWatch
extends JavaWatch {
    static final long serialVersionUID = 3439367144447814302L;
    protected ToolsVariable toolsVariable;
    private String errorMessage;
    protected transient boolean inScope = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsWatch;

    ToolsWatch(ToolsDebugger toolsDebugger, boolean bl) {
        super((JavaDebugger)toolsDebugger, bl);
        this.toolsVariable = new ToolsVariable(toolsDebugger, false);
    }

    public boolean isInScope() {
        return this.getErrorMessage() == null;
    }

    public AbstractVariable getVariable() {
        return this.toolsVariable;
    }

    public boolean isLeaf() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validate() {
        block6: {
            block5: {
                if (this.toolsVariable.getDebugger().synchronizer == null) break block5;
                int n = this.toolsVariable.getDebugger().getState();
                this.toolsVariable.getDebugger();
                if (n != 1) break block6;
            }
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsWatch == null ? (class$org$netbeans$modules$debugger$debug$ToolsWatch = ToolsWatch.class$("org.netbeans.modules.debugger.debug.ToolsWatch")) : class$org$netbeans$modules$debugger$debug$ToolsWatch)).getString("EXC_No_session"));
            this.firePropertyChange(null, null, null);
            return;
        }
        int n = this.toolsVariable.getDebugger().getState();
        this.toolsVariable.getDebugger();
        if (n != 4) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsWatch == null ? (class$org$netbeans$modules$debugger$debug$ToolsWatch = ToolsWatch.class$("org.netbeans.modules.debugger.debug.ToolsWatch")) : class$org$netbeans$modules$debugger$debug$ToolsWatch)).getString("CTL_No_context"));
            this.firePropertyChange(null, null, null);
            return;
        }
        ToolsThread toolsThread = (ToolsThread)this.toolsVariable.getDebugger().getCurrentThread();
        if (toolsThread != null) {
            this.refreshValue(toolsThread);
            return;
        }
        this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsWatch == null ? (class$org$netbeans$modules$debugger$debug$ToolsWatch = ToolsWatch.class$("org.netbeans.modules.debugger.debug.ToolsWatch")) : class$org$netbeans$modules$debugger$debug$ToolsWatch)).getString("CTL_No_context"));
        this.firePropertyChange(null, null, null);
    }

    public boolean canRemove() {
        return false;
    }

    public void setAsText(String string) {
        this.toolsVariable.setAsText(string);
    }

    public AbstractVariable[] getVariables() {
        if (!this.isInScope()) {
            return new ToolsVariable[0];
        }
        return this.toolsVariable.getVariables();
    }

    public JavaVariable[] filterVariables(ModifiersFilter modifiersFilter, int n, int n2) {
        if (!this.isInScope()) {
            return new ToolsVariable[0];
        }
        return this.toolsVariable.filterVariables(modifiersFilter, n, n2);
    }

    public AbstractVariable getVariable(String string) {
        if (!this.isInScope()) {
            return null;
        }
        return this.toolsVariable.getVariable(string);
    }

    public String toStringValue() {
        if (!this.isInScope()) {
            return null;
        }
        return this.toolsVariable.toStringValue();
    }

    public int getVariablesNumber() {
        if (!this.isInScope()) {
            return 0;
        }
        return this.toolsVariable.getVariablesNumber();
    }

    public JavaVariable createFixedVariable() {
        return this.toolsVariable.createFixedVariable();
    }

    public boolean isFixedVariable() {
        return this.toolsVariable.isFixedVariable();
    }

    public String getAsText() {
        if (!this.isInScope()) {
            return null;
        }
        return this.toolsVariable.getAsText();
    }

    public String getType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.toolsVariable.getType();
    }

    public String getInnerType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.toolsVariable.getInnerType();
    }

    public boolean isObject() {
        if (!this.isInScope()) {
            return false;
        }
        return this.toolsVariable.isObject();
    }

    public boolean isArray() {
        if (!this.isInScope()) {
            return false;
        }
        return this.toolsVariable.isArray();
    }

    public String getModifiers() {
        if (!this.isInScope()) {
            return "";
        }
        return this.toolsVariable.getModifiers();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    protected void refreshValue(JavaThread javaThread) {
        final ToolsThread toolsThread = (ToolsThread)javaThread;
        this.toolsVariable.setErrorMessage(null);
        new Protector("ToolsWatch.refreshValue"){
            static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsWatch;

            public Object protect() throws Exception {
                RemoteValue remoteValue = ToolsWatch.this.toolsVariable.getRemoteValue();
                RemoteThread remoteThread = toolsThread.getRemoteThread();
                try {
                    int n = ToolsWatch.this.getVariableName().lastIndexOf(46);
                    if (n >= 0) {
                        RemoteClass remoteClass = ToolsWatch.this.getRemoteClass(ToolsWatch.this.getVariableName().substring(0, n));
                        if (remoteClass != null) {
                            if (ToolsWatch.this.readStaticVariable(remoteClass, ToolsWatch.this.getVariableName().substring(n + 1, ToolsWatch.this.getVariableName().length()))) {
                                ToolsWatch.this.setErrorHelper(null);
                            } else {
                                ToolsWatch.this.setErrorHelper(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsWatch == null ? (class$org$netbeans$modules$debugger$debug$ToolsWatch = 1.class$("org.netbeans.modules.debugger.debug.ToolsWatch")) : class$org$netbeans$modules$debugger$debug$ToolsWatch)).getString("CTL_Name_unknown"));
                            }
                        }
                    } else if (ToolsWatch.this.readLocalVariable(remoteThread) || ToolsWatch.this.readObjectVariable(remoteThread) || ToolsWatch.this.readStaticVariable(remoteThread)) {
                        ToolsWatch.this.setErrorHelper(null);
                    } else {
                        ToolsWatch.this.setErrorHelper(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsWatch == null ? (class$org$netbeans$modules$debugger$debug$ToolsWatch = 1.class$("org.netbeans.modules.debugger.debug.ToolsWatch")) : class$org$netbeans$modules$debugger$debug$ToolsWatch)).getString("CTL_Name_unknown"));
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    ToolsWatch.this.setErrorHelper(throwable.toString());
                }
                return null;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }.wait(this.toolsVariable.getDebugger().synchronizer, this.toolsVariable.getDebugger().killer);
        this.firePropertyChange(null, null, null);
    }

    private boolean readLocalVariable(RemoteThread remoteThread) throws Exception {
        RemoteStackVariable remoteStackVariable = this.getRemoteStackVariable(remoteThread, this.displayName);
        if (remoteStackVariable == null) {
            return false;
        }
        this.inScope = remoteStackVariable.inScope();
        this.toolsVariable.update(this.displayName, remoteStackVariable.getValue(), remoteStackVariable.getType().toString());
        return true;
    }

    private boolean readObjectVariable(RemoteThread remoteThread) throws Exception {
        RemoteStackVariable remoteStackVariable = this.getRemoteStackVariable(remoteThread, "this");
        if (remoteStackVariable == null) {
            return false;
        }
        RemoteValue remoteValue = remoteStackVariable.getValue();
        if (remoteValue == null || !remoteValue.isObject()) {
            return false;
        }
        RemoteField remoteField = ((RemoteObject)remoteValue).getField(this.displayName);
        if (remoteField == null) {
            return false;
        }
        return this.toolsVariable.update(remoteField, -1, (RemoteObject)remoteValue);
    }

    private boolean readStaticVariable(RemoteThread remoteThread) throws Exception {
        RemoteStackFrame remoteStackFrame = remoteThread.getCurrentFrame();
        if (remoteStackFrame == null) {
            return false;
        }
        RemoteClass remoteClass = remoteStackFrame.getRemoteClass();
        if (remoteClass == null) {
            return false;
        }
        return this.readStaticVariable(remoteClass, this.displayName);
    }

    private boolean readStaticVariable(RemoteClass remoteClass, String string) throws Exception {
        RemoteField remoteField;
        Object var4_3 = null;
        try {
            remoteField = remoteClass.getField(string);
            if (remoteField == null) {
                return false;
            }
            RemoteValue remoteValue = remoteClass.getFieldValue(string);
            this.toolsVariable.setRemoteValue(remoteValue);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        this.toolsVariable.update(remoteField, -1, (RemoteObject)remoteClass);
        return true;
    }

    private RemoteStackVariable getRemoteStackVariable(RemoteThread remoteThread, String string) throws Exception {
        RemoteStackFrame remoteStackFrame = remoteThread.getCurrentFrame();
        if (remoteStackFrame == null) {
            return null;
        }
        return remoteStackFrame.getLocalVariable(string);
    }

    private RemoteClass getRemoteClass(String string) throws Exception {
        if (this.toolsVariable.getDebugger().remoteDebugger == null) {
            return null;
        }
        return this.toolsVariable.getDebugger().remoteDebugger.findClass(string);
    }

    void setErrorHelper(String string) {
        this.setErrorMessage(string);
    }

    void setValue(String string) {
        this.toolsVariable.setValue(string);
    }

    public String toString() {
        return this.toolsVariable.toString();
    }

    public int getSize() {
        return this.toolsVariable.getSize();
    }

    public int getStartIndex() {
        return this.toolsVariable.getStartIndex();
    }

    public void setStartIndex(int n) {
        this.toolsVariable.setStartIndex(n);
    }

    public int getLength() {
        return this.toolsVariable.getLength();
    }

    public void setLength(int n) {
        this.toolsVariable.setLength(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

