/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package vcs.commands;

import java.util.*;
import javax.swing.table.*;
import javax.swing.*;

import org.openide.*;

import org.netbeans.modules.vcscore.*;
import org.netbeans.modules.vcscore.util.*;


/**
 *
 * @author  Martin Entlicher
 */
public class CvsModuleSelectorDialog extends javax.swing.JPanel {

    private Vector modules = null;
    //private volatile InformationDialog waitDlg = null;
    private javax.swing.ButtonGroup bg;
    private CvsModuleSelector model;
    private String[] args;

    private static HashMap cash = new HashMap ();

    static final long serialVersionUID = 1987612235843595460L;
    /** Creates new form CvsModuleSelectorDialog */
    public CvsModuleSelectorDialog(CvsModuleSelector model, String[] args) {
        super ();
        this.model = model;
        this.args = args;
        initComponents ();
        rbCheckoutModule.setMnemonic(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.rbCheckoutModule.text_Mnemonic").charAt(0));  // NOI18N
        rbIgnore.setMnemonic(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.rbIgnore.text_Mnemonic").charAt(0));  // NOI18N
        refresh.setMnemonic(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.refresh_Mnemonic").charAt(0));  // NOI18N
        tblModules.getTableHeader().setReorderingAllowed(true);
        javax.swing.ButtonGroup bg = new javax.swing.ButtonGroup ();
        bg.add (rbCheckoutModule);
        bg.add (rbIgnore);
        initData();
        initAccessibility();
    }
    
    private void initAccessibility()
    {
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialogA11yName"));  // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialogA11yDesc"));  // NOI18N
        lblWarning.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.lbWarning.textA11yDesc"));  // NOI18N
        lblOptions.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.lblOptions.textA11yDesc"));  // NOI18N
        statusLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.statusLabelA11yDesc"));  // NOI18N
        tblModules.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.tableA11yName"));  // NOI18N
        tblModules.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.tableA11yDesc"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lblWarning = new javax.swing.JLabel();
        lblOptions = new javax.swing.JLabel();
        rbCheckoutModule = new javax.swing.JRadioButton();
        rbIgnore = new javax.swing.JRadioButton();
        statusLabel = new javax.swing.JLabel();
        refresh = new javax.swing.JButton();
        listScrollPane = new javax.swing.JScrollPane();
        tblModules = new javax.swing.JTable();

        setLayout(new java.awt.GridBagLayout());

        lblWarning.setText(java.util.ResourceBundle.getBundle("vcs/commands/Bundle").getString("CvsModuleSelectorDialog.lbWarning.text"));
        lblWarning.setLabelFor(lblOptions);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 6, 12);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(lblWarning, gridBagConstraints);

        lblOptions.setText(java.util.ResourceBundle.getBundle("vcs/commands/Bundle").getString("CvsModuleSelectorDialog.lblOptions.text"));
        lblOptions.setLabelFor(rbCheckoutModule);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 12);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(lblOptions, gridBagConstraints);

        rbCheckoutModule.setToolTipText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.rbCheckoutModule.textA11yDesc"));
        rbCheckoutModule.setSelected(true);
        rbCheckoutModule.setText(java.util.ResourceBundle.getBundle("vcs/commands/Bundle").getString("CvsModuleSelectorDialog.rbCheckoutModule.text"));
        rbCheckoutModule.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbCheckoutModuleActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 12);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(rbCheckoutModule, gridBagConstraints);

        rbIgnore.setToolTipText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.rbIgnore.textA11yDesc"));
        rbIgnore.setText(java.util.ResourceBundle.getBundle("vcs/commands/Bundle").getString("CvsModuleSelectorDialog.rbIgnore.text"));
        rbIgnore.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbIgnoreActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 12);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(rbIgnore, gridBagConstraints);

        statusLabel.setText("kuk");
        statusLabel.setLabelFor(listScrollPane);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 6);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(statusLabel, gridBagConstraints);

        refresh.setToolTipText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("ACS_CvsModuleSelectorDialog.refreshA11yDesc"));
        refresh.setText(java.util.ResourceBundle.getBundle("vcs/commands/Bundle").getString("CvsModuleSelectorDialog.refresh"));
        refresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshModules(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 12);
        add(refresh, gridBagConstraints);

        listScrollPane.setToolTipText("null");
        tblModules.setShowVerticalLines(false);
        tblModules.setPreferredScrollableViewportSize(new java.awt.Dimension(300, 200));
        tblModules.setShowHorizontalLines(false);
        listScrollPane.setViewportView(tblModules);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(listScrollPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void refreshModules(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshModules
        // Add your handling code here:
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                new Thread("ModuleSelector-Command") {
                    public void run() {
                        waitingForModules();
                        Vector modules = CvsModuleSelectorDialog.this.model.getModulesList (CvsModuleSelectorDialog.this.args);
                        boolean cmdSuccess = (modules != null);
                        Hashtable vars = CvsModuleSelectorDialog.this.model.getVariables();
                        cash.put(createModuleKey(vars), modules);
                        /*
                        VcsFileSystem fs = CvsModuleSelectorDialog.this.model.getFileSystem();
                        if (fs instanceof CvsFileSystem) {
                            CvsFileSystem cvsFs = (CvsFileSystem)fs;
                            String key = ":"+cvsFs.getCvsServerType()+":"+cvsFs.getCvsUserName()+"@"+cvsFs.getCvsServer()+":"+cvsFs.getCvsRoot();
                            cash.put (key, modules);
                        }
                         */
                        setModules(modules, cmdSuccess);    
                   }
                }.start();
            }
        });
    }//GEN-LAST:event_refreshModules

  private void rbIgnoreActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbIgnoreActionPerformed
// Add your handling code here:
      tblModules.setEnabled(false);
      tblModules.getSelectionModel().clearSelection();
  }//GEN-LAST:event_rbIgnoreActionPerformed

  private void rbCheckoutModuleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbCheckoutModuleActionPerformed
// Add your handling code here:
      tblModules.setEnabled(true);
  }//GEN-LAST:event_rbCheckoutModuleActionPerformed

  
    private String createModuleKey(Hashtable vars) {
        String userName = (String) vars.get("CVS_USERNAME");
        if (userName == null) userName = "";
        String server = (String) vars.get("CVS_SERVER");
        if (server == null) server = "";
        String key = ":"+vars.get("SERVERTYPE")+":"+userName+"@"+server+":"+vars.get("CVS_REPOSITORY");
        return key;
    }
    
    
    public void calledAsCommand(boolean yeah) {
        if (yeah) {
            lblWarning.setVisible(false);
            lblOptions.setVisible(false);
            rbCheckoutModule.setVisible(false);
            rbIgnore.setVisible(false);
        } else {
            lblWarning.setVisible(true);
            lblOptions.setVisible(true);
            rbCheckoutModule.setVisible(true);
            rbIgnore.setVisible(true);
        }
    }
    
    public void waitingForModules() {
        statusLabel.setText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.waitingForModules"));
        /*
        if (waitDlg == null) {
          javax.swing.SwingUtilities.invokeLater(new Runnable () {
            public void run () {
              waitDlg = new InformationDialog(new java.awt.Frame(), true, "Please wait, modules are loading ...");
              MiscStuff.centerWindow(waitDlg);
              waitDlg.show();
            }
          });
    }
         */
    }
    
    /*
     * This method picks good column sizes.
     * If all column heads are wider than the column's cells'
     * contents, then you can just use column.sizeWidthToFit().
     *
    private void initColumnSizes(JTable table, TableModel model) {
        TableColumn column = null;
        java.awt.Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int columns = model.getColumnCount();
     
        for (int i = 0; i < columns; i++) {
            column = table.getColumnModel().getColumn(i);
     
            comp = column.getHeaderRenderer().
                             getTableCellRendererComponent(
                                 null, column.getHeaderValue(),
                                 false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            /*
            comp = table.getDefaultRenderer(model.getColumnClass(i)).
                             getTableCellRendererComponent(
                                 table, model.getValueAt(, i),
                                 false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
     *
            column.setPreferredWidth(headerWidth); //Math.max(headerWidth, cellWidth));
        }
    }
     */
    
    public void setModules(Vector modules, boolean success) {
        this.modules = modules;
        //if (waitDlg != null) waitDlg.setVisible(false);
        if (success) statusLabel.setText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.modulesLoaded"));
        else statusLabel.setText(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.modulesLoadError"));
        if (modules == null || modules.size() == 0) {
            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    NotifyDescriptor nd = new NotifyDescriptor.Message(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.noModules"));
                    TopManager.getDefault().notify(nd);
                }
            });
            rbCheckoutModule.setEnabled(false);
            //   closeDialog(null);
        } else {
            Vector columns = new Vector();
            columns.add(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.columnModule"));
            columns.add(org.openide.util.NbBundle.getBundle(CvsModuleSelectorDialog.class).getString("CvsModuleSelectorDialog.columnStatus"));
            DefaultTableModel model = new MyDefaultTableModel(modules, columns);
            TableSorter sorter = new TableSorter(model);
            tblModules.setModel(sorter);
            //tblModules.createDefaultColumnsFromModel();
            //initColumnSizes(tblModules, model);
            sorter.addMouseListenerToHeaderInTable(tblModules);
            sorter.sortByColumn(0, true);
            //tblModules.revalidate();
            //tblModules.repaint();
            listScrollPane.validate();
            //pack();
        }
    }
    
    public String[] getSelection() {
        if (tblModules.getSelectedRowCount() == 0) {return null;}
        int[] select = tblModules.getSelectedRows();
        TableModel model = tblModules.getModel();
        Vector selStr = new Vector();
        for (int ind = 0; ind < select.length; ind++) {
            String mod = (String)model.getValueAt(select[ind], 0);
            selStr.add(mod);
        }
        String[] modulesStrs = (String[]) selStr.toArray(new String[0]);
        return modulesStrs;
    }
    
    private void initData() {
        Vector modules = null;
        /*
        VcsFileSystem fs = this.model.getFileSystem();
        if (fs instanceof CvsFileSystem) {
            CvsFileSystem cvsFs = (CvsFileSystem)fs;
            String key = ":"+cvsFs.getCvsServerType()+":"+cvsFs.getCvsUserName()+"@"+cvsFs.getCvsServer()+":"+cvsFs.getCvsRoot();
            modules = (Vector) cash.get(key);
        }
         */
        Hashtable vars = this.model.getVariables();
        modules = (Vector) cash.get(createModuleKey(vars));
        if (modules == null) {
            this.refreshModules(null);
        }
        else {
            setModules(modules,true);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton rbIgnore;
    private javax.swing.JLabel lblWarning;
    private javax.swing.JRadioButton rbCheckoutModule;
    private javax.swing.JButton refresh;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JLabel lblOptions;
    private javax.swing.JTable tblModules;
    private javax.swing.JScrollPane listScrollPane;
    // End of variables declaration//GEN-END:variables
   
   class MyDefaultTableModel extends DefaultTableModel {
       
       static final long serialVersionUID = 4907156662613927521L;       

      public MyDefaultTableModel (Vector data, Vector columns) {
        super(data, columns);   
      }    
           
      public boolean isCellEditable(int row, int column) {
        return false;  
      }    
 
   }    
    
}

