/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package vcs.commands;

import java.util.*;

/**
 *
 * @author  Martin Entlicher
 */
public class CvsRevisionChooserPanel extends javax.swing.JPanel {

    static final long serialVersionUID = 2011764469350457472L;
    /** Creates new form CvsRevisionChooserPanel */
    public CvsRevisionChooserPanel() {
        initComponents();
        infoLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("CvsRevisionChooser.infoLabel.text_Mnemonic").charAt(0));  // NOI18N
        initAccessibility();
    }
    
    private void initAccessibility()
    {
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("ACS_CvsRevisionChooserA11yName"));  // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("ACS_CvsRevisionChooserA11yDesc"));  // NOI18N
        infoLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("ACS_CvsRevisionChooser.infoLabel.textA11yDesc"));  // NOI18N
        revisionList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("ACS_CvsRevisionChooser.revisionList.textA11yName"));  // NOI18N
        revisionList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(CvsRevisionChooserPanel.class).getString("ACS_CvsRevisionChooser.revisionList.textA11yDesc"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        infoLabel = new javax.swing.JLabel();
        revisionScrollPane = new javax.swing.JScrollPane();
        revisionList = new javax.swing.JList();

        setLayout(new java.awt.GridBagLayout());

        infoLabel.setText("Revision Selector");
        infoLabel.setLabelFor(revisionList);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 12, 8, 11);
        add(infoLabel, gridBagConstraints);

        revisionScrollPane.setViewportView(revisionList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 11);
        add(revisionScrollPane, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane revisionScrollPane;
    private javax.swing.JLabel infoLabel;
    private javax.swing.JList revisionList;
    // End of variables declaration//GEN-END:variables

    public void setCommandName(String name) {
        infoLabel.setText(name);
        infoLabel.repaint();
        //setTitle(name);
    }

    public void setRevisions(Vector revisions) {
        javax.swing.DefaultListModel lm = new javax.swing.DefaultListModel();
        Enumeration enum = revisions.elements();
        while(enum.hasMoreElements()) {
            lm.addElement((String) enum.nextElement());
        }
        revisionList.setModel(lm);
        revisionList.setSelectedIndex(0);
    }

    public String getRevision() {
        if (revisionList.isSelectionEmpty() || revisionList.getModel().getSize() == 0) return null;
        String revision = (String) revisionList.getSelectedValue();
        int space = revision.indexOf(" "); // NOI18N
        if (space > 0) revision = revision.substring(space + 1, revision.length());
        return revision;
    }

}
