/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package vcs.commands;

/**
 *
 * @author  Milos Kleint
 */
import org.netbeans.modules.vcscore.ui.MyTableObject;
import org.netbeans.modules.vcscore.util.table.*;
import org.netbeans.modules.vcscore.annotation.AnnotationProvider;
import org.netbeans.modules.vcscore.annotation.AnnotationSupport;

import org.openide.filesystems.*;
import java.util.*;
import java.io.File;
import javax.swing.table.*;
import javax.swing.*;
import java.lang.reflect.*;
import org.openide.util.*;


public class ToLockFilesPanel extends javax.swing.JPanel {

    private TableInfoModel model;
    /** Creates new form ToAddFilesPanel */
    public ToLockFilesPanel(List fileObjectList) {
        initComponents();

        cbPerform.setMnemonic (org.openide.util.NbBundle.getBundle (ToLockFilesPanel.class).getString ("ToLockFilesPanel.cbPerform.mnemonic").charAt (0));
        rbAll.setMnemonic (org.openide.util.NbBundle.getBundle (ToLockFilesPanel.class).getString ("ToLockFilesPanel.rbAll.mnemonic").charAt (0));
        rbSelectedOnly.setMnemonic (org.openide.util.NbBundle.getBundle (ToLockFilesPanel.class).getString ("ToLockFilesPanel.rbSelectedOnly.mnemonic").charAt (0));
        jTextArea1.setFont (javax.swing.UIManager.getFont ("Label.font"));
        jTextArea1.setForeground (javax.swing.UIManager.getColor ("Label.foreground"));

        rbAll.setSelected(true);
        rbSelectedOnly.setSelected(false);
        rbAll.setEnabled(false);
        rbSelectedOnly.setEnabled(false);
        buttonGroup1.add(rbAll);
        buttonGroup1.add(rbSelectedOnly);        
        // setting the model....
        model = new TableInfoModel();
        Class classa = MyTableObject.class;
        FoStatusComparator comp = new FoStatusComparator();
        String  column1 = NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.fileColumn"); // NOI18N
        String  column2 = NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.pathColumn"); // NOI18N
        String  column3 = NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.statusColumn"); // NOI18N
        try {
            Method method1 = classa.getMethod("getName", null);     //NOI18N
            Method method2 = classa.getMethod("getPackg", null);     //NOI18N
            Method method3 = classa.getMethod("getFilesystem", null); //NOI18N - can be whatever here.. will decide on the rowobject..
            model.setColumnDefinition(0, column1, method1, true, null);
            model.setColumnDefinition(1, column3, method3, true, comp);
            model.setColumnDefinition(2, column2, method2, true, null);
            
        } catch (NoSuchMethodException exc) {
            Thread.dumpStack();
        } catch (SecurityException exc2) {
            Thread.dumpStack();
        }
        Iterator it = fileObjectList.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            model.addElement(new MyTableObject(fo));
        }
        tblToBeAddedFiles.setModel(model);
        JTableHeader head = tblToBeAddedFiles.getTableHeader();
        head.setUpdateTableInRealTime(true);
        ColumnSortListener listen = new ColumnSortListener(tblToBeAddedFiles);
        head.addMouseListener(listen);        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroup1 = new javax.swing.ButtonGroup();
        cbPerform = new javax.swing.JCheckBox();
        rbAll = new javax.swing.JRadioButton();
        rbSelectedOnly = new javax.swing.JRadioButton();
        spToBeAddedFiles = new javax.swing.JScrollPane();
        tblToBeAddedFiles = new javax.swing.JTable();
        jTextArea1 = new javax.swing.JTextArea();
        
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setPreferredSize(new java.awt.Dimension(250, 250));
        cbPerform.setText(org.openide.util.NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.cbPerform.text"));
        cbPerform.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbPerformActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(12, 12, 12, 11);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(cbPerform, gridBagConstraints1);
        
        rbAll.setText(org.openide.util.NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.rbAll.text"));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new java.awt.Insets(0, 12, 0, 11);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(rbAll, gridBagConstraints1);
        
        rbSelectedOnly.setText(org.openide.util.NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.rbSelectedOnly.text"));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.insets = new java.awt.Insets(0, 12, 0, 11);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(rbSelectedOnly, gridBagConstraints1);
        
        spToBeAddedFiles.setMinimumSize(new java.awt.Dimension(150, 120));
        tblToBeAddedFiles.setModel(new javax.swing.table.DefaultTableModel(
        new Object [][] {
            {null, null, null, null},
            {null, null, null, null},
            {null, null, null, null},
            {null, null, null, null}
        },
        new String [] {
            "Title 1", "Title 2", "Title 3", "Title 4"
        }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Object.class
            };
            
            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        spToBeAddedFiles.setViewportView(tblToBeAddedFiles);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 30, 11, 11);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(spToBeAddedFiles, gridBagConstraints1);
        
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setLineWrap(true);
        jTextArea1.setEditable(false);
        jTextArea1.setText(org.openide.util.NbBundle.getBundle(ToLockFilesPanel.class).getString("ToLockFilesPanel.lblDescription.text"));
        jTextArea1.setOpaque(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(12, 12, 0, 11);
        add(jTextArea1, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void cbPerformActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbPerformActionPerformed
        // Add your handling code here:
        rbAll.setEnabled(cbPerform.isSelected());
        rbSelectedOnly.setEnabled(cbPerform.isSelected());
    }//GEN-LAST:event_cbPerformActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbPerform;
    private javax.swing.JRadioButton rbAll;
    private javax.swing.JRadioButton rbSelectedOnly;
    private javax.swing.JScrollPane spToBeAddedFiles;
    private javax.swing.JTable tblToBeAddedFiles;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

    private static final long serialVersionUID = -2911342615927356990L;    

    /** 
     * returns the selected fileobjects. if the action should not be performed, returns null
     * if the rbFsRoos is selected by the user, then it returns filesystems root fileobjects..
     */
    
    public java.util.List getFileObjects() {
        if (cbPerform.isSelected()) {
            java.util.List list = new LinkedList();
            if (rbAll.isSelected()) {
                Iterator it = model.getList().iterator();
                while (it.hasNext()) {
                    MyTableObject tb = (MyTableObject)it.next();
                    list.add(tb.getFileObject());
                }
            } 
            else  if (rbSelectedOnly.isSelected()) {
                int[] rows = tblToBeAddedFiles.getSelectedRows();
                for (int i = 0; i< rows.length; i++) {
                    MyTableObject tb = (MyTableObject)model.getElementAt(rows[i]);
                    list.add(tb.getFileObject());
                }
            }
            else {
                java.util.Set set = new HashSet();
                Iterator it = model.getList().iterator();
                while (it.hasNext()) {
                    MyTableObject tb = (MyTableObject)it.next();
                    FileObject fo = tb.getFileObject();
                    while (fo.getParent() != null) {
                        fo = fo.getParent();
                    }
                    set.add(fo);
                }
                list = new LinkedList(set);
            }
            return list;
        }
        return null;
    }
    

    
    private static class FoStatusComparator implements TableInfoComparator {

        public FoStatusComparator() {
        }
        
        
        public int compare(java.lang.Object obj, java.lang.Object obj1) {
            return 0;
        }
        
        public String getDisplayValue(Object obj, Object rowObject) {
            MyTableObject tb = (MyTableObject)rowObject;
            FileObject fo = tb.getFileObject();
            AnnotationProvider provider = (AnnotationProvider)fo.getAttribute(AnnotationProvider.ANN_PROVIDER_FO_ATTRIBUTE);
            if (provider != null) {
                return provider.getAttributeValue(fo.getPackageNameExt('/','.'), AnnotationSupport.ANNOTATION_PATTERN_STATUS);
            }
                
            return "";
        }
        
    }
}
