#!/bin/sh
#                 Sun Public License Notice
# 
# The contents of this file are subject to the Sun Public License
# Version 1.0 (the "License"). You may not use this file except in
# compliance with the License. A copy of the License is available at
# http://www.sun.com/
# 
# The Original Code is NetBeans. The Initial Developer of the Original
# Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
# Microsystems, Inc. All Rights Reserved.

# -----------------------------------------------------
# Run with -help for usage.
# Normally, editing this script should not be required.
# -----------------------------------------------------

# the value set here can be overriden by $JDK_HOME or the -jdkhome switch
jdkhome=""

# append on command line or ide.cfg, with -J prefix on each
jreflags=""

PRG=$0

#
# resolve symlinks
#

while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
	PRG="$link"
    else
	PRG="`dirname $PRG`/$link"
    fi
done

progdir=`dirname $PRG`
progname=`basename $0`

idehome="$progdir/.."

# absolutize idehome

oldpwd=`pwd` ; cd ${idehome}; idehome=`pwd`; cd $oldpwd; unset oldpwd

# calculate branding to brand userdir with
defaults="$idehome/bin/.runide_defaults.sh"
if [ -r "$idehome/lib/branding" ]; then
    branding=`cat "$idehome/lib/branding"`
    if [ -r "$idehome/bin/.runide_defaults_$branding.sh" ]; then
        defaults="$idehome/bin/.runide_defaults_$branding.sh"
    fi
fi
# This script should set the var userdir at the least:
# (another likely option would be $jdkhome, see #18628)
. "$defaults"

thread_flag=""

jargs=${jreflags}
jargs="$jargs -Dnetbeans.home=$idehome"
jargs="$jargs -Djava.security.policy=$idehome/bin/ide.policy"

args=""

prefixcp=""
postfixcp=""

updater_class=org.netbeans.updater.UpdaterFrame
ide_class=org.netbeans.Main

#
# defaults
#

# if JAVA_PATH is set it overrides the default in the script

if [ ! -z "$JAVA_PATH" -a -z "$jdkhome" ] ; then
    jdkhome=$JAVA_PATH
fi

# if JDK_HOME is set it overrides the default in the script and ${JAVA_PATH}

if [ ! -z "$JDK_HOME" -a -z "$jdkhome" ] ; then
    jdkhome=$JDK_HOME
fi

#
# parse arguments
#

parse_args() {
while [ $# -gt 0 ] ; do
#    echo "Processing arg: '$1'"
    case "$1" in
        -h|-help) cat <<EOF
Usage: $0 {options} arguments

Options can be

   -h -help
        shows usage
   -jdkhome <path>
        specifies the JDK directory

   -hotspot
   -client
   -server
   -classic
   -native
   -green
        specifies the type of JVM
        
   -J<jvm_options>
        passes <jvm_option> to JVM
   -userdir <path>
        specifies userdir (\$HOME/nbuser32 by default)
   -single
        runs the IDE in single user mode
   -cp:p <classpath>
        prepends <classpath> to IDE's classpath
   -cp:a <classpath>
        appends <classpath> to IDE's classpath

All other options and arguments are passed to the IDE.
Any options found in \$HOME/ide.cfg or else .../bin/ide.cfg
are treated as defaults (may be overridden).
See documentation for details.

EOF
exit 1
;;
        -jdkhome) shift; if [ $# -gt 0 ] ; then jdkhome=$1; fi;;
        -userdir) shift; if [ $# -gt 0 ] ; then userdir=$1; fi;;
        -single) userdir="";;
        -mainclass) shift; if [ $# -gt 0 ] ; then ide_class=$1; fi;;
        -cp|-cp:a)
            shift;
            if [ $# -gt 0 ] ; then
                if [ ! -z "$postfixcp" ] ; then postfixcp="$postfixcp:" ; fi
                postfixcp=$postfixcp$1;
            fi
            ;;
        
        -cp:p)
            shift;
            if [ $# -gt 0 ] ; then
                if [ ! -z "$prefixcp" ] ; then prefixcp="$prefixcp:" ; fi
                prefixcp=$prefixcp$1;
            fi
            ;;
        
        -hotspot|-client|-server|-classic|-native|-green) thread_flag=$1;;
        -J-hotspot|-J-client|-J-server|-J-classic|-J-native|-J-green) thread_flag=`expr $1 : '-J\(.*\)'`;;
        -J*) jopt=`expr "$1" : '-J\(.*\)'`; jargs="$jargs \"$jopt\"";;
        *) args="$args \"$1\"" ;;
    esac
    shift
done
} # parse_args()

# Process any ./ide.cfg or ~/ide.cfg.
# Note that there is no quoting scheme for these files.
if [ -r "${HOME}/ide.cfg" ]; then
    parse_args `cat ${HOME}/ide.cfg`
elif [ -r "${progdir}/ide.cfg" ]; then
    parse_args `cat ${progdir}/ide.cfg`
# else leave as is
fi

if [ -f /usr/j2se/opt/javahelp/lib/jhall.jar ]; then
    # See http://www.netbeans.org/issues/show_bug.cgi?id=22455
    parse_args "-J-Xbootclasspath/p:${idehome}/lib/ext/jh.jar"
fi

# Process arguments given on the command line.
parse_args "$@"

#
# check JDK
#

if [ -z "$jdkhome" ] ; then
    echo "Cannot find JDK. Please set the JDK_HOME environment variable to point"
    echo "to your JDK installation directory, or use the -jdkhome switch"
    echo ""
    exit 1
fi

if [ ! -x "${jdkhome}/bin/java" ] ; then
    echo "Cannot find JDK at ${jdkhome}. Please set the JDK_HOME"
    echo "environment variable to point to your JDK installation directory,"
    echo "or use the -jdkhome switch"
    echo ""
    exit 1
fi

#
# check userdir
#

if [ ! -z "$userdir" ] ; then
    echo "Using ${userdir} as user directory...";
    jargs="-Dnetbeans.user=$userdir $jargs"
fi

#
# increase file descriptor's limit, on Solaris it's set to 64, too small for
# fastjavac
#

ulimit -n 1024

append_jars_to_cp() {
    dir="$1"
    for ex in jar zip ; do
        if [ "`echo ${dir}/*.$ex`" != "${dir}/*.$ex" ] ; then
            for x in ${dir}/*.$ex ; do
                # XXX also filter out lib/locale/updater*.jar to make Japanese startup faster
                # (and put it back in below when building ${updatercp}
                if [ "$x" != "$idehome/lib/updater.jar" -a "$x" != "$userdir/lib/updater.jar" ] ; then
                    if [ ! -z "$cp" ] ; then cp="$cp:" ; fi
                    cp="$cp$x"
                fi
            done
        fi
    done
}

build_cp() {
    base="$1"

    append_jars_to_cp "${base}/lib/patches/locale"
    append_jars_to_cp "${base}/lib/patches"

    append_jars_to_cp "${base}/lib/locale"
    append_jars_to_cp "${base}/lib"

    append_jars_to_cp "${base}/lib/ext/locale"
    append_jars_to_cp "${base}/lib/ext"
}

do_run_updater() {
    eval $jdkhome/bin/java $thread_flag -classpath "\"${updatercp}\"" $jargs $updater_class
}

look_for_pre_runs() {
    base="$1"
    dir="${base}/update/download"
    if [ -f "${dir}/install_later.xml" -a "`echo ${dir}/*.nbm`" != "${dir}/*.nbm" ] ; then
        run_updater=yes
    fi
}

look_for_post_runs() {
    base="$1"
    dir="${base}/update/download"
    if [ \! -f "${dir}/install_later.xml" -a "`echo ${dir}/*.nbm`" != "${dir}/*.nbm" ] ; then
        run_updater=yes
    fi
}

#
# dump the OS env variables into a temp file
#

# XXX does this make sense?
# rm -f /tmp/nbenv.*
# otherwise env files collect after crashes etc.

nbenvfile="/tmp/nbenv.$$"

# attempt to delete a leftover from crashed instance which happened to have the
# same PID

rm -f ${nbenvfile}

# if ${nbenvfile} already exists there is a possibility that it is a leftover
# after another instance of this script crashed and the owner of the file can
# be another user (PIDs are reused).  In such a case keep appending 'X' to the
# filename until we find an unused name

while [ -f "$nbenvfile" ]
do
    nbenvfile=${nbenvfile}X
done

if [ -x /usr/bin/env ] ; then
    /usr/bin/env > "$nbenvfile"
else
    echo "" > "$nbenvfile"
fi

#
# main loop
#

# clear to prevent loop from ending
restart="yes"
first_time_starting="yes"

while [ "$restart" ] ; do

    #
    # build CLASSPATH
    #
    
    cp=""
    updatercp=""
    
    # userdir comes first
    
    if [ ! -z "${userdir}" ] ; then
        build_cp ${userdir}
        
        # XXX really ought not be an updater.jar in userdir...
        if [ -f "${userdir}/lib/updater.jar" ] ; then
            updatercp="${userdir}/lib/updater.jar"
        fi
    fi

    # idehome comes second
    
    build_cp ${idehome}
    
    if [ -f "${idehome}/lib/updater.jar" ] ; then
        if [ ! -z "$updatercp" ] ; then updatercp="${updatercp}:" ; fi
        updatercp="${updatercp}${idehome}/lib/updater.jar"
    fi

    # JDK tools
    
    for ex in jar zip ; do
        # XXX does this still work if ${jdkhome} contains spaces?
        if [ "`echo ${jdkhome}/lib/*.$ex`" != "${jdkhome}/lib/*.$ex" ] ;then
            for x in ${jdkhome}/lib/*.$ex ; do
                if [ ! -z "$cp" ] ; then cp="$cp:" ; fi
                cp="${cp}$x"
            done
        fi
    done

    # user-specified prefix and postfix CLASSPATH
    
    if [ ! -z "${prefixcp}" ] ; then
        cp="${prefixcp}:$cp"
    fi
    
    if [ ! -z "${postfixcp}" ] ; then
        cp="$cp:${postfixcp}"
    fi


    # prepend IDE's classpath to updater's classpath
    
    # XXX not really necessary; currently none of it is needed;
    # perhaps just XML parser would be enough
    if [ ! -z "$updatercp" ] ; then
        updatercp=${cp}:${updatercp}
    else
        updatercp=${cp}
    fi

    # First check for pre-run updates.
    if [ "$first_time_starting" ] ; then
        run_updater=""
        look_for_pre_runs "$idehome"
        look_for_pre_runs "$userdir"
        if [ "$run_updater" ] ; then do_run_updater ; fi
        # Do not check this after a restart, it makes no sense.
        first_time_starting=""
    fi
    
    #
    # let's go
    #
    
    eval $jdkhome/bin/java $thread_flag -classpath "\"$cp\"" \
        -Dnetbeans.osenv="${nbenvfile}" \
        $jargs $ide_class $args

    # If we should update anything, do it and restart IDE.
    run_updater=""
    look_for_post_runs "$idehome"
    look_for_post_runs "$userdir"
    if [ "$run_updater" ] ; then
        do_run_updater
        restart="yes"
    else
        restart=""
        # will fall thru loop and exit
    fi

done

rm "$nbenvfile"
# and we exit.
