/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.awt.SwingBrowserImpl;
import org.openide.awt.ToolbarButton;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class HtmlBrowser
extends JPanel {
    static final long serialVersionUID = 2912844785502987960L;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private static Factory browserFactory;
    private static String homePage;
    private static ResourceBundle resourceBundle;
    private static MessageFormat msgFormat;
    private static Icon iBack;
    private static Icon iForward;
    private static Icon iHome;
    private static Icon iReload;
    private static Icon iStop;
    private static Icon iHistory;
    private Impl browserImpl;
    private boolean everythinkIListenInCheckBoxIsUnimportant = false;
    private boolean toolbarVisible = false;
    private boolean statusLineVisible = false;
    private BrowserListener browserListener;
    private JButton bBack;
    private JButton bForward;
    private JButton bHome;
    private JButton bReload;
    private JButton bStop;
    private JButton bHistory;
    private JComboBox cbLocation;
    private JLabel cbLabel;
    private JLabel lStatusLine;
    private Component browserComponent;
    private JPanel head;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;

    public static void setHomePage(String string) {
        homePage = string;
    }

    public static String getHomePage() {
        if (homePage == null) {
            return NbBundle.getMessage(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser, "PROP_HomePage");
        }
        return homePage;
    }

    public static void setFactory(Factory factory) {
        browserFactory = factory;
    }

    public HtmlBrowser() {
        this(true, true);
    }

    public HtmlBrowser(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public HtmlBrowser(Factory factory, boolean bl, boolean bl2) {
        HtmlBrowser.init();
        try {
            if (factory == null) {
                Impl[] implArray = new Impl[1];
                this.browserComponent = HtmlBrowser.findComponent(implArray);
                this.browserImpl = implArray[0];
            } else {
                try {
                    this.browserImpl = factory.createHtmlBrowserImpl();
                    this.browserComponent = this.browserImpl.getComponent();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    ErrorManager.getDefault().notify(unsupportedOperationException);
                    this.browserImpl = new SwingBrowserImpl();
                    this.browserComponent = this.browserImpl.getComponent();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)runtimeException, resourceBundle.getString("EXC_Module"));
            errorManager.notify(runtimeException);
        }
        this.setLayout(new BorderLayout(0, 2));
        this.add((Component)(this.browserComponent != null ? new JScrollPane(this.browserComponent) : new JScrollPane()), "Center");
        this.browserListener = new BrowserListener();
        if (bl) {
            this.initToolbar();
        }
        if (bl2) {
            this.initStatusLine();
        }
        this.browserImpl.addPropertyChangeListener(this.browserListener);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_HtmlBrowser"));
    }

    private static Component findComponent(Impl[] implArray) {
        Factory factory;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = HtmlBrowser.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory));
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            factory = (Factory)iterator.next();
            try {
                Component component;
                Impl impl = factory.createHtmlBrowserImpl();
                Component component2 = component = impl != null ? impl.getComponent() : null;
                if (component == null) continue;
                implArray[0] = impl;
                return component;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        factory = browserFactory;
        if (factory != null) {
            try {
                implArray[0] = factory.createHtmlBrowserImpl();
                return implArray[0].getComponent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        implArray[0] = new SwingBrowserImpl();
        return implArray[0].getComponent();
    }

    private static void init() {
        if (iBack != null) {
            return;
        }
        resourceBundle = NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser);
        iBack = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/back.gif"));
        iForward = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/forward.gif"));
        iHome = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/home.gif"));
        iReload = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/refresh.gif"));
        iStop = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/stop.gif"));
        iHistory = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/history.gif"));
        msgFormat = new MessageFormat(resourceBundle.getString("CTL_Html_viewer_title"));
    }

    private void initToolbar() {
        this.toolbarVisible = true;
        this.head = new JPanel();
        this.head.setLayout(new BorderLayout(11, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.bBack = new ToolbarButton(iBack);
        jPanel.add(this.bBack);
        this.bBack.setToolTipText(resourceBundle.getString("CTL_Back"));
        this.bBack.setMnemonic(resourceBundle.getString("CTL_Back_Mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bForward = new ToolbarButton(iForward);
        jPanel.add((Component)this.bForward, gridBagConstraints);
        this.bForward.setToolTipText(resourceBundle.getString("CTL_Forward"));
        this.bForward.setMnemonic(resourceBundle.getString("CTL_Forward_Mnemonic").charAt(0));
        this.bStop = new ToolbarButton(iStop);
        jPanel.add(this.bStop);
        this.bStop.setToolTipText(resourceBundle.getString("CTL_Stop"));
        this.bStop.setMnemonic(resourceBundle.getString("CTL_Stop_Mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bReload = new ToolbarButton(iReload);
        jPanel.add((Component)this.bReload, gridBagConstraints);
        this.bReload.setToolTipText(resourceBundle.getString("CTL_Reload"));
        this.bReload.setMnemonic(resourceBundle.getString("CTL_Reload_Mnemonic").charAt(0));
        this.bHome = new ToolbarButton(iHome);
        jPanel.add(this.bHome);
        this.bHome.setToolTipText(resourceBundle.getString("CTL_Home"));
        this.bHome.setMnemonic(resourceBundle.getString("CTL_Home_Mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bHistory = new ToolbarButton(iHistory);
        jPanel.add((Component)this.bHistory, gridBagConstraints);
        this.bHistory.setToolTipText(resourceBundle.getString("CTL_History"));
        this.bHistory.setMnemonic(resourceBundle.getString("CTL_History_Mnemonic").charAt(0));
        if (this.browserImpl != null) {
            this.bBack.setEnabled(this.browserImpl.isBackward());
            this.bForward.setEnabled(this.browserImpl.isForward());
            this.bHistory.setEnabled(this.browserImpl.isHistory());
        }
        JToolBar.Separator separator = new JToolBar.Separator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)separator, gridBagConstraints);
        separator.updateUI();
        this.cbLabel = new JLabel(resourceBundle.getString("CTL_Location"));
        jPanel.add(this.cbLabel);
        this.cbLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Location_Mnemonic").charAt(0));
        this.head.add("West", jPanel);
        this.cbLocation = new JComboBox();
        this.head.add("Center", this.cbLocation);
        this.cbLocation.setEditable(true);
        this.cbLabel.setLabelFor(this.cbLocation);
        this.add((Component)this.head, "North");
        this.cbLocation.addActionListener(this.browserListener);
        this.bHistory.addActionListener(this.browserListener);
        this.bBack.addActionListener(this.browserListener);
        this.bForward.addActionListener(this.browserListener);
        this.bReload.addActionListener(this.browserListener);
        this.bHome.addActionListener(this.browserListener);
        this.bStop.addActionListener(this.browserListener);
        this.bHistory.getAccessibleContext().setAccessibleName(this.bHistory.getToolTipText());
        this.bBack.getAccessibleContext().setAccessibleName(this.bBack.getToolTipText());
        this.bForward.getAccessibleContext().setAccessibleName(this.bForward.getToolTipText());
        this.bReload.getAccessibleContext().setAccessibleName(this.bReload.getToolTipText());
        this.bHome.getAccessibleContext().setAccessibleName(this.bHome.getToolTipText());
        this.bStop.getAccessibleContext().setAccessibleName(this.bStop.getToolTipText());
        this.cbLocation.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_HtmlBrowser_Location"));
    }

    private void destroyToolbar() {
        this.remove(this.head);
        this.head = null;
        this.toolbarVisible = false;
    }

    private void initStatusLine() {
        this.statusLineVisible = true;
        this.lStatusLine = new JLabel(resourceBundle.getString("CTL_Loading"));
        this.add((Component)this.lStatusLine, "South");
        this.lStatusLine.setLabelFor(this);
    }

    private void destroyStatusLine() {
        this.remove(this.lStatusLine);
        this.lStatusLine = null;
        this.statusLineVisible = false;
    }

    public void setURL(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("http://" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                ErrorManager.getDefault().notify(malformedURLException2);
                return;
            }
        }
        this.setURL(uRL);
    }

    public void setURL(final URL uRL) {
        if (uRL == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl;
                boolean bl2 = bl = uRL.getHost() != null && HtmlBrowser.this.browserImpl.getURL() != null && uRL.getHost().equals(HtmlBrowser.this.browserImpl.getURL().getHost());
                if (uRL.equals(HtmlBrowser.this.browserImpl.getURL()) && bl) {
                    HtmlBrowser.this.browserImpl.reloadDocument();
                } else {
                    HtmlBrowser.this.browserImpl.setURL(uRL);
                }
            }
        });
    }

    public final URL getDocumentURL() {
        return this.browserImpl.getURL();
    }

    public final void setEnableHome(boolean bl) {
        this.bHome.setEnabled(bl);
        this.bHome.setVisible(bl);
    }

    public final void setEnableLocation(boolean bl) {
        this.cbLocation.setEditable(bl);
        this.cbLocation.setVisible(bl);
        this.cbLabel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean bl) {
        if (bl == this.statusLineVisible) {
            return;
        }
        if (bl) {
            this.initStatusLine();
        } else {
            this.destroyStatusLine();
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl == this.toolbarVisible) {
            return;
        }
        if (bl) {
            this.initToolbar();
        } else {
            this.destroyToolbar();
        }
    }

    private final void firePropertyChangeAccess(String string, String string2, String string3) {
        super.firePropertyChange(string, string2, string3);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(400, dimension.width), Math.max(600, dimension.height));
    }

    public void requestFocus() {
        if (this.browserComponent != null) {
            boolean bl = false;
            if (this.browserComponent instanceof JComponent) {
                bl = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!bl) {
                this.browserComponent.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHtmlBrowser();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        homePage = null;
    }

    private class AccessibleHtmlBrowser
    extends JPanel.AccessibleJPanel {
        private AccessibleHtmlBrowser() {
            super(HtmlBrowser.this);
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setAccessibleDescription(String string) {
            super.setAccessibleDescription(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }

    public static interface Factory {
        public Impl createHtmlBrowserImpl();
    }

    public static abstract class Impl {
        static final long serialVersionUID = 2912844785502962114L;
        public static final String PROP_STATUS_MESSAGE = "statusMessage";
        public static final String PROP_URL = "url";
        public static final String PROP_TITLE = "title";
        public static final String PROP_FORWARD = "forward";
        public static final String PROP_BACKWARD = "backward";
        public static final String PROP_HISTORY = "history";

        public abstract Component getComponent();

        public abstract void reloadDocument();

        public abstract void stopLoading();

        public abstract void setURL(URL var1);

        public abstract URL getURL();

        public abstract String getStatusMessage();

        public abstract String getTitle();

        public abstract boolean isForward();

        public abstract void forward();

        public abstract boolean isBackward();

        public abstract void backward();

        public abstract boolean isHistory();

        public abstract void showHistory();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient BrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(BrowserComponent browserComponent) {
            this.bComp = browserComponent;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeBoolean(this.bComp.isStatusLineVisible());
            objectOutput.writeBoolean(this.bComp.isToolbarVisible());
            objectOutput.writeObject(this.bComp.getDocumentURL());
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.statLine = objectInput.readBoolean();
            this.toolbar = objectInput.readBoolean();
            this.url = (URL)objectInput.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if (this.url.getProtocol().equals("http") && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {
                return null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, exception);
            }
            this.bComp = new BrowserComponent(this.statLine, this.toolbar);
            this.bComp.setURL(this.url);
            return this.bComp;
        }
    }

    public static class BrowserComponent
    extends CloneableTopComponent {
        static final long serialVersionUID = 2912844785502987960L;
        public static final String MODE_NAME = "webbrowser";
        private HtmlBrowser browserComponent;
        static /* synthetic */ Class class$org$openide$awt$HtmlBrowser;
        static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$BrowserComponent;

        public BrowserComponent() {
            this(true, true);
        }

        public BrowserComponent(boolean bl, boolean bl2) {
            this(null, bl, bl2);
        }

        public BrowserComponent(Factory factory, boolean bl, boolean bl2) {
            this.setName("");
            this.setLayout(new BorderLayout());
            this.browserComponent = new HtmlBrowser(factory, bl, bl2);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.browserImpl.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ BrowserComponent this$0;
                {
                    this.this$0 = browserComponent;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!propertyChangeEvent.getPropertyName().equals("title")) {
                        return;
                    }
                    String string = HtmlBrowser.access$100(BrowserComponent.access$1500(this.this$0)).getTitle();
                    if (string == null || string.length() < 1) {
                        return;
                    }
                    this.this$0.setName(string);
                }
            });
            this.putClientProperty("PersistenceType", "OnlyOpened");
            if (this.browserComponent.browserComponent != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
            this.setToolTipText(NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getString("HINT_WebBrowser"));
        }

        public void open(Workspace workspace) {
            Mode mode;
            if (this.browserComponent.browserComponent == null) {
                return;
            }
            Workspace workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            Mode mode2 = workspace2.findMode(MODE_NAME);
            if (mode2 == null) {
                mode2 = workspace2.createMode(MODE_NAME, NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getString("CTL_WebBrowser"), (class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/htmlView.gif"));
            }
            if ((mode = workspace2.findMode(this)) == null) {
                mode2.dockInto(this);
            }
            super.open(workspace);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return new BrowserReplacer(this);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.setStatusLineVisible(objectInput.readBoolean());
            this.setToolbarVisible(objectInput.readBoolean());
            this.browserComponent.setURL((URL)objectInput.readObject());
        }

        protected CloneableTopComponent createClonedObject() {
            BrowserComponent browserComponent = new BrowserComponent();
            browserComponent.setURL(this.getDocumentURL());
            return browserComponent;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$awt$HtmlBrowser$BrowserComponent == null ? (class$org$openide$awt$HtmlBrowser$BrowserComponent = BrowserComponent.class$("org.openide.awt.HtmlBrowser$BrowserComponent")) : class$org$openide$awt$HtmlBrowser$BrowserComponent);
        }

        protected void componentActivated() {
            this.browserComponent.browserImpl.getComponent().requestFocus();
            super.componentActivated();
        }

        public Image getIcon() {
            return new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/htmlView.gif")).getImage();
        }

        public void setURL(String string) {
            this.browserComponent.setURL(string);
        }

        public void setURL(URL uRL) {
            this.browserComponent.setURL(uRL);
        }

        public final URL getDocumentURL() {
            return this.browserComponent.getDocumentURL();
        }

        public final void setEnableHome(boolean bl) {
            this.browserComponent.setEnableHome(bl);
        }

        public final void setEnableLocation(boolean bl) {
            this.browserComponent.setEnableLocation(bl);
        }

        public boolean isStatusLineVisible() {
            return this.browserComponent.isStatusLineVisible();
        }

        public void setStatusLineVisible(boolean bl) {
            this.browserComponent.setStatusLineVisible(bl);
        }

        public boolean isToolbarVisible() {
            return this.browserComponent.isToolbarVisible();
        }

        public void setToolbarVisible(boolean bl) {
            this.browserComponent.setToolbarVisible(bl);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.browserComponent.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.browserComponent.removePropertyChangeListener(propertyChangeListener);
        }

        static /* synthetic */ HtmlBrowser access$1500(BrowserComponent browserComponent) {
            return browserComponent.browserComponent;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class BrowserListener
    implements ActionListener,
    PropertyChangeListener {
        private BrowserListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("url") || string.equals("title")) {
                HtmlBrowser.super.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (string.equals("url")) {
                if (HtmlBrowser.this.toolbarVisible) {
                    HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant = true;
                    String string2 = HtmlBrowser.this.browserImpl.getURL().toString();
                    HtmlBrowser.this.cbLocation.setSelectedItem(string2);
                    HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant = false;
                }
            } else if (string.equals("statusMessage")) {
                String string3 = HtmlBrowser.this.browserImpl.getStatusMessage();
                if (string3 == null || string3.length() < 1) {
                    string3 = resourceBundle.getString("CTL_Document_done");
                }
                if (HtmlBrowser.this.lStatusLine != null) {
                    HtmlBrowser.this.lStatusLine.setText(string3);
                }
            } else if (string.equals("forward") && HtmlBrowser.this.bForward != null) {
                HtmlBrowser.this.bForward.setEnabled(HtmlBrowser.this.browserImpl.isForward());
            } else if (string.equals("backward") && HtmlBrowser.this.bBack != null) {
                HtmlBrowser.this.bBack.setEnabled(HtmlBrowser.this.browserImpl.isBackward());
            } else if (string.equals("history") && HtmlBrowser.this.bHistory != null) {
                HtmlBrowser.this.bHistory.setEnabled(HtmlBrowser.this.browserImpl.isHistory());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HtmlBrowser.this.cbLocation) {
                if (HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant) {
                    return;
                }
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object == null) {
                    return;
                }
                HtmlBrowser.this.setURL((String)object);
                ComboBoxModel comboBoxModel = jComboBox.getModel();
                int n = comboBoxModel.getSize();
                int n2 = 0;
                while (n2 < n) {
                    if (object.equals(comboBoxModel.getElementAt(n2))) break;
                    ++n2;
                }
                if (n2 != n) {
                    return;
                }
                if (n == 20) {
                    jComboBox.removeItem(comboBoxModel.getElementAt(n - 1));
                }
                jComboBox.insertItemAt(object, 0);
            } else if (actionEvent.getSource() == HtmlBrowser.this.bHistory) {
                HtmlBrowser.this.browserImpl.showHistory();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bBack) {
                HtmlBrowser.this.browserImpl.backward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bForward) {
                HtmlBrowser.this.browserImpl.forward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bReload) {
                HtmlBrowser.this.browserImpl.reloadDocument();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bHome) {
                HtmlBrowser.this.setURL(homePage);
            } else if (actionEvent.getSource() == HtmlBrowser.this.bStop) {
                HtmlBrowser.this.browserImpl.stopLoading();
            }
        }
    }
}

