/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.IndexedPropertyEditor;
import org.openide.explorer.propertysheet.NamesPanel;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.explorer.propertysheet.PropertyShow;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.SheetButton;
import org.openide.explorer.propertysheet.SheetButtonListener;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class PropertyPanel
extends JComponent
implements Accessible {
    public static final int PREF_READ_ONLY = 1;
    public static final int PREF_CUSTOM_EDITOR = 2;
    public static final int PREF_INPUT_STATE = 4;
    public static final String PROP_PREFERENCES = "preferences";
    public static final String PROP_MODEL = "model";
    public static final String PROP_PROPERTY_EDITOR = "propertyEditor";
    public static final String PROP_STATE = "state";
    private static final String PROP_CAN_EDIT_AS_TEXT = "canEditAsText";
    private static final String PROP_TITLE = "title";
    private static final PropertyModel EMPTY_MODEL = new EmptyModel();
    private int preferences;
    private PropertyModel model;
    private PropertyEditor editor;
    private PropertyEnv env;
    private FeatureDescriptor descriptor = new FeatureDescriptor();
    private int paintingStyle;
    private Color foregroundColor;
    private Color disabledColor;
    private boolean plastic;
    static ThreadLocal current = new ThreadLocal();
    private boolean canWrite = true;
    private boolean canRead = true;
    private SheetButton readComponent;
    private SheetButton textView;
    private PropertyShow propertyShow;
    private SheetButton paintView;
    private SheetButton customizeButton;
    private Component writeComponent;
    private boolean isReadState;
    private boolean isWriteState;
    private boolean ignoreEvents;
    private boolean customDialogShown;
    private boolean differentValues;
    private JTextField textField;
    private JComboBox comboBox;
    private ReadComponentListener readComponentListener;
    private WriteComponentListener writeComponentListener;
    private PropertyChangeListener modelListener;
    private PropertyChangeListener editorListener;
    private PropertyChangeListener weakEditorListener;
    private SheetButtonListener sheetButtonListener;
    private VetoableChangeListener envListener;
    private static final WeakHashMap envCache = new WeakHashMap();
    private boolean changeImmediate = true;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyPanel;
    static /* synthetic */ Class class$java$awt$Container;

    public PropertyPanel() {
        this(EMPTY_MODEL, 0);
    }

    public PropertyPanel(Object object, String string, int n) {
        this(new DefaultPropertyModel(object, string), n);
    }

    public PropertyPanel(PropertyModel propertyModel, int n) {
        this.model = propertyModel;
        this.preferences = n;
        this.setLayout(new BorderLayout());
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertyPanel$PropertySheetSettingsInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
        }
        catch (Exception exception) {
            bl = true;
        }
        catch (LinkageError linkageError) {
            bl = true;
        }
        if (bl) {
            this.paintingStyle = 3;
            this.plastic = false;
            this.disabledColor = SystemColor.textInactiveText;
            this.foregroundColor = new Color(0, 0, 128);
        }
        propertyModel.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
    }

    PropertyPanel(Node.Property property, Object[] objectArray) {
        this(new SimpleModel(property, objectArray), 0);
    }

    public int getPreferences() {
        return this.preferences;
    }

    public void setPreferences(int n) {
        int n2 = this.preferences;
        this.preferences = n;
        this.readComponent = null;
        this.reset();
        this.firePropertyChange(PROP_PREFERENCES, new Integer(n2), new Integer(n));
    }

    public PropertyModel getModel() {
        return this.model;
    }

    public void setModel(PropertyModel propertyModel) {
        PropertyModel propertyModel2 = this.model;
        this.model = propertyModel;
        propertyModel2.removePropertyChangeListener(this.getModelListener());
        propertyModel.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
        this.firePropertyChange(PROP_MODEL, propertyModel2, propertyModel);
    }

    public final Object getState() {
        PropertyEnv propertyEnv = this.env;
        return propertyEnv == null ? PropertyEnv.STATE_VALID : propertyEnv.getState();
    }

    public void updateValue() {
        Component component;
        if (this.editor == null) {
            return;
        }
        PropertyEnv propertyEnv = this.env;
        if (propertyEnv != null && propertyEnv.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
            propertyEnv.setState(PropertyEnv.STATE_VALID);
        }
        if (this.editor.supportsCustomEditor() && (component = this.editor.getCustomEditor()) instanceof EnhancedCustomPropertyEditor) {
            try {
                Object object = ((EnhancedCustomPropertyEditor)((Object)component)).getPropertyValue();
                this.editor.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                PropertyDialogManager.notify(illegalStateException);
            }
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public void setEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                this.setComponentEnabled(componentArray[n], bl);
                ++n;
            }
        }
        super.setEnabled(bl);
    }

    public boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    public void setChangeImmediate(boolean bl) {
        if (this.changeImmediate == bl) {
            return;
        }
        this.changeImmediate = bl;
        if (this.env != null) {
            this.env.setChangeImmediate(bl);
        }
        this.firePropertyChange("changeImmediate", bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    SheetButton getReadComponent() {
        return this.readComponent;
    }

    void setWriteState() {
        if (this.isWriteState) {
            return;
        }
        if ((this.preferences & 1) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isReadState = false;
        this.isWriteState = false;
        this.removeAll();
        JComponent jComponent = this.getWriterComponent();
        jComponent.setToolTipText(this.getPanelToolTipText());
        this.add((Component)jComponent, "Center");
        this.updateNeighbourPanels();
        this.revalidate();
        this.repaint();
        Component component = PropertyPanel.getDefaultFocusComponent(jComponent);
        if (component != null) {
            WriteComponentListener writeComponentListener = this.getWriteComponentListener();
            component.requestFocus();
            component.removeFocusListener(writeComponentListener);
            component.removeKeyListener(writeComponentListener);
            component.addFocusListener(writeComponentListener);
            component.addKeyListener(writeComponentListener);
        }
        this.isReadState = false;
        this.isWriteState = true;
    }

    private static Component getDefaultFocusComponent(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component;
            if (componentArray[n].isFocusTraversable()) {
                return componentArray[n];
            }
            if (componentArray[n] instanceof JComponent && !((JComponent)componentArray[n]).isManagingFocus() && (component = PropertyPanel.getDefaultFocusComponent((JComponent)componentArray[n])) != null) {
                return component;
            }
            ++n;
        }
        return null;
    }

    void setPlastic(boolean bl) {
        this.plastic = bl;
        this.reset();
    }

    boolean getPlastic() {
        return this.plastic;
    }

    void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.reset();
    }

    void setDisabledColor(Color color) {
        this.disabledColor = color;
        this.reset();
    }

    void setPaintingStyle(int n) {
        this.paintingStyle = n;
        this.reset();
    }

    void addSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.sheetButtonListener = sheetButtonListener;
        if (this.readComponent != null) {
            this.readComponent.addSheetButtonListener(sheetButtonListener);
        }
    }

    boolean isWriteState() {
        return this.isWriteState;
    }

    private void updateNeighbourPanels() {
        Container container = this.getParent();
        while (container != null && !(container instanceof NamesPanel)) {
            container = container.getParent();
        }
        if (container instanceof NamesPanel) {
            NamesPanel namesPanel = (NamesPanel)container;
            namesPanel.reset();
        }
    }

    private void updateEditor() {
        Object object;
        Object object2;
        if (this.model == EMPTY_MODEL) {
            return;
        }
        PropertyEditor propertyEditor = this.editor;
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.getEditorListener());
        }
        this.editor = null;
        if (this.env != null) {
            this.env.removePropertyChangeListener(this.getEditorListener());
        }
        this.env = null;
        if (this.model instanceof ExPropertyModel) {
            this.descriptor = ((ExPropertyModel)this.model).getFeatureDescriptor();
            if (this.descriptor instanceof Node.Property) {
                this.canWrite = ((Node.Property)this.descriptor).canWrite();
                this.canRead = ((Node.Property)this.descriptor).canRead();
                this.editor = ((Node.Property)this.descriptor).getPropertyEditor();
                if (this.editor == null && this.descriptor instanceof Node.IndexedProperty) {
                    this.editor = new IndexedPropertyEditor();
                    this.descriptor.setValue("changeImmediate", Boolean.FALSE);
                }
            }
        }
        if (this.editor == null && (object2 = this.model.getPropertyEditorClass()) != null) {
            try {
                object = ((Class)object2).getConstructor(new Class[0]);
                ((AccessibleObject)object).setAccessible(true);
                this.editor = (PropertyEditor)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                PropertyDialogManager.notify(exception);
            }
        }
        if (this.editor == null && (object2 = this.model.getPropertyType()) != null) {
            this.editor = PropertyEditorManager.findEditor(object2);
        }
        if (this.editor != null) {
            if (this.editor instanceof ExPropertyEditor) {
                object2 = (Reference)envCache.get(this.editor);
                if (object2 != null) {
                    this.env = (PropertyEnv)((Reference)object2).get();
                }
                if (this.env == null) {
                    this.env = new PropertyEnv();
                    envCache.put(this.editor, new WeakReference<PropertyEnv>(this.env));
                }
                this.setChangeImmediate(true);
                if (this.model instanceof ExPropertyModel) {
                    object = (ExPropertyModel)this.model;
                    this.env.setFeatureDescriptor(object.getFeatureDescriptor());
                    this.env.setBeans(object.getBeans());
                }
                this.envListener = new VetoableChangeListener(){

                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        PropertyPanel.this.refresh();
                    }
                };
                this.env.addVetoableChangeListener(WeakListener.vetoableChange(this.envListener, this.env));
                this.env.addPropertyChangeListener(this.getEditorListener());
                ((ExPropertyEditor)this.editor).attachEnv(this.env);
            }
            try {
                if (this.canRead) {
                    this.editor.setValue(this.model.getValue());
                }
            }
            catch (ProxyNode.DifferentValuesException differentValuesException) {
                this.differentValues = true;
            }
            catch (Exception exception) {
                this.processThrowable(exception);
            }
            if (this.canWrite) {
                this.editor.addPropertyChangeListener(this.getEditorListener());
            }
        }
        this.firePropertyChange(PROP_PROPERTY_EDITOR, propertyEditor, this.editor);
    }

    private void reset() {
        Component component;
        this.isWriteState = false;
        this.isReadState = false;
        if ((this.preferences & 4) != 0) {
            this.setWriteState();
            return;
        }
        if ((this.preferences & 2) != 0 && this.editor != null && (component = this.editor.getCustomEditor()) != null && component.getParent() != this) {
            this.removeAll();
            this.add(component, "Center");
            this.validate();
            return;
        }
        this.setReadState();
    }

    void refresh() {
        if (this.customDialogShown) {
            return;
        }
        if (this.isReadState) {
            // empty if block
        }
        if (this.isWriteState && (this.preferences & 4) == 0) {
            return;
        }
        this.reset();
    }

    void setReadState() {
        if (this.isReadState) {
            return;
        }
        if ((this.preferences & 4) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isWriteState = false;
        this.isReadState = false;
        this.removeAll();
        this.readComponent = this.getReaderComponent();
        this.readComponent.addSheetButtonListener(this.getReadComponentListener());
        this.setComponentEnabled(this.readComponent, this.isEnabled());
        this.readComponent.setToolTipText(this.getPanelToolTipText());
        this.updateSheetButtonVisually();
        this.add((Component)this.readComponent, "Center");
        this.revalidate();
        this.repaint();
        this.isReadState = true;
        this.isWriteState = false;
    }

    private ReadComponentListener getReadComponentListener() {
        if (this.readComponentListener == null) {
            this.readComponentListener = new ReadComponentListener();
        }
        return this.readComponentListener;
    }

    private WriteComponentListener getWriteComponentListener() {
        if (this.writeComponentListener == null) {
            this.writeComponentListener = new WriteComponentListener();
        }
        return this.writeComponentListener;
    }

    private PropertyChangeListener getModelListener() {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener();
        }
        return this.modelListener;
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
            this.weakEditorListener = WeakListener.propertyChange(this.editorListener, this.editor);
        }
        return this.weakEditorListener;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateSheetButtonVisually();
    }

    private SheetButton getReaderComponent() {
        String string = null;
        SheetButton sheetButton = null;
        if (this.editor == null) {
            return this.getTextView(NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_No_property_editor"));
        }
        try {
            if (!this.differentValues && this.canRead) {
                string = this.editor.getAsText();
            }
            sheetButton = this.editor.isPaintable() && (this.paintingStyle == 3 || this.paintingStyle == 2 && string == null) ? (this.differentValues ? this.getTextView(NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_Different_Values")) : this.getPaintView()) : (string == null ? (this.differentValues ? this.getTextView(NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_Different_Values")) : this.getTextView(this.getTypeString(this.model.getPropertyType()))) : this.getTextView(string));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, PropertyPanel.getString("PS_ExcIn") + " " + this.editor.getClass().getName() + " " + PropertyPanel.getString("PS_Editor") + ".");
            sheetButton = this.getTextView(this.getExceptionString(exception));
        }
        if (sheetButton == null) {
            sheetButton = this.getTextView("null");
        }
        return sheetButton;
    }

    private SheetButton getTextView(String string) {
        this.textView = new PropertySheetButton(string, this.plastic, this.plastic);
        this.textView.setFocusTraversable(true);
        if (this.sheetButtonListener != null) {
            this.textView.addSheetButtonListener(this.sheetButtonListener);
        }
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            this.textView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
        }
        if (this.canWrite) {
            this.textView.setActiveForeground(this.foregroundColor);
        } else {
            this.textView.setActiveForeground(this.disabledColor);
        }
        return this.textView;
    }

    private SheetButton getPaintView() {
        if (this.propertyShow == null) {
            this.propertyShow = new PropertyShow(this.editor);
        } else {
            this.propertyShow.setEditor(this.editor);
        }
        this.paintView = new PropertySheetButton();
        this.paintView.setFocusTraversable(true);
        if (this.canWrite) {
            this.paintView.setActiveForeground(this.foregroundColor);
            this.propertyShow.setForeground(this.foregroundColor);
        } else {
            this.paintView.setActiveForeground(this.disabledColor);
            this.propertyShow.setForeground(this.disabledColor);
        }
        if (this.sheetButtonListener != null) {
            this.paintView.addSheetButtonListener(this.sheetButtonListener);
        }
        this.paintView.add(this.propertyShow);
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            this.paintView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
        }
        this.paintView.setPlastic(this.plastic);
        this.paintView.setToolTipText(this.getPanelToolTipText());
        return this.paintView;
    }

    private JComponent getWriterComponent() {
        Node.Property property;
        if (this.editor == null) {
            return this.getDisabledWriterComponent();
        }
        String string = null;
        boolean bl = true;
        Object object = this.descriptor.getValue(PROP_CAN_EDIT_AS_TEXT);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        try {
            if (this.canRead) {
                string = !this.differentValues ? this.editor.getAsText() : NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_Different_Values");
            }
        }
        catch (Exception exception) {
            this.processThrowable(exception);
        }
        if (string == null && object == null) {
            bl = false;
        }
        this.getWriteComponentListener().setOldValue(this.editor.getValue());
        boolean bl2 = this.editor.supportsCustomEditor();
        if (this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).hasInPlaceCustomEditor()) {
            return this.getInput(this.getInPlace(), bl2);
        }
        if (this.descriptor instanceof Node.Property && !(property = (Node.Property)this.descriptor).canWrite()) {
            if (bl2) {
                return this.getInput(this.getDisabledWriterComponent(), true);
            }
            return this.getDisabledWriterComponent();
        }
        boolean bl3 = this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues();
        String[] stringArray = this.editor.getTags();
        if (stringArray != null) {
            return this.getInput(this.getInputTag(stringArray, string, bl3), bl2);
        }
        if (bl) {
            return this.getInput(this.getInputLine(string == null ? "???" : string, true), bl2);
        }
        if (bl2) {
            return this.getInput(this.getDisabledWriterComponent(), true);
        }
        return this.getDisabledWriterComponent();
    }

    private JComponent getDisabledWriterComponent() {
        SheetButton sheetButton = this.getReaderComponent();
        if (this.descriptor instanceof Node.Property && !((Node.Property)this.descriptor).canWrite()) {
            sheetButton.setActiveForeground(this.disabledColor);
        }
        sheetButton.addFocusListener(this.getWriteComponentListener());
        return sheetButton;
    }

    private JComponent getInputTag(String[] stringArray, String string, boolean bl) {
        this.comboBox = new PropertyComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.comboBox.setMaximumRowCount(stringArray.length <= 12 ? stringArray.length : 8);
        if (string != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    this.comboBox.setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(string);
            this.comboBox.getEditor().setItem(string);
            this.comboBox.getEditor().getEditorComponent().addFocusListener(this.getWriteComponentListener());
            this.comboBox.getEditor().getEditorComponent().addKeyListener(this.getWriteComponentListener());
        }
        this.comboBox.addActionListener(this.getWriteComponentListener());
        this.comboBox.setToolTipText(this.getPanelToolTipText());
        return this.comboBox;
    }

    void tryToSelectNextTag() {
        if (this.comboBox == null) {
            return;
        }
        this.setWriteState();
        int n = this.comboBox.getSelectedIndex();
        if (++n >= this.comboBox.getItemCount()) {
            n = 0;
        }
        this.comboBox.setSelectedIndex(n);
    }

    private Component getInPlace() {
        Component component = ((EnhancedPropertyEditor)this.editor).getInPlaceCustomEditor();
        component.addFocusListener(this.getWriteComponentListener());
        component.addKeyListener(this.getWriteComponentListener());
        if (component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getPanelToolTipText());
        }
        return component;
    }

    private JComponent getInputLine(String string, boolean bl) {
        this.textField = new PropertyTextField();
        this.textField.addActionListener(this.getWriteComponentListener());
        this.textField.addKeyListener(this.getWriteComponentListener());
        this.textField.addFocusListener(this.getWriteComponentListener());
        this.textField.setText(string);
        this.textField.setEditable(bl);
        this.textField.setToolTipText(this.getPanelToolTipText());
        if (!this.isWriteState) {
            this.textField.selectAll();
        }
        return this.textField;
    }

    private String getExceptionString(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        return "<" + throwable.getClass().getName() + ">";
    }

    private String getTypeString(Class clazz) {
        if (clazz == null) {
            return PropertyPanel.getString("CTL_NoPropertyEditor");
        }
        if (clazz.isArray()) {
            return "[" + PropertyPanel.getString("PS_ArrayOf") + " " + this.getTypeString(clazz.getComponentType()) + "]";
        }
        return "[" + clazz.getName() + "]";
    }

    private JComponent getInput(Component component, boolean bl) {
        JPanel jPanel = component == null && this.editor != null && this.editor.isPaintable() && this.paintingStyle != 1 ? new PropertyShow(this.editor) : new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (component != null) {
            jPanel.add(component, "Center");
        }
        if (bl) {
            jPanel.add((Component)this.getCustomizeButton(), "East");
        }
        jPanel.setToolTipText(this.getPanelToolTipText());
        jPanel.addFocusListener(this.getWriteComponentListener());
        jPanel.addKeyListener(this.getWriteComponentListener());
        return jPanel;
    }

    private SheetButton getCustomizeButton() {
        if (this.customizeButton == null) {
            this.customizeButton = new SheetButton("...", this.plastic, this.plastic);
            this.customizeButton.setFocusTraversable(true);
            Font font = this.customizeButton.getFont();
            this.customizeButton.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize()));
            this.customizeButton.addFocusListener(this.getWriteComponentListener());
            this.customizeButton.addSheetButtonListener(new CustomizeListener());
            this.customizeButton.setToolTipText(PropertyPanel.getString("CTL_ElipsisHint"));
        }
        if (this.canWrite) {
            this.customizeButton.setActiveForeground(this.foregroundColor);
        } else {
            this.customizeButton.setActiveForeground(this.disabledColor);
        }
        return this.customizeButton;
    }

    private void notifyExceptionWhileSettingProperty(Exception exception) {
        if (this.getPreferences() == 0 || this.getPreferences() == 4) {
            PropertyPanel.notifyUser(exception, this.descriptor.getDisplayName());
        } else {
            ErrorManager.getDefault().notify(1, exception);
        }
    }

    static void notifyUser(Exception exception, String string) {
        String string2 = PropertyPanel.extractLocalizedMessage(exception);
        if (string2 == null && exception instanceof InvocationTargetException) {
            string2 = PropertyPanel.extractLocalizedMessage(((InvocationTargetException)exception).getTargetException());
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        if (string2 != null) {
            errorManager.annotate((Throwable)exception, NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "FMT_ErrorSettingProperty", string2, string));
            errorManager.notify(256, exception);
        } else {
            errorManager.notify(1, exception);
        }
    }

    private static String extractLocalizedMessage(Throwable throwable) {
        ErrorManager errorManager = ErrorManager.getDefault();
        ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations(throwable);
        String string = null;
        if (annotationArray != null) {
            int n = 0;
            while (n < annotationArray.length) {
                String string2 = annotationArray[n].getLocalizedMessage();
                if (string2 != null) {
                    string = string2;
                    break;
                }
                ++n;
            }
        }
        if (string == null) {
            string = throwable.getLocalizedMessage();
        }
        return string;
    }

    private void processThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate(throwable, NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "FMT_ErrorSettingProperty", throwable.getLocalizedMessage(), this.descriptor.getDisplayName()));
        errorManager.notify(throwable);
    }

    private void setComponentEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if ((class$java$awt$Container == null ? (class$java$awt$Container = PropertyPanel.class$("java.awt.Container")) : class$java$awt$Container).isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].setEnabled(bl);
                this.setComponentEnabled(componentArray[n], bl);
                ++n;
            }
        }
    }

    private String getPanelToolTipText() {
        String string = this.getToolTipText();
        if (string != null) {
            return string;
        }
        Class clazz = this.model.getPropertyType();
        if (this.editor == null) {
            return null;
        }
        if (this.differentValues) {
            return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_Desc_Different_Values");
        }
        if (this.canRead) {
            return this.editor.getAsText();
        }
        return null;
    }

    private void updateSheetButtonVisually() {
        boolean bl = false;
        Object object = this.getClientProperty("flat");
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (this.readComponent != null) {
            this.readComponent.setFlat(bl);
            this.readComponent.setBackground(this.getBackground());
        }
        if (this.propertyShow != null) {
            this.propertyShow.setBackground(this.getBackground());
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, string);
    }

    public void requestFocus() {
        this.requestDefaultFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyPanel();
        }
        return this.accessibleContext;
    }

    private String getWriteComponentAccessibleName() {
        String string = this.getAccessibleContext().getAccessibleName();
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACS_PropertyPanelWriteComponent", string, this.editor == null ? PropertyPanel.getString("CTL_No_value") : this.editor.getAsText());
    }

    private String getWriteComponentAccessibleDescription() {
        String string = this.getAccessibleContext().getAccessibleDescription();
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = PropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACSD_PropertyPanelWriteComponent", string, this.getPanelToolTipText());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Component access$2200(JComponent jComponent) {
        return PropertyPanel.getDefaultFocusComponent(jComponent);
    }

    private class PropertySheetButton
    extends SheetButton {
        PropertySheetButton() {
        }

        PropertySheetButton(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertySheetButton();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertySheetButton
        extends SheetButton.AccessibleSheetButton {
            static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyPanel;

            private AccessiblePropertySheetButton() {
                super(PropertySheetButton.this);
            }

            public String getAccessibleName() {
                return this.getReadComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return this.getReadComponentAccessibleDescription();
            }

            private String getReadComponentAccessibleName() {
                String string = PropertyPanel.this.getAccessibleContext().getAccessibleName();
                if (string == null) {
                    return null;
                }
                return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = AccessiblePropertySheetButton.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACS_PropertyPanelReadComponent", string, super.getAccessibleName());
            }

            private String getReadComponentAccessibleDescription() {
                Object[] objectArray;
                String string = PropertyPanel.this.getAccessibleContext().getAccessibleDescription();
                if (string == null) {
                    return null;
                }
                String string2 = null;
                int n = 0;
                if (PropertyPanel.this.model instanceof ExPropertyModel) {
                    objectArray = ((ExPropertyModel)PropertyPanel.this.model).getBeans();
                    String string3 = PropertyPanel.getString("ACSD_BeanListDelimiter");
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (objectArray[n2] instanceof Node) {
                            Node node = (Node)objectArray[n2];
                            string2 = (string2 == null ? "" : string2 + string3) + node.getDisplayName();
                            ++n;
                        }
                        ++n2;
                    }
                }
                objectArray = PropertyPanel.this.model.getPropertyType();
                return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = AccessiblePropertySheetButton.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACSD_PropertyPanelReadComponent", new Object[]{string, objectArray == null ? PropertyPanel.getString("CTL_No_type") : objectArray.getName(), new Integer(n), string2});
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    private class PropertyComboBox
    extends JComboBox {
        private PropertyComboBox() {
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyComboBox();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyComboBox
        extends JComboBox.AccessibleJComboBox {
            private AccessiblePropertyComboBox() {
                super(PropertyComboBox.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class PropertyTextField
    extends JTextField {
        private PropertyTextField() {
        }

        public void setDocument(Document document) {
            super.setDocument(document);
            if (document != null) {
                document.putProperty("filterNewlines", null);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyTextField();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyTextField
        extends JTextField.AccessibleJTextField {
            private AccessiblePropertyTextField() {
                super(PropertyTextField.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class AccessiblePropertyPanel
    extends JComponent.AccessibleJComponent {
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyPanel;

        private AccessiblePropertyPanel() {
            super(PropertyPanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = AccessiblePropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACS_PropertyPanel", featureDescriptor.getDisplayName());
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = AccessiblePropertyPanel.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "ACSD_PropertyPanel", featureDescriptor.getShortDescription());
            }
            return string;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof PropertyEnv) {
                if (!PropertyPanel.PROP_STATE.equals(propertyChangeEvent.getPropertyName())) return;
                PropertyPanel.super.firePropertyChange(PropertyPanel.PROP_STATE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                return;
            }
            if (PropertyPanel.this.ignoreEvents) {
                return;
            }
            if (!PropertyPanel.this.isWriteState && !PropertyPanel.this.customDialogShown && PropertyPanel.this.preferences < 2) {
                return;
            }
            if (PropertyPanel.this.env != null && !PropertyPanel.this.env.isChangeImmediate() && PropertyPanel.this.customDialogShown) {
                return;
            }
            if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (PropertyPanel.this.editor == null) return;
            try {
                block16: {
                    try {
                        PropertyPanel.this.ignoreEvents = true;
                        Object object = PropertyPanel.this.editor.getValue();
                        Object object2 = null;
                        try {
                            if (PropertyPanel.this.canRead) {
                                object2 = PropertyPanel.this.model.getValue();
                            }
                        }
                        catch (ProxyNode.DifferentValuesException differentValuesException) {
                            // empty catch block
                        }
                        if ((object == null || object.equals(object2)) && (object != null || object2 == null)) break block16;
                        PropertyPanel.this.model.setValue(object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        PropertyPanel.this.notifyExceptionWhileSettingProperty(invocationTargetException);
                        try {
                            if (PropertyPanel.this.canRead) {
                                PropertyPanel.this.editor.setValue(PropertyPanel.this.model.getValue());
                            }
                        }
                        catch (ProxyNode.DifferentValuesException differentValuesException) {
                        }
                        catch (Exception exception) {
                            PropertyDialogManager.notify(exception);
                        }
                        Object var6_9 = null;
                        PropertyPanel.this.ignoreEvents = false;
                        return;
                    }
                }
                Object var6_8 = null;
                PropertyPanel.this.ignoreEvents = false;
                return;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                PropertyPanel.this.ignoreEvents = false;
                throw throwable;
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName()) && PropertyPanel.this.editor != null) {
                Mutex.EVENT.readAccess(new Runnable(this){
                    private final /* synthetic */ ModelListener this$1;
                    {
                        this.this$1 = modelListener;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                PropertyPanel.access$3202(ModelListener.access$3400(this.this$1), true);
                                PropertyPanel.access$1702(ModelListener.access$3400(this.this$1), false);
                                Object object = PropertyPanel.access$2900(ModelListener.access$3400(this.this$1)).getValue();
                                Object object2 = PropertyPanel.access$1800(ModelListener.access$3400(this.this$1)).getValue();
                                if (object != null && !object.equals(object2) || object == null && object2 != null) {
                                    PropertyPanel.access$1800(ModelListener.access$3400(this.this$1)).setValue(object);
                                }
                                ModelListener.access$3400(this.this$1).refresh();
                            }
                            catch (ProxyNode.DifferentValuesException differentValuesException) {
                                PropertyPanel.access$1702(ModelListener.access$3400(this.this$1), true);
                                Object var4_6 = null;
                                PropertyPanel.access$3202(ModelListener.access$3400(this.this$1), false);
                                return;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                PropertyPanel.access$2400(ModelListener.access$3400(this.this$1), invocationTargetException);
                                Object var4_7 = null;
                                PropertyPanel.access$3202(ModelListener.access$3400(this.this$1), false);
                                return;
                            }
                            Object var4_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_8 = null;
                            PropertyPanel.access$3202(ModelListener.access$3400(this.this$1), false);
                            throw throwable;
                        }
                        PropertyPanel.access$3202(ModelListener.access$3400(this.this$1), false);
                    }
                });
            }
        }

        static /* synthetic */ PropertyPanel access$3400(ModelListener modelListener) {
            return modelListener.PropertyPanel.this;
        }
    }

    private final class CustomizeListener
    implements SheetButtonListener {
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyPanel;

        private CustomizeListener() {
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sheetButtonClicked(ActionEvent actionEvent) {
            block12: {
                String string = PropertyPanel.this.descriptor.getDisplayName();
                PropertyPanel.this.customDialogShown = true;
                if (PropertyPanel.this.textField != null) {
                    try {
                        if (PropertyPanel.this.editor.getValue() == null || !PropertyPanel.this.textField.getText().equals(PropertyPanel.this.editor.getAsText())) {
                            PropertyPanel.this.editor.setAsText(PropertyPanel.this.textField.getText());
                        }
                    }
                    catch (ProxyNode.DifferentValuesException differentValuesException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                PropertyDialogManager propertyDialogManager = new PropertyDialogManager(NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = CustomizeListener.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "PS_EditorTitle", string == null ? "" : string, PropertyPanel.this.model.getPropertyType()), true, PropertyPanel.this.editor, PropertyPanel.this.model, PropertyPanel.this.env);
                propertyDialogManager.getDialog().show();
                if (PropertyPanel.this.canRead) {
                    try {
                        block11: {
                            try {
                                PropertyPanel.this.ignoreEvents = true;
                                Object object = PropertyPanel.this.model.getValue();
                                Object object2 = PropertyPanel.this.editor.getValue();
                                if ((object == null || object.equals(object2)) && (object != null || object2 == null)) break block11;
                                PropertyPanel.this.editor.setValue(object);
                            }
                            catch (ProxyNode.DifferentValuesException differentValuesException) {
                                PropertyPanel.this.differentValues = true;
                                Object var7_11 = null;
                                PropertyPanel.this.ignoreEvents = false;
                                break block12;
                            }
                            catch (Exception exception) {
                                PropertyPanel.this.processThrowable(exception);
                                Object var7_12 = null;
                                PropertyPanel.this.ignoreEvents = false;
                                break block12;
                            }
                        }
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        PropertyPanel.this.ignoreEvents = false;
                        throw throwable;
                    }
                    PropertyPanel.this.ignoreEvents = false;
                }
            }
            PropertyPanel.this.reset();
            PropertyPanel.this.requestFocus();
            PropertyPanel.this.customDialogShown = false;
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class ReadComponentListener
    implements SheetButtonListener {
        private ReadComponentListener() {
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
        }

        public void sheetButtonClicked(ActionEvent actionEvent) {
            if ("rightMouseActionCommand".equals(actionEvent.getActionCommand()) || PropertyPanel.this.isWriteState) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ReadComponentListener this$1;
                {
                    this.this$1 = readComponentListener;
                }

                public void run() {
                    ReadComponentListener.access$2600(this.this$1).setWriteState();
                }
            });
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
        }

        static /* synthetic */ PropertyPanel access$2600(ReadComponentListener readComponentListener) {
            return readComponentListener.PropertyPanel.this;
        }
    }

    private final class WriteComponentListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private Object oldValue;
        private Runnable comboActionTask;
        private Runnable requestFocusTask;
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyPanel;

        private WriteComponentListener() {
        }

        private void setOldValue(Object object) {
            this.oldValue = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (actionEvent.getSource() == PropertyPanel.this.comboBox) {
                SwingUtilities.invokeLater(this.getComboActionTask());
            } else {
                if (actionEvent.getSource() == PropertyPanel.this.textField) {
                    String string = PropertyPanel.this.textField.getText();
                    this.changeValue(string);
                }
                this.prepareReadState();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (keyEvent.getKeyCode() == 27) {
                if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isPopupVisible() && object instanceof Component && SwingUtilities.isDescendingFrom((Component)object, PropertyPanel.this.comboBox)) {
                    this.resetOldValue();
                } else if (object == PropertyPanel.this.textField) {
                    this.resetOldValue();
                    keyEvent.consume();
                }
                this.prepareReadState();
            } else if (keyEvent.getKeyCode() == 10 && PropertyPanel.this.comboBox != null && object instanceof Component && SwingUtilities.isDescendingFrom((Component)object, PropertyPanel.this.comboBox) && !PropertyPanel.this.comboBox.isEditable() && (PropertyPanel.this.preferences & 4) == 0) {
                this.changeValue((String)PropertyPanel.this.comboBox.getSelectedItem());
                this.prepareReadState();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            boolean bl;
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (PropertyPanel.this.comboBox != null && focusEvent.isTemporary()) {
                return;
            }
            boolean bl2 = PropertyPanel.this.differentValues && focusEvent.getSource().equals(PropertyPanel.this.textField) && NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertyPanel == null ? (class$org$openide$explorer$propertysheet$PropertyPanel = WriteComponentListener.class$("org.openide.explorer.propertysheet.PropertyPanel")) : class$org$openide$explorer$propertysheet$PropertyPanel, "CTL_Different_Values").equals(PropertyPanel.this.textField.getText());
            boolean bl3 = bl = PropertyPanel.this.editor != null && PropertyPanel.this.editor.supportsCustomEditor();
            if (bl || PropertyPanel.this.comboBox != null) {
                SwingUtilities.invokeLater(new Runnable(this, focusEvent, bl2){
                    private final /* synthetic */ FocusEvent val$e;
                    private final /* synthetic */ boolean val$differentValuesNoChange;
                    private final /* synthetic */ WriteComponentListener this$1;
                    {
                        this.this$1 = writeComponentListener;
                        this.val$e = focusEvent;
                        this.val$differentValuesNoChange = bl;
                    }

                    public void run() {
                        if (this.val$e.getSource().equals(PropertyPanel.access$1500(WriteComponentListener.access$1900(this.this$1))) && !this.val$differentValuesNoChange) {
                            this.this$1.changeValue(PropertyPanel.access$1500(WriteComponentListener.access$1900(this.this$1)).getText());
                            if (PropertyPanel.access$1800(WriteComponentListener.access$1900(this.this$1)) != null && !PropertyPanel.access$1800(WriteComponentListener.access$1900(this.this$1)).getAsText().equals(PropertyPanel.access$1500(WriteComponentListener.access$1900(this.this$1)).getText())) {
                                PropertyPanel.access$1500(WriteComponentListener.access$1900(this.this$1)).setText(PropertyPanel.access$1800(WriteComponentListener.access$1900(this.this$1)).getAsText());
                            }
                        }
                        if (SwingUtilities.findFocusOwner(WriteComponentListener.access$1900(this.this$1)) == null && PropertyPanel.access$1300(WriteComponentListener.access$1900(this.this$1))) {
                            if (!this.val$differentValuesNoChange) {
                                WriteComponentListener.access$2000(this.this$1, this.val$e);
                            } else {
                                WriteComponentListener.access$1900(this.this$1).setReadState();
                            }
                        }
                    }
                });
            } else if (!bl2) {
                this.resetReadState(focusEvent);
            } else {
                PropertyPanel.this.setReadState();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyPanel.this.textField) {
                PropertyPanel.this.textField.selectAll();
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                PropertyPanel.this.comboBox.getEditor().selectAll();
            }
        }

        public void changeValue(String string) {
            if (!(string == null || PropertyPanel.this.editor.getValue() != null && string.equals(PropertyPanel.this.editor.getAsText()) || this.setAsText(string))) {
                this.resetOldValue();
            }
        }

        private synchronized Runnable getComboActionTask() {
            if (this.comboActionTask == null) {
                this.comboActionTask = new Runnable(this){
                    private final /* synthetic */ WriteComponentListener this$1;
                    {
                        this.this$1 = writeComponentListener;
                    }

                    public void run() {
                        if (PropertyPanel.access$1400(WriteComponentListener.access$1900(this.this$1)).isPopupVisible() || !PropertyPanel.access$1300(WriteComponentListener.access$1900(this.this$1))) {
                            return;
                        }
                        this.this$1.changeValue((String)PropertyPanel.access$1400(WriteComponentListener.access$1900(this.this$1)).getSelectedItem());
                        WriteComponentListener.access$2100(this.this$1);
                    }
                };
            }
            return this.comboActionTask;
        }

        private synchronized Runnable getRequestFocusTask() {
            if (this.requestFocusTask == null) {
                this.requestFocusTask = new Runnable(this){
                    private final /* synthetic */ WriteComponentListener this$1;
                    {
                        this.this$1 = writeComponentListener;
                    }

                    public void run() {
                        Component component = PropertyPanel.access$2200(WriteComponentListener.access$1900(this.this$1));
                        if (component != null) {
                            component.requestFocus();
                        }
                    }
                };
            }
            return this.requestFocusTask;
        }

        private void prepareReadState() {
            boolean bl = SwingUtilities.findFocusOwner(PropertyPanel.this) != null;
            PropertyPanel.this.setReadState();
            if (bl) {
                SwingUtilities.invokeLater(this.getRequestFocusTask());
            }
        }

        private void resetReadState(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyPanel.this.customizeButton && PropertyPanel.this.textField != null) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (focusEvent.getSource() == PropertyPanel.this.textField) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                this.changeValue((String)PropertyPanel.this.comboBox.getEditor().getItem());
            }
            PropertyPanel.this.setReadState();
        }

        private void resetOldValue() {
            try {
                if (!PropertyPanel.this.differentValues) {
                    PropertyPanel.this.editor.setValue(this.oldValue);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(illegalArgumentException);
            }
            catch (RuntimeException runtimeException) {
                PropertyPanel.this.processThrowable(runtimeException);
            }
        }

        private boolean setAsText(String string) {
            try {
                PropertyPanel.this.editor.setAsText(string);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(illegalArgumentException);
            }
            catch (RuntimeException runtimeException) {
                PropertyPanel.this.processThrowable(runtimeException);
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ PropertyPanel access$1900(WriteComponentListener writeComponentListener) {
            return writeComponentListener.PropertyPanel.this;
        }

        static /* synthetic */ void access$2000(WriteComponentListener writeComponentListener, FocusEvent focusEvent) {
            writeComponentListener.resetReadState(focusEvent);
        }

        static /* synthetic */ void access$2100(WriteComponentListener writeComponentListener) {
            writeComponentListener.prepareReadState();
        }
    }

    static class SimpleModel
    implements ExPropertyModel {
        private Node.Property prop;
        private Object[] beans;
        private PropertyChangeSupport sup = new PropertyChangeSupport(this);

        public SimpleModel(Node.Property property, Object[] objectArray) {
            this.prop = property;
            this.beans = objectArray;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            try {
                this.prop.setValue(object);
                this.sup.firePropertyChange("value", null, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.annotateException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        private InvocationTargetException annotateException(Exception exception) {
            if (exception instanceof InvocationTargetException) {
                return (InvocationTargetException)exception;
            }
            return new InvocationTargetException(exception);
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            PropertyEditor propertyEditor = this.prop.getPropertyEditor();
            if (propertyEditor != null) {
                return propertyEditor.getClass();
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.sup.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.sup.removePropertyChangeListener(propertyChangeListener);
        }

        public Object[] getBeans() {
            return this.beans;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }

        void fireValueChanged() {
            this.sup.firePropertyChange("value", null, null);
        }
    }

    private static class EmptyModel
    implements PropertyModel {
        static /* synthetic */ Class class$java$lang$Object;

        private EmptyModel() {
        }

        public Object getValue() throws InvocationTargetException {
            return null;
        }

        public void setValue(Object object) throws InvocationTargetException {
        }

        public Class getPropertyType() {
            return class$java$lang$Object == null ? (class$java$lang$Object = EmptyModel.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Class getPropertyEditorClass() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class PropertySheetSettingsInvoker
    implements Runnable {
        PropertySheetSettingsInvoker() {
        }

        public void run() {
            PropertyPanel propertyPanel = (PropertyPanel)current.get();
            current.set(null);
            if (propertyPanel == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings propertySheetSettings = PropertySheetSettings.getDefault();
            propertyPanel.paintingStyle = propertySheetSettings.getPropertyPaintingStyle();
            propertyPanel.plastic = propertySheetSettings.getPlastic();
            propertyPanel.disabledColor = propertySheetSettings.getDisabledPropertyColor();
            propertyPanel.foregroundColor = propertySheetSettings.getValueColor();
        }
    }
}

