/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.EmptyPanel;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.explorer.propertysheet.PropertySheetTab;
import org.openide.explorer.propertysheet.PropertySheetToolbar;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class PropertySheet
extends JPanel {
    static final long serialVersionUID = -7698351033045864945L;
    public static final String PROPERTY_SORTING_MODE = "sortingMode";
    public static final String PROPERTY_VALUE_COLOR = "valueColor";
    public static final String PROPERTY_DISABLED_PROPERTY_COLOR = "disabledPropertyColor";
    public static final String PROPERTY_CURRENT_PAGE = "currentPage";
    public static final String PROPERTY_PLASTIC = "plastic";
    public static final String PROPERTY_PROPERTY_PAINTING_STYLE = "propertyPaintingStyle";
    public static final String PROPERTY_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final int ALWAYS_AS_STRING = 1;
    public static final int STRING_PREFERRED = 2;
    public static final int PAINTING_PREFERRED = 3;
    public static final int UNSORTED = 0;
    public static final int SORTED_BY_NAMES = 1;
    public static final int SORTED_BY_TYPES = 2;
    protected static Icon iNoSort;
    protected static Icon iAlphaSort;
    protected static Icon iTypeSort;
    protected static Icon iDisplayWritableOnly;
    protected static Icon iCustomize;
    static final String PROP_HAS_CUSTOMIZER = "hasCustomizer";
    static final String PROP_PAGE_HELP_ID = "pageHelpID";
    private int savedSplitterPosition = -1;
    private transient JTabbedPane pages;
    private transient EmptyPanel emptyPanel;
    private transient int pageIndex = 0;
    private transient PropertyChangeListener settingsListener;
    private transient ChangeListener tabListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            int n = PropertySheet.this.pages.getSelectedIndex();
            PropertySheet.this.setCurrentPage(n);
        }
    };
    private Node activeNode;
    private NodeListener activeNodeListener;
    private boolean displayWritableOnly;
    private int propertyPaintingStyle;
    private int sortingMode;
    private boolean plastic;
    private Color disabledPropertyColor;
    private Color valueColor;
    private transient DelayedUpdater delayedUpdater;
    static ThreadLocal current;
    private static Method helpMethod;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane;

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet).getString(string);
    }

    public PropertySheet() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        boolean bl = false;
        try {
            serializable = Class.forName("org.openide.explorer.propertysheet.PropertySheet$PropertySheetSettingsInvoker");
            Runnable runnable = (Runnable)serializable.newInstance();
            current.set(this);
            runnable.run();
        }
        catch (Exception exception) {
            bl = true;
        }
        catch (LinkageError linkageError) {
            bl = true;
        }
        if (bl) {
            this.displayWritableOnly = false;
            this.propertyPaintingStyle = 3;
            this.sortingMode = 1;
            this.plastic = false;
            this.disabledPropertyColor = SystemColor.textInactiveText;
            this.valueColor = new Color(0, 0, 128);
        }
        this.pages = new HelpAwareJTabbedPane();
        this.pages.getAccessibleContext().setAccessibleName(PropertySheet.getString("ACS_PropertySheetTabs"));
        this.pages.getAccessibleContext().setAccessibleDescription(PropertySheet.getString("ACSD_PropertySheetTabs"));
        this.pages.addChangeListener(this.tabListener);
        this.emptyPanel = new EmptyPanel(PropertySheet.getString("CTL_NoProperties"));
        this.pages.setTabPlacement(3);
        this.add((Component)this.emptyPanel, "Center");
        serializable = new PropertySheetToolbar(this);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.add((Component)serializable, "North");
        this.setNodes(new Node[0]);
        this.setPreferredSize(new Dimension(200, 300));
    }

    public void setNodes(Node[] nodeArray) {
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            if (this.delayedUpdater == null) {
                this.delayedUpdater = new DelayedUpdater();
            }
        }
        this.delayedUpdater.updateNodes(nodeArray);
    }

    public void setPropertyPaintingStyle(int n) {
        if (n == this.propertyPaintingStyle) {
            return;
        }
        int n2 = this.propertyPaintingStyle;
        this.propertyPaintingStyle = n;
        this.firePropertyChange(PROPERTY_PROPERTY_PAINTING_STYLE, new Integer(n2), new Integer(n));
    }

    public int getPropertyPaintingStyle() {
        return this.propertyPaintingStyle;
    }

    public void setSortingMode(int n) throws PropertyVetoException {
        if (this.sortingMode == n) {
            return;
        }
        int n2 = this.sortingMode;
        this.sortingMode = n;
        this.firePropertyChange(PROPERTY_SORTING_MODE, new Integer(n2), new Integer(n));
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public void setCurrentPage(int n) {
        Component component;
        int n2;
        if (this.pageIndex == n) {
            return;
        }
        this.pageIndex = n;
        if (n < 0) {
            return;
        }
        if (n != this.pages.getSelectedIndex()) {
            this.pages.setSelectedIndex(n);
        }
        if ((n2 = this.pages.getSelectedIndex()) >= 0 && (component = this.pages.getComponentAt(n2)) instanceof PropertySheetTab) {
            ((PropertySheetTab)component).ensurePaneCreated();
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    public boolean setCurrentPage(String string) {
        int n = this.pages.indexOfTab(string);
        if (n < 0) {
            return false;
        }
        this.setCurrentPage(n);
        return true;
    }

    public int getCurrentPage() {
        return this.pages.getSelectedIndex();
    }

    String getPageHelpID() {
        String string;
        Component component;
        if (this.isAncestorOf(this.pages) && (component = this.pages.getSelectedComponent()) instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
            return string;
        }
        return null;
    }

    public void setPlastic(boolean bl) {
        if (this.plastic == bl) {
            return;
        }
        this.plastic = bl;
        this.firePropertyChange(PROPERTY_PLASTIC, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getPlastic() {
        return this.plastic;
    }

    public void setValueColor(Color color) {
        if (this.valueColor.equals(color)) {
            return;
        }
        Color color2 = this.valueColor;
        this.valueColor = color;
        this.firePropertyChange(PROPERTY_VALUE_COLOR, color2, color);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setDisabledPropertyColor(Color color) {
        if (this.disabledPropertyColor.equals(color)) {
            return;
        }
        Color color2 = this.disabledPropertyColor;
        this.disabledPropertyColor = color;
        this.firePropertyChange(PROPERTY_DISABLED_PROPERTY_COLOR, color2, color);
    }

    public Color getDisabledPropertyColor() {
        return this.disabledPropertyColor;
    }

    public void setDisplayWritableOnly(boolean bl) {
        if (this.displayWritableOnly == bl) {
            return;
        }
        this.displayWritableOnly = bl;
        this.firePropertyChange(PROPERTY_DISPLAY_WRITABLE_ONLY, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getDisplayWritableOnly() {
        return this.displayWritableOnly;
    }

    void setSavedPosition(int n) {
        this.savedSplitterPosition = n;
    }

    int getSavedPosition() {
        return this.savedSplitterPosition;
    }

    private void setCurrentNode(Node node) {
        int n;
        int n2;
        Node.PropertySet[] propertySetArray;
        if (this.activeNode == node) {
            return;
        }
        String string = null;
        if (this.activeNode != null) {
            this.activeNode.removeNodeListener(this.activeNodeListener);
            propertySetArray = this.activeNode.getPropertySets();
            if (propertySetArray == null) {
                ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
                propertySetArray = new Node.PropertySet[]{};
            }
            if (this.pageIndex >= 0 && this.pageIndex < propertySetArray.length) {
                string = propertySetArray[this.pageIndex].getDisplayName();
            }
            n2 = 0;
            n = this.pages.getTabCount();
            while (n2 < n) {
                ((PropertySheetTab)this.pages.getComponentAt(n2)).detachPropertyChangeListener();
                ++n2;
            }
            this.pages.removeAll();
        }
        this.activeNode = node;
        if (this.activeNode != null) {
            this.activeNodeListener = new ActiveNodeListener();
            this.activeNode.addNodeListener(WeakListener.node(this.activeNodeListener, this.activeNode));
            propertySetArray = this.activeNode.getPropertySets();
            if (propertySetArray == null) {
                ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
                propertySetArray = new Node.PropertySet[]{};
            }
            n2 = 0;
            n = propertySetArray.length;
            while (n2 < n) {
                Node.PropertySet propertySet = propertySetArray[n2];
                if (!propertySet.isHidden()) {
                    this.pages.addTab(propertySet.getDisplayName(), null, new PropertySheetTab(propertySet, node, this), propertySet.getShortDescription());
                }
                ++n2;
            }
            if (this.pages.getTabCount() > 0) {
                Component component;
                int n3;
                if (this.isAncestorOf(this.emptyPanel)) {
                    this.remove(this.emptyPanel);
                    this.add((Component)this.pages, "Center");
                }
                if (string != null) {
                    this.setCurrentPage(string);
                }
                if ((n3 = this.pages.getSelectedIndex()) >= 0 && (component = this.pages.getComponentAt(n3)) instanceof PropertySheetTab) {
                    ((PropertySheetTab)component).ensurePaneCreated();
                }
            } else if (this.isAncestorOf(this.pages)) {
                this.remove(this.pages);
                this.add((Component)this.emptyPanel, "Center");
            }
        } else if (this.isAncestorOf(this.pages)) {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
        this.revalidate();
        this.repaint();
        if (this.activeNode != null && this.activeNode.hasCustomizer()) {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.TRUE);
        } else {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.FALSE);
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    void invokeCustomization() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertySheet$CustomizationInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
            return;
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (this.activeNode == null) {
            throw new IllegalStateException();
        }
        Component component = this.activeNode.getCustomizer();
        if (component == null) {
            throw new IllegalStateException("Node " + this.activeNode + " doesn't have a customizer");
        }
        final JDialog jDialog = new JDialog();
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add(component, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet).getString("CTL_Close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)jDialog).setVisible(false);
                jDialog.dispose();
            }
        });
        jPanel.add(jButton);
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.pack();
        jDialog.show();
    }

    void invokeHelp() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertySheet$HelpInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
            return;
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$1200(PropertySheet propertySheet) {
        return propertySheet.pageIndex;
    }

    static {
        current = new ThreadLocal();
        try {
            helpMethod = (class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane == null ? (class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet$HelpAwareJTabbedPane")) : class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane).getMethod("getHelpCtx", new Class[0]);
            ((AccessibleObject)helpMethod).setAccessible(true);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(exception);
        }
    }

    private static final class HelpAwareJTabbedPane
    extends JTabbedPane {
        public HelpAwareJTabbedPane() {
            this.putClientProperty("HelpIDMethod", helpMethod);
            if (Boolean.getBoolean("netbeans.scrolling.tabs")) {
                boolean bl;
                boolean bl2 = bl = Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0;
                if (bl) {
                    try {
                        Method method = this.getClass().getMethod("setTabLayoutPolicy", Integer.TYPE);
                        method.invoke((Object)this, new Integer(1));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
        }

        public HelpCtx getHelpCtx() {
            String string;
            Component component = this.getSelectedComponent();
            if (component instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
                return new HelpCtx(string);
            }
            return HelpCtx.findHelp(this.getParent());
        }
    }

    private class ActiveNodeListener
    extends NodeAdapter {
        private ActiveNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != PropertySheet.this.activeNode) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == null || "propertySets".equals(propertyChangeEvent.getPropertyName())) {
                Mutex.EVENT.readAccess(new Runnable(this){
                    private final /* synthetic */ ActiveNodeListener this$1;
                    {
                        this.this$1 = activeNodeListener;
                    }

                    public void run() {
                        Node.PropertySet[] propertySetArray;
                        String string = null;
                        if (PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)) != null) {
                            propertySetArray = PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)).getPropertySets();
                            if (propertySetArray == null) {
                                ErrorManager.getDefault().log(16, "Node " + PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)) + ": getPropertySets() returns null!");
                                propertySetArray = new Node.PropertySet[]{};
                            }
                            if (PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1)) >= 0 && PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1)) < propertySetArray.length) {
                                string = propertySetArray[PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1))].getDisplayName();
                            }
                        }
                        propertySetArray = PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1));
                        PropertySheet.access$700(ActiveNodeListener.access$1100(this.this$1), null);
                        PropertySheet.access$700(ActiveNodeListener.access$1100(this.this$1), (Node)propertySetArray);
                        if (string != null) {
                            ActiveNodeListener.access$1100(this.this$1).setCurrentPage(string);
                        }
                    }
                });
            }
        }

        static /* synthetic */ PropertySheet access$1100(ActiveNodeListener activeNodeListener) {
            return activeNodeListener.PropertySheet.this;
        }
    }

    static class HelpInvoker
    implements Runnable {
        HelpInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null || propertySheet.getPageHelpID() == null) {
                throw new IllegalStateException();
            }
            TopManager.getDefault().showHelp(new HelpCtx(propertySheet.getPageHelpID()));
        }
    }

    static class CustomizationInvoker
    implements Runnable {
        CustomizationInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null || propertySheet.activeNode == null) {
                throw new IllegalStateException();
            }
            TopManager.getDefault().getNodeOperation().customize(propertySheet.activeNode);
        }
    }

    private class DelayedUpdater
    implements ActionListener {
        private Node[] nodes;
        private Timer timer;

        private DelayedUpdater() {
        }

        public void updateNodes(Node[] nodeArray) {
            DelayedUpdater delayedUpdater = this;
            synchronized (delayedUpdater) {
                this.nodes = nodeArray;
                if (this.timer == null) {
                    this.timer = new Timer(70, this);
                    this.timer.setCoalesce(true);
                    this.timer.setRepeats(false);
                }
                this.timer.start();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node node = null;
            DelayedUpdater delayedUpdater = this;
            synchronized (delayedUpdater) {
                DelayedUpdater delayedUpdater2 = this;
                synchronized (delayedUpdater2) {
                    node = this.nodes.length == 1 ? this.nodes[0] : new ProxyNode(this.nodes);
                    this.timer.stop();
                }
            }
            PropertySheet.this.setCurrentNode(node);
        }
    }

    private static class PropertySheetSettingsInvoker
    implements Runnable {
        private PropertySheetSettingsInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings propertySheetSettings = PropertySheetSettings.getDefault();
            propertySheet.displayWritableOnly = propertySheetSettings.getDisplayWritableOnly();
            propertySheet.propertyPaintingStyle = propertySheetSettings.getPropertyPaintingStyle();
            propertySheet.sortingMode = propertySheetSettings.getSortingMode();
            propertySheet.plastic = propertySheetSettings.getPlastic();
            propertySheet.disabledPropertyColor = propertySheetSettings.getDisabledPropertyColor();
            propertySheet.valueColor = propertySheetSettings.getValueColor();
        }
    }
}

