/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.compiler.ExternalCompiler;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.ExternalCompiler;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ErrorExpressionPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    private ExternalCompiler.ErrorExpressionEditor editor;
    static final long serialVersionUID = -2763818133650482979L;
    private JPanel jPanel1;
    private JLabel presetNameLabel;
    private JLabel errorDescriptionLabel;
    private JLabel filePositionLabel;
    private JLabel linePositionLabel;
    private JLabel columnPositionLabel;
    private JLabel descriptionPositionLabel;
    private JLabel errorDescriptionsLabel;
    private JTextField presetNameField;
    private JTextField errorDescriptionField;
    private JTextField filePositionField;
    private JTextField linePositionField;
    private JTextField columnPositionField;
    private JTextField descriptionPositionField;
    private JScrollPane presetsScroll;
    private JList errorDescriptions;
    private JPanel jPanel2;
    private JButton addButton;
    private JButton setButton;
    private JButton removeButton;
    private ExternalCompiler.ErrorExpression descriptions;
    private boolean internalListChange = false;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel;

    public ErrorExpressionPanel(ExternalCompiler.ErrorExpressionEditor errorExpressionEditor) {
        this.editor = errorExpressionEditor;
        this.descriptions = (ExternalCompiler.ErrorExpression)errorExpressionEditor.getValue();
        this.initComponents();
        this.addButton.setText(ErrorExpressionPanel.getString("CTL_AddError"));
        this.addButton.setToolTipText(ErrorExpressionPanel.getString("CTL_AddError_tip"));
        this.removeButton.setText(ErrorExpressionPanel.getString("CTL_RemoveError"));
        this.removeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_RemoveError_tip"));
        this.setButton.setText(ErrorExpressionPanel.getString("CTL_SetError"));
        this.setButton.setToolTipText(ErrorExpressionPanel.getString("CTL_SetError_tip"));
        this.presetNameLabel.setText(ErrorExpressionPanel.getString("CTL_Preset_label"));
        this.errorDescriptionLabel.setText(ErrorExpressionPanel.getString("CTL_Error_label"));
        this.filePositionLabel.setText(ErrorExpressionPanel.getString("CTL_File_label"));
        this.linePositionLabel.setText(ErrorExpressionPanel.getString("CTL_Line_label"));
        this.columnPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Column_label"));
        this.descriptionPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Description_label"));
        this.errorDescriptionsLabel.setText(ErrorExpressionPanel.getString("CTL_Descriptions"));
        this.addButton.setMnemonic(ErrorExpressionPanel.getString("CTL_AddError_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(ErrorExpressionPanel.getString("CTL_RemoveError_Mnemonic").charAt(0));
        this.setButton.setMnemonic(ErrorExpressionPanel.getString("CTL_SetError_Mnemonic").charAt(0));
        this.presetNameLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Preset_label_Mnemonic").charAt(0));
        this.errorDescriptionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Error_label_Mnemonic").charAt(0));
        this.filePositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_File_label_Mnemonic").charAt(0));
        this.linePositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Line_label_Mnemonic").charAt(0));
        this.columnPositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Column_label_Mnemonic").charAt(0));
        this.descriptionPositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Description_label_Mnemonic").charAt(0));
        this.errorDescriptionsLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Descriptions_Mnemonic").charAt(0));
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ErrorExpressionPanel.this.internalListChange) {
                    return;
                }
                int n = ErrorExpressionPanel.this.errorDescriptions.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ErrorExpressionPanel.this.descriptions = ErrorExpressionPanel.this.editor.getExpressions()[n];
                ErrorExpressionPanel.this.updateFields();
                ErrorExpressionPanel.this.updateButtons();
            }
        };
        this.errorDescriptions.addListSelectionListener(listSelectionListener);
        this.updateList();
        this.updateFields();
        this.updateButtons();
        HelpCtx.setHelpIDString(this, (class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel == null ? (class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.openide.explorer.propertysheet.editors.ErrorExpressionPanel")) : class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel).getName());
        this.presetNameField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_PresetField"));
        this.errorDescriptionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ErrorField"));
        this.filePositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_FileField"));
        this.linePositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_LineField"));
        this.columnPositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ColumnField"));
        this.descriptionPositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_DescriptionField"));
        this.errorDescriptions.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_DescriptionsList"));
        this.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ErrorExpressionPanel"));
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.descriptions;
    }

    private void updateList() {
        ExternalCompiler.ErrorExpression[] errorExpressionArray = this.editor.getExpressions();
        ExternalCompiler.ErrorExpression errorExpression = this.descriptions;
        String[] stringArray = new String[errorExpressionArray.length];
        int n = -1;
        int n2 = 0;
        while (n2 < errorExpressionArray.length) {
            stringArray[n2] = errorExpressionArray[n2].getName();
            if (errorExpression != null && errorExpressionArray[n2].getName().equals(errorExpression.getName())) {
                n = n2;
            }
            ++n2;
        }
        this.internalListChange = true;
        this.errorDescriptions.setListData(stringArray);
        this.internalListChange = false;
        if (n != -1) {
            this.errorDescriptions.setSelectedIndex(n);
        }
    }

    private void updateFields() {
        ExternalCompiler.ErrorExpression errorExpression = this.descriptions;
        if (errorExpression == null) {
            return;
        }
        this.presetNameField.setText(errorExpression.getName());
        this.errorDescriptionField.setText(errorExpression.getErrorExpression());
        this.filePositionField.setText(String.valueOf(errorExpression.getFilePos()));
        this.linePositionField.setText(String.valueOf(errorExpression.getLinePos()));
        this.columnPositionField.setText(String.valueOf(errorExpression.getColumnPos()));
        this.descriptionPositionField.setText(String.valueOf(errorExpression.getDescriptionPos()));
    }

    private void updateButtons() {
        boolean bl;
        boolean bl2 = bl = this.errorDescriptions.getSelectedIndex() != -1;
        if (bl) {
            bl = !this.isReadOnly(this.descriptions);
        }
        this.removeButton.setEnabled(bl);
        this.setButton.setEnabled(bl);
        this.addButton.setEnabled(!"".equals(this.presetNameField.getText()));
    }

    private boolean isReadOnly(ExternalCompiler.ErrorExpression errorExpression) {
        if (errorExpression.equals(ExternalCompiler.JAVAC)) {
            return true;
        }
        if (errorExpression.equals(ExternalCompiler.JVC)) {
            return true;
        }
        return errorExpression.equals(ExternalCompiler.JIKES);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.presetNameLabel = new JLabel();
        this.errorDescriptionLabel = new JLabel();
        this.filePositionLabel = new JLabel();
        this.linePositionLabel = new JLabel();
        this.columnPositionLabel = new JLabel();
        this.descriptionPositionLabel = new JLabel();
        this.errorDescriptionsLabel = new JLabel();
        this.presetNameField = new JTextField();
        this.errorDescriptionField = new JTextField();
        this.filePositionField = new JTextField();
        this.linePositionField = new JTextField();
        this.columnPositionField = new JTextField();
        this.descriptionPositionField = new JTextField();
        this.presetsScroll = new JScrollPane();
        this.errorDescriptions = new JList();
        this.jPanel2 = new JPanel();
        this.addButton = new JButton();
        this.setButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new BorderLayout(11, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.presetNameLabel.setText("jLabel1");
        this.presetNameLabel.setLabelFor(this.presetNameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.presetNameLabel, gridBagConstraints);
        this.errorDescriptionLabel.setText("jLabel2");
        this.errorDescriptionLabel.setLabelFor(this.errorDescriptionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.errorDescriptionLabel, gridBagConstraints);
        this.filePositionLabel.setText("jLabel3");
        this.filePositionLabel.setLabelFor(this.filePositionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.filePositionLabel, gridBagConstraints);
        this.linePositionLabel.setText("jLabel4");
        this.linePositionLabel.setLabelFor(this.linePositionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.linePositionLabel, gridBagConstraints);
        this.columnPositionLabel.setText("jLabel5");
        this.columnPositionLabel.setLabelFor(this.columnPositionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.columnPositionLabel, gridBagConstraints);
        this.descriptionPositionLabel.setText("jLabel6");
        this.descriptionPositionLabel.setLabelFor(this.descriptionPositionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.descriptionPositionLabel, gridBagConstraints);
        this.errorDescriptionsLabel.setText("jLabel7");
        this.errorDescriptionsLabel.setLabelFor(this.errorDescriptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.errorDescriptionsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.presetNameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.errorDescriptionField, gridBagConstraints);
        this.filePositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.filePositionField, gridBagConstraints);
        this.linePositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.linePositionField, gridBagConstraints);
        this.columnPositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.columnPositionField, gridBagConstraints);
        this.descriptionPositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.descriptionPositionField, gridBagConstraints);
        this.presetsScroll.setPreferredSize(new Dimension(300, 200));
        this.errorDescriptions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ErrorExpressionPanel.this.errorDescriptionsMouseClicked(mouseEvent);
            }
        });
        this.presetsScroll.setViewportView(this.errorDescriptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.presetsScroll, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.addButton.setText("jButton1");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.anchor = 11;
        this.jPanel2.add((Component)this.addButton, gridBagConstraints2);
        this.setButton.setText("jButton2");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.setButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.anchor = 11;
        this.jPanel2.add((Component)this.setButton, gridBagConstraints2);
        this.removeButton.setText("jButton3");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.weighty = 1.0;
        this.jPanel2.add((Component)this.removeButton, gridBagConstraints2);
        this.add((Component)this.jPanel2, "East");
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        ExternalCompiler.ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection collection = this.editor.getExpressionsVector();
            int n = this.errorDescriptions.getSelectedIndex();
            collection.remove(this.descriptions);
            if (n >= collection.size()) {
                n = collection.size() - 1;
            }
            this.descriptions = n >= 0 ? this.editor.getExpressions()[n] : null;
            this.updateList();
        }
    }

    private void setButtonActionPerformed(ActionEvent actionEvent) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ExternalCompiler.ErrorExpression errorExpression = this.descriptions;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Integer.parseInt(this.filePositionField.getText());
            n2 = Integer.parseInt(this.linePositionField.getText());
            n3 = Integer.parseInt(this.columnPositionField.getText());
            n4 = Integer.parseInt(this.descriptionPositionField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        errorExpression.setName(this.presetNameField.getText());
        errorExpression.setErrorExpression(this.errorDescriptionField.getText());
        errorExpression.setFilePos(n);
        errorExpression.setLinePos(n2);
        errorExpression.setColumnPos(n3);
        errorExpression.setDescriptionPos(n4);
        this.updateList();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ExternalCompiler.ErrorExpression[] errorExpressionArray = this.editor.getExpressions();
        int n = 0;
        while (n < errorExpressionArray.length) {
            if (errorExpressionArray[n].getName().equals(this.presetNameField.getText())) {
                return;
            }
            ++n;
        }
        ExternalCompiler.ErrorExpression errorExpression = null;
        try {
            errorExpression = new ExternalCompiler.ErrorExpression(this.presetNameField.getText(), this.errorDescriptionField.getText(), Integer.parseInt(this.filePositionField.getText()), Integer.parseInt(this.linePositionField.getText()), Integer.parseInt(this.columnPositionField.getText()), Integer.parseInt(this.descriptionPositionField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        ExternalCompiler.ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection collection = this.editor.getExpressionsVector();
            int n2 = this.errorDescriptions.getSelectedIndex();
            collection.add(errorExpression);
            this.descriptions = errorExpression;
            this.updateList();
        }
    }

    private void errorDescriptionsMouseClicked(MouseEvent mouseEvent) {
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel == null ? (class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.openide.explorer.propertysheet.editors.ErrorExpressionPanel")) : class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

