/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.editors.NodePropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class FileEditor
extends PropertyEditorSupport
implements NodePropertyEditor {
    private int mode = 2;
    private Node[] nodes = null;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$FileEditor;

    public FileEditor() {
    }

    public FileEditor(int n) {
        this.mode = n;
    }

    public void attach(Node[] nodeArray) {
        this.nodes = nodeArray;
    }

    public void setAsText(String string) {
        this.setValue(new File(string));
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof File) {
            return object.toString();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        if (this.nodes != null) {
            int n = 0;
            while (n < this.nodes.length) {
                Node.PropertySet[] propertySetArray = this.nodes[n].getPropertySets();
                int n2 = 0;
                while (n2 < propertySetArray.length) {
                    Node.Property[] propertyArray = propertySetArray[n2].getProperties();
                    int n3 = 0;
                    while (n3 < propertyArray.length) {
                        Node.Property property;
                        if (!(!(class$java$io$File == null ? FileEditor.class$("java.io.File") : class$java$io$File).equals((property = propertyArray[n3]).getValueType()) || property.canRead() && property.canWrite())) {
                            return false;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return true;
    }

    public Component getCustomEditor() {
        final JFileChooser jFileChooser = this.createFileChooser();
        final JDialog jDialog = new JDialog(WindowManager.getDefault().getMainWindow(), jFileChooser.getDialogTitle(), true);
        jDialog.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)jDialog).setVisible(false);
                jDialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        jDialog.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((Component)jDialog).setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jFileChooser, "Center");
        jFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                    File file = jFileChooser.getSelectedFile();
                    FileEditor.this.setValue(file);
                    ((Component)jDialog).setVisible(false);
                    jDialog.dispose();
                } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                    ((Component)jDialog).setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        HelpCtx.setHelpIDString(jDialog.getRootPane(), this.getHelpCtx().getHelpID());
        return jDialog;
    }

    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return "null";
        }
        return "new java.io.File (\"" + Utilities.replaceString(file.getAbsolutePath(), "\\", "\\\\") + "\")";
    }

    protected JFileChooser createFileChooser() {
        File file = (File)this.getValue();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(this.mode);
        if (file != null && file.getParent() != null) {
            jFileChooser.setCurrentDirectory(new File(file.getParent()));
        }
        jFileChooser.setSelectedFile(file);
        jFileChooser.setApproveButtonText(FileEditor.getString("CTL_ApproveSelect"));
        jFileChooser.setApproveButtonToolTipText(FileEditor.getString("CTL_ApproveSelectToolTip"));
        switch (this.mode) {
            case 2: {
                jFileChooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                break;
            }
            case 0: {
                jFileChooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                break;
            }
            case 1: {
                jFileChooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
            }
        }
        return jFileChooser;
    }

    protected HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$explorer$propertysheet$editors$FileEditor == null ? (class$org$openide$explorer$propertysheet$editors$FileEditor = FileEditor.class$("org.openide.explorer.propertysheet.editors.FileEditor")) : class$org$openide$explorer$propertysheet$editors$FileEditor);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$FileEditor == null ? (class$org$openide$explorer$propertysheet$editors$FileEditor = FileEditor.class$("org.openide.explorer.propertysheet.editors.FileEditor")) : class$org$openide$explorer$propertysheet$editors$FileEditor).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

