/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

final class DragDropUtilities {
    static final boolean dragAndDropEnabled = DragDropUtilities.isDragAndDropEnabled();
    static final int NODE_UP = -1;
    static final int NODE_CENTRAL = 0;
    static final int NODE_DOWN = 1;
    static final Point CURSOR_CENTRAL_POINT = new Point(10, 10);
    static Runnable postDropRun = null;
    static final int NoDrag = 0;
    static final int NoDrop = 1;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeViewDropSupport;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$org$openide$explorer$view$DragDropUtilities;

    private DragDropUtilities() {
    }

    private static boolean isDragAndDropEnabled() {
        if (!System.getProperty("java.version").startsWith("1.3")) {
            if (System.getProperty("netbeans.dnd.enabled") != null) {
                return Boolean.getBoolean("netbeans.dnd.enabled");
            }
            return true;
        }
        return false;
    }

    static Cursor chooseCursor(int n, boolean bl) {
        try {
            String string;
            Image image;
            switch (n) {
                case 1: 
                case 3: {
                    if (bl) {
                        image = Utilities.loadImage("org/openide/resources/cursorscopysingle.gif");
                        string = "ACTION_COPY";
                        break;
                    }
                    image = Utilities.loadImage("org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_COPY";
                    break;
                }
                case 2: {
                    if (bl) {
                        image = Utilities.loadImage("org/openide/resources/cursorsmovesingle.gif");
                        string = "ACTION_MOVE";
                        break;
                    }
                    image = Utilities.loadImage("org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_MOVE";
                    break;
                }
                case 0x40000000: {
                    if (bl) {
                        image = Utilities.loadImage("org/openide/resources/cursorsunknownsingle.gif");
                        string = "ACTION_LINK";
                        break;
                    }
                    image = Utilities.loadImage("org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_LINK";
                    break;
                }
                default: {
                    image = Utilities.loadImage("org/openide/resources/cursorsnone.gif");
                    string = "ACTION_NONE";
                }
            }
            return DragDropUtilities.createCustomCursor(image, string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(exception);
            return DragSource.DefaultMoveNoDrop;
        }
    }

    private static Cursor createCustomCursor(Image image, String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(16, 16);
        Image image2 = image;
        if (dimension.width != image.getWidth(null)) {
            BufferedImage bufferedImage = DragDropUtilities.createBufferedImage(dimension.width, dimension.height);
            image2 = Utilities.mergeImages(image, bufferedImage, 0, 0);
        }
        return toolkit.createCustomCursor(image2, new Point(1, 1), string);
    }

    private static final BufferedImage createBufferedImage(int n, int n2) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    static boolean checkNodeForAction(Node node, int n) {
        if (node.canCut() && (n == 2 || n == 3)) {
            return true;
        }
        return node.canCopy() && (n == 1 || n == 3 || n == 0x40000000 || n == 0x40000000);
    }

    static Transferable getNodeTransferable(Node[] nodeArray, int n) throws IOException {
        Transferable[] transferableArray = new Transferable[nodeArray.length];
        int n2 = 0;
        while (n2 < nodeArray.length) {
            Clipboard clipboard = DragDropUtilities.getClipboard();
            if (clipboard instanceof ExClipboard) {
                ExClipboard exClipboard = (ExClipboard)clipboard;
                transferableArray[n2] = n == 2 ? exClipboard.convert(nodeArray[n2].clipboardCut()) : exClipboard.convert(nodeArray[n2].clipboardCopy());
            } else {
                transferableArray[n2] = n == 2 ? nodeArray[n2].clipboardCut() : nodeArray[n2].clipboardCopy();
            }
            ++n2;
        }
        if (transferableArray.length == 1) {
            return transferableArray[0];
        }
        return new ExTransferable.Multi(transferableArray);
    }

    static Transferable getNodeTransferable(Node node, int n) throws IOException {
        return DragDropUtilities.getNodeTransferable(new Node[]{node}, n);
    }

    static void setPostDropRun(Runnable runnable) {
        postDropRun = runnable;
    }

    private static void invokePostDropRun() {
        if (postDropRun != null) {
            SwingUtilities.invokeLater(postDropRun);
            postDropRun = null;
        }
    }

    static void performDrop(PasteType pasteType) {
        try {
            Transferable transferable = pasteType.paste();
        }
        catch (UserCancelException userCancelException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(iOException);
        }
    }

    static PasteType[] getPasteTypes(Node node, Transferable transferable) {
        boolean bl = false;
        try {
            bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            PasteType[] pasteTypeArray = null;
            try {
                pasteTypeArray = node.getPasteTypes(transferable);
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().notify(nullPointerException);
            }
            return pasteTypeArray;
        }
        try {
            MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
            int n = multiTransferObject.getCount();
            Transferable[] transferableArray = new Transferable[n];
            PasteType[] pasteTypeArray = new PasteType[n];
            PasteType[] pasteTypeArray2 = null;
            int n2 = 0;
            while (n2 < n) {
                transferableArray[n2] = multiTransferObject.getTransferableAt(n2);
                pasteTypeArray2 = node.getPasteTypes(transferableArray[n2]);
                if (pasteTypeArray2.length == 0) {
                    return pasteTypeArray2;
                }
                pasteTypeArray[n2] = pasteTypeArray2[0];
                ++n2;
            }
            return new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray)};
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PasteType[0];
    }

    static void dropNotSuccesfull() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.view.DragDropUtilities.WarningInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            runnable.run();
            return;
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(null, "", NbBundle.getBundle(class$org$openide$explorer$view$TreeViewDropSupport == null ? (class$org$openide$explorer$view$TreeViewDropSupport = DragDropUtilities.class$("org.openide.explorer.view.TreeViewDropSupport")) : class$org$openide$explorer$view$TreeViewDropSupport).getString("MSG_NoPasteTypes"), 2);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = DragDropUtilities.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static Node secureFindNode(Object object) {
        try {
            return Visualizer.findNode(object);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return null;
        }
    }

    static JPopupMenu createDropFinishPopup(final TreeSet treeSet) {
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        final JMenuItem[] jMenuItemArray = new JMenuItem[treeSet.size()];
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Iterator iterator = treeSet.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    PasteType pasteType = (PasteType)iterator.next();
                    if (jMenuItemArray[n].equals(jMenuItem)) {
                        DragDropUtilities.performDrop(pasteType);
                        DragDropUtilities.invokePostDropRun();
                        break;
                    }
                    ++n;
                }
            }
        };
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jMenuItemArray[n] = new JMenuItem(((PasteType)iterator.next()).getName());
            jMenuItemArray[n].addActionListener(actionListener);
            jPopupMenuPlus.add(jMenuItemArray[n]);
            ++n;
        }
        jPopupMenuPlus.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$DragDropUtilities == null ? (class$org$openide$explorer$view$DragDropUtilities = DragDropUtilities.class$("org.openide.explorer.view.DragDropUtilities")) : class$org$openide$explorer$view$DragDropUtilities).getString("MSG_ABORT"));
        jPopupMenuPlus.add(jMenuItem);
        return jPopupMenuPlus;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            int n2 = 0;
            while (n2 < n) {
                transferableArray[n2] = this.p[n2].paste();
                ++n2;
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }

    private static class WarningInvoker
    implements Runnable {
        static /* synthetic */ Class class$org$openide$explorer$view$TreeViewDropSupport;

        private WarningInvoker() {
        }

        public void run() {
            TopManager.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getBundle(class$org$openide$explorer$view$TreeViewDropSupport == null ? (class$org$openide$explorer$view$TreeViewDropSupport = WarningInvoker.class$("org.openide.explorer.view.TreeViewDropSupport")) : class$org$openide$explorer$view$TreeViewDropSupport).getString("MSG_NoPasteTypes"), 2));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

