/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TableSheetCell;
import org.openide.explorer.view.TreeTableModelAdapter;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeTable
extends JTable {
    private TreeTableCellRenderer tree;
    private NodeTableModel tableModel;
    private int treeColumnIndex = -1;
    private int lastRow = -1;
    private boolean canEdit;
    private boolean ignoreScrolling = false;
    private boolean ignoreClearSelection = false;
    private int positionX;
    private boolean treeHScrollingEnabled = true;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTableModelAdapter;
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTable;

    public TreeTable(NodeTreeModel nodeTreeModel, NodeTableModel nodeTableModel) {
        this.tree = new TreeTableCellRenderer(nodeTreeModel);
        this.tableModel = new TreeTableModelAdapter(this.tree, nodeTableModel);
        NodeRenderer nodeRenderer = NodeRenderer.sharedInstance();
        this.tree.setCellRenderer(nodeRenderer);
        this.setModel(this.tableModel);
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter, this.tree);
        this.setDefaultEditor(class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter, new TreeTableCellEditor());
        TableSheetCell tableSheetCell = new TableSheetCell(this.tableModel);
        tableSheetCell.setFlat(true);
        this.setDefaultRenderer(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TreeTable.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, tableSheetCell);
        this.setDefaultEditor(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TreeTable.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, tableSheetCell);
        this.getTableHeader().setDefaultRenderer(tableSheetCell);
        this.getActionMap().put("selectNextColumn", new TreeTableAction(this.tree.getActionMap().get("selectChild"), this.getActionMap().get("selectNextColumn")));
        this.getActionMap().put("selectPreviousColumn", new TreeTableAction(this.tree.getActionMap().get("selectParent"), this.getActionMap().get("selectPreviousColumn")));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(class$org$openide$explorer$view$TreeTable == null ? (class$org$openide$explorer$view$TreeTable = TreeTable.class$("org.openide.explorer.view.TreeTable")) : class$org$openide$explorer$view$TreeTable).getString("ACSN_TreeTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$explorer$view$TreeTable == null ? (class$org$openide$explorer$view$TreeTable = TreeTable.class$("org.openide.explorer.view.TreeTable")) : class$org$openide$explorer$view$TreeTable).getString("ACSD_TreeTable"));
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        this.setUI(new TreeTableUI());
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter) ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    JTree getTree() {
        return this.tree;
    }

    int getTreeColumnIndex() {
        return this.treeColumnIndex;
    }

    void setTreeColumnIndex(int n) {
        if (this.treeColumnIndex == n) {
            return;
        }
        int n2 = this.treeColumnIndex;
        this.treeColumnIndex = n;
        this.firePropertyChange("treeColumnIndex", n2, this.treeColumnIndex);
    }

    public void clearSelection() {
        if (!this.ignoreClearSelection) {
            super.clearSelection();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.getTreeColumnIndex();
        if (tableModelEvent.getFirstRow() <= 0 && n != -1 && this.getColumnCount() > 0) {
            String string = this.getModel().getColumnName(n);
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setHeaderValue(string);
        }
        this.ignoreClearSelection = true;
        try {
            super.tableChanged(tableModelEvent);
            Object var6_5 = null;
            this.ignoreClearSelection = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ignoreClearSelection = false;
            throw throwable;
        }
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.canEdit = this.lastRow == n;
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && n2 == this.getTreeColumnIndex()) {
            this.ignoreScrolling = true;
            this.tree.scrollRectToVisible(this.tree.getRowBounds(n));
            this.ignoreScrolling = false;
        }
        return bl;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.lastRow = this.getSelectedRowCount() == 1 ? this.getSelectedRow() : -1;
        super.valueChanged(listSelectionEvent);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        this.updateTreeColumnIndex();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        this.updateTreeColumnIndex();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        this.updateTreeColumnIndex();
        int n = tableColumnModelEvent.getFromIndex();
        int n2 = tableColumnModelEvent.getToIndex();
        if (n != n2) {
            this.firePropertyChange("column_moved", n, n2);
        }
    }

    private void updateTreeColumnIndex() {
        int n = this.getColumnCount() - 1;
        while (n >= 0) {
            if (this.getColumnClass(n) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? TreeTable.class$("org.openide.explorer.view.TreeTableModelAdapter") : class$org$openide$explorer$view$TreeTableModelAdapter)) {
                this.setTreeColumnIndex(n);
                return;
            }
            --n;
        }
        this.setTreeColumnIndex(-1);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionX(int n) {
        if (n == this.positionX || !this.treeHScrollingEnabled) {
            return;
        }
        int n2 = this.positionX;
        this.positionX = n;
        this.firePropertyChange("positionX", n2, n);
        if (this.isEditing() && this.getEditingColumn() == this.getTreeColumnIndex()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (this.ignoreScrolling && tableCellEditor instanceof TreeTableCellEditor) {
                ((TreeTableCellEditor)tableCellEditor).revalidateTextField();
            } else {
                this.removeEditor();
            }
        }
        this.repaint();
    }

    void setTreeHScrollingEnabled(boolean bl) {
        this.treeHScrollingEnabled = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TreeTableAction
    extends AbstractAction {
        Action treeAction;
        Action tableAction;

        TreeTableAction(Action action, Action action2) {
            this.treeAction = action;
            this.tableAction = action2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTable.this.getSelectedColumn() == TreeTable.this.getTreeColumnIndex()) {
                this.treeAction.actionPerformed(actionEvent);
            }
        }
    }

    class TreeTableUI
    extends BasicTableUI {
        TreeTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        public class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            private Component dispatchComponent;
            static /* synthetic */ Class class$org$openide$explorer$view$TreeTableModelAdapter;

            public TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
                if (!TreeTable.this.isEditing()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            private void setDispatchComponent(MouseEvent mouseEvent) {
                Component component = TreeTableUI.this.table.getEditorComponent();
                Point point = mouseEvent.getPoint();
                Point point2 = SwingUtilities.convertPoint(TreeTableUI.this.table, point, component);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
            }

            private boolean repostEvent(MouseEvent mouseEvent) {
                if (this.dispatchComponent == null) {
                    return false;
                }
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(TreeTableUI.this.table, mouseEvent, this.dispatchComponent);
                this.dispatchComponent.dispatchEvent(mouseEvent2);
                return true;
            }

            private void setValueIsAdjusting(boolean bl) {
                TreeTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
                TreeTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
            }

            private boolean shouldIgnore(MouseEvent mouseEvent) {
                return !TreeTableUI.this.table.isEnabled();
            }

            private boolean isTreeColumn(int n) {
                return TreeTable.this.getColumnClass(n) == (class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTableMouseInputHandler.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter);
            }

            private void processMouseEvent(MouseEvent mouseEvent) {
                Object object;
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = TreeTableUI.this.table.rowAtPoint(point);
                int n2 = TreeTableUI.this.table.columnAtPoint(point);
                if (n2 == -1 || n == -1) {
                    return;
                }
                if (TreeTable.this.getEditingColumn() == n2 && TreeTable.this.getEditingRow() == n) {
                    return;
                }
                boolean bl = true;
                if (this.isTreeColumn(n2)) {
                    object = TreeTable.this.tree.getPathForRow(TreeTable.this.rowAtPoint(mouseEvent.getPoint()));
                    Rectangle rectangle = TreeTable.this.tree.getPathBounds((TreePath)object);
                    int n3 = 0;
                    if (TreeTable.this.getTree().getUI() instanceof BasicTreeUI) {
                        n3 = ((BasicTreeUI)TreeTable.this.getTree().getUI()).getExpandedIcon().getIconWidth();
                    }
                    if (mouseEvent.getX() >= rectangle.x - n3 - TreeTable.this.positionX && mouseEvent.getX() <= rectangle.x - TreeTable.this.positionX + rectangle.width) {
                        bl = false;
                    }
                }
                if (TreeTableUI.this.table.getSelectionModel().isSelectedIndex(n) && MouseUtils.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (TreeTableUI.this.table.editCellAt(n, n2, mouseEvent)) {
                    this.setDispatchComponent(mouseEvent);
                    this.repostEvent(mouseEvent);
                } else {
                    TreeTableUI.this.table.requestFocus();
                }
                object = TreeTableUI.this.table.getCellEditor();
                if (bl && (object == null || object.shouldSelectCell(mouseEvent))) {
                    this.setValueIsAdjusting(true);
                    TreeTableUI.this.table.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = TreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, this.offset);
            super.reshape(n5, n2, n3 - (n5 - n), n4);
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor
    implements TreeSelectionListener,
    ActionListener,
    FocusListener,
    CellEditorListener {
        protected transient int offset;
        protected transient Timer timer;
        static /* synthetic */ Class class$org$openide$explorer$view$TreeViewCellEditor;

        public TreeTableCellEditor() {
            super(new TreeTableTextField());
            TreeTable.this.tree.addTreeSelectionListener(this);
            this.addCellEditorListener(this);
            super.getComponent().addFocusListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            this.determineOffset(object, bl, n);
            ((TreeTableTextField)this.getComponent()).offset = this.offset;
            return component;
        }

        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            if (!(TreeTable.this.lastRow == -1 || (object = Visualizer.findNode(TreeTable.this.tree.getPathForRow(TreeTable.this.lastRow).getLastPathComponent())) != null && ((Node)object).canRename())) {
                TreeTable.this.canEdit = false;
            }
            if (TreeTable.this.canEdit && eventObject != null && eventObject.getSource() instanceof Timer) {
                return true;
            }
            if (TreeTable.this.canEdit && this.shouldStartEditingTimer(eventObject)) {
                this.startEditingTimer();
            } else if (this.shouldStopEditingTimer(eventObject)) {
                this.timer.stop();
            }
            if (eventObject instanceof MouseEvent) {
                object = (MouseEvent)eventObject;
                int n = TreeTable.this.getTreeColumnIndex();
                MouseEvent mouseEvent = new MouseEvent(TreeTable.this.tree, ((AWTEvent)object).getID(), ((InputEvent)object).getWhen(), ((InputEvent)object).getModifiers(), ((MouseEvent)object).getX() - TreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x + TreeTable.this.positionX, ((MouseEvent)object).getY(), ((MouseEvent)object).getClickCount(), ((MouseEvent)object).isPopupTrigger());
                TreeTable.this.tree.dispatchEvent(mouseEvent);
            }
            return false;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTable.this.lastRow != -1) {
                TreeTable.this.editCellAt(TreeTable.this.lastRow, TreeTable.this.getTreeColumnIndex(), new EventObject(this.timer));
            }
        }

        private boolean shouldStartEditingTimer(EventObject eventObject) {
            if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return mouseEvent.getID() == 501 && mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent);
            }
            return false;
        }

        private boolean shouldStopEditingTimer(EventObject eventObject) {
            if (this.timer == null) {
                return false;
            }
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1;
            }
            return false;
        }

        private void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        private boolean inHitRegion(MouseEvent mouseEvent) {
            this.determineOffset(mouseEvent);
            return mouseEvent.getX() > this.offset;
        }

        private void determineOffset(MouseEvent mouseEvent) {
            int n = TreeTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(n).getLastPathComponent(), TreeTable.this.isRowSelected(n), n);
        }

        private void determineOffset(Object object, boolean bl, int n) {
            Icon icon;
            Object object2;
            JTree jTree = TreeTable.this.getTree();
            boolean bl2 = jTree.isRootVisible();
            int n2 = n;
            if (!bl2 && n > 0) {
                --n2;
            }
            Rectangle rectangle = jTree.getRowBounds(n2);
            this.offset = rectangle.x;
            TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
            Component component = treeCellRenderer.getTreeCellRendererComponent(jTree, object2 = jTree.getPathForRow(n2).getLastPathComponent(), bl, jTree.isExpanded(n2), jTree.getModel().isLeaf(object2), n2, false);
            if (component instanceof JLabel && (icon = ((JLabel)component).getIcon()) != null) {
                this.offset += ((JLabel)component).getIconTextGap() + icon.getIconWidth();
            }
            this.offset -= TreeTable.this.positionX;
        }

        private void revalidateTextField() {
            int n = TreeTable.this.editingRow;
            if (n == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(n).getLastPathComponent(), TreeTable.this.isRowSelected(n), n);
            ((TreeTableTextField)super.getComponent()).offset = this.offset;
            this.getComponent().setBounds(TreeTable.this.getCellRect(n, TreeTable.this.getTreeColumnIndex(), false));
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            ((TreeTableTextField)super.getComponent()).selectAll();
        }

        /*
         * Unable to fully structure code
         */
        public void editingStopped(ChangeEvent var1_1) {
            block7: {
                var2_2 = TreeTable.access$200(TreeTable.this).getPathForRow(TreeTable.access$300(TreeTable.this));
                if (var2_2 != null && (var3_3 = Visualizer.findNode(var2_2.getLastPathComponent())) != null && var3_3.canRename()) {
                    block8: {
                        var4_4 = (String)this.getCellEditorValue();
                        try {
                            if (!var3_3.getName().equals(var4_4)) {
                                var3_3.setName(var4_4);
                            }
                            break block7;
                        }
                        catch (IllegalArgumentException var5_5) {
                            var6_6 = true;
                            var7_7 = ErrorManager.getDefault();
                            var8_8 = var7_7.findAnnotations(var5_5);
                            if (var8_8 == null || var8_8.length <= 0) break block8;
                            var9_9 = 0;
                            ** while (var9_9 < var8_8.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var10_11 = var8_8[var9_9].getLocalizedMessage();
                            if (var10_11 != null && !var10_11.equals("")) {
                                var6_6 = false;
                            }
                            ++var9_9;
                            continue;
                        }
                    }
                    if (var6_6) {
                        var9_10 = NbBundle.getMessage(TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor == null ? (TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor = TreeTableCellEditor.class$("org.openide.explorer.view.TreeViewCellEditor")) : TreeTableCellEditor.class$org$openide$explorer$view$TreeViewCellEditor, "RenameFailed", var3_3.getName(), var4_4);
                        var7_7.annotate((Throwable)var5_5, var9_10);
                    }
                    var7_7.notify(var5_5);
                }
            }
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        private int oldWidth;
        boolean hasFocus;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.setRowHeight(this.getRowHeight());
            this.setToggleClickCount(0);
            this.putClientProperty("JTree.lineStyle", "None");
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (TreeTable.this != null && TreeTable.this.getRowHeight() != n) {
                    TreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3 + TreeTable.this.positionX, TreeTable.this.getHeight());
        }

        public void reshape(int n, int n2, int n3, int n4) {
            super.reshape(n, n2, n3, n4);
            int n5 = this.getPreferredSize().width;
            if (this.oldWidth != n5) {
                this.firePropertyChange("width", this.oldWidth, n5);
                this.oldWidth = n5;
            }
        }

        public void paint(Graphics graphics) {
            graphics.translate(-TreeTable.this.positionX, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Rectangle getVisibleRect() {
            Rectangle rectangle = TreeTable.this.getVisibleRect();
            rectangle.x = TreeTable.this.positionX;
            rectangle.width = TreeTable.this.getColumnModel().getColumn(TreeTable.this.getTreeColumnIndex()).getWidth();
            return rectangle;
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            Rectangle rectangle2 = this.getVisibleRect();
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            TreeTable.this.scrollRectToVisible(rectangle2);
            int n = rectangle2.x;
            if (rectangle.width > rectangle2.width) {
                n = rectangle.x;
            } else if (rectangle.x < rectangle2.x) {
                n = rectangle.x;
            } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                n = rectangle.x + rectangle.width - rectangle2.width;
            }
            TreeTable.this.setPositionX(n);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                point.translate(TreeTable.this.positionX, this.visibleRow * this.getRowHeight());
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    VisualizerNode visualizerNode = (VisualizerNode)treePath.getLastPathComponent();
                    String string = visualizerNode.getShortDescription();
                    String string2 = visualizerNode.displayName;
                    if (string != null && !string.equals(string2)) {
                        return string;
                    }
                }
            }
            return null;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.hasFocus = bl2;
            this.visibleRow = n;
            return this;
        }
    }
}

