/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.xml.XMLUtil;

final class XMLMapAttr
implements Map {
    Map map = new HashMap(5);

    public Object get(Object object) {
        Object object2;
        try {
            object2 = this.getAttribute(object);
        }
        catch (Exception exception) {
            object2 = null;
            ExternalUtil.exception(exception);
        }
        return object2;
    }

    public Object get(Object object, Object[] objectArray) {
        Object object2;
        try {
            object2 = this.getAttribute(object, objectArray);
        }
        catch (Exception exception) {
            object2 = null;
            ExternalUtil.exception(exception);
        }
        return object2;
    }

    Object getAttribute(Object object) throws Exception {
        return this.getAttribute(object, null);
    }

    private Object getAttribute(Object object, Object[] objectArray) throws Exception {
        Attr attr;
        String string = (String)object;
        Object[] objectArray2 = ModifiedAttribute.translateInto((String)object, null);
        object = (String)objectArray2[0];
        XMLMapAttr xMLMapAttr = this;
        synchronized (xMLMapAttr) {
            attr = (Attr)this.map.get(object);
        }
        Attr attr2 = null;
        try {
            attr2 = attr == null ? attr : attr.get(objectArray);
        }
        catch (Exception exception) {
            ExternalUtil.annotate((Throwable)exception, "attrName = " + object);
            throw exception;
        }
        if (attr2 instanceof ModifiedAttribute) {
            Object object2 = ((ModifiedAttribute)((Object)attr2)).getValue(string);
            if (object2 instanceof Attr) {
                return ((Attr)object2).get(objectArray);
            }
            return object2;
        }
        return attr2;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        Object[] objectArray = ModifiedAttribute.translateInto((String)object, object2);
        String string = (String)objectArray[0];
        Object object3 = objectArray[1];
        Object object4 = object3 == null || object3 instanceof Attr ? object3 : new Attr(object3);
        return this.map.put(Attr.decode(string).intern(), object4);
    }

    public static void writeHeading(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE attributes PUBLIC \"-//NetBeans//DTD DefaultAttributes 1.0//EN\" \"http://www.netbeans.org/dtds/attributes-1_0.dtd\">");
        printWriter.println("<attributes version=\"1.0\">");
    }

    public static void writeEnding(PrintWriter printWriter) {
        printWriter.println("</attributes>");
    }

    public synchronized void write(PrintWriter printWriter, String string, String string2) {
        boolean bl = false;
        if (this.isEmpty()) {
            return;
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string3 = (String)entry.getKey();
            Attr attr = (Attr)entry.getValue();
            if (string3 == null || attr == null || string3.length() == 0 || attr.isValid() == -1) {
                if (string3 == null || string3.length() == 0 || attr != null && attr.isValid() != -1) continue;
                iterator.remove();
                continue;
            }
            if (attr != null) {
                attr.transformMe();
            }
            if (!bl) {
                bl = true;
                String string4 = string;
                try {
                    string4 = XMLUtil.toAttributeValue(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                printWriter.println(string2 + "<fileobject name=\"" + string4 + "\">");
            }
            printWriter.println(string2 + string2 + "<attr name=\"" + attr.getAttrNameForPrint(string3) + "\" " + attr.getKeyForPrint() + "=\"" + attr.getValueForPrint() + "\"/>");
            attr.maybeAddSerValueComment(printWriter, string2 + string2);
        }
        if (bl) {
            printWriter.println(string2 + "</fileobject>");
        }
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized Object remove(Object object) {
        return this.map.remove(object);
    }

    public synchronized boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    public synchronized Set keySet() {
        return this.map.keySet();
    }

    public synchronized Collection values() {
        return this.map.values();
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized void putAll(Map map) {
        this.map.putAll(map);
    }

    public synchronized boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized boolean equals(Object object) {
        return this.map.equals(object);
    }

    public synchronized int size() {
        return this.map.size();
    }

    static class ModifiedAttribute
    implements Serializable {
        static final long serialVersionUID = 84214031923497718L;
        private static final String[] fragments = new String[]{"transient:"};
        private int modifier = 0;
        private Object origAttrValue = null;

        private ModifiedAttribute(Object object) {
            this.origAttrValue = object;
        }

        static Object[] translateInto(String string, Object object) {
            String string2 = string;
            Object object2 = object;
            ModifiedAttribute modifiedAttribute = null;
            int n = 0;
            while (n < fragments.length) {
                String string3 = fragments[n];
                int n2 = string2.indexOf(string3);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2) + string2.substring(n2 + string3.length());
                    if (modifiedAttribute == null) {
                        modifiedAttribute = new ModifiedAttribute(object);
                        object2 = modifiedAttribute;
                    }
                    modifiedAttribute.modifier |= 1 << n;
                }
                ++n;
            }
            return new Object[]{string2, object2};
        }

        static Object[] revert(String string, Object object) {
            if (!(object instanceof ModifiedAttribute) || object == null) {
                return new Object[]{string, object};
            }
            ModifiedAttribute modifiedAttribute = (ModifiedAttribute)object;
            String string2 = string;
            Object object2 = modifiedAttribute;
            int n = 0;
            while (n < fragments.length) {
                String string3 = fragments[n];
                if ((modifiedAttribute.modifier & 1 << n) != 0 && fragments[n] != null) {
                    string2 = fragments[n] + string2;
                    if (object2 instanceof ModifiedAttribute) {
                        object2 = modifiedAttribute.origAttrValue;
                    }
                }
                ++n;
            }
            return new Object[]{string2, object2};
        }

        Object getValue(String string) {
            int n = 0;
            while (n < fragments.length) {
                String string2 = fragments[n];
                int n2 = string.indexOf(string2);
                if (n2 != -1) {
                    return this;
                }
                ++n;
            }
            return this.origAttrValue;
        }

        Object getValue() {
            return this.getValue("");
        }

        static boolean isTransient(FileObject fileObject, String string) {
            Object object = fileObject.getAttribute(fragments[0] + string);
            if (object instanceof ModifiedAttribute) {
                return (((ModifiedAttribute)object).modifier & 1) != 0;
            }
            return false;
        }
    }

    static final class Attr {
        private String value;
        private int keyIndex;
        private Object obj;
        private static final String[] ALLOWED_ATTR_KEYS = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "methodvalue", "serialvalue", "urlvalue", "newvalue"};
        static /* synthetic */ Class class$org$openide$util$SharedClassObject;

        Attr(String string, String string2) {
            this.putEntry(string, string2);
        }

        Attr(Object object) {
            this.obj = object;
        }

        Attr(int n, String string) {
            this.keyIndex = n;
            if (this.isValid() != -1) {
                this.putEntry(ALLOWED_ATTR_KEYS[this.keyIndex], string);
            } else {
                this.value = string;
            }
        }

        static String[] getAttrTypes() {
            return ALLOWED_ATTR_KEYS;
        }

        private final void putEntry(String string, String string2) {
            int n;
            this.keyIndex = n = Attr.isValid(string);
            if (n == Attr.isValid("stringvalue")) {
                this.value = Attr.decode(string2).intern();
                return;
            }
            this.value = string2.intern();
        }

        static Object unMarshallObjectRecursively(Object object) {
            Object object2 = object;
            while (object2 instanceof NbMarshalledObject) {
                try {
                    object2 = ((NbMarshalledObject)object2).get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    return object;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    return object;
                }
            }
            return object2 == null ? object : object2;
        }

        private void transformMe() {
            if (this.obj == null) {
                return;
            }
            Object object = Attr.unMarshallObjectRecursively(this.obj);
            if (object != null) {
                int n = Attr.distinguishObject(object);
                if (n != Attr.isValid("SERIALVALUE")) {
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[n], object.toString());
                } else {
                    String string;
                    try {
                        string = Attr.encodeValue(object);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[n], string);
                }
            }
        }

        static int distinguishObject(Object object) {
            if (object instanceof Byte) {
                return Attr.isValid("BYTEVALUE");
            }
            if (object instanceof Short) {
                return Attr.isValid("SHORTVALUE");
            }
            if (object instanceof Integer) {
                return Attr.isValid("INTVALUE");
            }
            if (object instanceof Long) {
                return Attr.isValid("LONGVALUE");
            }
            if (object instanceof Float) {
                return Attr.isValid("FLOATVALUE");
            }
            if (object instanceof Double) {
                return Attr.isValid("DOUBLEVALUE");
            }
            if (object instanceof Boolean) {
                return Attr.isValid("BOOLVALUE");
            }
            if (object instanceof Character) {
                return Attr.isValid("CHARVALUE");
            }
            if (object instanceof String) {
                return Attr.isValid("STRINGVALUE");
            }
            if (object instanceof URL) {
                return Attr.isValid("URLVALUE");
            }
            return Attr.isValid("SERIALVALUE");
        }

        static String encode(String string) {
            try {
                string = XMLUtil.toAttributeValue(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer(6 * string.length());
            int n = 0;
            while (n < string.length()) {
                if (Character.isISOControl(string.charAt(n))) {
                    stringBuffer.append(Attr.encodeChar(string.charAt(n)));
                } else {
                    stringBuffer.append(string.charAt(n));
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        static String encodeChar(char c) {
            String string = Integer.toString(c, 16);
            return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
        }

        static String decode(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (n + 5 < string.length() && c == '\\' && string.charAt(n + 1) == 'u' && Character.isDigit(string.charAt(n + 2))) {
                    String string2 = string.substring(n + 2, n + 6);
                    stringBuffer.append((char)Integer.parseInt(string2, 16));
                    n += 5;
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        private Object get() throws Exception {
            return this.getObject(null);
        }

        private Object get(Object[] objectArray) throws Exception {
            return this.getObject(objectArray);
        }

        final String getKey() {
            String[] stringArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return "serialvalue";
            }
            if (this.isValid() == -1) {
                return "";
            }
            return stringArray[this.keyIndex];
        }

        final String getValue() {
            if (this.obj != null) {
                Attr.getValue(this.obj);
            }
            return this.value != null ? this.value : "";
        }

        static final String getValue(Object object) {
            try {
                return Attr.encodeValue(object);
            }
            catch (IOException iOException) {
                return "";
            }
        }

        final String getValueForPrint() {
            if (this.obj != null) {
                Attr attr = null;
                if (this.obj instanceof ModifiedAttribute) {
                    attr = (Attr)((ModifiedAttribute)this.obj).getValue();
                }
                return attr != null ? Attr.encode(attr.getValue()) : Attr.encode(this.getValue());
            }
            return this.value != null ? Attr.encode(this.value) : "";
        }

        final String getKeyForPrint() {
            if (this.obj != null && this.obj instanceof ModifiedAttribute) {
                Attr attr = (Attr)((ModifiedAttribute)this.obj).getValue();
                int n = Attr.isValid("SERIALVALUE");
                if (attr != null) {
                    n = Attr.distinguishObject(attr.getValue());
                }
                String[] stringArray = Attr.getAttrTypes();
                return stringArray[n];
            }
            return this.getKey();
        }

        final String getAttrNameForPrint(String string) {
            if (this.obj != null && this.obj instanceof ModifiedAttribute) {
                Object[] objectArray = ModifiedAttribute.revert(string, this.obj);
                return Attr.encode((String)objectArray[0]);
            }
            return Attr.encode(string);
        }

        final void maybeAddSerValueComment(PrintWriter printWriter, String string) {
            if (this.obj != null) {
                String string2;
                String string3 = null;
                if (this.obj instanceof ModifiedAttribute && Attr.distinguishObject(string3 = ((Attr)((ModifiedAttribute)this.obj).getValue()).getValue()) != Attr.isValid("SERIALVALUE")) {
                    return;
                }
                printWriter.print(string);
                printWriter.print("<!-- ");
                String string4 = string2 = string3 != null ? string3.toString() : this.obj.toString();
                if (string2.indexOf("--") != -1) {
                    string2 = string2.replace('-', '_');
                }
                printWriter.print(string2);
                printWriter.println(" -->");
            }
        }

        static Object decodeValue(String string) throws IOException {
            if (string == null || string.length() == 0) {
                return null;
            }
            byte[] byArray = new byte[string.length() / 2];
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                try {
                    int n3 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
                    if (n3 > 127) {
                        n3 -= 256;
                    }
                    byArray[n++] = (byte)n3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw (IOException)ExternalUtil.copyAnnotation(new IOException(), numberFormatException);
                }
                n2 += 2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            try {
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);
                Object object = nbObjectInputStream.readObject();
                return object;
            }
            catch (Exception exception) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), exception);
            }
        }

        static String encodeValue(Object object) throws IOException {
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object2 = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object2).writeObject(object);
                ((ObjectOutputStream)object2).close();
            }
            catch (Exception exception) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), exception);
            }
            object2 = byteArrayOutputStream.toByteArray();
            StringBuffer stringBuffer = new StringBuffer(((Object)object2).length * 2);
            int n = 0;
            while (n < ((Object)object2).length) {
                if (object2[n] < 16 && object2[n] >= 0) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString((int)(object2[n] < 0 ? object2[n] + 256 : object2[n])));
                ++n;
            }
            return stringBuffer.toString();
        }

        private Object getObject(Object[] objectArray) throws Exception {
            if (this.obj != null) {
                return this.obj;
            }
            int n = this.isValid();
            if (n != -1) {
                try {
                    switch (n) {
                        case 0: {
                            return new Byte(this.value);
                        }
                        case 1: {
                            return new Short(this.value);
                        }
                        case 2: {
                            return new Integer(this.value);
                        }
                        case 3: {
                            return new Long(this.value);
                        }
                        case 4: {
                            return new Float(this.value);
                        }
                        case 5: {
                            return new Double(this.value);
                        }
                        case 6: {
                            return new Boolean(this.value);
                        }
                        case 7: {
                            if (this.value.trim().length() != 1) break;
                            return new Character(this.value.charAt(0));
                        }
                        case 8: {
                            return new String(this.value);
                        }
                        case 9: {
                            return this.methodValue(this.value, objectArray);
                        }
                        case 10: {
                            return Attr.decodeValue(this.value);
                        }
                        case 11: {
                            return new URL(this.value);
                        }
                        case 12: {
                            Class clazz = ExternalUtil.findClass(Utilities.translate(this.value));
                            if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = Attr.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(clazz)) {
                                return SharedClassObject.findObject(clazz, true);
                            }
                            return clazz.newInstance();
                        }
                    }
                }
                catch (Exception exception) {
                    ExternalUtil.annotate((Throwable)exception, "value = " + this.value);
                    throw exception;
                }
            }
            throw new InstantiationException(this.value);
        }

        private final Object methodValue(String string, Object[] objectArray) throws Exception {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                String string3 = string.substring(0, n);
                Class clazz = ExternalUtil.findClass(string3);
                Object[][] objectArrayArray = new Object[][]{null, null, null};
                Method[] methodArray = new Method[]{null, null, null};
                Class<?> clazz2 = null;
                Class<?> clazz3 = null;
                if (objectArray != null) {
                    if (objectArray.length > 0) {
                        clazz2 = objectArray[0].getClass();
                    }
                    if (objectArray.length > 1) {
                        clazz3 = objectArray[1].getClass();
                    }
                }
                Method[] methodArray2 = clazz.getDeclaredMethods();
                int n2 = 0;
                while (n2 < methodArray2.length) {
                    if (methodArray2[n2].getName().equals(string2)) {
                        Class<?>[] classArray = methodArray2[n2].getParameterTypes();
                        if (objectArray == null || objectArray.length == 0 || classArray.length == 0) {
                            if (classArray.length == 0 && methodArray[0] == null && objectArrayArray[0] == null) {
                                methodArray[classArray.length] = methodArray2[n2];
                                objectArrayArray[classArray.length] = new Object[0];
                            }
                        } else if (classArray.length == 2 && objectArray.length >= 2 && methodArray[2] == null && objectArrayArray[2] == null) {
                            Class<?> clazz4 = classArray[0];
                            if (classArray[0].isAssignableFrom(clazz2) && classArray[1].isAssignableFrom(clazz3)) {
                                methodArray[classArray.length] = methodArray2[n2];
                                objectArrayArray[classArray.length] = new Object[]{objectArray[0], objectArray[1]};
                                break;
                            }
                            if (classArray[0].isAssignableFrom(clazz3) && classArray[1].isAssignableFrom(clazz2)) {
                                methodArray[classArray.length] = methodArray2[n2];
                                objectArrayArray[classArray.length] = new Object[]{objectArray[1], objectArray[0]};
                                break;
                            }
                        } else if (classArray.length == 1 && objectArray.length >= 1 && methodArray[1] == null && objectArrayArray[1] == null) {
                            if (classArray[0].isAssignableFrom(clazz2)) {
                                methodArray[classArray.length] = methodArray2[n2];
                                objectArrayArray[classArray.length] = new Object[]{objectArray[0]};
                            } else if (classArray[0].isAssignableFrom(clazz3)) {
                                methodArray[classArray.length] = methodArray2[n2];
                                objectArrayArray[classArray.length] = new Object[]{objectArray[1]};
                            }
                        }
                    }
                    ++n2;
                }
                int n3 = methodArray.length - 1;
                while (n3 >= 0) {
                    if (methodArray[n3] != null && objectArrayArray[n3] != null) {
                        ((AccessibleObject)methodArray[n3]).setAccessible(true);
                        return methodArray[n3].invoke(null, objectArrayArray[n3]);
                    }
                    --n3;
                }
            }
            throw new InstantiationException(string);
        }

        final int isValid() {
            String[] stringArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return Attr.isValid("SERIALVALUE");
            }
            if (this.keyIndex >= stringArray.length || this.keyIndex < 0) {
                return -1;
            }
            return this.keyIndex;
        }

        static final int isValid(String string) {
            int n = -1;
            String[] stringArray = Attr.getAttrTypes();
            String string2 = string.trim();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

