/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

final class BrokenDataShadow
extends MultiDataObject {
    private String origFSName;
    private String origFOName;
    private static Set allDataShadows;
    private static ReferenceQueue rqueue;
    private static final long serialVersionUID = -3046981691235483810L;
    static /* synthetic */ Class class$org$openide$loaders$BrokenDataShadow;

    public BrokenDataShadow(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            this.origFOName = bufferedReader.readLine();
            this.origFSName = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    private static Set getDataShadowsSet() {
        if (allDataShadows == null) {
            Class clazz = class$org$openide$loaders$BrokenDataShadow == null ? (class$org$openide$loaders$BrokenDataShadow = BrokenDataShadow.class$("org.openide.loaders.BrokenDataShadow")) : class$org$openide$loaders$BrokenDataShadow;
            synchronized (clazz) {
                if (allDataShadows == null) {
                    allDataShadows = new HashSet();
                }
            }
        }
        return allDataShadows;
    }

    private static ReferenceQueue getRqueue() {
        if (rqueue == null) {
            Class clazz = class$org$openide$loaders$BrokenDataShadow == null ? (class$org$openide$loaders$BrokenDataShadow = BrokenDataShadow.class$("org.openide.loaders.BrokenDataShadow")) : class$org$openide$loaders$BrokenDataShadow;
            synchronized (clazz) {
                if (rqueue == null) {
                    rqueue = new ReferenceQueue();
                }
            }
        }
        return rqueue;
    }

    private static void checkQueue() {
        if (rqueue == null) {
            return;
        }
        Reference reference = rqueue.poll();
        while (reference != null) {
            BrokenDataShadow.getDataShadowsSet().remove(reference);
            reference = rqueue.poll();
        }
    }

    private static synchronized void enqueueBrokenDataShadow(BrokenDataShadow brokenDataShadow) {
        BrokenDataShadow.checkQueue();
        BrokenDataShadow.getDataShadowsSet().add(DataShadow.createReference(brokenDataShadow, BrokenDataShadow.getRqueue()));
    }

    private static synchronized List getAllDataShadows() {
        Set set = allDataShadows;
        if (set == null || set.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            Object t = reference.get();
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    static void checkValidity(EventObject eventObject) {
        List list = BrokenDataShadow.getAllDataShadows();
        if (list == null) {
            return;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            ((BrokenDataShadow)e).refresh();
            ++n2;
        }
    }

    private BrokenDataShadow(FileObject fileObject) throws DataObjectExistsException {
        this(fileObject, DataLoaderPool.getShadowLoader());
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public void refresh() {
        try {
            if (DataShadow.checkOriginal(this.origFOName, this.origFSName) != null) {
                this.setValid(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/resources/brokenShadow";
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

        public BrokenShadowNode(BrokenDataShadow brokenDataShadow) {
            super(brokenDataShadow, Children.LEAF);
            this.setIconBase(ICON_NAME);
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(DataObject.getString("FMT_brokenShadowName"));
            }
            return format.format(this.createArguments());
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BrokenShadowNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = BrokenShadowNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BrokenShadowNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BrokenShadowNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BrokenShadowNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BrokenShadowNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            Sheet sheet = new Sheet();
            int n = 0;
            while (n < propertySetArray.length) {
                Sheet.Set set = new Sheet.Set();
                set.put(propertySetArray[n].getProperties());
                set.setName(propertySetArray[n].getName());
                set.setDisplayName(propertySetArray[n].getDisplayName());
                set.setShortDescription(propertySetArray[n].getShortDescription());
                this.modifySheetSet(set);
                sheet.put(set);
                ++n;
            }
            return sheet;
        }

        private void modifySheetSet(Sheet.Set set) {
            Node.Property property = set.remove("name");
            if (property != null) {
                property = new PropertySupport.Name(this);
                set.put(property);
                property = new Name();
                set.put(property);
                property = new FileSystemProperty();
                set.put(property);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final class FileSystemProperty
        extends PropertySupport.ReadOnly {
            static /* synthetic */ Class class$java$lang$String;

            public FileSystemProperty() {
                super("BrokenLinkFileSystem", class$java$lang$String == null ? (class$java$lang$String = FileSystemProperty.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowFileSystem"), DataObject.getString("HINT_brokenShadowFileSystem"));
            }

            public Object getValue() {
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return brokenDataShadow.origFSName;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            static /* synthetic */ Class class$java$lang$String;

            public Name() {
                super("BrokenLink", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_brokenShadowOriginalName"), DataObject.getString("HINT_brokenShadowOriginalName"));
            }

            public Object getValue() {
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return brokenDataShadow.origFOName;
            }

            public void setValue(Object object) {
            }

            public boolean canWrite() {
                return false;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }
}

