/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CompilerSupport;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DataTransferSupport;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderComparator;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.SortModeEditor;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.enum.QueueEnumeration;

public class DataFolder
extends MultiDataObject
implements Serializable,
DataObject.Container {
    static final long serialVersionUID = -8244904281845488751L;
    public static final String PROP_CHILDREN = "children";
    public static final String PROP_SORT_MODE = "sortMode";
    static final String EA_SORT_MODE = "OpenIDE-Folder-SortMode";
    static final String EA_ORDER = "OpenIDE-Folder-Order";
    public static final String PROP_ORDER = "order";
    public static final String SET_SORTING = "sorting";
    static final String FOLDER_ICON_BASE = "org/openide/resources/defaultFolder";
    private static final String ROOT_SHADOW_NAME = "Root";
    private FolderList list;
    private PropertyChangeListener pcl;
    private DataTransferSupport dataTransferSupport = new Paste();
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$org$openide$loaders$FolderChildren;

    public DataFolder(FileObject fileObject) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, DataLoaderPool.getFolderLoader());
    }

    protected DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, multiFileLoader, true);
    }

    protected DataFolder(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, dataLoader);
        this.init(fileObject, true);
    }

    private DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader, boolean bl) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, multiFileLoader);
        this.init(fileObject, bl);
    }

    private void init(FileObject fileObject, boolean bl) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not folder: " + fileObject);
        }
        this.list = this.reassignList(fileObject, bl);
    }

    private FolderList reassignList(FileObject fileObject, boolean bl) {
        FolderList folderList = FolderList.find(fileObject, true);
        if (bl) {
            this.pcl = new ListPCL();
            folderList.addPropertyChangeListener(WeakListener.propertyChange(this.pcl, folderList));
        }
        return folderList;
    }

    public static DataFolder create(DataFolder dataFolder, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (DataFolder.confirmName(string2)) continue;
            throw new IOException(NbBundle.getMessage(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder, "EXC_WrongName", string2));
        }
        return DataFolder.findFolder(FileUtil.createFolder(dataFolder.getPrimaryFile(), string));
    }

    public final synchronized void setSortMode(SortMode sortMode) throws IOException {
        SortMode sortMode2 = this.getOrder().getSortMode();
        this.getOrder().setSortMode(sortMode);
        this.firePropertyChange(PROP_SORT_MODE, sortMode2, this.getOrder().getSortMode());
    }

    public final SortMode getSortMode() {
        return this.getOrder().getSortMode();
    }

    public final synchronized void setOrder(DataObject[] dataObjectArray) throws IOException {
        this.getOrder().setOrder(dataObjectArray);
        this.firePropertyChange(PROP_ORDER, null, null);
    }

    private FolderOrder getOrder() {
        return FolderOrder.findFor(this.getPrimaryFile());
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public DataObject[] getChildren() {
        return this.list.getChildren();
    }

    final List getChildrenList() {
        return this.list.getChildrenList();
    }

    final RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.list.computeChildrenList(folderListListener);
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildrenList());
    }

    public Enumeration children(final boolean bl) {
        if (!bl) {
            return this.children();
        }
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            public void process(Object object) {
                DataObject dataObject = (DataObject)object;
                if (bl && dataObject instanceof DataFolder) {
                    DataFolder.addChildrenToEnum(this, ((DataFolder)dataObject).getChildren());
                }
            }
        };
        DataFolder.addChildrenToEnum(queueEnumeration, this.getChildren());
        return queueEnumeration;
    }

    static void addChildrenToEnum(QueueEnumeration queueEnumeration, DataObject[] dataObjectArray) {
        int n = 0;
        while (n < dataObjectArray.length) {
            queueEnumeration.put(dataObjectArray[n]);
            ++n;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Cmp cmp;
        if ((class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = DataFolder.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie).isAssignableFrom(clazz) && clazz.isInstance(cmp = new Cmp(clazz))) {
            return cmp;
        }
        return super.getCookie(clazz);
    }

    protected synchronized Node createNodeDelegate() {
        FolderNode folderNode = new FolderNode();
        folderNode.setShortDescription(NbBundle.getMessage(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder, "HINT_Folder"));
        return folderNode;
    }

    Node getClonedNodeDelegate(DataFilter dataFilter) {
        Node node = this.getNodeDelegate();
        Children children = node.getChildren();
        if (children.getClass() == (class$org$openide$loaders$FolderChildren == null ? (class$org$openide$loaders$FolderChildren = DataFolder.class$("org.openide.loaders.FolderChildren")) : class$org$openide$loaders$FolderChildren)) {
            DataFilter dataFilter2 = ((FolderChildren)children).getFilter();
            if (dataFilter2 == DataFilter.ALL) {
                return new ClonedFilter(node, dataFilter);
            }
            if (dataFilter != DataFilter.ALL) {
                return new ClonedFilter(node, DataFolder.filterCompose(dataFilter2, dataFilter));
            }
            return node.cloneNode();
        }
        return node.cloneNode();
    }

    private static DataFilter filterCompose(final DataFilter dataFilter, final DataFilter dataFilter2) {
        if (dataFilter.equals(dataFilter2)) {
            return dataFilter;
        }
        return new DataFilter(){

            public boolean acceptDataObject(DataObject dataObject) {
                return dataFilter.acceptDataObject(dataObject) && dataFilter2.acceptDataObject(dataObject);
            }
        };
    }

    public Children createNodeChildren(DataFilter dataFilter) {
        return new FolderChildren(this, dataFilter);
    }

    public boolean isDeleteAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isRenameAllowed() {
        FileObject fileObject = this.getPrimaryFile();
        return !fileObject.isRoot() && !fileObject.isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
    }

    public static DataFolder findFolder(FileObject fileObject) {
        try {
            return (DataFolder)DataObject.find(fileObject);
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, classCastException);
            throw illegalArgumentException;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, dataObjectNotFoundException);
            throw illegalArgumentException;
        }
    }

    public static DataObject.Container findContainer(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return FolderList.find(fileObject, true);
        }
        throw new IllegalArgumentException("Not a folder: " + fileObject);
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (dataFolder.equals(this)) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error Copying File or Folder"), NbBundle.getMessage(this.getClass(), "EXC_CannotCopyTheSame", this.getName()));
        }
        Object object = dataFolder.getFolder();
        while (object != null) {
            if (object.equals(this)) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error Copying File or Folder"), NbBundle.getMessage(this.getClass(), "EXC_CannotCopySubfolder", this.getName()));
            }
            object = ((DataObject)object).getFolder();
        }
        object = this.children();
        DataFolder dataFolder2 = (DataFolder)super.handleCopy(dataFolder);
        while (object.hasMoreElements()) {
            try {
                DataObject dataObject = (DataObject)object.nextElement();
                if (dataObject.isCopyAllowed()) {
                    dataObject.copy(dataFolder2);
                    continue;
                }
                TopManager.getDefault().getStdOut().println(NbBundle.getMessage(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder, "FMT_CannotCopyDo", dataObject.getName()));
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException(iOException);
            }
        }
        return dataFolder2;
    }

    protected void handleDelete() throws IOException {
        IOException iOException = null;
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                if (!dataObject.isValid()) continue;
                dataObject.delete();
            }
            catch (IOException iOException2) {
                ErrorManager.getDefault().annotate((Throwable)iOException2, iOException);
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        super.handleDelete();
    }

    protected FileObject handleRename(final String string) throws IOException {
        if (!DataFolder.confirmName(string)) {
            throw new IOException("bad name: " + string){
                static /* synthetic */ Class class$org$openide$loaders$DataFolder;

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 3.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder, "EXC_WrongName", string);
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            };
        }
        return super.handleRename(string);
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        Serializable serializable;
        FileObject fileObject = this.getPrimaryFile();
        FileLock fileLock = fileObject.lock();
        List list = this.saveEntries();
        try {
            Object object;
            FileObject fileObject2 = super.handleMove(dataFolder);
            DataFolder dataFolder2 = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = 20;
            while (n >= 0) {
                --n;
                try {
                    object = (DataLoaderPool.FolderLoader)this.getMultiFileLoader();
                    dataFolder2 = (DataFolder)((DataLoaderPool.FolderLoader)object).createMultiObject(fileObject2, this);
                    bl = false;
                    break;
                }
                catch (DataObjectExistsException dataObjectExistsException) {
                    dataFolder2 = (DataFolder)dataObjectExistsException.getDataObject();
                    dataFolder2.dispose();
                    bl = true;
                }
            }
            object = this.children();
            while (object.hasMoreElements()) {
                try {
                    serializable = (DataObject)object.nextElement();
                    if (serializable.isMoveAllowed()) {
                        serializable.move(dataFolder2);
                        continue;
                    }
                    bl2 = true;
                    TopManager.getDefault().getStdOut().println(NbBundle.getMessage(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder, "FMT_CannotMoveDo", serializable.getName()));
                }
                catch (IOException iOException) {
                    bl2 = true;
                    TopManager.getDefault().notifyException(iOException);
                }
            }
            if (bl2) {
                this.restoreEntries(list);
                this.list.refresh();
                serializable = fileObject;
                Object var15_16 = null;
                fileLock.releaseLock();
                return serializable;
            }
            try {
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)iOException, DataObject.getString("EXC_folder_delete_failed"));
                ErrorManager.getDefault().notify(throwable);
            }
            if (bl) {
                try {
                    this.setValid(false);
                    fileObject2 = fileObject;
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.restoreEntries(list);
                    fileObject2 = this.getPrimaryEntry().getFile();
                }
            } else {
                this.item.changePrimaryFile(fileObject2);
                dataFolder2.dispose();
                this.list = this.reassignList(fileObject2, true);
            }
            serializable = fileObject2;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        Object var15_17 = null;
        fileLock.releaseLock();
        return serializable;
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = this.getPrimaryFile().getName();
        }
        DataFolder dataFolder2 = (DataFolder)super.handleCreateFromTemplate(dataFolder, string);
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                dataObject.createFromTemplate(dataFolder2);
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException(iOException);
            }
        }
        return dataFolder2;
    }

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        String string = this.getPrimaryFile().isRoot() ? FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), ROOT_SHADOW_NAME, "shadow") : null;
        return DataShadow.create(dataFolder, string, this);
    }

    boolean isMergingFolders() {
        return true;
    }

    private static boolean confirmName(String string) {
        return string.indexOf(47) == -1 && string.indexOf(92) == -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ListPCL
    implements PropertyChangeListener {
        private ListPCL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FolderList folderList = (FolderList)propertyChangeEvent.getSource();
            if (this == DataFolder.this.pcl) {
                DataFolder.this.firePropertyChange(DataFolder.PROP_CHILDREN, null, null);
            }
        }
    }

    final class Cmp
    implements CompilerCookie.Compile,
    CompilerCookie.Build,
    CompilerCookie.Clean {
        private Class cookieClass;

        public Cmp(Class clazz) {
            this.cookieClass = clazz;
        }

        public boolean isDepthSupported(Compiler.Depth depth) {
            return true;
        }

        public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
            if (depth.isLastDepth()) {
                return;
            }
            depth = depth.nextDepth();
            CompilerSupport.prepareJobFor(compilerJob, DataFolder.this.children(), this.cookieClass, depth, this);
        }

        boolean wasCreatedFor(Object object) {
            if (object == DataFolder.this) {
                return true;
            }
            return object == DataFolder.this.getNodeDelegateOrNull();
        }

        public int hashCode() {
            return DataFolder.this.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Cmp) {
                Cmp cmp = (Cmp)object;
                return cmp.wasCreatedFor(DataFolder.this);
            }
            return false;
        }
    }

    private class Paste
    extends DataTransferSupport {
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
        static /* synthetic */ Class class$java$io$Serializable;

        private Paste() {
        }

        protected DataTransferSupport.PasteTypeExt[] definePasteTypes(int n) {
            switch (n) {
                case 4: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_move");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = 5.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".move");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isMoveAllowed() && !this.isParent(Paste.access$600(this.this$1).getPrimaryFile(), dataObject.getPrimaryFile());
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.move(Paste.access$600(this.this$1));
                        }

                        protected boolean cleanClipboard() {
                            return true;
                        }

                        private boolean isParent(FileObject fileObject, FileObject fileObject2) {
                            try {
                                if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                                    return false;
                                }
                            }
                            catch (IOException iOException) {}
                            while (fileObject != null) {
                                if (fileObject.equals(fileObject2)) {
                                    return true;
                                }
                                fileObject = fileObject.getParent();
                            }
                            return false;
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }};
                }
                case 1: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_copy");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = 6.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".copy");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isCopyAllowed();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.copy(Paste.access$600(this.this$1));
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_instantiate");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = 7.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".instantiate");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isTemplate();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createFromTemplate(Paste.access$600(this.this$1));
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_shadow");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = 8.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".shadow");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isShadowAllowed();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createShadow(Paste.access$600(this.this$1));
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }};
                }
            }
            return new DataTransferSupport.PasteTypeExt[0];
        }

        protected int[] defineOperations() {
            return new int[]{4, 1};
        }

        protected void handleCreatePasteTypes(Transferable transferable, List list) {
            Node node = NodeTransfer.node(transferable, 1);
            if (node != null) {
                try {
                    InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = Paste.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                    if (instanceCookie != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = Paste.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(instanceCookie.instanceClass())) {
                        list.add(new DataTransferSupport.SerializePaste(DataFolder.this, instanceCookie));
                        list.add(new DataTransferSupport.InstantiatePaste(DataFolder.this, instanceCookie));
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ DataFolder access$600(Paste paste) {
            return paste.DataFolder.this;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class NewFolder
    extends NewType {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder$NewFolder;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private NewFolder() {
        }

        public String getName() {
            return DataObject.getString("CTL_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$loaders$DataFolder$NewFolder == null ? (class$org$openide$loaders$DataFolder$NewFolder = NewFolder.class$("org.openide.loaders.DataFolder$NewFolder")) : class$org$openide$loaders$DataFolder$NewFolder);
        }

        public void create() throws IOException {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(DataObject.getString("CTL_NewFolderName"), DataObject.getString("CTL_NewFolderTitle"));
            inputLine.setInputText(DataObject.getString("CTL_NewFolderValue"));
            if (TopManager.getDefault().notify(inputLine) == NotifyDescriptor.OK_OPTION) {
                Serializable serializable;
                Object object;
                String string = inputLine.getInputText();
                if ("".equals(string)) {
                    return;
                }
                Serializable serializable2 = DataFolder.this.getPrimaryFile();
                int n = -1;
                while ((n = string.indexOf(".")) != -1) {
                    object = string.substring(0, n);
                    string = string.substring(n + 1);
                    serializable = ((FileObject)serializable2).getFileObject((String)object);
                    if (serializable != null) {
                        if (!((FileObject)serializable).isFolder()) {
                            TopManager.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NewFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_FMT_FileExists", object, ((FileObject)serializable2).getName()), 2));
                            return;
                        }
                        serializable2 = serializable;
                        continue;
                    }
                    if (!DataFolder.confirmName((String)object)) {
                        throw new IOException(NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NewFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "EXC_WrongName", object));
                    }
                    serializable2 = ((FileObject)serializable2).createFolder((String)object);
                }
                if (!"".equals(string)) {
                    object = ((FileObject)serializable2).getFileObject(string);
                    if (object != null) {
                        if (((FileObject)object).isFolder()) {
                            TopManager.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NewFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_FMT_FolderExists", string, ((FileObject)serializable2).getName()), 1));
                        } else {
                            TopManager.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NewFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_FMT_FileExists", string, ((FileObject)serializable2).getName()), 2));
                        }
                        return;
                    }
                    if (!DataFolder.confirmName(string)) {
                        throw new IOException(NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NewFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "EXC_WrongName", string));
                    }
                    serializable = DataObject.find(((FileObject)serializable2).createFolder(string));
                    if (serializable != null) {
                        TopManager.getDefault().getLoaderPool().fireOperationEvent(new OperationEvent.Copy((DataObject)serializable, DataFolder.this), 6);
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class FolderNode
    extends DataNode {
        static /* synthetic */ Class class$org$openide$nodes$Index;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder$Index;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder$SortMode;

        public FolderNode(Children children) {
            super(DataFolder.this, children);
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        protected FolderNode() {
            super(DataFolder.this, new FolderChildren(DataFolder.this));
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = FolderNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) || clazz == (class$org$openide$loaders$DataFolder$Index == null ? (class$org$openide$loaders$DataFolder$Index = FolderNode.class$("org.openide.loaders.DataFolder$Index")) : class$org$openide$loaders$DataFolder$Index)) {
                return new Index(DataFolder.this, this);
            }
            return super.getCookie(clazz);
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = new Sheet.Set();
            set.setName(DataFolder.SET_SORTING);
            set.setDisplayName(DataObject.getString("PROP_sorting"));
            set.setShortDescription(DataObject.getString("HINT_sorting"));
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, DataFolder.PROP_SORT_MODE, class$org$openide$loaders$DataFolder$SortMode == null ? (class$org$openide$loaders$DataFolder$SortMode = FolderNode.class$("org.openide.loaders.DataFolder$SortMode")) : class$org$openide$loaders$DataFolder$SortMode, DataObject.getString("PROP_sort"), DataObject.getString("HINT_sort")){
                private final /* synthetic */ FolderNode this$1;
                {
                    this.this$1 = folderNode;
                }

                public Object getValue() {
                    return FolderNode.access$300(this.this$1).getSortMode();
                }

                public void setValue(Object object) throws InvocationTargetException {
                    try {
                        FolderNode.access$300(this.this$1).setSortMode((SortMode)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortModeEditor();
                }
            };
            set.put(readWrite);
            sheet.put(set);
            return sheet;
        }

        public SystemAction getDefaultAction() {
            return null;
        }

        public NewType[] getNewTypes() {
            return new NewType[0];
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            super.createPasteTypes(transferable, list);
            if (!DataFolder.this.getPrimaryFile().isReadOnly()) {
                DataFolder.this.dataTransferSupport.createPasteTypes(transferable, list);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ DataFolder access$300(FolderNode folderNode) {
            return folderNode.DataFolder.this;
        }
    }

    public static abstract class SortMode
    implements Comparator {
        public static final SortMode NONE = new FolderComparator(0);
        public static final SortMode NAMES = new FolderComparator(1);
        public static final SortMode CLASS = new FolderComparator(2);
        public static final SortMode FOLDER_NAMES = new FolderComparator(3);

        void write(FileObject fileObject) throws IOException {
            String string = this == FOLDER_NAMES ? "F" : (this == NAMES ? "N" : (this == CLASS ? "C" : "O"));
            fileObject.setAttribute(DataFolder.EA_SORT_MODE, string);
        }

        static SortMode read(FileObject fileObject) {
            String string = (String)fileObject.getAttribute(DataFolder.EA_SORT_MODE);
            if (string == null || string.length() != 1) {
                return FOLDER_NAMES;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'N': {
                    return NAMES;
                }
                case 'C': {
                    return CLASS;
                }
                case 'O': {
                    return NONE;
                }
            }
            return FOLDER_NAMES;
        }

        public abstract int compare(Object var1, Object var2);
    }

    public static class Index
    extends Index.Support {
        private DataFolder df;
        private Node node;
        private Listener listener;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public Index(DataFolder dataFolder) {
            this(dataFolder, dataFolder.getNodeDelegate());
        }

        public Index(DataFolder dataFolder, Node node) {
            this.df = dataFolder;
            this.node = node;
            this.listener = new Listener();
            node.addNodeListener(WeakListener.node(this.listener, node));
        }

        public int getNodesCount() {
            return this.node.getChildren().getNodesCount();
        }

        public Node[] getNodes() {
            return this.node.getChildren().getNodes();
        }

        public void reorder(int[] nArray) {
            Serializable serializable;
            Object object;
            DataObject[] dataObjectArray = this.df.getChildren();
            DataObject[] dataObjectArray2 = new DataObject[dataObjectArray.length];
            Node[] nodeArray = this.getNodes();
            if (nodeArray.length != nArray.length) {
                throw new IllegalArgumentException("permutation of incorrect length: " + nArray.length + " rather than " + nodeArray.length);
            }
            HashMap<String, DataObject> hashMap = new HashMap<String, DataObject>(2 * dataObjectArray.length);
            int n = 0;
            while (n < dataObjectArray.length) {
                object = dataObjectArray[n].getNodeDelegate();
                if (((Node)object).getCookie(class$org$openide$loaders$DataObject == null ? Index.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) == null) {
                    hashMap.put(((FeatureDescriptor)object).getName(), dataObjectArray[n]);
                }
                ++n;
            }
            object = new DataObject[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                serializable = (DataObject)nodeArray[n2].getCookie(class$org$openide$loaders$DataObject == null ? Index.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (serializable == null) {
                    serializable = (DataObject)hashMap.get(nodeArray[n2].getName());
                }
                if (serializable == null) {
                    throw new IllegalArgumentException("cannot reorder node with no DataObject: " + nodeArray[n2]);
                }
                if (((DataObject)serializable).getFolder() != this.df) {
                    throw new IllegalArgumentException("wrong folder for: " + ((DataObject)serializable).getPrimaryFile() + " rather than " + this.df.getPrimaryFile());
                }
                object[nArray[n2]] = serializable;
                ++n2;
            }
            serializable = new HashSet(Arrays.asList(object));
            if (serializable.size() != ((Object)object).length) {
                throw new IllegalArgumentException("duplicate DataObject's among reordered childen");
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < dataObjectArray.length) {
                dataObjectArray2[n4] = serializable.remove(dataObjectArray[n4]) ? object[n3++] : dataObjectArray[n4];
                ++n4;
            }
            try {
                this.df.setOrder(dataObjectArray2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, DataObject.getString("EXC_ReorderFailed"));
                ErrorManager.getDefault().notify(iOException);
            }
        }

        public void reorder() {
            Index.Support.showIndexedCustomizer(this);
        }

        void fireChangeEventAccess() {
            this.fireChangeEvent(new ChangeEvent(this));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final class Listener
        implements NodeListener {
            private Listener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }
        }
    }

    private static final class ClonedFilterHandle
    implements Node.Handle {
        private static final long serialVersionUID = 24234097765186L;
        private DataObject folder;
        private DataFilter filter;

        public ClonedFilterHandle(DataFolder dataFolder, DataFilter dataFilter) {
            this.folder = dataFolder;
            this.filter = dataFilter;
        }

        public Node getNode() throws IOException {
            if (this.folder instanceof DataFolder) {
                return (DataFolder)this.folder.new ClonedFilter(this.filter);
            }
            throw new InvalidObjectException(this.folder == null ? "" : this.folder.toString());
        }
    }

    private final class ClonedFilter
    extends FilterNode {
        private DataFilter filter;
        private int hashCode = -1;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        public ClonedFilter(Node node, DataFilter dataFilter) {
            super(node, DataFolder.this.createNodeChildren(dataFilter));
            this.filter = dataFilter;
        }

        public ClonedFilter(DataFilter dataFilter) {
            this(dataFolder.getNodeDelegate(), dataFilter);
        }

        public Node cloneNode() {
            if (DataFolder.this.isValid()) {
                return new ClonedFilter(this.filter);
            }
            return super.cloneNode();
        }

        public Node.Handle getHandle() {
            return new ClonedFilterHandle(DataFolder.this, this.filter);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)object;
                if (folderNode.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ClonedFilter.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != DataFolder.this) {
                    return false;
                }
                Children children = folderNode.getChildren();
                return children instanceof FolderChildren && ((FolderChildren)children).getFilter().equals(this.filter);
            }
            if (object instanceof ClonedFilter) {
                ClonedFilter clonedFilter = (ClonedFilter)object;
                return clonedFilter.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ClonedFilter.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == DataFolder.this && clonedFilter.filter.equals(this.filter);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = DataFolder.this.isValid() ? DataFolder.this.getNodeDelegate().hashCode() : super.hashCode();
                if (this.hashCode == -1) {
                    this.hashCode = -2;
                }
            }
            return this.hashCode;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

