/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.loaders.UniFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public abstract class DataLoaderPool
implements Serializable {
    static final long serialVersionUID = -360141823874889956L;
    private static MultiFileLoader[] systemLoaders;
    private static MultiFileLoader[] defaultLoaders;
    private transient DataLoader[] loaderArray;
    private transient EventListenerList listeners;
    private transient DataLoader preferredLoader;
    private static final DataLoader.RecognizedFiles emptyDataLoaderRecognized;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$loaders$OperationListener;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$FolderLoader;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Loader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$DefaultLoader;

    protected DataLoaderPool() {
    }

    protected DataLoaderPool(DataLoader dataLoader) {
        this.preferredLoader = dataLoader;
    }

    protected abstract Enumeration loaders();

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }
    }

    protected final void fireChangeEvent(final ChangeEvent changeEvent) {
        Object[] objectArray;
        this.loaderArray = null;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getListenerList();
        }
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? DataLoaderPool.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                final ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                RequestProcessor.postRequest(new Runnable(){

                    public void run() {
                        changeListener.stateChanged(changeEvent);
                    }
                });
            }
            n -= 2;
        }
    }

    public final synchronized void addOperationListener(OperationListener operationListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, operationListener);
    }

    public final synchronized void removeOperationListener(OperationListener operationListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, operationListener);
        }
    }

    final void fireOperationEvent(OperationEvent operationEvent, int n) {
        Object[] objectArray;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getListenerList();
        }
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$org$openide$loaders$OperationListener == null ? DataLoaderPool.class$("org.openide.loaders.OperationListener") : class$org$openide$loaders$OperationListener)) {
                OperationListener operationListener = (OperationListener)objectArray[n2 + 1];
                switch (n) {
                    case 1: {
                        operationListener.operationCopy((OperationEvent.Copy)operationEvent);
                        break;
                    }
                    case 2: {
                        operationListener.operationMove((OperationEvent.Move)operationEvent);
                        break;
                    }
                    case 3: {
                        operationListener.operationDelete(operationEvent);
                        break;
                    }
                    case 4: {
                        operationListener.operationRename((OperationEvent.Rename)operationEvent);
                        break;
                    }
                    case 5: {
                        operationListener.operationCreateShadow((OperationEvent.Copy)operationEvent);
                        break;
                    }
                    case 6: {
                        operationListener.operationCreateFromTemplate((OperationEvent.Copy)operationEvent);
                        break;
                    }
                    case 7: {
                        operationListener.operationPostCreate(operationEvent);
                    }
                }
            }
            n2 -= 2;
        }
    }

    public final Enumeration allLoaders() {
        if (this.preferredLoader == null) {
            return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
        }
        return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new SingletonEnumeration(this.preferredLoader), new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
    }

    public DataLoader[] toArray() {
        DataLoader[] dataLoaderArray = this.loaderArray;
        if (dataLoaderArray != null) {
            return dataLoaderArray;
        }
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.loaders();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        dataLoaderArray = new DataLoader[arrayList.size()];
        dataLoaderArray = arrayList.toArray(dataLoaderArray);
        this.loaderArray = dataLoaderArray;
        return dataLoaderArray;
    }

    public final DataLoader firstProducerOf(Class clazz) {
        Enumeration enumeration = this.allLoaders();
        while (enumeration.hasMoreElements()) {
            DataLoader dataLoader = (DataLoader)enumeration.nextElement();
            if (!dataLoader.getRepresentationClass().isAssignableFrom(clazz)) continue;
            return dataLoader;
        }
        return null;
    }

    public final Enumeration producersOf(final Class clazz) {
        return new FilterEnumeration(this.allLoaders()){

            public boolean accept(Object object) {
                DataLoader dataLoader = (DataLoader)object;
                return clazz.isAssignableFrom(dataLoader.getRepresentationClass());
            }
        };
    }

    public DataObject findDataObject(FileObject fileObject) throws IOException {
        return this.findDataObject(fileObject, emptyDataLoaderRecognized);
    }

    public DataObject findDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        Object object;
        DataLoader dataLoader = DataLoaderPool.getPreferredLoader(fileObject);
        if (dataLoader != null && (object = dataLoader.findDataObject(fileObject, recognizedFiles)) != null) {
            DataObjectPool.getPOOL().notifyCreation((DataObject)object);
            return object;
        }
        object = this.allLoaders();
        while (object.hasMoreElements()) {
            DataLoader dataLoader2 = (DataLoader)object.nextElement();
            DataObject dataObject = dataLoader2.findDataObject(fileObject, recognizedFiles);
            if (dataObject == null) continue;
            DataObjectPool.getPOOL().notifyCreation(dataObject);
            return dataObject;
        }
        return null;
    }

    public static void setPreferredLoader(FileObject fileObject, DataLoader dataLoader) throws IOException {
        Serializable serializable;
        DataLoader dataLoader2 = DataLoaderPool.getPreferredLoader(fileObject);
        if (dataLoader2 == dataLoader) {
            return;
        }
        if (dataLoader == null) {
            fileObject.setAttribute("NetBeansAttrAssignedLoader", null);
        } else {
            serializable = dataLoader.getClass();
            Iterator iterator = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
            String string = null;
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.owns((Class)serializable)) continue;
                string = moduleInfo.getCodeNameBase();
                break;
            }
            fileObject.setAttribute("NetBeansAttrAssignedLoader", ((Class)serializable).getName());
            fileObject.setAttribute("NetBeansAttrAssignedLoaderModule", string);
        }
        serializable = DataObjectPool.getPOOL().find(fileObject);
        if (serializable != null && ((DataObject)serializable).getLoader() != dataLoader) {
            try {
                ((DataObject)serializable).setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, propertyVetoException);
            }
        }
    }

    public static DataLoader getPreferredLoader(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("NetBeansAttrAssignedLoader");
        if (string != null) {
            Object object;
            String string2 = (String)fileObject.getAttribute("NetBeansAttrAssignedLoaderModule");
            if (string2 != null) {
                object = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    ModuleInfo moduleInfo = (ModuleInfo)object.next();
                    if (!moduleInfo.getCodeNameBase().equals(string2)) continue;
                    if (moduleInfo.isEnabled()) {
                        bl = true;
                        break;
                    }
                    return null;
                }
                if (!bl) {
                    return null;
                }
            }
            try {
                object = Class.forName(string, true, TopManager.getDefault().systemClassLoader());
                return DataLoader.getLoader(object);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, exception);
            }
        }
        return null;
    }

    private static MultiFileLoader[] getSystemLoaders() {
        if (systemLoaders == null) {
            systemLoaders = new MultiFileLoader[]{new ShadowLoader(), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoaderSystem")) : class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem)};
        }
        return systemLoaders;
    }

    private static MultiFileLoader[] getDefaultLoaders() {
        if (defaultLoaders == null) {
            defaultLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$FolderLoader == null ? (class$org$openide$loaders$DataLoaderPool$FolderLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$FolderLoader")) : class$org$openide$loaders$DataLoaderPool$FolderLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$XMLDataObject$Loader == null ? (class$org$openide$loaders$XMLDataObject$Loader = DataLoaderPool.class$("org.openide.loaders.XMLDataObject$Loader")) : class$org$openide$loaders$XMLDataObject$Loader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoader == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoader")) : class$org$openide$loaders$DataLoaderPool$InstanceLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$DefaultLoader == null ? (class$org$openide$loaders$DataLoaderPool$DefaultLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$DefaultLoader")) : class$org$openide$loaders$DataLoaderPool$DefaultLoader)};
        }
        return defaultLoaders;
    }

    static MultiFileLoader getDefaultFileLoader() {
        return DataLoaderPool.getDefaultLoaders()[3];
    }

    static MultiFileLoader getFolderLoader() {
        return DataLoaderPool.getDefaultLoaders()[0];
    }

    static MultiFileLoader getShadowLoader() {
        return DataLoaderPool.getSystemLoaders()[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        emptyDataLoaderRecognized = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fileObject) {
            }
        };
    }

    private static class ShadowLoader
    extends UniFileLoader {
        static final long serialVersionUID = -11013405787959120L;
        private static ShadowChangeAdapter changeAdapter = new ShadowChangeAdapter();
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public ShadowLoader() {
            super("org.openide.loaders.DataShadow");
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = ShadowLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_shadow_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.hasExt("shadow")) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            try {
                DataObject dataObject = DataShadow.deserialize(fileObject);
                if (dataObject != null) {
                    return new DataShadow(fileObject, dataObject, this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new BrokenDataShadow(fileObject, this);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class DefaultLoader
    extends MultiFileLoader {
        static final long serialVersionUID = -6761887227412396555L;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public DefaultLoader() {
            super("org.openide.loaders.DefaultDataObject");
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = DefaultLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = DefaultLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DefaultLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DefaultLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = DefaultLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = DefaultLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DefaultLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DefaultLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DefaultLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_default_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.isFolder()) {
                return null;
            }
            return fileObject;
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new DefaultDataObject(fileObject, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            throw new UnsupportedOperationException();
        }

        void checkFiles(MultiDataObject multiDataObject) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class InstanceLoader
    extends UniFileLoader {
        static final long serialVersionUID = -3462727693843631328L;
        static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public InstanceLoader() {
            super("org.openide.loaders.InstanceDataObject");
        }

        protected void initialize() {
            super.initialize();
            this.setExtensions(null);
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = InstanceLoader.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction), SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = InstanceLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = InstanceLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = InstanceLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = InstanceLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = InstanceLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = InstanceLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = InstanceLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = InstanceLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = InstanceLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_instance_loader_display_name");
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            InstanceDataObject instanceDataObject = new InstanceDataObject(fileObject, this);
            return instanceDataObject;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this);
            super.writeExternal(objectOutput);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object = objectInput.readObject();
            if (object instanceof SystemAction[]) {
                this.setActions((SystemAction[])object);
                this.setExtensions(this.getExtensions());
            } else if (object instanceof ExtensionList) {
                ExtensionList extensionList = (ExtensionList)object;
                this.setExtensions(extensionList);
            } else {
                super.readExternal(objectInput);
                this.setExtensions(this.getExtensions());
            }
        }

        public void setExtensions(ExtensionList extensionList) {
            super.setExtensions(this.initExtensions(extensionList));
        }

        private ExtensionList initExtensions(ExtensionList extensionList) {
            String[] stringArray = this.getRequiredExt();
            if (extensionList == null) {
                extensionList = new ExtensionList();
            }
            int n = 0;
            while (n < stringArray.length) {
                extensionList.addExtension(stringArray[n]);
                ++n;
            }
            return extensionList;
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "ser", "settings"};
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class InstanceLoaderSystem
    extends InstanceLoader {
        private static final long serialVersionUID = -935749906623354837L;

        protected FileObject findPrimaryFile(FileObject fileObject) {
            FileSystem fileSystem = null;
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            if (fileSystem != Repository.getDefault().getDefaultFileSystem()) {
                return null;
            }
            return super.findPrimaryFile(fileObject);
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "settings"};
        }
    }

    static class FolderLoader
    extends UniFileLoader {
        static final long serialVersionUID = -8325525104047820255L;
        static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
        static /* synthetic */ Class class$org$openide$actions$FindAction;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CompileAction;
        static /* synthetic */ Class class$org$openide$actions$CompileAllAction;
        static /* synthetic */ Class class$org$openide$actions$BuildAction;
        static /* synthetic */ Class class$org$openide$actions$BuildAllAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public FolderLoader() {
            super("org.openide.loaders.DataFolder");
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = FolderLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction), SystemAction.get(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = FolderLoader.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction), SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FolderLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = FolderLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction), SystemAction.get(class$org$openide$actions$CompileAllAction == null ? (class$org$openide$actions$CompileAllAction = FolderLoader.class$("org.openide.actions.CompileAllAction")) : class$org$openide$actions$CompileAllAction), null, SystemAction.get(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = FolderLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction), SystemAction.get(class$org$openide$actions$BuildAllAction == null ? (class$org$openide$actions$BuildAllAction = FolderLoader.class$("org.openide.actions.BuildAllAction")) : class$org$openide$actions$BuildAllAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = FolderLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = FolderLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = FolderLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = FolderLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = FolderLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = FolderLoader.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = FolderLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = FolderLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = FolderLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_folder_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.isFolder()) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry.Folder(multiDataObject, fileObject);
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new DataFolder(fileObject);
        }

        MultiDataObject createMultiObject(FileObject fileObject, DataFolder dataFolder) throws DataObjectExistsException, IOException {
            class NodeSharingDataFolder
            extends DataFolder {
                private final /* synthetic */ DataFolder val$original;
                private final /* synthetic */ FolderLoader this$0;

                public NodeSharingDataFolder(FolderLoader folderLoader, DataFolder dataFolder, FileObject fileObject) throws DataObjectExistsException, IllegalArgumentException {
                    super(fileObject);
                    this.this$0 = folderLoader;
                    this.val$original = dataFolder;
                }

                protected Node createNodeDelegate() {
                    return new FilterNode(this.val$original.getNodeDelegate());
                }

                Node getClonedNodeDelegate(DataFilter dataFilter) {
                    return new FilterNode(this.val$original.getClonedNodeDelegate(dataFilter));
                }
            }
            return new NodeSharingDataFolder(this, dataFolder, fileObject);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

