/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.LoaderTransfer;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

public class DataShadow
extends MultiDataObject
implements DataObject.Container {
    static final long serialVersionUID = 6305590675982925167L;
    private DataObject original;
    private OrigL origL = null;
    private LinkedList nodes = new LinkedList();
    static final String SHADOW_EXTENSION = "shadow";
    private static Set allDataShadows;
    private static ReferenceQueue rqueue;
    private static Mutex MUTEX;
    private static final int IDX_FS = 0;
    private static final int IDX_PATH = 1;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;

    private static Set getDataShadowsSet() {
        if (allDataShadows == null) {
            Class clazz = class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow;
            synchronized (clazz) {
                if (allDataShadows == null) {
                    allDataShadows = new HashSet();
                }
            }
        }
        return allDataShadows;
    }

    private static ReferenceQueue getRqueue() {
        if (rqueue == null) {
            Class clazz = class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow;
            synchronized (clazz) {
                if (rqueue == null) {
                    rqueue = new ReferenceQueue();
                }
            }
        }
        return rqueue;
    }

    private static void checkQueue() {
        if (rqueue == null) {
            return;
        }
        Reference reference = rqueue.poll();
        while (reference != null) {
            DataShadow.getDataShadowsSet().remove(reference);
            reference = rqueue.poll();
        }
    }

    static Reference createReference(Object object, ReferenceQueue referenceQueue) {
        return new DSWeakReference(object, referenceQueue);
    }

    private static synchronized void enqueueDataShadow(DataShadow dataShadow) {
        DataShadow.checkQueue();
        DataShadow.getDataShadowsSet().add(DataShadow.createReference(dataShadow, DataShadow.getRqueue()));
    }

    private static synchronized List getAllDataShadows() {
        Set set = allDataShadows;
        if (set == null || set.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            Object t = reference.get();
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    static void checkValidity(EventObject eventObject) {
        List list = DataShadow.getAllDataShadows();
        if (list == null) {
            return;
        }
        boolean bl = false;
        if (eventObject instanceof OperationEvent.Rename || eventObject instanceof OperationEvent.Move) {
            bl = true;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            ((DataShadow)e).refresh(bl);
            ++n2;
        }
    }

    protected DataShadow(FileObject fileObject, DataObject dataObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.init(dataObject);
    }

    protected DataShadow(FileObject fileObject, DataObject dataObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
        this.init(dataObject);
    }

    private void init(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException();
        }
        this.setOriginal(dataObject);
        DataShadow.enqueueDataShadow(this);
    }

    private DataShadow(FileObject fileObject, DataObject dataObject) throws DataObjectExistsException {
        this(fileObject, dataObject, DataLoaderPool.getShadowLoader());
    }

    public static DataShadow create(DataFolder dataFolder, DataObject dataObject) throws IOException {
        return DataShadow.create(dataFolder, null, dataObject, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder dataFolder, String string, DataObject dataObject) throws IOException {
        return DataShadow.create(dataFolder, string, dataObject, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder dataFolder, final String string, final DataObject dataObject, final String string2) throws IOException {
        final FileObject fileObject = dataFolder.getPrimaryFile();
        final DataShadow[] dataShadowArray = new DataShadow[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2 = DataShadow.writeOriginal(string, string2, fileObject, dataObject);
                DataObject dataObject2 = DataObject.find(fileObject2);
                if (!(dataObject2 instanceof DataShadow)) {
                    DataObjectNotFoundException dataObjectNotFoundException = new DataObjectNotFoundException(dataObject2.getPrimaryFile());
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)dataObjectNotFoundException, dataObject2 == null ? null : dataObject2.getClass().toString());
                    errorManager.annotate((Throwable)dataObjectNotFoundException, fileObject2 == null ? null : fileObject2.getPackageNameExt('/', '.'));
                    throw dataObjectNotFoundException;
                }
                dataShadowArray[0] = (DataShadow)dataObject2;
            }
        });
        return dataShadowArray[0];
    }

    private static FileObject writeOriginal(final String string, final String string2, final FileObject fileObject, final DataObject dataObject) throws IOException {
        try {
            return (FileObject)MUTEX.writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    Object object;
                    FileObject fileObject3;
                    if (fileObject.isData()) {
                        fileObject3 = fileObject;
                    } else {
                        object = string == null ? FileUtil.findFreeFileName(fileObject, dataObject.getName(), string2) : string;
                        fileObject3 = fileObject.createData((String)object, string2);
                    }
                    object = fileObject3.lock();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject3.getOutputStream((FileLock)object), "UTF-8");
                    try {
                        FileObject fileObject2 = dataObject.getPrimaryFile();
                        outputStreamWriter.write(fileObject2.getPackageNameExt('/', '.'));
                        ((Writer)outputStreamWriter).write(10);
                        outputStreamWriter.write(fileObject2.getFileSystem().getSystemName());
                        ((Writer)outputStreamWriter).write(10);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        ((Writer)outputStreamWriter).close();
                        ((FileLock)object).releaseLock();
                        throw throwable;
                    }
                    ((Writer)outputStreamWriter).close();
                    ((FileLock)object).releaseLock();
                    return fileObject3;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    protected static DataObject deserialize(FileObject fileObject) throws IOException {
        String[] stringArray = DataShadow.read(fileObject);
        FileObject fileObject2 = DataShadow.checkOriginal(stringArray[1], stringArray[0]);
        return DataObject.find(fileObject2);
    }

    private static String[] read(final FileObject fileObject) throws IOException {
        if (fileObject.getSize() == 0L) {
            Object object = fileObject.getAttribute("originalFile");
            if (object instanceof String) {
                Object object2 = fileObject.getAttribute("originalFileSystem");
                if (object2 == null || !(object2 instanceof String)) {
                    object2 = fileObject.getFileSystem().getSystemName();
                }
                return new String[]{(String)object2, (String)object};
            }
            throw new FileNotFoundException(fileObject.getPackageNameExt('/', '.'));
        }
        try {
            return (String[])MUTEX.readAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    String[] stringArray;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
                    try {
                        String string = bufferedReader.readLine();
                        String string2 = bufferedReader.readLine();
                        if (string == null) {
                            throw new FileNotFoundException(fileObject.getPackageNameExt('/', '.'));
                        }
                        stringArray = new String[]{string2, string};
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        bufferedReader.close();
                        throw throwable;
                    }
                    bufferedReader.close();
                    return stringArray;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static FileObject checkOriginal(DataObject dataObject) throws IOException {
        if (dataObject == null) {
            return null;
        }
        String string = dataObject.getPrimaryFile().getPackageNameExt('/', '.');
        String string2 = dataObject.getPrimaryFile().getFileSystem().getSystemName();
        return DataShadow.checkOriginal(string, string2);
    }

    static FileObject checkOriginal(String string, String string2) throws IOException {
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem fileSystem = string2 != null ? repository.findFileSystem(string2) : null;
        FileObject fileObject = fileSystem != null ? fileSystem.findResource(string) : null;
        if (fileObject == null) {
            throw new FileNotFoundException(string);
        }
        return fileObject;
    }

    public DataObject getOriginal() {
        return this.original;
    }

    public DataObject[] getChildren() {
        return new DataObject[]{this.getOriginal()};
    }

    protected Node createNodeDelegate() {
        return new ShadowNode(this);
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return this.getOriginal().getHelpCtx();
    }

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        return this.original.handleCreateShadow(dataFolder);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return this.original.getCookie(this, clazz);
    }

    public void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean bl) {
        try {
            if (bl) {
                this.tryUpdate();
            }
            if (DataShadow.checkOriginal(this.original) != null) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void tryUpdate() throws IOException {
        FileObject fileObject;
        String[] stringArray = DataShadow.read(this.getPrimaryFile());
        if (stringArray[1].equals((fileObject = this.original.getPrimaryFile()).getPackageNameExt('/', '.')) && stringArray[0].equals(fileObject.getFileSystem().getSystemName())) {
            return;
        }
        DataShadow.writeOriginal(null, null, this.getPrimaryFile(), this.original);
    }

    private void setOriginal(DataObject dataObject) {
        if (this.origL == null) {
            this.origL = new OrigL(this);
        }
        if (this.original != null) {
            this.original.removePropertyChangeListener(this.origL);
        }
        DataObject dataObject2 = this.original;
        dataObject.addPropertyChangeListener(this.origL);
        this.original = dataObject;
        ShadowNode[] shadowNodeArray = null;
        LinkedList linkedList = this.nodes;
        synchronized (linkedList) {
            shadowNodeArray = this.nodes.toArray(new ShadowNode[this.nodes.size()]);
        }
        try {
            int n = 0;
            while (n < shadowNodeArray.length) {
                shadowNodeArray[n].originalChanged();
                ++n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("Please reopen the bug #18998 if you see this message.");
            System.out.println("Old:" + dataObject2 + (dataObject2 == null ? "" : " / " + dataObject2.isValid() + " / " + System.identityHashCode(dataObject2)));
            System.out.println("New:" + this.original + (this.original == null ? "" : " / " + this.original.isValid() + " / " + System.identityHashCode(this.original)));
            throw illegalStateException;
        }
    }

    private static void updateShadowOriginal(final DataShadow dataShadow) {
        final FileObject fileObject = dataShadow.original.getPrimaryFile();
        RequestProcessor.postRequest(new Runnable(){

            public void run() {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find(fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObject = null;
                }
                if (dataObject != null) {
                    dataShadow.setOriginal(dataObject);
                }
            }
        }, 100);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MUTEX = new Mutex();
    }

    static final class DSWeakReference
    extends WeakReference {
        private int hash;

        DSWeakReference(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = object.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t = this.get();
            if (t == null) {
                return false;
            }
            if (object instanceof DSWeakReference) {
                DSWeakReference dSWeakReference = (DSWeakReference)object;
                return t.equals(dSWeakReference.get());
            }
            return false;
        }
    }

    protected static class ShadowNode
    extends FilterNode {
        private static MessageFormat format;
        private static MessageFormat descriptionFormat;
        private static final String ATTR_USEOWNNAME = "UseOwnName";
        private DataShadow obj;
        private Sheet sheet;
        private String originalFS;
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;

        public ShadowNode(DataShadow dataShadow) {
            this(dataShadow, dataShadow.getOriginal().getNodeDelegate());
        }

        private ShadowNode(DataShadow dataShadow, Node node) {
            super(node);
            this.obj = dataShadow;
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.add(this);
            }
        }

        public Node cloneNode() {
            ShadowNode shadowNode = new ShadowNode(this.obj);
            return shadowNode;
        }

        public void setName(String string) {
            try {
                if (!string.equals(this.obj.getName())) {
                    this.obj.rename(string);
                    if (this.obj.original.getPrimaryFile().isRoot()) {
                        this.obj.getPrimaryFile().setAttribute(ATTR_USEOWNNAME, Boolean.TRUE);
                    }
                    this.fireDisplayNameChange(null, null);
                    this.fireNameChange(null, null);
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        public String getName() {
            return this.obj.getName();
        }

        private String getOriginalFileSystemName() {
            if (this.originalFS != null) {
                return this.originalFS;
            }
            try {
                this.originalFS = this.obj.getOriginal().getPrimaryFile().getFileSystem().getDisplayName();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.originalFS = "";
            }
            return this.originalFS;
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(NbBundle.getBundle(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ShadowNode.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow).getString("FMT_shadowName"));
            }
            String string = format.format(this.createArguments());
            try {
                this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(string, this.obj.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return string;
        }

        private Object[] createArguments() {
            String string = this.obj.getName();
            String string2 = this.obj.original.isValid() ? this.obj.original.getNodeDelegate().getDisplayName() : "";
            Boolean bl = (Boolean)this.obj.getPrimaryFile().getAttribute(ATTR_USEOWNNAME);
            if (this.obj.original.getPrimaryFile().isRoot() && (bl == null || !bl.booleanValue())) {
                try {
                    string = this.obj.original.getPrimaryFile().getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return new Object[]{string, super.getDisplayName(), ShadowNode.systemNameOrFileName(this.obj.getPrimaryFile()), ShadowNode.systemNameOrFileName(this.obj.getOriginal().getPrimaryFile()), string2};
        }

        private static String systemNameOrFileName(FileObject fileObject) {
            if (fileObject.isRoot()) {
                try {
                    return fileObject.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return fileObject.getPackageNameExt('/', '.');
        }

        public String getShortDescription() {
            if (descriptionFormat == null) {
                descriptionFormat = new MessageFormat(NbBundle.getBundle(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ShadowNode.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow).getString("FMT_shadowHint"));
            }
            return descriptionFormat.format(this.createArguments());
        }

        public Image getIcon(int n) {
            Image image = this.rootIcon(n);
            if (image != null) {
                return image;
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            Image image = this.rootIcon(n);
            if (image != null) {
                return image;
            }
            return super.getOpenedIcon(n);
        }

        private Image rootIcon(int n) {
            FileObject fileObject = this.obj.getOriginal().getPrimaryFile();
            if (fileObject.isRoot()) {
                try {
                    FileSystem fileSystem = fileObject.getFileSystem();
                    try {
                        Image image = Introspector.getBeanInfo(fileSystem.getClass()).getIcon(n);
                        return fileSystem.getStatus().annotateIcon(image, n, this.obj.files());
                    }
                    catch (IntrospectionException introspectionException) {
                        ErrorManager.getDefault().notify(1, introspectionException);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean canDestroy() {
            return this.obj.isDeleteAllowed();
        }

        public void destroy() throws IOException {
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.remove(this);
            }
            this.obj.delete();
        }

        public final boolean canRename() {
            return this.obj.isRenameAllowed();
        }

        public final boolean canCopy() {
            return this.obj.isCopyAllowed();
        }

        public final boolean canCut() {
            return this.obj.isMoveAllowed();
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = this.obj.getCookie(clazz);
            if (cookie != null) {
                return cookie;
            }
            return super.getCookie(clazz);
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = this.sheet;
            if (sheet == null) {
                sheet = this.sheet = this.cloneSheet();
            }
            return sheet.toArray();
        }

        public Transferable clipboardCopy() throws IOException {
            ExTransferable exTransferable = ExTransferable.create(super.clipboardCopy());
            exTransferable.put(LoaderTransfer.transferable(this.obj, 1));
            return exTransferable;
        }

        public Transferable clipboardCut() throws IOException {
            ExTransferable exTransferable = ExTransferable.create(super.clipboardCut());
            exTransferable.put(LoaderTransfer.transferable(this.obj, 4));
            return exTransferable;
        }

        public Transferable drag() throws IOException {
            return this.clipboardCopy();
        }

        protected NodeListener createNodeListener() {
            return new PropL(this);
        }

        public boolean equals(Object object) {
            if (object instanceof ShadowNode) {
                ShadowNode shadowNode = (ShadowNode)object;
                return shadowNode.obj == this.obj;
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] propertySetArray = this.getOriginal().getPropertySets();
            Sheet sheet = new Sheet();
            int n = 0;
            while (n < propertySetArray.length) {
                Sheet.Set set = new Sheet.Set();
                set.put(propertySetArray[n].getProperties());
                set.setName(propertySetArray[n].getName());
                set.setDisplayName(propertySetArray[n].getDisplayName());
                set.setShortDescription(propertySetArray[n].getShortDescription());
                this.modifySheetSet(set);
                sheet.put(set);
                ++n;
            }
            return sheet;
        }

        private void modifySheetSet(Sheet.Set set) {
            Node.Property property = set.remove("name");
            if (property != null) {
                property = new PropertySupport.Name(this);
                set.put(property);
                property = new Name();
                set.put(property);
                property = new FileSystemProperty();
                set.put(property);
            }
        }

        private void originalChanged() {
            DataObject dataObject = this.obj.getOriginal();
            if (dataObject.isValid()) {
                this.changeOriginal(dataObject.getNodeDelegate(), true);
            } else {
                DataShadow.updateShadowOriginal(this.obj);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private static class PropL
        extends FilterNode.NodeAdapter {
            public PropL(ShadowNode shadowNode) {
                super(shadowNode);
            }

            protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
                if ("propertySets".equals(propertyChangeEvent.getPropertyName())) {
                    ShadowNode shadowNode = (ShadowNode)filterNode;
                    shadowNode.sheet = null;
                }
                super.propertyChange(filterNode, propertyChangeEvent);
            }
        }

        private final class FileSystemProperty
        extends PropertySupport.ReadOnly {
            static /* synthetic */ Class class$java$lang$String;

            public FileSystemProperty() {
                super("OriginalFileSystem", class$java$lang$String == null ? (class$java$lang$String = FileSystemProperty.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_ShadowOriginalFileSystem"), DataObject.getString("HINT_ShadowOriginalFileSystem"));
            }

            public Object getValue() {
                return ShadowNode.this.getOriginalFileSystemName();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            static /* synthetic */ Class class$java$lang$String;

            public Name() {
                super("OriginalName", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_ShadowOriginalName"), DataObject.getString("HINT_ShadowOriginalName"));
            }

            public Object getValue() {
                return ShadowNode.this.obj.getOriginal().getName();
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    DataObject dataObject = ShadowNode.this.obj.getOriginal();
                    dataObject.rename((String)object);
                    DataShadow.writeOriginal(null, null, ShadowNode.this.obj.getPrimaryFile(), dataObject);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return ShadowNode.this.obj.getOriginal().isRenameAllowed();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    private static class OrigL
    implements PropertyChangeListener {
        WeakReference shadow = null;

        public OrigL(DataShadow dataShadow) {
            this.shadow = new WeakReference<DataShadow>(dataShadow);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataShadow dataShadow = (DataShadow)this.shadow.get();
            if (dataShadow != null && "valid".equals(propertyChangeEvent.getPropertyName())) {
                DataShadow.updateShadowOriginal(dataShadow);
            }
        }
    }
}

