/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class DefaultDataObject
extends MultiDataObject {
    static final long serialVersionUID = -4936309935667095746L;
    static /* synthetic */ Class class$org$openide$loaders$DefaultDataObject;

    DefaultDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = new DataNode(this, Children.LEAF);
        dataNode.setShortDescription(NbBundle.getMessage(class$org$openide$loaders$DefaultDataObject == null ? (class$org$openide$loaders$DefaultDataObject = DefaultDataObject.class$("org.openide.loaders.DefaultDataObject")) : class$org$openide$loaders$DefaultDataObject, "HINT_DefaultDataObject"));
        return dataNode;
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$loaders$DefaultDataObject == null ? (class$org$openide$loaders$DefaultDataObject = DefaultDataObject.class$("org.openide.loaders.DefaultDataObject")) : class$org$openide$loaders$DefaultDataObject);
    }

    protected FileObject handleRename(String string) throws IOException {
        FileLock fileLock = this.getPrimaryFile().lock();
        int n = string.lastIndexOf(46);
        try {
            if (n < 0) {
                this.getPrimaryFile().rename(fileLock, string, null);
            } else if (n == 0) {
                this.getPrimaryFile().rename(fileLock, string, this.getPrimaryFile().getExt());
            } else if (!string.equals(this.getPrimaryFile().getNameExt())) {
                this.getPrimaryFile().rename(fileLock, string.substring(0, n), string.substring(n + 1, string.length()));
                DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(this.getPrimaryFile())));
            }
            Object var5_4 = null;
            fileLock.releaseLock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        return this.getPrimaryFile();
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string != null && string.endsWith("." + this.getPrimaryFile().getExt())) {
            string = string.substring(0, string.lastIndexOf("." + this.getPrimaryFile().getExt()));
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

