/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;

final class FilesSet
implements Set {
    private Object primaryFile;
    private HashMap secondary;
    private TreeSet delegate;

    public FilesSet(Object object, HashMap hashMap) {
        this.primaryFile = object;
        this.secondary = hashMap;
    }

    private Set getDelegate() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            if (this.delegate == null) {
                this.delegate = new TreeSet(new FilesComparator());
                this.delegate.add(this.primaryFile);
                this.delegate.addAll(this.secondary.keySet());
            }
        }
        return this.delegate;
    }

    public boolean add(Object object) {
        return this.getDelegate().add(object);
    }

    public boolean addAll(Collection collection) {
        return this.getDelegate().addAll(collection);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    public boolean isEmpty() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            boolean bl = this.delegate == null ? false : this.delegate.isEmpty();
            return bl;
        }
    }

    public Iterator iterator() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Iterator iterator = this.delegate == null ? new FilesIterator() : this.delegate.iterator();
            return iterator;
        }
    }

    public boolean remove(Object object) {
        return this.getDelegate().remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.getDelegate().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getDelegate().retainAll(collection);
    }

    public int size() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            int n = this.delegate == null ? this.secondary.size() + 1 : this.delegate.size();
            return n;
        }
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getDelegate().toArray(objectArray);
    }

    private final class FilesComparator
    implements Comparator {
        private FilesComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == FilesSet.this.primaryFile) {
                return -1;
            }
            if (object2 == FilesSet.this.primaryFile) {
                return 1;
            }
            return ((FileObject)object).getNameExt().compareTo(((FileObject)object2).getNameExt());
        }
    }

    private final class FilesIterator
    implements Iterator {
        private boolean first = true;
        private Iterator itDelegate = null;

        private FilesIterator() {
        }

        public boolean hasNext() {
            return this.first ? true : this.getIteratorDelegate().hasNext();
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return FilesSet.this.primaryFile;
            }
            return this.getIteratorDelegate().next();
        }

        public void remove() {
            this.getIteratorDelegate().remove();
        }

        private Iterator getIteratorDelegate() {
            if (this.itDelegate == null) {
                this.itDelegate = FilesSet.this.getDelegate().iterator();
                this.itDelegate.next();
            }
            return this.itDelegate;
        }
    }
}

