/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceNode;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;

public class InstanceDataObject
extends MultiDataObject
implements InstanceCookie.Of {
    static final long serialVersionUID = -6134784731744777123L;
    private static final String EA_INSTANCE_CLASS = "instanceClass";
    private static final String EA_INSTANCE_CREATE = "instanceCreate";
    private static final String EA_INSTANCE_OF = "instanceOf";
    static final String EA_NAME = "name";
    private static final int SAVE_DELAY = 2000;
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    public static final String INSTANCE = "instance";
    static final String SER_EXT = "ser";
    static final String XML_EXT = "settings";
    private static final String ICON_NAME = "icon";
    private static final String DISPLAY_NAME = "name";
    private Ser ser;
    private boolean savingCanceled = false;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Instance processor");
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.InstanceDataObject");
    private final Object IDO_LOCK = new Object();
    private UpdatableNode un;
    private Lookup.Result cookieResult = null;
    private Lookup.Result nodeResult = null;
    private Lookup cookiesLkp = null;
    private LookupListener cookiesLsnr = null;
    private static final Set warnedAboutBrackets = new WeakSet(100);
    private static final int MAX_FILENAME_LENGTH = 50;
    private FileLock fileLock;
    private static final String EA_PROVIDER_PATH = "settings.providerPath";
    private static final List createdIDOs = Collections.synchronizedList(new ArrayList(1));
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$nodes$Node$Handle;
    static /* synthetic */ Class class$org$openide$nodes$Node$Cookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$lang$Object;

    public InstanceDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        if (fileObject.hasExt(SER_EXT)) {
            this.ser = new Ser(this);
            this.getCookieSet().add(this.ser);
        } else if (!fileObject.hasExt(XML_EXT)) {
            this.ser = new Ser(this);
        }
    }

    private Object getLock() {
        return this.IDO_LOCK;
    }

    private static FileObject findFO(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string3 = string2.replace('.', '-');
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.hasExt(INSTANCE) || (string == null ? !string3.equals(InstanceDataObject.getName(fileObject2)) : !string.equals(InstanceDataObject.getName(fileObject2))) || !string2.equals(Ser.getClassName(fileObject2))) continue;
            return fileObject2;
        }
        return null;
    }

    private static String getName(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("name");
        if (string != null) {
            return string;
        }
        string = fileObject.getName();
        int n = string.indexOf(91);
        if (n == -1) {
            return InstanceDataObject.unescape(string);
        }
        InstanceDataObject.warnAboutBrackets(fileObject);
        return InstanceDataObject.unescape(string.substring(0, n));
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject != null) {
            try {
                return (InstanceDataObject)DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, Class clazz) {
        return InstanceDataObject.find(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, final String string, final String string2) throws IOException {
        final FileObject fileObject = dataFolder.getPrimaryFile();
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        FileObject fileObject2 = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject2 == null) {
            final FileObject[] fileObjectArray = new FileObject[1];
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    String string3 = string == null ? FileUtil.findFreeFileName(fileObject, string2.replace('.', '-'), InstanceDataObject.INSTANCE) : InstanceDataObject.escape(string);
                    fileObjectArray[0] = fileObject.createData(string3, InstanceDataObject.INSTANCE);
                    fileObjectArray[0].setAttribute(InstanceDataObject.EA_INSTANCE_CLASS, string2);
                }
            });
            fileObject2 = fileObjectArray[0];
        }
        return (InstanceDataObject)DataObject.find(fileObject2);
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Class clazz) throws IOException {
        return InstanceDataObject.create(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        return InstanceDataObject.create(dataFolder, string, object, moduleInfo, false);
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo, boolean bl) throws IOException {
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        return Creator.createInstanceDataObject(dataFolder, string, object, moduleInfo, bl);
    }

    private static InstanceDataObject storeSettings(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        InstanceDataObject instanceDataObject;
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string2 = fileObject.getPackageName('/') + '/' + string + '.' + XML_EXT;
        try {
            System.setProperty("InstanceDataObject.current.file", fileObject.toString() + "/" + string + "." + XML_EXT);
            ByteArrayOutputStream byteArrayOutputStream = InstanceDataObject.storeThroughConvertor(object);
            System.setProperty("InstanceDataObject.current.file", "");
            FileObject fileObject2 = fileObject.getFileObject(string, XML_EXT);
            if (fileObject2 == null) {
                createdIDOs.add(string2);
                fileObject2 = fileObject.createData(string, XML_EXT);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.close();
                    Object var12_10 = null;
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    throw throwable;
                }
            }
            instanceDataObject = (InstanceDataObject)DataObject.find(fileObject2);
            instanceDataObject.attachToConvertor(object);
            Object var14_14 = null;
            createdIDOs.remove(string2);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            createdIDOs.remove(string2);
            throw throwable;
        }
        return instanceDataObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean remove(DataFolder dataFolder, String string, String string2) {
        FileLock fileLock = null;
        try {
            try {
                FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
                if (fileObject == null) {
                    boolean bl = false;
                    Object var7_8 = null;
                    if (fileLock == null) return bl;
                    fileLock.releaseLock();
                    return bl;
                }
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var7_10 = null;
                if (fileLock == null) return bl;
                fileLock.releaseLock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        Object var7_9 = null;
        if (fileLock == null) return true;
        fileLock.releaseLock();
        return true;
    }

    public static boolean remove(DataFolder dataFolder, String string, Class clazz) {
        return InstanceDataObject.remove(dataFolder, string, clazz.getName());
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp(this);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject);
    }

    static void inform(Throwable throwable) {
        err.notify(1, throwable);
    }

    protected Node createNodeDelegate() {
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.un = new UpdatableNode(this.createNodeDelegateImpl());
            return this.un;
        }
        return this.createNodeDelegateImpl();
    }

    private Node createNodeDelegateImpl() {
        Object object;
        try {
            if (this.getPrimaryFile().getFileSystem() != Repository.getDefault().getDefaultFileSystem()) {
                return new DataNode(this, Children.LEAF);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            InstanceDataObject.inform(fileStateInvalidException);
            return new DataNode(this, Children.LEAF);
        }
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            if (null == this.getCookieFromEP(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) {
                return new CookieAdjustingFilter(new UnrecognizedSettingNode());
            }
            object = (Node)this.getCookieFromEP(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceDataObject.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            if (object != null) {
                return new CookieAdjustingFilter((Node)object);
            }
        }
        try {
            if (this.instanceOf(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceDataObject.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                object = (Node)this.instanceCreate();
                return new CookieAdjustingFilter((Node)object);
            }
            if (this.instanceOf(class$org$openide$nodes$Node$Handle == null ? (class$org$openide$nodes$Node$Handle = InstanceDataObject.class$("org.openide.nodes.Node$Handle")) : class$org$openide$nodes$Node$Handle)) {
                object = (Node.Handle)this.instanceCreate();
                return new CookieAdjustingFilter(object.getNode());
            }
        }
        catch (IOException iOException) {
            InstanceDataObject.inform(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            InstanceDataObject.inform(classNotFoundException);
        }
        return new InstanceNode(this);
    }

    private Object getCookieFromEP(Class clazz) {
        this.updateLookup();
        return this.cookiesLkp.lookup(clazz);
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = null;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            String string = this.getPrimaryFile().getPackageNameExt('/', '.');
            if (createdIDOs.contains(string)) {
                return null;
            }
            cookie = (Node.Cookie)this.getCookieFromEP(clazz);
            if ((class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie).isAssignableFrom(clazz)) {
                return cookie;
            }
        }
        if (cookie == null) {
            cookie = super.getCookie(clazz);
        }
        return cookie;
    }

    private Lookup findLookup() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.cookiesLkp != null) {
                Lookup lookup = this.cookiesLkp;
                return lookup;
            }
        }
        Lookup lookup = Environment.findForOne(this);
        Object object2 = this.getLock();
        synchronized (object2) {
            if (this.cookiesLkp == null) {
                this.cookiesLkp = lookup == null ? Lookup.EMPTY : lookup;
            }
            Lookup lookup2 = this.cookiesLkp;
            return lookup2;
        }
    }

    private void updateLookup() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.cookieResult != null) {
                return;
            }
        }
        this.findLookup();
        boolean bl = false;
        Object object2 = this.getLock();
        synchronized (object2) {
            if (this.cookieResult != null) {
                return;
            }
            this.cookieResult = this.cookiesLkp.lookup(new Lookup.Template(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = InstanceDataObject.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie));
            this.cookiesLsnr = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    InstanceDataObject.this.firePropertyChange("cookie", null, null);
                }
            };
            this.cookieResult.addLookupListener(this.cookiesLsnr);
            this.nodeResult = this.cookiesLkp.lookup(new Lookup.Template(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
            this.nodeResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    if (InstanceDataObject.this.un != null) {
                        InstanceDataObject.this.un.update();
                    }
                }
            });
            bl = true;
        }
        if (bl) {
            this.cookieResult.allItems();
            this.nodeResult.allItems();
        }
    }

    private InstanceCookie.Of delegateIC() {
        InstanceCookie.Of of = null;
        of = this.getPrimaryFile().hasExt(XML_EXT) ? (InstanceCookie.Of)this.getCookieFromEP(class$org$openide$cookies$InstanceCookie$Of == null ? (class$org$openide$cookies$InstanceCookie$Of = InstanceDataObject.class$("org.openide.cookies.InstanceCookie$Of")) : class$org$openide$cookies$InstanceCookie$Of) : this.ser;
        return of;
    }

    public String instanceName() {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this.getName();
        }
        return of.instanceName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this.getClass();
        }
        return of.instanceClass();
    }

    public boolean instanceOf(Class clazz) {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return clazz.isAssignableFrom(this.getClass());
        }
        return of.instanceOf(clazz);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this;
        }
        return of.instanceCreate();
    }

    public String getName() {
        String string = (String)this.getPrimaryFile().getAttribute("name");
        if (string != null) {
            return string;
        }
        string = super.getName();
        int n = string.indexOf(91);
        if (n == -1) {
            return InstanceDataObject.unescape(string);
        }
        InstanceDataObject.warnAboutBrackets(this.getPrimaryFile());
        return InstanceDataObject.unescape(string.substring(0, n));
    }

    private static void warnAboutBrackets(FileObject fileObject) {
        if (warnedAboutBrackets.add(fileObject)) {
            err.log(16, "Use of [] in " + fileObject + " is deprecated.");
            err.log(16, "(Please use the string-valued file attribute instanceClass instead.)");
        }
    }

    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        fileObject.setAttribute("name", string);
        return fileObject;
    }

    static String escape(String string) {
        boolean bl = string.startsWith(" ") || string.endsWith(" ") || string.indexOf("  ") != -1;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && bl || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                stringBuffer.append('#');
                String string2 = Integer.toString(c, 16).toUpperCase();
                if (string2.length() < 4) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 3) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '#') {
                if (n2 + 4 >= n) {
                    err.log(16, "trailing garbage in instance name: " + string);
                    break;
                }
                try {
                    char[] cArray = new char[4];
                    string.getChars(n2 + 1, n2 + 5, cArray, 0);
                    stringBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    err.notify(1, numberFormatException);
                }
                n2 += 4;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String escapeAndCut(String string) {
        int n = 50;
        String string2 = InstanceDataObject.escape(string);
        if (string2.length() <= n) {
            return string2;
        }
        String string3 = Integer.toHexString(string2.hashCode());
        n = n > string3.length() ? (n - string3.length()) / 2 : 1;
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(string2.length() - n);
        return string4 + string3 + string5;
    }

    final void scheduleSave() {
        if (this.isSavingCanceled() || !this.getPrimaryFile().hasExt(SER_EXT)) {
            return;
        }
        this.doFileLock();
        this.ser.getSaveTask().schedule(2000);
    }

    private FileLock doFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock != null) {
                FileLock fileLock = this.fileLock;
                return fileLock;
            }
            try {
                this.fileLock = this.getPrimaryFile().lock();
            }
            catch (IOException iOException) {
                err.annotate((Throwable)iOException, this.getPrimaryFile().toString());
                InstanceDataObject.inform(iOException);
            }
            FileLock fileLock = this.fileLock;
            return fileLock;
        }
    }

    private void relaseFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock == null) {
                return;
            }
            this.fileLock.releaseLock();
            this.fileLock = null;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        try {
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                InstanceDataObject instanceDataObject = this.createSettingsFile(dataFolder, string, object);
                this.attachToConvertor(null);
                return instanceDataObject;
            }
            if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass())) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                return DataObject.find(this.createSerFile(dataFolder, string, object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            InstanceDataObject.inform(classNotFoundException);
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        try {
            InstanceCookie instanceCookie;
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie instanceCookie2 = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie2 != null) {
                    Object object = instanceCookie2.instanceCreate();
                    InstanceDataObject instanceDataObject = this.createSettingsFile(dataFolder, this.getNodeDelegate().getDisplayName(), object);
                    instanceDataObject.attachToConvertor(null);
                    return instanceDataObject;
                }
            } else if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass()) && (instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) != null) {
                Object object = instanceCookie.instanceCreate();
                return DataObject.find(this.createSerFile(dataFolder, this.getNodeDelegate().getDisplayName(), object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            InstanceDataObject.inform(classNotFoundException);
        }
        return super.handleCopy(dataFolder);
    }

    private boolean isSavingCanceled() {
        return this.savingCanceled;
    }

    protected void dispose() {
        if (this.getPrimaryFile().hasExt(SER_EXT)) {
            RequestProcessor.Task task;
            this.savingCanceled = true;
            if (this.ser != null && ((task = this.ser.getSaveTask()).getDelay() > 0 || this.ser.isSaving() && !task.isFinished())) {
                task.waitFinished();
            }
            this.relaseFileLock();
        } else if (this.getPrimaryFile().hasExt(XML_EXT)) {
            SaveCookie saveCookie = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            try {
                if (saveCookie != null) {
                    saveCookie.save();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    protected void handleDelete() throws IOException {
        this.savingCanceled = true;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.handleDeleteSettings();
            return;
        }
        if (this.ser != null) {
            RequestProcessor.Task task = this.ser.getSaveTask();
            task.cancel();
            if (this.ser.isSaving() && !task.isFinished()) {
                task.waitFinished();
            }
        }
        this.relaseFileLock();
        super.handleDelete();
    }

    private void handleDeleteSettings() throws IOException {
        SaveCookie saveCookie = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        try {
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.handleDelete();
    }

    private InstanceDataObject createSettingsFile(DataFolder dataFolder, String string, Object object) throws IOException {
        String string2;
        Serializable serializable;
        FileObject fileObject = dataFolder.getPrimaryFile();
        boolean bl = false;
        if (object instanceof ServiceType) {
            bl = true;
            serializable = (ServiceType)object;
            String string3 = string = string == null ? ((ServiceType)serializable).getName() : string;
            int n = 1;
            while (TopManager.getDefault().getServices().find(string3) != null) {
                string3 = new StringBuffer(string.length() + 2).append(string).append('_').append(n).toString();
                ++n;
            }
            if (!string3.equals(((ServiceType)serializable).getName())) {
                serializable = ((ServiceType)serializable).createClone();
                object = serializable;
                ((ServiceType)serializable).setName(string3);
            }
            string2 = InstanceDataObject.escapeAndCut(string3);
        } else {
            string2 = string == null ? this.getPrimaryFile().getName() : InstanceDataObject.escapeAndCut(string);
        }
        string2 = FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), string2, this.getPrimaryFile().getExt());
        serializable = InstanceDataObject.storeSettings(dataFolder, string2, object, null);
        if (string != null && !bl) {
            ((DataObject)serializable).getPrimaryFile().setAttribute("name", string);
        }
        return serializable;
    }

    private FileObject createSerFile(DataFolder dataFolder, String string, Object object) throws IOException {
        FileObject fileObject;
        FileLock fileLock;
        block7: {
            fileLock = null;
            OutputStream outputStream = null;
            fileObject = null;
            try {
                FileObject fileObject2 = dataFolder.getPrimaryFile();
                if (string == null) {
                    string = FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), this.getPrimaryFile().getName(), this.getPrimaryFile().getExt());
                }
                if ((fileObject = fileObject2.getFileObject(string, SER_EXT)) == null) {
                    fileObject = fileObject2.createData(string, SER_EXT);
                }
                fileLock = fileObject.lock();
                outputStream = fileObject.getOutputStream(fileLock);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                Object var10_9 = null;
                if (outputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            outputStream.close();
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
        return fileObject;
    }

    final void setCustomClassLoader(ClassLoader classLoader) {
        if (this.ser instanceof Ser) {
            this.ser.setCustomClassLoader(classLoader);
        }
    }

    private static ByteArrayOutputStream storeThroughConvertor(Object object) throws IOException {
        FileObject fileObject = InstanceDataObject.resolveConvertor(object);
        Object object2 = fileObject.getAttribute("settings.convertor");
        if (object2 == null) {
            throw new IOException("missing attribute settings.convertor");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        InstanceDataObject.convertorWriteMethod(object2, outputStreamWriter, object);
        ((Writer)outputStreamWriter).close();
        return byteArrayOutputStream;
    }

    private static void convertorWriteMethod(Object object, Writer writer, Object object2) throws IOException {
        Throwable throwable;
        block5: {
            throwable = null;
            try {
                Method method = object.getClass().getMethod("write", class$java$io$Writer == null ? (class$java$io$Writer = InstanceDataObject.class$("java.io.Writer")) : class$java$io$Writer, class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object);
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(object, writer, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throwable = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof IOException)) break block5;
                throw (IOException)throwable;
            }
        }
        if (throwable != null) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Problem with Convertor.write method."), throwable);
        }
    }

    private static FileObject resolveConvertor(Object object) throws IOException {
        String string = "xml/memory/";
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            throw new FileNotFoundException("SFS/xml/memory/");
        }
        String[] stringArray = new String[]{object.getClass().getName(), (class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object).getName()};
        int n = 0;
        while (n < stringArray.length) {
            String string2 = new StringBuffer(200).append(string).append(stringArray[n].replace('.', '/')).toString();
            FileObject fileObject2 = fileSystem.findResource(string2);
            if (fileObject2 != null) {
                String string3 = (String)fileObject2.getAttribute(EA_PROVIDER_PATH);
                if (string3 == null) break;
                return fileSystem.findResource(string3);
            }
            ++n;
        }
        throw new FileNotFoundException("None convertor was found under SFS/xml/memory/ for " + object);
    }

    private void attachToConvertor(Object object) throws IOException {
        this.findLookup();
        Object object2 = this.cookiesLkp.lookup(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
        if (object2 == null) {
            throw new IllegalStateException("Trying to store object " + object + " which most probably belongs to already disabled module!");
        }
        InstanceDataObject.convertorSetInstanceMethod(object2, object);
    }

    private static void convertorSetInstanceMethod(Object object, Object object2) throws IOException {
        ReflectiveOperationException reflectiveOperationException;
        block5: {
            reflectiveOperationException = null;
            try {
                Method method = object.getClass().getMethod("setInstance", class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object);
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                reflectiveOperationException = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof IOException)) break block5;
                throw (IOException)invocationTargetException.getTargetException();
            }
        }
        if (reflectiveOperationException != null) {
            ErrorManager.getDefault().annotate((Throwable)reflectiveOperationException, "Problem with InstanceCookie.setInstance method: " + object.getClass());
            InstanceDataObject.inform(reflectiveOperationException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Creator
    implements FileSystem.AtomicAction {
        private ModuleInfo mi = null;
        private DataFolder folder = null;
        private Object instance = null;
        private String name = null;
        private InstanceDataObject result = null;
        private boolean create;
        private static final Creator me = new Creator();

        private Creator() {
        }

        public void run() throws IOException {
            FileObject fileObject = this.folder.getPrimaryFile();
            String string = this.name;
            if (string == null) {
                string = this.instance.getClass().getName().replace('.', '-');
                string = FileUtil.findFreeFileName(fileObject, string, InstanceDataObject.XML_EXT);
            } else {
                String string2 = InstanceDataObject.escape(string);
                string = fileObject.getFileObject(string2, InstanceDataObject.XML_EXT) == null ? InstanceDataObject.escapeAndCut(string) : string2;
                if (this.create) {
                    string = FileUtil.findFreeFileName(fileObject, string, InstanceDataObject.XML_EXT);
                }
            }
            this.result = InstanceDataObject.storeSettings(this.folder, string, this.instance, this.mi);
        }

        public static InstanceDataObject createInstanceDataObject(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo, boolean bl) throws IOException {
            Creator creator = me;
            synchronized (creator) {
                Creator.me.mi = moduleInfo;
                Creator.me.folder = dataFolder;
                Creator.me.instance = object;
                Creator.me.name = string;
                Creator.me.create = bl;
                dataFolder.getPrimaryFile().getFileSystem().runAtomicAction(me);
                Creator.me.mi = null;
                Creator.me.folder = null;
                Creator.me.instance = null;
                Creator.me.name = null;
                InstanceDataObject instanceDataObject = Creator.me.result;
                Creator.me.result = null;
                InstanceDataObject instanceDataObject2 = instanceDataObject;
                return instanceDataObject2;
            }
        }

        public static boolean isFiredFromMe(FileEvent fileEvent) {
            return fileEvent.firedFrom(me);
        }
    }

    private static final class Ser
    extends InstanceSupport.Origin
    implements Runnable {
        private Reference bean = new SoftReference<Object>(null);
        private long saveTime;
        private ClassLoader customClassLoader = null;
        private InstanceDataObject dobj;
        private RequestProcessor.Task task;
        private boolean saving = false;
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

        public Ser(InstanceDataObject instanceDataObject) {
            super(instanceDataObject.getPrimaryEntry());
            this.dobj = instanceDataObject;
        }

        public String instanceName() {
            Object t;
            FileObject fileObject = this.entry().getFile();
            if (fileObject.lastModified().getTime() <= this.saveTime && (t = this.bean.get()) != null) {
                return t.getClass().getName();
            }
            if (!fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                return super.instanceName();
            }
            return Ser.getClassName(fileObject);
        }

        private static String getClassName(FileObject fileObject) {
            int n;
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CLASS);
            if (object instanceof String) {
                return Utilities.translate((String)object);
            }
            if (object != null) {
                err.log(16, "instanceClass was a " + object.getClass().getName());
            }
            if ((object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE)) != null) {
                return object.getClass().getName();
            }
            String string = fileObject.getName();
            int n2 = string.indexOf(91) + 1;
            if (n2 != 0) {
                InstanceDataObject.warnAboutBrackets(fileObject);
            }
            if ((n = string.indexOf(93)) < 0) {
                n = string.length();
            }
            if (n2 < n) {
                string = string.substring(n2, n);
            }
            string = string.replace('-', '.');
            string = Utilities.translate(string);
            return string;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            Class clazz = super.instanceClass(this.customClassLoader);
            Ser.updateListOfClasses(clazz, this.entry().getFile());
            return clazz;
        }

        public boolean instanceOf(Class clazz) {
            Object object;
            FileObject fileObject = this.entry().getFile();
            if (fileObject.lastModified().getTime() <= this.saveTime && (object = this.bean.get()) != null) {
                return clazz.isInstance(object);
            }
            object = Ser.inListOfClasses(clazz, this.entry().getFile());
            if (object == null) {
                return super.instanceOf(clazz);
            }
            return (Boolean)object;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            FileObject fileObject = this.entry().getFile();
            Object object = fileObject.lastModified().getTime() <= this.saveTime ? (Object)this.bean.get() : null;
            if (object != null) {
                return object;
            }
            this.saveTime = fileObject.lastModified().getTime();
            if (this.saveTime < System.currentTimeMillis()) {
                this.saveTime = System.currentTimeMillis();
            }
            if (fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE);
            }
            if (object == null) {
                object = super.instanceCreate();
            }
            this.bean = new SoftReference<Object>(object);
            return object;
        }

        public void run() {
            try {
                this.saving = true;
                this.runImpl();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.dobj.relaseFileLock();
                this.saving = false;
                throw throwable;
            }
            this.dobj.relaseFileLock();
            this.saving = false;
        }

        private void runImpl() {
            Object t = this.bean.get();
            if (t == null) {
                return;
            }
            try {
                FileLock fileLock = this.dobj.doFileLock();
                if (fileLock == null) {
                    return;
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.entry().getFile().getOutputStream(fileLock));
                try {
                    objectOutputStream.writeObject(t);
                    this.saveTime = this.entry().getFile().lastModified().getTime();
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    objectOutputStream.close();
                    throw throwable;
                }
                objectOutputStream.close();
                {
                }
            }
            catch (IOException iOException) {
                err.annotate((Throwable)iOException, NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = Ser.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject, "EXC_CannotSaveBean", this.instanceName(), this.entry().getFile().getPackageNameExt('/', '.')));
                err.notify(iOException);
            }
        }

        private static Boolean inListOfClasses(Class clazz, FileObject fileObject) {
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (object instanceof String) {
                String string = clazz.getName();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;:");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!string.equals(string2)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (object != null) {
                err.log(16, "instanceOf was a " + object.getClass().getName());
            }
            return null;
        }

        private static void updateListOfClasses(Class clazz, FileObject fileObject) {
            boolean bl;
            StringBuffer stringBuffer = null;
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (object instanceof String) {
                bl = false;
                stringBuffer = new StringBuffer(1024);
                HashSet<String> hashSet = new HashSet<String>(101);
                hashSet.add("java.lang.Object");
                Ser.collectType(clazz, stringBuffer, hashSet);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;:");
                while (stringTokenizer.hasMoreTokens()) {
                    if (hashSet.contains(stringTokenizer.nextToken().trim())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl) {
                try {
                    fileObject.setAttribute(InstanceDataObject.EA_INSTANCE_OF, stringBuffer.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static boolean collectType(Class clazz, StringBuffer stringBuffer, HashSet hashSet) {
            if (clazz == null) {
                return false;
            }
            String string = clazz.getName();
            if (hashSet.contains(string)) {
                return false;
            }
            hashSet.add(string);
            if (Ser.collectType(clazz.getSuperclass(), stringBuffer, hashSet)) {
                stringBuffer.append(',');
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (Ser.collectType(classArray[n], stringBuffer, hashSet)) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            stringBuffer.append(string);
            return true;
        }

        final void setCustomClassLoader(ClassLoader classLoader) {
            this.customClassLoader = classLoader;
        }

        public RequestProcessor.Task getSaveTask() {
            if (this.task == null) {
                this.task = PROCESSOR.create(this);
            }
            return this.task;
        }

        public boolean isSaving() {
            return this.saving;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class CookieAdjustingFilter
    extends FilterNode {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

        public CookieAdjustingFilter(Node node) {
            super(node);
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = CookieAdjustingFilter.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) || clazz == (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = CookieAdjustingFilter.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject)) {
                return InstanceDataObject.this;
            }
            return super.getCookie(clazz);
        }

        public Node.Handle getHandle() {
            return this.getOriginal().getHandle();
        }

        public boolean equals(Object object) {
            return this == object || this.getOriginal().equals(object) || object != null && object.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class UnrecognizedSettingNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;

        public UnrecognizedSettingNode() {
            super(Children.LEAF);
            this.setName(NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = UnrecognizedSettingNode.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject, "LBL_BrokenSettings"));
            this.setIconBase("org/openide/resources/instanceBroken");
            this.setShortDescription(InstanceDataObject.this.getPrimaryFile().toString());
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = UnrecognizedSettingNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)};
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class UpdatableNode
    extends FilterNode {
        public UpdatableNode(Node node) {
            super(node);
        }

        public void update() {
            this.changeOriginal(InstanceDataObject.this.createNodeDelegateImpl(), true);
        }
    }
}

