/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.beans.PropertyEditor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class PropertySupport
extends Node.Property {
    private boolean canR;
    private boolean canW;

    public PropertySupport(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2) {
        super(clazz);
        this.setName(string);
        this.setDisplayName(string2);
        this.setShortDescription(string3);
        this.canR = bl;
        this.canW = bl2;
    }

    public boolean canRead() {
        return this.canR;
    }

    public boolean canWrite() {
        return this.canW;
    }

    public static final class Name
    extends PropertySupport {
        private final Node node;
        static /* synthetic */ Class class$org$openide$nodes$PropertySupport;
        static /* synthetic */ Class class$java$lang$String;

        public Name(Node node) {
            this(node, NbBundle.getBundle(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = Name.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport).getString("CTL_StandardName"), NbBundle.getBundle(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = Name.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport).getString("CTL_StandardHint"));
        }

        public Name(Node node, String string, String string2) {
            super("name", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, string, string2, true, node.canRename());
            this.node = node;
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.node.getName();
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (!(object instanceof String)) {
                throw new IllegalAccessException();
            }
            String string = this.node.getName();
            this.node.setName((String)object);
            this.node.firePropertyChange("name", string, object);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static abstract class WriteOnly
    extends PropertySupport {
        public WriteOnly(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, false, true);
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannod read from WriteOnly property");
        }
    }

    public static abstract class ReadOnly
    extends PropertySupport {
        public ReadOnly(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, false);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannot write to ReadOnly property");
        }
    }

    public static abstract class ReadWrite
    extends PropertySupport {
        public ReadWrite(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, true);
        }
    }

    public static class Reflection
    extends Node.Property {
        protected Object instance;
        private Method setter;
        private Method getter;
        private Class propertyEditorClass;
        static /* synthetic */ Class class$java$lang$Object;

        public Reflection(Object object, Class clazz, Method method, Method method2) {
            super(clazz);
            if (method != null && !Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public getter " + method);
            }
            if (method2 != null && !Modifier.isPublic(method2.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public setter " + method2);
            }
            this.instance = object;
            this.setter = method2;
            this.getter = method;
        }

        public Reflection(Object object, Class clazz, String string, String string2) throws NoSuchMethodException {
            this(object, clazz, string == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string, new Class[0]), string2 == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string2, clazz));
        }

        private static Class findAccessibleClass(Class clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                return clazz;
            }
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return class$java$lang$Object == null ? (class$java$lang$Object = Reflection.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return Reflection.findAccessibleClass(clazz2);
        }

        public Reflection(Object object, Class clazz, String string) throws NoSuchMethodException {
            this(object, clazz, Reflection.firstLetterToUpperCase(string, "get"), Reflection.firstLetterToUpperCase(string, "set"));
        }

        private static String firstLetterToUpperCase(String string, String string2) {
            switch (string.length()) {
                case 0: {
                    return string2;
                }
                case 1: {
                    return string2 + Character.toUpperCase(string.charAt(0));
                }
            }
            return string2 + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }

        public boolean canRead() {
            return this.getter != null;
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getter == null) {
                throw new IllegalAccessException();
            }
            Object object = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
            try {
                return this.getter.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    ((AccessibleObject)this.getter).setAccessible(true);
                    Object object2 = this.getter.invoke(object, new Object[0]);
                    Object var5_4 = null;
                    ((AccessibleObject)this.getter).setAccessible(false);
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    ((AccessibleObject)this.getter).setAccessible(false);
                    throw throwable;
                }
            }
        }

        public boolean canWrite() {
            return this.setter != null;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.setter == null) {
                throw new IllegalAccessException();
            }
            Object object2 = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
            try {
                this.setter.invoke(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    ((AccessibleObject)this.setter).setAccessible(true);
                    this.setter.invoke(object2, object);
                    Object var5_4 = null;
                    ((AccessibleObject)this.setter).setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    ((AccessibleObject)this.setter).setAccessible(false);
                    throw throwable;
                }
            }
        }

        public PropertyEditor getPropertyEditor() {
            if (this.propertyEditorClass != null) {
                try {
                    return (PropertyEditor)this.propertyEditorClass.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return super.getPropertyEditor();
        }

        public void setPropertyEditorClass(Class clazz) {
            this.propertyEditorClass = clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

