/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.SourceException;

public final class InitializerElement
extends Element
implements Cloneable {
    private ClassElement declaringClass;
    static final long serialVersionUID = 5768667690932077280L;

    public InitializerElement() {
        this(new Memory(), null);
    }

    public InitializerElement(Impl impl, ClassElement classElement) {
        super(impl);
        this.declaringClass = classElement;
    }

    Impl getInitializerImpl() {
        return (Impl)this.impl;
    }

    public Object clone() {
        return new InitializerElement(new Memory(this), null);
    }

    public void setStatic(boolean bl) throws SourceException {
        this.getInitializerImpl().setStatic(bl);
    }

    public boolean isStatic() {
        return this.getInitializerImpl().isStatic();
    }

    public void setBody(String string) throws SourceException {
        this.getInitializerImpl().setBody(string);
    }

    public String getBody() {
        return this.getInitializerImpl().getBody();
    }

    public JavaDoc getJavaDoc() {
        return this.getInitializerImpl().getJavaDoc();
    }

    public final ClassElement getDeclaringClass() {
        return this.declaringClass;
    }

    public void print(ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        elementPrinter.markInitializer(this, 0);
        JavaDoc javaDoc = this.getJavaDoc();
        if (javaDoc != null && !javaDoc.isEmpty()) {
            elementPrinter.markInitializer(this, 2);
            Element.printJavaDoc(javaDoc, elementPrinter);
            elementPrinter.markInitializer(this, 3);
            elementPrinter.println("");
        }
        if (this.isStatic()) {
            elementPrinter.markInitializer(this, 4);
            elementPrinter.print("static ");
            elementPrinter.markInitializer(this, 5);
        }
        elementPrinter.print("{");
        elementPrinter.markInitializer(this, 6);
        elementPrinter.print(this.getBody());
        elementPrinter.markInitializer(this, 7);
        elementPrinter.print("}");
        elementPrinter.markInitializer(this, 1);
    }

    static class Memory
    extends Element.Memory
    implements Impl {
        private boolean stat;
        private String body;
        private JavaDoc javadoc;
        static final long serialVersionUID = 1956692952966906280L;
        static /* synthetic */ Class class$org$openide$src$ClassElement$Memory;

        Memory() {
            this.stat = false;
            this.body = "";
            this.javadoc = JavaDocSupport.createInitializerJavaDoc(null);
        }

        Memory(InitializerElement initializerElement) {
            this.stat = initializerElement.isStatic();
            this.body = initializerElement.getBody();
            this.javadoc = initializerElement.getJavaDoc().isEmpty() ? JavaDocSupport.createJavaDoc(null) : JavaDocSupport.createJavaDoc(initializerElement.getJavaDoc().getRawText());
        }

        public void setStatic(boolean bl) {
            boolean bl2 = bl;
            this.stat = bl;
            this.firePropertyChange("static", new Boolean(bl2), new Boolean(bl));
        }

        public boolean isStatic() {
            return this.stat;
        }

        public void setBody(String string) throws SourceException {
            String string2 = this.body;
            this.body = string;
            this.firePropertyChange("body", string2, this.body);
        }

        public String getBody() {
            return this.body;
        }

        public JavaDoc getJavaDoc() {
            return this.javadoc;
        }

        public void markCurrent(boolean bl) {
            ClassElement classElement = ((InitializerElement)this.element).getDeclaringClass();
            if (classElement == null) {
                throw new IllegalStateException();
            }
            ((ClassElement.Memory)classElement.getCookie(class$org$openide$src$ClassElement$Memory == null ? (class$org$openide$src$ClassElement$Memory = Memory.class$("org.openide.src.ClassElement$Memory")) : class$org$openide$src$ClassElement$Memory)).markCurrent(this.element, bl);
        }

        public Object readResolve() {
            return new InitializerElement(this, null);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface Impl
    extends Element.Impl {
        public static final long serialVersionUID = -3742940543185945549L;

        public void setStatic(boolean var1) throws SourceException;

        public boolean isStatic();

        public void setBody(String var1) throws SourceException;

        public String getBody();

        public JavaDoc getJavaDoc();
    }
}

