/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassCustomizer;
import org.openide.src.nodes.ClassElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.FieldCustomizer;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

class SourceEditSupport {
    static final ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$SourceEditSupport == null ? (class$org$openide$src$nodes$SourceEditSupport = SourceEditSupport.class$("org.openide.src.nodes.SourceEditSupport")) : class$org$openide$src$nodes$SourceEditSupport);
    static final String[] MENU_NAMES = new String[]{bundle.getString("MENU_CREATE_BLOCK"), bundle.getString("MENU_CREATE_VARIABLE"), bundle.getString("MENU_CREATE_CONSTRUCTOR"), bundle.getString("MENU_CREATE_METHOD"), bundle.getString("MENU_CREATE_CLASS"), bundle.getString("MENU_CREATE_INTERFACE")};
    static /* synthetic */ Class class$org$openide$src$nodes$SourceEditSupport;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    SourceEditSupport() {
    }

    public static NewType[] createNewTypes(ClassElement classElement) {
        if (classElement.isClass()) {
            return new NewType[]{new ElementNewType(classElement, 0), new ElementNewType(classElement, 1), new ElementNewType(classElement, 2), new ElementNewType(classElement, 3), new ElementNewType(classElement, 4), new ElementNewType(classElement, 5)};
        }
        return new NewType[]{new ElementNewType(classElement, 1), new ElementNewType(classElement, 3), new ElementNewType(classElement, 4), new ElementNewType(classElement, 5)};
    }

    static boolean openCustomizer(Component component, String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(component, ElementNode.bundle.getString(string), 2, -1, null, null);
        Object object = TopManager.getDefault().notify(notifyDescriptor);
        return object == NotifyDescriptor.OK_OPTION;
    }

    static void invokeAtomicAsUser(Element element, final ExceptionalRunnable exceptionalRunnable) throws IOException {
        Serializable serializable;
        final SourceException[] sourceExceptionArray = new SourceException[]{null};
        try {
            serializable = SourceEditSupport.findSource(element);
            if (serializable == null) {
                exceptionalRunnable.run();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            exceptionalRunnable.run();
                        }
                        catch (SourceException sourceException) {
                            sourceExceptionArray[0] = sourceException;
                        }
                    }
                };
                serializable.runAtomicAsUser(runnable);
            }
        }
        catch (SourceException sourceException) {
            sourceExceptionArray[0] = sourceException;
        }
        if (sourceExceptionArray[0] != null) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                sourceExceptionArray[0].printStackTrace();
            }
            serializable = new IOException(sourceExceptionArray[0].getMessage());
            ErrorManager.getDefault().annotate((Throwable)serializable, 256, null, null, sourceExceptionArray[0], null);
            throw serializable;
        }
    }

    static void runAsUser(Element element, final ExceptionalRunnable exceptionalRunnable) throws SourceException {
        final SourceException[] sourceExceptionArray = new SourceException[]{null};
        SourceElement sourceElement = SourceEditSupport.findSource(element);
        if (sourceElement == null) {
            exceptionalRunnable.run();
        } else {
            sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        exceptionalRunnable.run();
                    }
                    catch (SourceException sourceException) {
                        sourceExceptionArray[0] = sourceException;
                    }
                }
            });
        }
        if (sourceExceptionArray[0] != null) {
            throw sourceExceptionArray[0];
        }
    }

    static boolean isWriteable(Element element) {
        DataObject dataObject;
        SourceElement sourceElement = SourceEditSupport.findSource(element);
        DataObject dataObject2 = sourceElement == null ? null : (dataObject = (DataObject)sourceElement.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SourceEditSupport.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject));
        if (dataObject == null) {
            return true;
        }
        return !dataObject.getPrimaryFile().isReadOnly();
    }

    static SourceElement findSource(Element element) {
        SourceElement sourceElement = null;
        ClassElement classElement = null;
        if (element instanceof ClassElement) {
            classElement = (ClassElement)element;
        } else if (element instanceof MemberElement) {
            classElement = ((MemberElement)element).getDeclaringClass();
        } else if (element instanceof InitializerElement) {
            classElement = ((InitializerElement)element).getDeclaringClass();
        } else if (element instanceof SourceElement) {
            return (SourceElement)element;
        }
        if (classElement != null) {
            sourceElement = classElement.getSource();
        }
        return sourceElement;
    }

    static void createJavaFile(ClassElement classElement, FileObject fileObject) throws SourceException, IOException {
        DataObject dataObject;
        String string = classElement.getName().getSourceName();
        String string2 = fileObject.getPackageName('.');
        if ("".equals(string2)) {
            string2 = null;
        }
        String string3 = FileUtil.findFreeFileName(fileObject, string, "java");
        FileObject fileObject2 = fileObject.createData(string, "java");
        try {
            dataObject = DataObject.find(fileObject2);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw (IOException)ErrorManager.getDefault().annotate(new IOException(dataObjectNotFoundException.getMessage()), 4096, "Data object can't be created", bundle.getString("EXC_CREATE_SOURCE_FILE"), dataObjectNotFoundException, null);
        }
        SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = SourceEditSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        if (sourceCookie == null) {
            throw (SourceException)ErrorManager.getDefault().annotate((Throwable)new SourceException("Source element cannot be found"), bundle.getString("EXC_CREATE_SOURCE_FILE"));
        }
        if (string2 != null && !"".equals(string2)) {
            sourceCookie.getSource().setPackage(Identifier.create(string2));
        }
        sourceCookie.getSource().addClass(classElement);
        ClassElement classElement2 = sourceCookie.getSource().getClass(Identifier.create(classElement.getName().getSourceName()));
        int n = classElement2.getModifiers() & 0xFFFFFFF7;
        if ((n & 6) > 0) {
            n = n & 0xFFFFFFF9 | 1;
        }
        classElement2.setModifiers(n);
    }

    static void removeClass(ClassElement classElement) throws SourceException {
        if (classElement.getDeclaringClass() != null) {
            classElement.getDeclaringClass().removeClass(classElement);
        } else {
            SourceElement sourceElement = SourceEditSupport.findSource(classElement);
            if (sourceElement == null) {
                throw (SourceException)ErrorManager.getDefault().annotate((Throwable)new SourceException("Element has no source"), bundle.getString("EXC_NO_SOURCE"));
            }
            sourceElement.removeClass(classElement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ClassMultiPasteType
    extends PasteType {
        ClassElementNode target;
        Collection members;
        boolean delete;

        ClassMultiPasteType(ClassElementNode classElementNode, Collection collection, boolean bl) {
            this.target = classElementNode;
            this.members = collection;
            this.delete = bl;
        }

        public Transferable paste() throws IOException {
            Iterator iterator = this.members.iterator();
            while (iterator.hasNext()) {
                this.target.pasteElement((Element)iterator.next(), this.delete);
            }
            if (this.delete) {
                return ExTransferable.EMPTY;
            }
            return null;
        }
    }

    static class PackagePaste
    implements NodeTransfer.Paste {
        private static PasteType[] EMPTY_TYPES = new PasteType[0];
        private boolean deleteSelf;
        private ClassElement element;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        PackagePaste(ClassElement classElement, boolean bl) {
            this.deleteSelf = bl;
            this.element = classElement;
        }

        public PasteType[] types(Node node) {
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PackagePaste.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.element == null || dataObject == null) {
                return EMPTY_TYPES;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (!fileObject.isFolder()) {
                return EMPTY_TYPES;
            }
            return new PasteType[]{new Type(fileObject)};
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private class Type
        extends PasteType {
            private FileObject target;

            Type(FileObject fileObject) {
                this.target = fileObject;
            }

            public String getName() {
                return bundle.getString("MENU_PASTE_AS_FILE");
            }

            public HelpCtx getHelpCtx() {
                return super.getHelpCtx();
            }

            public Transferable paste() throws IOException {
                ClassElement classElement = PackagePaste.this.element;
                boolean bl = PackagePaste.this.deleteSelf;
                try {
                    SourceEditSupport.createJavaFile(classElement, this.target);
                }
                catch (SourceException sourceException) {
                    IOException iOException = new IOException(sourceException.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, sourceException);
                    throw iOException;
                }
                if (bl) {
                    SourceException[] sourceExceptionArray = new SourceException[]{null};
                    SourceEditSupport.invokeAtomicAsUser(classElement, new ExceptionalRunnable(this, classElement, sourceExceptionArray){
                        private final /* synthetic */ ClassElement val$clazz;
                        private final /* synthetic */ SourceException[] val$ex;
                        private final /* synthetic */ Type this$1;
                        {
                            this.this$1 = type;
                            this.val$clazz = classElement;
                            this.val$ex = sourceExceptionArray;
                        }

                        public void run() throws SourceException {
                            try {
                                SourceEditSupport.removeClass(this.val$clazz);
                            }
                            catch (SourceException sourceException) {
                                this.val$ex[0] = sourceException;
                            }
                        }
                    });
                    if (sourceExceptionArray[0] != null) {
                        IOException iOException = new IOException(sourceExceptionArray[0].getMessage());
                        ErrorManager.getDefault().annotate((Throwable)iOException, sourceExceptionArray[0]);
                        throw iOException;
                    }
                    PackagePaste.this.element = null;
                    return ExTransferable.EMPTY;
                }
                return null;
            }
        }
    }

    static interface ExceptionalRunnable {
        public void run() throws SourceException;
    }

    static class ElementNewType
    extends NewType {
        ClassElement element;
        ClassElement proxy;
        byte kind;
        static /* synthetic */ Class class$org$openide$src$nodes$SourceEditSupport;

        public ElementNewType(ClassElement classElement, byte by) {
            this.element = classElement;
            this.proxy = new ClassElement();
            try {
                this.proxy.setName(Identifier.create("Default"));
                this.proxy.setClassOrInterface(classElement.isClassOrInterface());
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            this.kind = by;
        }

        public String getName() {
            return MENU_NAMES[this.kind];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$openide$src$nodes$SourceEditSupport == null ? (class$org$openide$src$nodes$SourceEditSupport = ElementNewType.class$("org.openide.src.nodes.SourceEditSupport")) : class$org$openide$src$nodes$SourceEditSupport).getName() + ".newElement" + this.kind);
        }

        public void create() throws IOException {
            Element element;
            Identifier identifier = this.element.getName();
            boolean bl = this.element.isClass();
            Element element2 = null;
            try {
                switch (this.kind) {
                    case 0: {
                        element = new InitializerElement();
                        ((InitializerElement)element).setStatic(true);
                        ((InitializerElement)element).setBody("\n");
                        element2 = element;
                        break;
                    }
                    case 1: {
                        element = new FieldElement();
                        ((FieldElement)element).setType(Type.INT);
                        ((FieldElement)element).setName(Identifier.create("newField"));
                        ((MemberElement)element).setModifiers(2 + (bl ? 0 : 8));
                        this.proxy.addField((FieldElement)element);
                        element = this.proxy.getFields()[0];
                        FieldCustomizer fieldCustomizer = new FieldCustomizer((FieldElement)element);
                        if (!SourceEditSupport.openCustomizer(fieldCustomizer, "TIT_NewField") || !fieldCustomizer.isOK()) break;
                        element2 = element;
                        break;
                    }
                    case 2: {
                        element = new ConstructorElement();
                        ((MemberElement)element).setName(Identifier.create(this.element.getName().getName()));
                        ((MemberElement)element).setModifiers(1);
                        ((ConstructorElement)element).setBody("\n");
                        MethodCustomizer methodCustomizer = new MethodCustomizer((ConstructorElement)element);
                        if (!SourceEditSupport.openCustomizer(methodCustomizer, "TIT_NewConstructor") || !methodCustomizer.isOK()) break;
                        element2 = element;
                        break;
                    }
                    case 3: {
                        element = new MethodElement();
                        ((MethodElement)element).setReturn(Type.VOID);
                        ((MethodElement)element).setName(Identifier.create("newMethod"));
                        ((MemberElement)element).setModifiers(1);
                        ((ConstructorElement)element).setBody(bl ? "\n" : null);
                        this.proxy.addMethod((MethodElement)element);
                        element = this.proxy.getMethods()[0];
                        MethodCustomizer methodCustomizer = new MethodCustomizer((ConstructorElement)element);
                        if (!SourceEditSupport.openCustomizer(methodCustomizer, "TIT_NewMethod") || !methodCustomizer.isOK()) break;
                        if ((((MemberElement)element).getModifiers() & 0x500) > 0) {
                            ((ConstructorElement)element).setBody(null);
                        }
                        element2 = element;
                        break;
                    }
                    case 4: {
                        element = new ClassElement();
                        ((ClassElement)element).setName(Identifier.create(identifier.getFullName() + ".InnerClass", "InnerClass"));
                        ((MemberElement)element).setModifiers(1);
                        ((ClassElement)element).setClassOrInterface(true);
                        this.proxy.addClass((ClassElement)element);
                        element = this.proxy.getClasses()[0];
                        ClassCustomizer classCustomizer = new ClassCustomizer((ClassElement)element);
                        if (!SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewClass") || !classCustomizer.isOK()) break;
                        element2 = element;
                        break;
                    }
                    case 5: {
                        element = new ClassElement();
                        ((ClassElement)element).setName(Identifier.create(identifier.getFullName() + ".InnerInterface", "InnerInterface"));
                        ((MemberElement)element).setModifiers(1);
                        ((ClassElement)element).setClassOrInterface(false);
                        this.proxy.addClass((ClassElement)element);
                        element = this.proxy.getClasses()[0];
                        ClassCustomizer classCustomizer = new ClassCustomizer((ClassElement)element);
                        if (!SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewInterface") || !classCustomizer.isOK()) break;
                        element2 = element;
                    }
                }
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            if (element2 == null) {
                return;
            }
            element = element2;
            SourceEditSupport.invokeAtomicAsUser(this.element, new ExceptionalRunnable(this, element){
                private final /* synthetic */ Element val$addingElement;
                private final /* synthetic */ ElementNewType this$0;
                {
                    this.this$0 = elementNewType;
                    this.val$addingElement = element;
                }

                public void run() throws SourceException {
                    switch (this.this$0.kind) {
                        case 0: {
                            this.this$0.element.addInitializer((InitializerElement)this.val$addingElement);
                            return;
                        }
                        case 1: {
                            this.this$0.element.addField((FieldElement)this.val$addingElement);
                            return;
                        }
                        case 2: {
                            this.this$0.element.addConstructor((ConstructorElement)this.val$addingElement);
                            return;
                        }
                        case 3: {
                            this.this$0.element.addMethod((MethodElement)this.val$addingElement);
                            return;
                        }
                        case 4: 
                        case 5: {
                            this.this$0.element.addClass((ClassElement)this.val$addingElement);
                            return;
                        }
                    }
                }
            });
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

