/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintSettings;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    public static final String EDITOR_MODE = "editor";
    private boolean inUserQuestionExceptionHandler;
    private static final ThreadLocal LOCAL_LOAD_TASK = new ThreadLocal();
    private Task loadTask;
    private Task prepareTask;
    private EditorKit kit;
    private StyledDocument doc;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private final Object LOCK_LINE_SET = new Object();
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private HashSet listeners;
    transient CloneableEditor lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;

    public CloneableEditorSupport(Env env) {
        super(env);
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected abstract String messageToolTip();

    final Env env() {
        return (Env)this.env;
    }

    final EditorKit kit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        if (this.undoRedo == null) {
            this.undoRedo = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    public Task prepareDocument() {
        return this.prepareDocument(false);
    }

    private Task prepareDocument(final boolean bl) {
        Task task = this.prepareTask;
        if (task != null) {
            return task;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.prepareTask != null) {
                Task task2 = this.prepareTask;
                return task2;
            }
            this.env.removePropertyChangeListener(this.getListener());
            this.env.addPropertyChangeListener(this.getListener());
            this.kit = this.createEditorKit();
            if (this.doc == null) {
                this.doc = this.createStyledDocument(this.kit);
            }
            Task task3 = this.prepareTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            if (bl) {
                                CloneableEditorSupport.this.clearDocument();
                            }
                            CloneableEditorSupport.this.loadTask = new Task(CloneableEditorSupport.this.getListener());
                            CloneableEditorSupport.this.loadTask.run();
                        }
                        CloneableEditorSupport.this.fireStateChangeEvent(CloneableEditorSupport.this.doc, false);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        throw runtimeException;
                    }
                }
            });
            return task3;
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.doc, new Runnable(){

            public void run() {
                try {
                    CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                    CloneableEditorSupport.this.doc.remove(0, CloneableEditorSupport.this.doc.getLength());
                    CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, badLocationException);
                }
            }
        });
    }

    public StyledDocument openDocument() throws IOException {
        StyledDocument styledDocument;
        do {
            this.prepareDocument().waitFinished();
            IOException iOException = this.getListener().checkLoadException();
            if (iOException == null) continue;
            throw iOException;
        } while ((styledDocument = this.doc) == null);
        return styledDocument;
    }

    public StyledDocument getDocument() {
        if (LOCAL_LOAD_TASK.get() != null) {
            return this.doc;
        }
        Task task = this.loadTask;
        if (task != null) {
            task.waitFinished();
            return this.doc;
        }
        return null;
    }

    public boolean isModified() {
        return this.env().isModified();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDocument() throws IOException {
        block11: {
            if (!this.env().isModified()) {
                return;
            }
            StyledDocument styledDocument = this.getDocument();
            BufferedOutputStream bufferedOutputStream = null;
            long l = this.lastSaveTime;
            try {
                try {
                    this.lastSaveTime = -1L;
                    bufferedOutputStream = new BufferedOutputStream(this.env().outputStream());
                    this.saveFromKitToStream(styledDocument, this.kit, bufferedOutputStream);
                    if (bufferedOutputStream != null) {
                        ((OutputStream)bufferedOutputStream).close();
                        bufferedOutputStream = null;
                    }
                    this.lastSaveTime = System.currentTimeMillis();
                    this.notifyUnmodified();
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(badLocationException);
                    Object var7_5 = null;
                    if (this.lastSaveTime == -1L) {
                        this.lastSaveTime = l;
                    }
                    if (bufferedOutputStream != null) {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                    break block11;
                }
                Object var7_4 = null;
                if (this.lastSaveTime == -1L) {
                    this.lastSaveTime = l;
                }
                if (bufferedOutputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.lastSaveTime == -1L) {
                    this.lastSaveTime = l;
                }
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
                throw throwable;
            }
            ((OutputStream)bufferedOutputStream).close();
        }
        this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(this.lastSaveTime)));
        this.updateLineSet(true);
        this.updateTitles();
    }

    public JEditorPane[] getOpenedPanes() {
        LinkedList<JEditorPane> linkedList = new LinkedList<JEditorPane>();
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof CloneableEditor)) continue;
            CloneableEditor cloneableEditor = (CloneableEditor)e;
            if (cloneableEditor.pane == null) continue;
            if (this.lastSelected == cloneableEditor) {
                linkedList.addFirst(cloneableEditor.pane);
                continue;
            }
            linkedList.add(cloneableEditor.pane);
        }
        return linkedList.isEmpty() ? null : linkedList.toArray(new JEditorPane[linkedList.size()]);
    }

    public Line.Set getLineSet() {
        return this.updateLineSet(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print() {
        Object object2 = this.LOCK_PRINTING;
        synchronized (object2) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            block19: {
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    Object object = NbDocument.findPageable(this.openDocument());
                    if (object instanceof Pageable) {
                        printerJob.setPageable((Pageable)object);
                    } else {
                        PageFormat pageFormat = PrintSettings.getPageFormat(printerJob);
                        printerJob.setPrintable((Printable)object, pageFormat);
                    }
                    if (!printerJob.printDialog()) break block19;
                    printerJob.print();
                }
                catch (FileNotFoundException printerJob) {
                    ErrorManager.getDefault().notify(printerJob);
                    String object3 = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getString("CTL_Bad_File");
                    CloneableEditorSupport.notifyInAWT(object3);
                    Object var7_10 = null;
                    Object object = this.LOCK_PRINTING;
                    synchronized (object) {
                        this.printing = false;
                        return;
                    }
                }
                catch (IOException string) {
                    ErrorManager.getDefault().notify(string);
                    Object var7_11 = null;
                    Object object5 = this.LOCK_PRINTING;
                    synchronized (object5) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterAbortException pageFormat) {
                    String string = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getString("CTL_Printer_Abort");
                    CloneableEditorSupport.notifyInAWT(string);
                    Object var7_12 = null;
                    Object object6 = this.LOCK_PRINTING;
                    synchronized (object6) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterException printerException) {
                    ErrorManager.getDefault().notify(printerException);
                    Object var7_13 = null;
                    Object object7 = this.LOCK_PRINTING;
                    synchronized (object7) {
                        this.printing = false;
                        return;
                    }
                }
            }
            Object var7_9 = null;
            Object object = this.LOCK_PRINTING;
            synchronized (object) {
                this.printing = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            Object object8 = this.LOCK_PRINTING;
            synchronized (object8) {
                this.printing = false;
                throw throwable;
            }
        }
    }

    static void notifyInAWT(final String string) {
        if (EventQueue.isDispatchThread()) {
            TopManager.getDefault().notify(new NotifyDescriptor.Message(string));
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TopManager.getDefault().notify(new NotifyDescriptor.Message(string));
                }
            });
        }
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        CloneableEditor cloneableEditor = this.createCloneableEditor();
        this.initializeCloneableEditor(cloneableEditor);
        return cloneableEditor;
    }

    protected boolean canClose() {
        if (this.env().isModified()) {
            String string = this.messageSave();
            ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport);
            String string2 = resourceBundle.getString("CTL_Save");
            String string3 = resourceBundle.getString("CTL_Discard");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor(string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{string2, string3, NotifyDescriptor.CANCEL_OPTION}, string2);
            Object object = TopManager.getDefault().notify(notifyDescriptor);
            if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
                return false;
            }
            if (string2.equals(object)) {
                try {
                    this.saveDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(iOException);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isDocumentLoaded() {
        return this.loadTask != null;
    }

    public void setMIMEType(String string) {
        this.mimeType = string;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet(8);
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), n, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedo.Manager();
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(outputStream, (Document)styledDocument, 0, styledDocument.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected Task reloadDocument() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.doc != null) {
                int[] nArray;
                this.doc.removeUndoableEditListener(this.getUndoRedo());
                final JEditorPane[] jEditorPaneArray = this.getOpenedPanes();
                if (jEditorPaneArray != null) {
                    nArray = new int[jEditorPaneArray.length];
                    int n = 0;
                    while (n < jEditorPaneArray.length) {
                        nArray[n] = jEditorPaneArray[n].getCaretPosition();
                        ++n;
                    }
                } else {
                    nArray = new int[]{};
                }
                this.prepareTask = null;
                final Task task = this.prepareDocument(true);
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (4.access$500(this.this$1) != null) {
                                    int n = 0;
                                    while (n < 4.access$500(this.this$1).length) {
                                        try {
                                            4.access$500(this.this$1)[n].setCaretPosition(4.access$600(this.this$1)[n]);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        ++n;
                                    }
                                }
                                4.access$700(this.this$1).getUndoRedo().discardAllEdits();
                                4.access$700(this.this$1).getUndoRedo().undoableEditHappened(new UndoableEditEvent(4.access$700(this.this$1), 4.access$700(this.this$1).new BeforeSaveEdit(CloneableEditorSupport.access$800(4.access$700(this.this$1)))));
                                4.access$700(this.this$1).notifyUnmodified();
                                4.access$700(this.this$1).updateLineSet(true);
                            }
                        });
                        task.removeTaskListener(this);
                    }

                    static /* synthetic */ JEditorPane[] access$500(4 var0) {
                        return var0.jEditorPaneArray;
                    }

                    static /* synthetic */ int[] access$600(4 var0) {
                        return var0.nArray;
                    }

                    static /* synthetic */ CloneableEditorSupport access$700(4 var0) {
                        return var0.CloneableEditorSupport.this;
                    }
                });
                Task task2 = task;
                return task2;
            }
        }
        return this.prepareDocument();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = JEditorPane.createEditorKitForContentType(this.mimeType);
        } else {
            String string = this.env().getMimeType();
            this.kit = JEditorPane.createEditorKitForContentType(string);
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = JEditorPane.createEditorKitForContentType("text/plain");
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = new PlainEditorKit();
        }
        return this.kit;
    }

    private boolean isDumbKit(EditorKit editorKit) {
        if (editorKit == null) {
            return true;
        }
        String string = editorKit.getClass().getName();
        return string.equals("javax.swing.text.DefaultEditorKit") || string.equals("javax.swing.JEditorPane$PlainEditorKit") || string.equals("javax.swing.text.html.HTMLEditorKit");
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = CloneableEditorSupport.createNetBeansDocument(editorKit.createDefaultDocument());
        styledDocument.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.env().getMimeType());
        return styledDocument;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        this.updateTitles();
    }

    protected boolean notifyModified() {
        boolean bl = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException userQuestionException) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(userQuestionException.getLocalizedMessage());
                            Object object = TopManager.getDefault().notify(confirmation);
                            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                                try {
                                    userQuestionException.confirmed();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(iOException);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            bl = false;
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != iOException.getLocalizedMessage()) {
                TopManager.getDefault().setStatusText(iOException.getLocalizedMessage());
            }
            bl = false;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    if (CloneableEditorSupport.this.doc != null) {
                        CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                    }
                    try {
                        block5: {
                            try {
                                if (!manager.canUndo()) break block5;
                                manager.undo();
                            }
                            catch (CannotUndoException cannotUndoException) {
                                Object var4_3 = null;
                                if (CloneableEditorSupport.this.doc == null) return;
                                CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                                return;
                            }
                        }
                        Object var4_2 = null;
                        if (CloneableEditorSupport.this.doc == null) return;
                        CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (CloneableEditorSupport.this.doc == null) throw throwable;
                        CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                        throw throwable;
                    }
                }
            });
            return false;
        }
        this.updateTitles();
        return true;
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    final StyledDocument getDocumentHack() {
        return this.doc;
    }

    DataObject getDataObjectHack() {
        return null;
    }

    Line.Set updateLineSet(boolean bl) {
        Object object = this.LOCK_LINE_SET;
        synchronized (object) {
            Object object2;
            if (this.lineSet != null && !bl) {
                Line.Set set = this.lineSet;
                return set;
            }
            Line.Set set = this.lineSet;
            this.lineSet = this.doc == null ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.doc);
            if (set != null) {
                object2 = set.lines;
                synchronized (object2) {
                    this.lineSet.lines.putAll(set.lines);
                }
            }
            object2 = this.lineSet;
            return object2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDocument(EditorKit editorKit, StyledDocument styledDocument) throws IOException {
        Throwable throwable = null;
        try {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.env().inputStream());
                try {
                    this.loadFromStreamToKit(styledDocument, bufferedInputStream, editorKit);
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    ((InputStream)bufferedInputStream).close();
                    throw throwable2;
                }
                ((InputStream)bufferedInputStream).close();
                styledDocument.addUndoableEditListener(this.getUndoRedo());
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                throw iOException;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Object var8_13 = null;
                if (exception2 == null) return;
                ErrorManager errorManager2 = ErrorManager.getDefault();
                errorManager2.annotate((Throwable)exception2, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
                errorManager2.notify(exception2);
                return;
            }
            Object var8_12 = null;
            if (throwable == null) return;
        }
        catch (Throwable throwable3) {
            Object var8_14 = null;
            if (throwable == null) throw throwable3;
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate(throwable, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
            errorManager.notify(throwable);
            throw throwable3;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate(throwable, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
        errorManager.notify(throwable);
    }

    protected boolean close(boolean bl) {
        if (!super.close(bl)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    private void closeDocument() {
        while (true) {
            Task task;
            Object object = this.getLock();
            synchronized (object) {
                if (this.doc == null) {
                    return;
                }
                if (this.loadTask == null) {
                    return;
                }
                task = this.prepareTask;
                if (task == null) {
                    return;
                }
                if (task.isFinished()) {
                    this.doCloseDocument();
                    return;
                }
            }
            task.waitFinished();
        }
    }

    private void doCloseDocument() {
        this.loadTask = null;
        this.prepareTask = null;
        this.env().removePropertyChangeListener(this.getListener());
        this.notifyUnmodified();
        if (this.doc != null) {
            this.getUndoRedo().discardAllEdits();
            this.doc.removeUndoableEditListener(this.getUndoRedo());
            this.doc.removeDocumentListener(this.getListener());
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
            this.fireStateChangeEvent(this.doc, true);
        }
        this.doc = null;
        this.kit = null;
        this.updateLineSet(true);
    }

    private void checkReload(boolean bl) {
        StyledDocument styledDocument = this.doc;
        if (styledDocument == null) {
            return;
        }
        if (!bl && !this.reloadDialogOpened) {
            String string = NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "FMT_External_change", styledDocument.getProperty("title"));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
            this.reloadDialogOpened = true;
            try {
                Object object = TopManager.getDefault().notify(confirmation);
                if (NotifyDescriptor.YES_OPTION.equals(object)) {
                    bl = true;
                }
                Object var7_6 = null;
                this.reloadDialogOpened = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.reloadDialogOpened = false;
                throw throwable;
            }
        }
        if (bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CloneableEditorSupport.this.reloadDocument();
                }
            });
        }
    }

    private static StyledDocument createNetBeansDocument(Document document) {
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    private final void fireStateChangeEvent(StyledDocument styledDocument, boolean bl) {
        if (this.listeners != null) {
            HashSet hashSet;
            EnhancedChangeEvent enhancedChangeEvent = new EnhancedChangeEvent(this, styledDocument, bl);
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                hashSet = (HashSet)this.listeners.clone();
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ChangeListener changeListener = (ChangeListener)iterator.next();
                changeListener.stateChanged(enhancedChangeEvent);
            }
        }
    }

    protected void updateTitles() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof CloneableEditor)) continue;
            CloneableEditor cloneableEditor = (CloneableEditor)e;
            cloneableEditor.updateName();
        }
    }

    private CloneableEditor openEditorComponent() {
        Object object = this.getLock();
        synchronized (object) {
            CloneableEditor cloneableEditor = this.getAnyEditor();
            if (cloneableEditor != null) {
                cloneableEditor.open();
                CloneableEditor cloneableEditor2 = cloneableEditor;
                return cloneableEditor2;
            }
            String string = this.messageOpening();
            if (string != null) {
                TopManager.getDefault().setStatusText(string);
            }
            this.prepareDocument();
            cloneableEditor = this.createCloneableEditor();
            this.initializeCloneableEditor(cloneableEditor);
            cloneableEditor.setReference(this.allEditors);
            cloneableEditor.open();
            string = this.messageOpened();
            if (string == null) {
                string = "";
            }
            TopManager.getDefault().setStatusText(string);
            CloneableEditor cloneableEditor3 = cloneableEditor;
            return cloneableEditor3;
        }
    }

    CloneableEditor getAnyEditor() {
        CloneableTopComponent cloneableTopComponent;
        try {
            cloneableTopComponent = this.allEditors.getAnyComponent();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        if (cloneableTopComponent instanceof CloneableEditor) {
            return (CloneableEditor)cloneableTopComponent;
        }
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof CloneableEditor)) continue;
            return (CloneableEditor)e;
        }
        return null;
    }

    final CloneableEditor openAt(PositionRef positionRef, int n) {
        CloneableEditor cloneableEditor = this.openEditorComponent();
        Task task = this.prepareDocument();
        cloneableEditor.open();
        cloneableEditor.requestVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private final /* synthetic */ CloneableEditor val$e;
            private final /* synthetic */ int val$column;
            private final /* synthetic */ PositionRef val$pos;
            private final /* synthetic */ CloneableEditorSupport this$0;

            Selector(CloneableEditorSupport cloneableEditorSupport, CloneableEditor cloneableEditor, int n, PositionRef positionRef) {
                this.this$0 = cloneableEditorSupport;
                this.val$e = cloneableEditor;
                this.val$column = n;
                this.val$pos = positionRef;
            }

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(this);
                task.removeTaskListener(this);
            }

            public void run() {
                int n;
                JEditorPane jEditorPane = this.val$e.pane;
                if (jEditorPane == null) {
                    return;
                }
                Caret caret = jEditorPane.getCaret();
                if (caret == null) {
                    return;
                }
                if (this.val$column >= 0) {
                    Element element = NbDocument.findLineRootElement(this.this$0.getDocument());
                    n = (element = element.getElement(element.getElementIndex(this.val$pos.getOffset()))).getStartOffset() + this.val$column;
                    if (n > element.getEndOffset()) {
                        n = element.getEndOffset();
                    }
                } else {
                    n = this.val$pos.getOffset();
                }
                caret.setDot(n);
            }
        }
        task.addTaskListener(new Selector(this, cloneableEditor, n, positionRef));
        return cloneableEditor;
    }

    Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$1100(CloneableEditorSupport cloneableEditorSupport, boolean bl) {
        cloneableEditorSupport.checkReload(bl);
    }

    private class BeforeModificationEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeModificationEdit(long l, UndoableEdit undoableEdit) {
            this.saveTime = l;
            this.delegate = undoableEdit;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }

        public void undo() {
            super.undo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.notifyUnmodified();
            }
        }
    }

    private class BeforeSaveEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeSaveEdit(long l) {
            this.saveTime = l;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (!(undoableEdit instanceof BeforeModificationEdit)) {
                CloneableEditorSupport.this.getUndoRedo().addEdit(new BeforeModificationEdit(this.saveTime, undoableEdit));
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.notifyUnmodified();
            }
        }

        public boolean isSignificant() {
            return this.delegate != null;
        }
    }

    private class FilterUndoableEdit
    implements UndoableEdit {
        protected UndoableEdit delegate;

        FilterUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            }
        }

        public boolean canUndo() {
            if (this.delegate != null) {
                return this.delegate.canUndo();
            }
            return false;
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            }
        }

        public boolean canRedo() {
            if (this.delegate != null) {
                return this.delegate.canRedo();
            }
            return false;
        }

        public void die() {
            if (this.delegate != null) {
                this.delegate.die();
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.addEdit(undoableEdit);
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.replaceEdit(undoableEdit);
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return this.delegate.isSignificant();
            }
            return true;
        }

        public String getPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getPresentationName();
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getUndoPresentationName();
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getRedoPresentationName();
            }
            return "";
        }
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }

    private final class Listener
    implements DocumentListener,
    PropertyChangeListener,
    Runnable {
        private IOException loadExc;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException iOException = this.loadExc;
            this.loadExc = null;
            return iOException;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.notifyModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.notifyModified();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("time".equals(propertyChangeEvent.getPropertyName())) {
                Date date = (Date)propertyChangeEvent.getNewValue();
                if (CloneableEditorSupport.this.lastSaveTime != -1L && (date == null || date.getTime() > CloneableEditorSupport.this.lastSaveTime)) {
                    SwingUtilities.invokeLater(new Runnable(this, date){
                        private final /* synthetic */ Date val$time;
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = listener;
                            this.val$time = date;
                        }

                        public void run() {
                            CloneableEditorSupport.access$1100(Listener.access$1000(this.this$1), this.val$time == null || !Listener.access$1000(this.this$1).isModified());
                        }
                    });
                }
            }
        }

        public void run() {
            Object object = CloneableEditorSupport.this.getLock();
            synchronized (object) {
                CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                try {
                    try {
                        this.loadExc = null;
                        LOCAL_LOAD_TASK.set(Boolean.TRUE);
                        CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.doc);
                    }
                    catch (IOException iOException) {
                        this.loadExc = iOException;
                        Object var4_3 = null;
                        LOCAL_LOAD_TASK.set(null);
                    }
                    Object var4_2 = null;
                    LOCAL_LOAD_TASK.set(null);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    LOCAL_LOAD_TASK.set(null);
                    throw throwable;
                }
                CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
                CloneableEditorSupport.this.updateLineSet(true);
                CloneableEditorSupport.this.lastSaveTime = System.currentTimeMillis();
                CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
            }
        }

        static /* synthetic */ CloneableEditorSupport access$1000(Listener listener) {
            return listener.CloneableEditorSupport.this;
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        public void install(JEditorPane jEditorPane) {
            super.install(jEditorPane);
            jEditorPane.setFont(new Font("Monospaced", 0, 12));
        }
    }
}

