/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.DocumentLine;
import org.openide.util.NbBundle;

public abstract class Line
extends Annotatable
implements Serializable {
    static final long serialVersionUID = 9113186289600795476L;
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private DataObject dataObject;
    public static final int SHOW_TRY_SHOW = 0;
    public static final int SHOW_SHOW = 1;
    public static final int SHOW_GOTO = 2;
    private static final Part nullPart = new NullPart();
    static /* synthetic */ Class class$org$openide$text$Line;

    public Line(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public String getDisplayName() {
        if (this.getDataObject() == null) {
            return this.getClass().getName() + ":" + this.getLineNumber();
        }
        return NbBundle.getMessage(class$org$openide$text$Line == null ? (class$org$openide$text$Line = Line.class$("org.openide.text.Line")) : class$org$openide$text$Line, "FMT_LineDisplayName", this.getDataObject().getName(), this.getDataObject().getPrimaryFile().getPackageNameExt('/', '.'), new Integer(this.getLineNumber() + 1));
    }

    public final DataObject getDataObject() {
        return this.dataObject;
    }

    public abstract int getLineNumber();

    public abstract void show(int var1, int var2);

    public void show(int n) {
        this.show(n, 0);
    }

    public abstract void setBreakpoint(boolean var1);

    public abstract boolean isBreakpoint();

    public abstract void markError();

    public abstract void unmarkError();

    public abstract void markCurrentLine();

    public abstract void unmarkCurrentLine();

    public boolean canBeMarkedCurrent(int n, Line line) {
        return true;
    }

    public Part createPart(int n, int n2) {
        return nullPart;
    }

    public String getText() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class Set {
        private Date date;
        final Map lines = new WeakHashMap(10);

        public Set() {
            this.date = new Date();
        }

        public abstract List getLines();

        public final Date getDate() {
            return this.date;
        }

        public abstract Line getOriginal(int var1) throws IndexOutOfBoundsException;

        public abstract Line getCurrent(int var1) throws IndexOutOfBoundsException;

        Line registerLine(Line line) {
            Map map = this.lines;
            synchronized (map) {
                Line line2;
                Reference reference = (Reference)this.lines.get(line);
                Line line3 = line2 = reference != null ? (Line)reference.get() : null;
                if (line2 == null) {
                    if (line instanceof DocumentLine) {
                        ((DocumentLine)line).init();
                    }
                    this.lines.put(line, new WeakReference<Line>(line));
                    line2 = line;
                }
                Line line4 = line2;
                return line4;
            }
        }
    }

    private static final class NullPart
    extends Part {
        NullPart() {
        }

        public int getColumn() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public Line getLine() {
            return null;
        }

        public String getText() {
            return null;
        }
    }

    public static abstract class Part
    extends Annotatable {
        public static final String PROP_LINE = "line";
        public static final String PROP_COLUMN = "column";
        public static final String PROP_LENGTH = "length";

        public abstract int getColumn();

        public abstract int getLength();

        public abstract Line getLine();
    }
}

