/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

final class MetaInfServicesLookup
extends AbstractLookup {
    private static final Map knownInstances = new WeakHashMap();
    private final Set classes = new WeakSet();
    private final ClassLoader loader;
    static /* synthetic */ Class class$org$openide$util$MetaInfServicesLookup;

    public MetaInfServicesLookup() {
        this((class$org$openide$util$MetaInfServicesLookup == null ? (class$org$openide$util$MetaInfServicesLookup = MetaInfServicesLookup.class$("org.openide.util.MetaInfServicesLookup")) : class$org$openide$util$MetaInfServicesLookup).getClassLoader());
    }

    public MetaInfServicesLookup(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    protected final synchronized void beforeLookup(Lookup.Template template) {
        Class clazz = template.getType();
        if (this.classes.add(clazz)) {
            ArrayList arrayList = new ArrayList();
            this.search(clazz, arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AbstractLookup.Pair pair = (AbstractLookup.Pair)iterator.next();
                this.addPair(pair);
            }
        }
    }

    private void search(Class clazz, Collection collection) {
        Enumeration<URL> enumeration;
        String string = "META-INF/services/" + clazz.getName();
        try {
            enumeration = this.loader.getResources(string);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(iOException);
            return;
        }
        HashSet hashSet = new HashSet();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            if (!bl) {
                bl = true;
                serializable = null;
                try {
                    serializable = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (serializable != clazz) {
                    return;
                }
            }
            serializable = enumeration.nextElement();
            try {
                Object var13_16;
                InputStream inputStream = serializable.openStream();
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                        Class<?> clazz2 = Class.forName(string2, false, this.loader);
                        if (!clazz.isAssignableFrom(clazz2)) {
                            throw new ClassNotFoundException(clazz2.getName() + " not a subclass of " + clazz.getName());
                        }
                        if (!hashSet.add(clazz2)) continue;
                        collection.add(new P(clazz2));
                    }
                    var13_16 = null;
                }
                catch (Throwable throwable) {
                    var13_16 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(classNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class P
    extends AbstractLookup.Pair {
        private Object object;
        static /* synthetic */ Class class$java$lang$Object;

        public P(Class clazz) {
            this.object = clazz;
        }

        private Class clazz() {
            Object object = this.object;
            if (object instanceof Class) {
                return (Class)object;
            }
            if (object != null) {
                return object.getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = P.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean equals(Object object) {
            if (object instanceof P) {
                return ((P)object).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        protected boolean instanceOf(Class clazz) {
            return clazz.isAssignableFrom(this.clazz());
        }

        public Class getType() {
            return this.clazz();
        }

        public Object getInstance() {
            Map map = knownInstances;
            synchronized (map) {
                Object object;
                if (this.object instanceof Class) {
                    try {
                        object = (Class)this.object;
                        this.object = knownInstances.get(object);
                        if (this.object == null) {
                            this.object = ((Class)object).newInstance();
                            knownInstances.put(object, this.object);
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(exception);
                        this.object = null;
                    }
                }
                object = this.object;
                return object;
            }
        }

        public String getDisplayName() {
            return this.clazz().getName();
        }

        public String getId() {
            return this.clazz().getName();
        }

        protected boolean creatorOf(Object object) {
            return object == this.object;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

