/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public abstract class CloneableTopComponent
extends TopComponent
implements Externalizable,
TopComponent.Cloneable {
    static final long serialVersionUID = 4893753008783256289L;
    private Ref ref;
    public static final Ref EMPTY = new Ref();
    static /* synthetic */ Class class$org$openide$windows$CloneableTopComponent;

    public CloneableTopComponent() {
    }

    public CloneableTopComponent(DataObject dataObject) {
        super(dataObject);
    }

    public final Object clone() {
        return this.cloneComponent();
    }

    public final CloneableTopComponent cloneTopComponent() {
        CloneableTopComponent cloneableTopComponent = this.createClonedObject();
        cloneableTopComponent.setReference(this.getReference());
        return cloneableTopComponent;
    }

    public final TopComponent cloneComponent() {
        return this.cloneTopComponent();
    }

    protected CloneableTopComponent createClonedObject() {
        try {
            NbMarshalledObject nbMarshalledObject = new NbMarshalledObject(this);
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)nbMarshalledObject.get();
            return cloneableTopComponent;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InternalError();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new InternalError();
        }
    }

    public final synchronized Ref getReference() {
        if (this.ref == null) {
            this.ref = new Ref(this);
        }
        return this.ref;
    }

    public final synchronized void setReference(Ref ref) {
        if (ref == EMPTY) {
            throw new IllegalArgumentException(NbBundle.getBundle(class$org$openide$windows$CloneableTopComponent == null ? (class$org$openide$windows$CloneableTopComponent = CloneableTopComponent.class$("org.openide.windows.CloneableTopComponent")) : class$org$openide$windows$CloneableTopComponent).getString("EXC_CannotAssign"));
        }
        if (this.ref != null) {
            Ref ref2 = this.ref;
            synchronized (ref2) {
                this.ref.getTable().remove(this);
            }
        }
        ref.register(this);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        if (bl) {
            return this.getReference().unregister(this);
        }
        return true;
    }

    protected boolean closeLast() {
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Ref ref;
        super.readExternal(objectInput);
        if (this.serialVersion != 0 && (ref = (Ref)objectInput.readObject()) != null) {
            this.setReference(ref);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.ref);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Ref
    implements Serializable {
        static final long serialVersionUID = 5543148876020730556L;
        private static final Object LOCK = new Object();
        private transient HashSet table;

        protected Ref() {
        }

        Ref(CloneableTopComponent cloneableTopComponent) {
            this.getTable().add(cloneableTopComponent);
        }

        private HashSet getTable() {
            if (this.table == null) {
                this.table = new HashSet(7);
            }
            return this.table;
        }

        Set componentSet() {
            Object object = LOCK;
            synchronized (object) {
                Set set = (Set)this.getTable().clone();
                return set;
            }
        }

        public Enumeration getComponents() {
            return Collections.enumeration(this.componentSet());
        }

        public boolean isEmpty() {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = this.getTable().isEmpty();
                return bl;
            }
        }

        public CloneableTopComponent getAnyComponent() {
            Object object = LOCK;
            synchronized (object) {
                CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)this.getTable().iterator().next();
                return cloneableTopComponent;
            }
        }

        final void register(CloneableTopComponent cloneableTopComponent) {
            Object object = LOCK;
            synchronized (object) {
                this.getTable().add(cloneableTopComponent);
                cloneableTopComponent.ref = this;
            }
        }

        final boolean unregister(CloneableTopComponent cloneableTopComponent) {
            HashSet hashSet = this.getTable();
            if (hashSet.size() > 1 || cloneableTopComponent.closeLast()) {
                Object object = LOCK;
                synchronized (object) {
                    hashSet.remove(cloneableTopComponent);
                }
                return true;
            }
            return false;
        }
    }
}

