/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.xml.XMLUtilImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        return XMLUtil.createXMLReader(bl, false);
    }

    public static XMLReader createXMLReader(boolean bl, boolean bl2) throws SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        sAXParserFactory.setNamespaceAware(bl2);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws DOMException {
        DOMImplementation dOMImplementation = XMLUtil.getDOMImplementation();
        if (string3 != null && string4 == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType documentType = null;
        if (string4 != null) {
            documentType = dOMImplementation.createDocumentType(string, string3, string4);
        }
        return dOMImplementation.createDocument(string2, string, documentType);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
    }

    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setNamespaceAware(bl2);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(inputSource);
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        XMLUtilImpl.write(document, outputStream, string);
    }

    public static String toAttributeValue(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('<' == c) {
                stringBuffer.append("&lt;");
            } else if ('&' == c) {
                stringBuffer.append("&amp;");
            } else if ('\'' == c) {
                stringBuffer.append("&apos;");
            } else if ('\"' == c) {
                stringBuffer.append("&quot;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toElementContent(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('<' == c) {
                stringBuffer.append("&lt;");
            } else if ('&' == c) {
                stringBuffer.append("&amp;");
            } else if ('>' == c && n > 1 && string.charAt(n - 2) == ']' && string.charAt(n - 1) == ']') {
                stringBuffer.append("&gt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n + n3];
            stringBuffer.append(DEC2HEX[(by & 0xF0) >> 4]);
            stringBuffer.append(DEC2HEX[by & 0xF]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHex(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException("null");
        }
        int n3 = cArray.length;
        if (n3 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] byArray = new byte[n3 / 2];
        while (n3 > 0) {
            String string = new String(cArray, n3 - 2, 2);
            try {
                byArray[n3 / 2 - 1] = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            n3 -= 2;
        }
        return byArray;
    }

    private static boolean checkAttributeCharacters(String string) throws CharConversionException {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c <= ']') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': {
                        bl = true;
                        break;
                    }
                    default: {
                        if (c >= ' ') break;
                        throw new CharConversionException("Invalid XML character &#" + c + ";.");
                    }
                }
            }
            ++n;
        }
        return !bl;
    }

    private static boolean checkContentCharacters(String string) throws CharConversionException {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c <= ']') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '>': {
                        if (bl) break;
                        bl = n > 0 && string.charAt(n - 1) == ']';
                        break;
                    }
                    case '&': 
                    case '<': {
                        bl = true;
                        break;
                    }
                    default: {
                        if (c >= ' ') break;
                        throw new CharConversionException("Invalid XML character &#" + c + ";.");
                    }
                }
            }
            ++n;
        }
        return !bl;
    }
}

