/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.editors.DataObjectEditor;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final int DEFAULT_INSET = 10;
    private ExplorerPanel expPanel;
    private TreeView reposTree;
    private DataFilter folderFilter;
    private DataFilter dataFilter;
    private NodeAcceptor nodeFilter;
    private Insets insets;
    private String subTitle;
    private DataObject rootObject;
    private Node rootNode;
    private DataObject dObj;
    private DataObjectEditor myEditor;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$DataObjectPanel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public DataObjectPanel(DataObjectEditor dataObjectEditor) {
        this.myEditor = dataObjectEditor;
        this.initComponent();
        this.reposTree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$DataObjectPanel == null ? (class$org$netbeans$beaninfo$editors$DataObjectPanel = DataObjectPanel.class$("org.netbeans.beaninfo.editors.DataObjectPanel")) : class$org$netbeans$beaninfo$editors$DataObjectPanel)).getString("ACSN_DataObjectPanel"));
        this.setDescription(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$DataObjectPanel == null ? (class$org$netbeans$beaninfo$editors$DataObjectPanel = DataObjectPanel.class$("org.netbeans.beaninfo.editors.DataObjectPanel")) : class$org$netbeans$beaninfo$editors$DataObjectPanel)).getString("ACSD_DataObjectPanel"));
    }

    public void addNotify() {
        this.completeInitialization();
        super.addNotify();
    }

    private void initComponent() {
        this.expPanel = new ExplorerPanel();
        this.expPanel.setLayout(new BorderLayout());
        this.reposTree = new SingleSelectionBeanTreeView();
        this.reposTree.setPopupAllowed(false);
        this.reposTree.setDefaultActionAllowed(false);
        this.expPanel.add((Component)this.reposTree, "Center");
    }

    private void completeInitialization() {
        Node node;
        Object object;
        if (this.insets != null) {
            this.setBorder(new EmptyBorder(this.insets));
        } else {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        this.setLayout(new BorderLayout(0, 2));
        if (this.subTitle != null) {
            object = new JLabel(this.subTitle);
            ((JLabel)object).setLabelFor((Component)this.reposTree);
            this.add((Component)object, "North");
        }
        if (this.rootNode == null) {
            if (this.dataFilter != null) {
                if (this.folderFilter != null) {
                    object = new DataFilter(){

                        public boolean acceptDataObject(DataObject dataObject) {
                            if (DataObjectPanel.this.folderFilter.acceptDataObject(dataObject)) {
                                return true;
                            }
                            return DataObjectPanel.this.dataFilter.acceptDataObject(dataObject);
                        }
                    };
                    this.rootNode = TopManager.getDefault().getPlaces().nodes().repository((DataFilter)object);
                } else {
                    this.rootNode = TopManager.getDefault().getPlaces().nodes().repository(this.dataFilter);
                }
            } else {
                this.rootNode = this.folderFilter != null ? TopManager.getDefault().getPlaces().nodes().repository(this.folderFilter) : TopManager.getDefault().getPlaces().nodes().repository();
            }
        }
        if (this.nodeFilter != null) {
            object = new FilteredChildren(this.rootNode, this.nodeFilter, this.dataFilter);
            this.rootNode = node = new FilterNode(this.rootNode, (Children)object);
        }
        object = this.rootNode;
        if (this.rootObject != null && (node = this.findNodeForObj(this.rootNode, this.rootObject)) != null) {
            NodeAcceptor nodeAcceptor = this.nodeFilter;
            if (nodeAcceptor == null) {
                nodeAcceptor = new NodeAcceptor(){

                    public boolean acceptNodes(Node[] nodeArray) {
                        return false;
                    }
                };
            }
            FilteredChildren filteredChildren = new FilteredChildren(node, nodeAcceptor, this.dataFilter);
            FilterNode filterNode = new FilterNode(node, (Children)filteredChildren);
            object = filterNode;
        }
        this.expPanel.getExplorerManager().setRootContext((Node)object);
        node = null;
        if (this.dObj != null) {
            node = this.findNodeForObj((Node)object, this.dObj);
        }
        if (node != null) {
            try {
                this.expPanel.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
            }
        }
        this.expPanel.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    if (nodeArray != null && nodeArray.length > 0 && DataObjectPanel.this.dataFilter != null && DataObjectPanel.this.getDataObject() != null) {
                        DataObjectPanel.this.myEditor.setOkButtonEnabled(DataObjectPanel.this.dataFilter.acceptDataObject(DataObjectPanel.this.getDataObject()));
                    } else {
                        DataObjectPanel.this.myEditor.setOkButtonEnabled(DataObjectPanel.this.getDataObject() != null);
                    }
                }
            }
        });
        this.add((Component)this.expPanel, "Center");
        if (this.dataFilter != null && this.getDataObject() != null) {
            this.myEditor.setOkButtonEnabled(this.dataFilter.acceptDataObject(this.getDataObject()));
        } else {
            this.myEditor.setOkButtonEnabled(this.getDataObject() != null);
        }
    }

    public void setDataFilter(DataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public void setNodeFilter(NodeAcceptor nodeAcceptor) {
        this.nodeFilter = nodeAcceptor;
    }

    public void setInsetValue(int n) {
        this.insets = new Insets(n, n, n, n);
    }

    public void setText(String string) {
        this.subTitle = string;
    }

    public void setRootObject(DataObject dataObject) {
        this.rootObject = dataObject;
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    public void setFolderFilter(DataFilter dataFilter) {
        this.folderFilter = dataFilter;
    }

    public DataFilter getFolderFilter() {
        return this.folderFilter;
    }

    public void setDataObject(DataObject dataObject) {
        this.dObj = dataObject;
    }

    public void setDescription(String string) {
        this.getAccessibleContext().setAccessibleDescription(string);
        this.reposTree.getAccessibleContext().setAccessibleDescription(string);
    }

    private Node findNode(Node node, DataObject dataObject) {
        Node[] nodeArray;
        Children children = node.getChildren();
        Node node2 = children.findChild(dataObject.getName());
        if (node2 == null && (nodeArray = children.getNodes()) != null && nodeArray.length > 0) {
            int n = 0;
            while (n < nodeArray.length && node2 == null) {
                DataObject dataObject2 = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? DataObjectPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject2 != null && dataObject2 == dataObject) {
                    node2 = nodeArray[n];
                }
                ++n;
            }
        }
        return node2;
    }

    private Node findNodeForObj(Node node, DataObject dataObject) {
        Node node2;
        Node node3 = null;
        DataFolder dataFolder = dataObject.getFolder();
        Vector<DataFolder> vector = new Vector<DataFolder>();
        while (dataFolder != null) {
            vector.addElement(dataFolder);
            dataFolder = dataFolder.getFolder();
        }
        node3 = !vector.isEmpty() ? ((node2 = this.findParentNode(vector, node.getChildren())) != null ? this.findNode(node2, dataObject) : this.findNode(node, dataObject)) : this.findNode(node, dataObject);
        return node3;
    }

    private Node findParentNode(Vector vector, Children children) {
        DataFolder dataFolder = (DataFolder)vector.lastElement();
        Node node = children.findChild(dataFolder.getNodeDelegate().getName());
        if (node == null) {
            Node[] nodeArray = children.getNodes();
            int n = 0;
            while (n < nodeArray.length && node == null) {
                DataFolder dataFolder2 = (DataFolder)nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? DataObjectPanel.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                if (dataFolder2 != null && dataFolder2 == dataFolder) {
                    node = nodeArray[n];
                }
                ++n;
            }
        }
        if (vector.size() > 1) {
            vector.removeElement(dataFolder);
            if (node != null) {
                return this.findParentNode(vector, node.getChildren());
            }
            return this.findParentNode(vector, children);
        }
        return node;
    }

    public DataObject getDataObject() {
        DataObject dataObject = null;
        Node[] nodeArray = this.expPanel.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        return dataObject;
    }

    public Node getNode() {
        Node node = null;
        Node[] nodeArray = this.expPanel.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            node = nodeArray[0];
        }
        return node;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getDataObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FilteredChildren
    extends FilterNode.Children {
        private NodeAcceptor nodeAcceptor;
        private DataFilter dFilter;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        FilteredChildren(Node node, NodeAcceptor nodeAcceptor, DataFilter dataFilter) {
            super(node);
            this.nodeAcceptor = nodeAcceptor;
            this.dFilter = dataFilter;
        }

        private Node[] makeFilterNode(Node node) {
            FilteredChildren filteredChildren = new FilteredChildren(node, this.nodeAcceptor, this.dFilter);
            return new Node[]{new FilterNode(node, (Children)filteredChildren)};
        }

        protected Node[] createNodes(Object object) {
            if (object != null && object instanceof Node) {
                DataObject dataObject;
                Node[] nodeArray = new Node[]{(Node)object};
                if (this.dFilter != null && (dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FilteredChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && this.dFilter.acceptDataObject(dataObject)) {
                    return this.makeFilterNode(nodeArray[0]);
                }
                if (this.nodeAcceptor.acceptNodes(nodeArray)) {
                    return this.makeFilterNode(nodeArray[0]);
                }
            }
            return new Node[0];
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class SingleSelectionBeanTreeView
    extends BeanTreeView {
        public SingleSelectionBeanTreeView() {
            ((TreeView)this).tree.getSelectionModel().setSelectionMode(1);
        }
    }
}

