/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.JarAndZipFilter;
import org.netbeans.beaninfo.editors.FileEditor;
import org.netbeans.core.ExJarFileSystem;
import org.netbeans.core.ExLocalFileSystem;
import org.netbeans.core.ModuleFSSection;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.NewType;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemPanel
extends TopComponent
implements EnhancedCustomPropertyEditor {
    private NewType[] newTypes;
    private String[] newTypeNames;
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private FileSystem originalFS;
    private LocalFileSystem localFS;
    private JarFileSystem jarFS;
    private FileSystem otherFS;
    private FileSystem fs;
    private Node activeNode;
    private Node originalNode;
    private Node localFSNode;
    private Node jarFSNode;
    private Node otherNode;
    private Node emptyNode;
    private ButtonGroup group;
    private JRadioButton originalRadioButton;
    private JRadioButton dirRadioButton;
    private JLabel dirLabel;
    private JTextField dirTextField;
    private JButton browseDirButton;
    private JRadioButton jarRadioButton;
    private JLabel jarLabel;
    private JTextField jarTextField;
    private JButton browseJarButton;
    private JRadioButton otherRadioButton;
    private JLabel createLabel;
    private JComboBox typeComboBox;
    private PropertySheet propertySheet1;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle");
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FileSystemPanel;

    public FileSystemPanel() {
        this.initComponents();
        this.initialize();
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.originalRadioButton = new JRadioButton();
        this.dirRadioButton = new JRadioButton();
        this.dirLabel = new JLabel();
        this.dirTextField = new JTextField();
        this.browseDirButton = new JButton();
        this.jarRadioButton = new JRadioButton();
        this.jarLabel = new JLabel();
        this.jarTextField = new JTextField();
        this.browseJarButton = new JButton();
        this.otherRadioButton = new JRadioButton();
        this.createLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.propertySheet1 = new PropertySheet();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        ((JComponent)((Object)this)).setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.Border_Title")), new EmptyBorder(new Insets(8, 8, 8, 8))));
        this.originalRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.originalRadioButton.text"));
        this.originalRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileSystemPanel.this.originalRadioButtonItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add(this.originalRadioButton, gridBagConstraints);
        this.dirRadioButton.setSelected(true);
        this.dirRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.dirRadioButton.text"));
        this.dirRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileSystemPanel.this.dirRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add(this.dirRadioButton, gridBagConstraints);
        this.dirLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.dirLabel.text"));
        this.dirLabel.setLabelFor(this.dirTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        ((Container)((Object)this)).add(this.dirLabel, gridBagConstraints);
        this.dirTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FileSystemPanel.this.dirTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add(this.dirTextField, gridBagConstraints);
        this.browseDirButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browse"));
        this.browseDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSystemPanel.this.browseDirButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        ((Container)((Object)this)).add(this.browseDirButton, gridBagConstraints);
        this.jarRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.jarRadioButton.text"));
        this.jarRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileSystemPanel.this.jarRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add(this.jarRadioButton, gridBagConstraints);
        this.jarLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.jarLabel.text"));
        this.jarLabel.setLabelFor(this.jarTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        ((Container)((Object)this)).add(this.jarLabel, gridBagConstraints);
        this.jarTextField.setEnabled(false);
        this.jarTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FileSystemPanel.this.jarTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add(this.jarTextField, gridBagConstraints);
        this.browseJarButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browse"));
        this.browseJarButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browse"));
        this.browseJarButton.setEnabled(false);
        this.browseJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSystemPanel.this.browseJarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.anchor = 17;
        ((Container)((Object)this)).add(this.browseJarButton, gridBagConstraints);
        this.otherRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.otherRadioButton.text"));
        this.otherRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileSystemPanel.this.otherRadioButtonItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add(this.otherRadioButton, gridBagConstraints);
        this.createLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.createLabel.text"));
        this.createLabel.setLabelFor(this.typeComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        ((Container)((Object)this)).add(this.createLabel, gridBagConstraints);
        this.typeComboBox.setPreferredSize(new Dimension(200, 25));
        this.typeComboBox.setMinimumSize(new Dimension(200, 25));
        this.typeComboBox.setEnabled(false);
        this.typeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileSystemPanel.this.typeComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        ((Container)((Object)this)).add(this.typeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.propertySheet1, gridBagConstraints);
    }

    private void jarTextFieldFocusLost(FocusEvent focusEvent) {
        File file = new File(this.jarTextField.getText());
        if (file != null && !file.exists()) {
            if (this.jarFS != null) {
                this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
            } else {
                this.jarTextField.setText("");
            }
            return;
        }
        if (file != null && file.isFile()) {
            try {
                lastJarFolder = file.getParentFile();
                this.jarFS = new ExJarFileSystem();
                this.jarFS.setJarFile(file);
                this.createJarFSNode();
                this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
                this.jarTextField.setText(file.getAbsolutePath());
            }
            catch (IOException iOException) {
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (IntrospectionException introspectionException) {}
        } else if (this.jarFS != null) {
            this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
        } else {
            this.jarTextField.setText("");
        }
    }

    private void dirTextFieldFocusLost(FocusEvent focusEvent) {
        File file = new File(this.dirTextField.getText());
        if (file != null && !file.exists()) {
            if (this.localFS != null) {
                this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
            } else {
                this.dirTextField.setText("");
            }
            return;
        }
        if (file != null && file.isDirectory()) {
            this.localFS = new ExLocalFileSystem();
            try {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                lastDirFolder = file;
                this.localFS.setRootDirectory(file);
                this.createLocalFSNode();
                this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
                this.dirTextField.setText(file.getAbsolutePath());
            }
            catch (IOException iOException) {
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (IntrospectionException introspectionException) {}
        } else if (this.localFS != null) {
            this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
        } else {
            this.dirTextField.setText("");
        }
    }

    private void originalRadioButtonItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.originalRadioButton.isSelected();
        if (bl) {
            if (this.originalNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.originalNode, this.originalFS);
            }
        }
    }

    private void browseJarButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        jFileChooser.setDialogType(0);
        HelpCtx.setHelpIDString((JComponent)jFileChooser, (String)this.getHelpCtx().getHelpID());
        jFileChooser.setFileFilter(new JarAndZipFilter());
        if (lastJarFolder != null) {
            jFileChooser.setCurrentDirectory(lastJarFolder);
        }
        jFileChooser.setDialogTitle(FileSystemPanel.getString("CTL_FileSystemPanel.Jar_Dialog_Title"));
        while (Utilities.showJFileChooser((JFileChooser)jFileChooser, (Component)WindowManager.getDefault().getMainWindow(), (String)FileSystemPanel.getString("CTL_FileSystemPanel.Approve_Button_Title")) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file != null && file.isFile()) {
                try {
                    lastJarFolder = jFileChooser.getCurrentDirectory();
                    this.jarFS = new ExJarFileSystem();
                    this.jarFS.setJarFile(file);
                    this.createJarFSNode();
                    this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
                    this.jarTextField.setText(file.getAbsolutePath());
                    return;
                }
                catch (IOException iOException) {
                }
                catch (PropertyVetoException propertyVetoException) {
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FileSystemPanel.getString("MSG_WrongFileName")));
        }
    }

    private void browseDirButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        jFileChooser.setDialogType(0);
        HelpCtx.setHelpIDString((JComponent)jFileChooser, (String)this.getHelpCtx().getHelpID());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(FileSystemPanel.getString("CTL_FileSystemPanel.Local_Dialog_Title"));
        if (lastDirFolder != null) {
            jFileChooser.setCurrentDirectory(lastDirFolder);
        }
        while (Utilities.showJFileChooser((JFileChooser)jFileChooser, (Component)WindowManager.getDefault().getMainWindow(), (String)FileSystemPanel.getString("CTL_FileSystemPanel.Approve_Button_Title")) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file != null && file.isDirectory()) {
                this.localFS = new ExLocalFileSystem();
                try {
                    lastDirFolder = jFileChooser.getCurrentDirectory();
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ((ExLocalFileSystem)this.localFS).setRootDirectory(file);
                    this.createLocalFSNode();
                    this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
                    this.dirTextField.setText(file.getAbsolutePath());
                    return;
                }
                catch (IOException iOException) {
                }
                catch (PropertyVetoException propertyVetoException) {
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FileSystemPanel.getString("MSG_WrongFile")));
        }
    }

    private void jarRadioButtonItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.jarRadioButton.isSelected();
        this.browseJarButton.setEnabled(bl);
        this.jarTextField.setEnabled(bl);
        if (bl) {
            if (this.jarFSNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
            }
        }
    }

    private void dirRadioButtonItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.dirRadioButton.isSelected();
        this.browseDirButton.setEnabled(bl);
        this.dirTextField.setEnabled(bl);
        if (bl) {
            if (this.localFSNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
            }
        }
    }

    private void typeComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.otherNode = this.createOtherNode();
        if (this.otherNode != null) {
            this.setActiveFS(this.otherNode, this.otherFS);
        }
    }

    private void otherRadioButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.otherRadioButton.isSelected()) {
            this.typeComboBox.setEnabled(true);
            if (this.otherNode == null) {
                this.otherNode = this.createOtherNode();
            }
            if (this.otherNode != null) {
                this.setActiveFS(this.otherNode, this.otherFS);
            }
        } else {
            this.typeComboBox.setEnabled(false);
        }
    }

    private void selectExisting(ActionEvent actionEvent) {
    }

    private void setActiveFS(Node node, FileSystem fileSystem) {
        this.fs = fileSystem;
        this.activeNode = node;
        this.propertySheet1.setNodes(new Node[]{node});
    }

    private Node getEmptyNode() {
        if (this.emptyNode == null) {
            this.emptyNode = new AbstractNode(Children.LEAF);
        }
        return this.emptyNode;
    }

    private void initialize() {
        Node node = TopManager.getDefault().getPlaces().nodes().repository();
        this.newTypes = node.getNewTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.newTypes.length) {
            arrayList.add(this.newTypes[n].getName());
            ++n;
        }
        this.newTypeNames = arrayList.toArray(new String[arrayList.size()]);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(this.newTypeNames));
        this.dirRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.dirRadioButton.text_Mnemonic").charAt(0));
        this.jarRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.jarRadioButton.text_Mnemonic").charAt(0));
        this.otherRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.otherRadioButton.text_Mnemonic").charAt(0));
        this.dirLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.dirLabel.text_Mnemonic").charAt(0));
        this.jarLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.jarLabel.text_Mnemonic").charAt(0));
        this.createLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.createLabel.text_Mnemonic").charAt(0));
        this.browseDirButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browse1_Mnemonic").charAt(0));
        this.browseJarButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browse2_Mnemonic").charAt(0));
        this.group.add(this.originalRadioButton);
        this.group.add(this.dirRadioButton);
        this.group.add(this.jarRadioButton);
        this.group.add(this.otherRadioButton);
        if (this.typeComboBox.getItemCount() == 0) {
            this.otherRadioButton.setEnabled(false);
        }
        this.setOriginalValueVisibility();
    }

    private Node createOtherNode() {
        int n = this.typeComboBox.getSelectedIndex();
        if (n >= 0 && n < this.newTypes.length && this.newTypes[n] instanceof ModuleFSSection) {
            ModuleFSSection moduleFSSection = (ModuleFSSection)this.newTypes[n];
            try {
                this.otherFS = moduleFSSection.createFileSystem();
                return new BeanNode((Object)this.otherFS);
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify((Throwable)introspectionException);
            }
            catch (InstantiationException instantiationException) {
                ErrorManager.getDefault().notify((Throwable)instantiationException);
            }
        }
        return null;
    }

    private void createLocalFSNode() throws IntrospectionException, IntrospectionException {
        this.localFSNode = new BeanNode((Object)this.localFS);
        this.localFSNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileSystemPanel.this.setDirTextFieldText();
            }
        });
    }

    private void createJarFSNode() throws IntrospectionException, IntrospectionException {
        this.jarFSNode = new BeanNode((Object)this.jarFS);
        this.jarFSNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileSystemPanel.this.setJarTextFieldText();
            }
        });
    }

    public void setFileSystem(FileSystem fileSystem) {
        try {
            if (fileSystem != null && this.fs != fileSystem) {
                this.originalFS = fileSystem;
                this.originalNode = new BeanNode((Object)this.originalFS);
                this.setActiveFS(this.originalNode, this.originalFS);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        this.setOriginalValueVisibility();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private void setDirTextFieldText() {
        if (this.localFS != null) {
            this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
        }
    }

    private void setJarTextFieldText() {
        if (this.jarFS != null) {
            this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getFileSystem();
    }

    private static final String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$FileSystemPanel == null ? (class$org$netbeans$beaninfo$editors$FileSystemPanel = FileSystemPanel.class$("org.netbeans.beaninfo.editors.FileSystemPanel")) : class$org$netbeans$beaninfo$editors$FileSystemPanel)).getString(string);
    }

    private void setOriginalValueVisibility() {
        if (this.originalFS == null) {
            this.originalRadioButton.setVisible(false);
        } else {
            this.originalRadioButton.setVisible(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

