/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.beaninfo.editors.FileEditor;
import org.openide.execution.NbClassPath;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class NbClassPathCustomEditor
extends JPanel {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private PropertyEditor editor;
    private DefaultListModel listModel = new DefaultListModel();
    private JLabel pathLabel;
    private JList pathList;
    private JButton addJarButton;
    private JButton downButton;
    private JScrollPane pathScrollPane;
    private JButton upButton;
    private JPanel innerPanel;
    private JButton addDirButton;
    private JButton removeButton;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor;

    public NbClassPathCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.setPreferredSize(new Dimension(400, 200));
        this.pathLabel.setDisplayedMnemonic(NbClassPathCustomEditor.getString("CTL_Classpath.Border_Mnemonic").charAt(0));
        this.addDirButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_AddDirectory_Mnemonic").charAt(0));
        this.addJarButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_AddJAR_Mnemonic").charAt(0));
        this.upButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_Remove_Mnemonic").charAt(0));
        this.pathList.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddDirectory"));
        this.addJarButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddJAR"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_CustomNbClassPathEditor"));
    }

    NbClassPathCustomEditor(PropertyEditor propertyEditor) {
        this();
        this.editor = propertyEditor;
        Object object = propertyEditor.getValue();
        if (object instanceof NbClassPath) {
            this.setClassPath(((NbClassPath)object).getClassPath());
        }
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.addJarButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.pathLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.addDirButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.addDirButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        this.addJarButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_AddJAR"));
        this.addJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.addJarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addJarButton, gridBagConstraints);
        this.upButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NbClassPathCustomEditor.this.pathListValueChanged(listSelectionEvent);
            }
        });
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NbClassPathCustomEditor.this.pathListMouseClicked(mouseEvent);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.pathLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString("CTL_Classpath.Border_Title"));
        this.pathLabel.setLabelFor(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.innerPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void pathListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        Object[] objectArray = this.pathList.getSelectedValues();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.listModel.removeElement(objectArray[n2]);
            this.fireValueChanged();
            ++n2;
        }
        int n3 = this.listModel.getSize();
        if (n >= 0 && n3 > 0) {
            if (n3 == n) {
                this.pathList.setSelectedIndex(n - 1);
            } else if (n3 > n) {
                this.pathList.setSelectedIndex(n);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n);
        this.pathList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n - 1);
        this.pathList.setSelectedIndex(n - 1);
    }

    private void addJarButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        this.setHelpToChooser(jFileChooser);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }

            public String getDescription() {
                return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
            }
        });
        if (lastJarFolder != null) {
            jFileChooser.setCurrentDirectory(lastJarFolder);
        }
        jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Jar_Dialog_Title"));
        jFileChooser.setMultiSelectionEnabled(true);
        if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            boolean bl = false;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] != null && fileArray[n].isFile()) {
                    bl = true;
                    this.listModel.addElement(fileArray[n].getAbsolutePath());
                }
                ++n;
            }
            if (bl) {
                lastJarFolder = jFileChooser.getCurrentDirectory();
                this.fireValueChanged();
            }
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
    }

    private void addDirButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        this.setHelpToChooser(jFileChooser);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Local_Dialog_Title"));
        if (lastDirFolder != null) {
            jFileChooser.setCurrentDirectory(lastDirFolder);
        }
        if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file = jFileChooser.getSelectedFile()) != null && file.isDirectory()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lastDirFolder = file.getParentFile();
            this.listModel.addElement(file.getAbsolutePath());
            this.fireValueChanged();
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int n) {
        if (n < 0) {
            return;
        }
        String string = (String)this.listModel.elementAt(n);
        File file = new File(string);
        if (file.isDirectory()) {
            File file2;
            JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(jFileChooser);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Local_Dialog_Title"));
            if (file.getParentFile() != null) {
                jFileChooser.setCurrentDirectory(file.getParentFile());
                jFileChooser.setSelectedFile(file);
            }
            if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file2 = jFileChooser.getSelectedFile()) != null && file2.isDirectory()) {
                lastDirFolder = jFileChooser.getCurrentDirectory();
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listModel.set(n, file2.getAbsolutePath());
                this.fireValueChanged();
            }
        } else if (file.isFile()) {
            File file3;
            JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(jFileChooser);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
                }
            });
            jFileChooser.setCurrentDirectory(file.getParentFile());
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Jar_Dialog_Title"));
            if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file3 = jFileChooser.getSelectedFile()) != null && file3.isFile()) {
                lastJarFolder = jFileChooser.getCurrentDirectory();
                this.listModel.set(n, file3.getAbsolutePath());
                this.fireValueChanged();
            }
        }
    }

    private void swap(int n) {
        if (n < 0 || n >= this.listModel.size() - 1) {
            return;
        }
        Object e = this.listModel.elementAt(n);
        this.listModel.removeElement(e);
        this.listModel.add(n + 1, e);
        this.fireValueChanged();
    }

    private void enableButtons() {
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    private void setClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.listModel.addElement(string2);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.listModel.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return new NbClassPath(stringArray);
    }

    private static final String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor == null ? (class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor = NbClassPathCustomEditor.class$("org.netbeans.beaninfo.editors.NbClassPathCustomEditor")) : class$org$netbeans$beaninfo$editors$NbClassPathCustomEditor)).getString(string);
    }

    private void setHelpToChooser(JFileChooser jFileChooser) {
        HelpCtx helpCtx = HelpCtx.findHelp((Component)this);
        if (helpCtx != null) {
            HelpCtx.setHelpIDString((JComponent)jFileChooser, (String)helpCtx.getHelpID());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

