/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.JarFileSystem;

public final class ExJarFileSystem
extends JarFileSystem {
    static final long serialVersionUID = 8682224601177674646L;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";

    public ExJarFileSystem() {
        InnerAttrs innerAttrs = new InnerAttrs(new AttrImpl(this));
        ((AbstractFileSystem)this).attr = innerAttrs;
        ((AbstractFileSystem)this).list = innerAttrs;
    }

    public void setSystemName2(String string) throws PropertyVetoException {
        try {
            super.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().annotate((Throwable)propertyVetoException, propertyVetoException.getMessage());
            throw propertyVetoException;
        }
    }

    private static class AttrImpl
    extends JarFileSystem.Impl
    implements PropertyChangeListener {
        static final String ATTR_NAME_EXT_XML = ".nbattrs";
        private transient File attrFile = null;
        private transient String systemName = null;
        private JarFileSystem jfs = null;
        static final long serialVersionUID = -67233308132567123L;

        public AttrImpl(JarFileSystem jarFileSystem) {
            super(jarFileSystem);
            this.jfs = jarFileSystem;
            this.jfs.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.jfs != null) {
                String string = this.jfs.getSystemName();
                File file = this.jfs.getJarFile();
                if (string != null) {
                    this.systemName = string;
                    this.attrFile = new File(this.systemName + ATTR_NAME_EXT_XML);
                }
                this.jfs.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                this.systemName = (String)propertyChangeEvent.getNewValue();
                if (this.systemName != null) {
                    this.attrFile = new File(this.systemName + ATTR_NAME_EXT_XML);
                }
            }
        }

        private void createAttributes() throws IOException {
            if (!this.attrFile.exists()) {
                this.attrFile.getParentFile().mkdirs();
                this.attrFile.createNewFile();
            }
        }

        public void createData(String string) throws IOException {
            if (this.attrFile != null && string.endsWith(ATTR_NAME_EXT_XML)) {
                this.createAttributes();
                return;
            }
            throw new IOException();
        }

        public long size(String string) {
            if (this.attrFile != null && string.endsWith(ATTR_NAME_EXT_XML)) {
                return this.attrFile.length();
            }
            return super.size(string);
        }

        public InputStream inputStream(String string) throws FileNotFoundException {
            if (this.attrFile != null && string.endsWith(ATTR_NAME_EXT_XML)) {
                return new FileInputStream(this.attrFile);
            }
            return super.inputStream(string);
        }

        public OutputStream outputStream(String string) throws IOException {
            if (this.attrFile != null && string.endsWith(ATTR_NAME_EXT_XML)) {
                this.createAttributes();
                return new FileOutputStream(this.attrFile);
            }
            return super.outputStream(string);
        }

        public void delete(String string) throws IOException {
            if (this.attrFile != null && string.endsWith(ATTR_NAME_EXT_XML)) {
                this.attrFile.delete();
                return;
            }
            super.delete(string);
        }
    }

    private static class InnerAttrs
    extends DefaultAttributes {
        static final long serialVersionUID = 1257351369229921994L;
        AttrImpl impl;

        public InnerAttrs(AttrImpl attrImpl) {
            super((AbstractFileSystem.Info)attrImpl, (AbstractFileSystem.Change)attrImpl, (AbstractFileSystem.List)attrImpl);
            this.impl = attrImpl;
        }

        private String transformName(String string) {
            char c = '|';
            if (string.indexOf(c) != -1) {
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n = 0;
                while (n < string.length()) {
                    stringBuffer.append(string.charAt(n));
                    if (string.charAt(n) == c) {
                        stringBuffer.append(c);
                    }
                    ++n;
                }
                string = stringBuffer.toString();
            }
            return this.impl.systemName + "/" + string.replace('/', c);
        }

        public Object readAttribute(String string, String string2) {
            if (string2.equals(ExJarFileSystem.READONLY_ATTRIBUTES)) {
                return new Boolean(false);
            }
            return super.readAttribute(this.transformName(string), string2);
        }

        public void deleteAttributes(String string) {
            super.deleteAttributes(this.transformName(string));
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            super.writeAttribute(this.transformName(string), string2, object);
        }

        public void renameAttributes(String string, String string2) {
            super.renameAttributes(this.transformName(string), this.transformName(string2));
        }

        public Enumeration attributes(String string) {
            Enumeration enumeration = super.attributes(this.transformName(string));
            return enumeration;
        }
    }
}

