/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbTheme;
import org.netbeans.core.NonGui;
import org.netbeans.core.ShortcutsFolder;
import org.netbeans.core.Splash;
import org.netbeans.core.TopThreadGroup;
import org.netbeans.core.perftool.PerformanceMeter;
import org.netbeans.core.perftool.PerformanceMeterFactory;
import org.netbeans.core.perftool.StartLog;
import org.netbeans.core.perftool.Util;
import org.netbeans.core.ui.WelcomePanel;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.xml.NbSAXParserFactoryImpl;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.ExecuteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

public final class Main
extends NonGui {
    private static Splash.SplashOutput splash;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$org$netbeans$core$Main;

    public static void setSplashMaxSteps(int n) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.setMaxSteps(n);
    }

    public static void addToSplashMaxSteps(int n) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.addToMaxSteps(n);
    }

    public static void addAndSetSplashMaxSteps(int n) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.addAndSetMaxSteps(n);
    }

    public static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar(1);
    }

    public static void incrementSplashProgressBar(int n) {
        if (Boolean.getBoolean("netbeans.splash.nobar") || NonGui.noSplash || splash == null) {
            return;
        }
        splash.increment(n);
    }

    protected void setStatusTextImpl(String string) {
        Splash.SplashOutput splashOutput = splash;
        if (splashOutput != null) {
            splashOutput.print(string);
        }
    }

    public static void start(String[] stringArray) {
        TopThreadGroup topThreadGroup = new TopThreadGroup("IDE Main", stringArray);
        topThreadGroup.start();
    }

    public void run() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        StartLog.logStart("TopManager initialization (org.netbeans.core.Main.run())");
        NbFocusManager.install();
        if (NonGui.uiClass != null) {
            try {
                object4 = (LookAndFeel)NonGui.uiClass.newInstance();
                UIManager.setLookAndFeel((LookAndFeel)object4);
            }
            catch (Exception exception) {
                System.out.println(Main.getString("ERR_UIError"));
            }
        } else {
            object4 = new NbTheme();
            MetalLookAndFeel.setCurrentTheme((MetalTheme)object4);
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception exception) {
                System.out.println("Failed loading Metal look and feel");
                System.out.println(exception);
                NonGui.uiFontSize = 11;
            }
        }
        StartLog.logProgress("Theme set");
        if (NonGui.uiFontSize > 0) {
            object4 = new Font("Dialog", 0, NonGui.uiFontSize);
            serializable = new Font("Dialog", 1, NonGui.uiFontSize);
            object3 = new Font("Serif", 0, NonGui.uiFontSize);
            object2 = new Font("SansSerif", 0, NonGui.uiFontSize);
            object = new Font("Monospaced", 0, NonGui.uiFontSize);
            UIManager.getDefaults().put("Button.font", object4);
            UIManager.getDefaults().put("ToggleButton.font", object4);
            UIManager.getDefaults().put("RadioButton.font", object4);
            UIManager.getDefaults().put("CheckBox.font", object4);
            UIManager.getDefaults().put("ColorChooser.font", object4);
            UIManager.getDefaults().put("ComboBox.font", object4);
            UIManager.getDefaults().put("Label.font", object4);
            UIManager.getDefaults().put("List.font", object4);
            UIManager.getDefaults().put("MenuBar.font", object4);
            UIManager.getDefaults().put("MenuItem.font", object4);
            UIManager.getDefaults().put("RadioButtonMenuItem.font", object4);
            UIManager.getDefaults().put("CheckBoxMenuItem.font", object4);
            UIManager.getDefaults().put("Menu.font", object4);
            UIManager.getDefaults().put("PopupMenu.font", object4);
            UIManager.getDefaults().put("OptionPane.font", object4);
            UIManager.getDefaults().put("Panel.font", object4);
            UIManager.getDefaults().put("ProgressBar.font", object4);
            UIManager.getDefaults().put("ScrollPane.font", object4);
            UIManager.getDefaults().put("Viewport.font", object4);
            UIManager.getDefaults().put("TabbedPane.font", object4);
            UIManager.getDefaults().put("Table.font", object4);
            UIManager.getDefaults().put("TableHeader.font", object4);
            UIManager.getDefaults().put("TextField.font", object2);
            UIManager.getDefaults().put("PasswordField.font", object);
            UIManager.getDefaults().put("TextArea.font", object);
            UIManager.getDefaults().put("TextPane.font", object3);
            UIManager.getDefaults().put("EditorPane.font", object3);
            UIManager.getDefaults().put("TitledBorder.font", object4);
            UIManager.getDefaults().put("ToolBar.font", object4);
            UIManager.getDefaults().put("ToolTip.font", object2);
            UIManager.getDefaults().put("Tree.font", object4);
            UIManager.getDefaults().put("InternalFrame.titleFont", serializable);
        }
        StartLog.logProgress("Fonts updated");
        try {
            object4 = new Hashtable<String, String>();
            ((Hashtable)object4).put("monospaced", "Monospaced");
            ((Hashtable)object4).put("Monospaced", "Monospaced");
            ((Hashtable)object4).put("serif", "Serif");
            ((Hashtable)object4).put("Serif", "Serif");
            ((Hashtable)object4).put("sansserif", "SansSerif");
            ((Hashtable)object4).put("SansSerif", "SansSerif");
            serializable = Class.forName("javax.swing.text.html.CSS");
            object3 = ((Class)serializable).getDeclaredField("fontMappingLock");
            object2 = ((Class)serializable).getDeclaredField("fontMapping");
            ((AccessibleObject)object3).setAccessible(true);
            ((AccessibleObject)object2).setAccessible(true);
            Object object5 = object = ((Field)object3).get(null);
            synchronized (object5) {
                if (((Field)object2).get(null) == null) {
                    ((Field)object2).set(null, object4);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        StartLog.logProgress("CSS fontMapping hacked");
        object4 = UIManager.getDefaults().get("Desktop.ancestorInputMap");
        if (object4 != null) {
            try {
                serializable = Class.forName("javax.swing.plaf.InputMapUIResource");
                object3 = ((Class)serializable).getMethod("remove", class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Main.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke);
                ((Method)object3).invoke(object4, KeyStroke.getKeyStroke(116, 2));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        StartLog.logProgress("Desktop shortcuts updated");
        super.run();
        StartLog.logProgress("NonGui part done");
        StartLog.logEnd("TopManager initialization (org.netbeans.core.Main.run())");
    }

    protected void initializeMainWindow() {
        StartLog.logStart("Main window initialization");
        this.setStatusText(Main.getString("MSG_MainWindowInit"));
        final MainWindow mainWindow = WindowManagerImpl.mainWindow();
        mainWindow.initialize();
        Main.incrementSplashProgressBar(10);
        StartLog.logProgress("Main window initialized");
        Timer timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        timer.setRepeats(false);
        timer.start();
        Main.incrementSplashProgressBar(10);
        StartLog.logProgress("Timer initialized");
        this.setStatusText(Main.getString("MSG_DefaultWorkspaceInit"));
        WindowManager.getDefault();
        Main.incrementSplashProgressBar();
        StartLog.logProgress("Workspaces initialized");
        if (System.getProperty("netbeans.kill") == null && System.getProperty("netbeans.close") == null) {
            ShortcutsFolder.initShortcuts();
        }
        Main.incrementSplashProgressBar();
        StartLog.logProgress("Shortcuts initialized");
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Welcome");
        if (fileObject != null && fileObject.getChildren().length > 0 && System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null) {
            mainWindow.addComponentListener(new ComponentAdapter(){
                static /* synthetic */ Class class$org$netbeans$core$IDESettings;

                public void componentShown(ComponentEvent componentEvent) {
                    mainWindow.removeComponentListener(this);
                    IDESettings iDESettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = 2.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
                    if (iDESettings.getShowTipsOnStartup()) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                WelcomePanel.showGettingStarted();
                            }
                        });
                        StartLog.logProgress("Welcome dialog fired");
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        this.setStatusText(Main.getString("MSG_WindowShowInit"));
        mainWindow.showWindow();
        this.setStatusText("");
        StartLog.logProgress("Main window opened");
        StartLog.logEnd("Main window initialization");
    }

    private static void checkDoubleBuffering() {
        RepaintManager repaintManager;
        if (Boolean.getBoolean("openide.windows.nodoublebuffer") && (repaintManager = RepaintManager.currentManager(null)) != null) {
            repaintManager.setDoubleBufferingEnabled(false);
        }
    }

    public static void main(String[] stringArray) throws SecurityException {
        long l = System.currentTimeMillis();
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        if (((Hashtable)System.getProperties()).get("org.openide.TopManager") == null) {
            ((Hashtable)System.getProperties()).put("org.openide.TopManager", "org.netbeans.core.Main");
        }
        NbSAXParserFactoryImpl.install();
        StartLog.logProgress("Basic properties set");
        NonGui.parseCommandLine(stringArray);
        StartLog.logProgress("Command line parsed");
        Main.checkDoubleBuffering();
        StartLog.logProgress("Double buffering checked");
        if (!NonGui.noSplash) {
            splash = Splash.showSplash();
        }
        StartLog.logProgress("Splash shown");
        StartLog.logStart("Creation of TopManager");
        TopManager topManager = TopManager.getDefault();
        StartLog.logEnd("Creation of TopManager");
        if (splash != null) {
            Splash.hideSplash(splash);
            splash = null;
        }
        StartLog.logProgress("Splash hidden");
        if (Util.isRunning()) {
            Main.measureStart(topManager, l);
        }
        StartLog.logProgress("Startup memory and time measured");
        if (System.getProperty("netbeans.kill") != null) {
            NonGui.doExit(5);
        }
        if (System.getProperty("netbeans.exec") != null) {
            Main.startResource(System.getProperty("netbeans.exec"));
        }
        if (System.getProperty("netbeans.close") != null) {
            TopManager.getDefault().exit();
        }
        StartLog.logEnd("Preparation");
    }

    private static void measureStart(TopManager topManager, long l) {
        Util.waitForSystemThreads();
        PerformanceMeter performanceMeter = PerformanceMeterFactory.getPerformanceMeter();
        performanceMeter.notifyTime("Total startup time:", System.currentTimeMillis() - l);
        Runtime runtime = Runtime.getRuntime();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = 0;
        while (n < 5) {
            runtime.gc();
            ++n;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = 0;
        while (n2 < 5) {
            runtime.gc();
            ++n2;
        }
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        performanceMeter.notifyMemory("Total heap:", l2);
        performanceMeter.notifyMemory("Used heap:", l2 - l3);
    }

    private static void startResource(String string) {
        FileObject fileObject = TopManager.getDefault().getRepository().findResource(string);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            ExecuteAction.execute((DataObject[])new DataObject[]{dataObject}, (boolean)true);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
        }
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$Main == null ? (class$org$netbeans$core$Main = Main.class$("org.netbeans.core.Main")) : class$org$netbeans$core$Main), (String)string);
    }

    protected Splash.SplashOutput getSplash() {
        return splash;
    }

    protected void showSplashAgain() {
        if (!NonGui.noSplash) {
            if (splash != null) {
                if (Splash.isVisible(splash)) {
                    return;
                }
                splash = null;
            }
            splash = Splash.showSplash();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

