/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.netbeans.core.projects.SessionManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.ErrorManager;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.SafeException;
import org.openide.windows.WindowManager;

final class NbProject
implements ProjectCookie {
    static final long serialVersionUID = 8726895988034807614L;
    private static byte SAVE_CONTROL_PANEL = 1;
    private static byte SAVE_REPOSITORY = (byte)2;
    private static byte SAVE_WORKSPACES = (byte)4;
    private static byte SAVE_SERVICES = (byte)8;
    private static final String SERIALIZED_PROJECT_NAME = "project";
    private static final String SERIALIZED_PROJECT_EXT = "basic";
    static /* synthetic */ Class class$org$netbeans$core$NbProject;

    NbProject() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void projectOpen() throws IOException {
        SessionManager.getDefault().setProjectLayer(null);
        FileObject fileObject = NbProject.getSerializedProjectFile(false);
        if (fileObject == null) {
            return;
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new NbObjectInputStream((InputStream)new BufferedInputStream(fileObject.getInputStream(), 16384));
            byte by = objectInputStream.readByte();
            try {
                if ((by & SAVE_REPOSITORY) != 0) {
                    NbObjectInputStream.readSafely((ObjectInput)objectInputStream);
                }
            }
            catch (SafeException safeException) {
                ErrorManager.getDefault().notify(1, (Throwable)safeException);
            }
            try {
                if ((by & SAVE_CONTROL_PANEL) != 0) {
                    NbObjectInputStream.readSafely((ObjectInput)objectInputStream);
                }
            }
            catch (SafeException safeException) {
                ErrorManager.getDefault().notify(1, (Throwable)safeException);
            }
            WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            if ((by & SAVE_WORKSPACES) != 0 && System.getProperty("netbeans.workspaces.noload") == null) {
                try {
                    NbObjectInputStream.readSafely((ObjectInput)objectInputStream);
                }
                catch (SafeException safeException) {
                    ErrorManager.getDefault().annotate((Throwable)safeException, NbBundle.getMessage((Class)(class$org$netbeans$core$NbProject == null ? (class$org$netbeans$core$NbProject = NbProject.class$("org.netbeans.core.NbProject")) : class$org$netbeans$core$NbProject), (String)"EXC_WorkspaceLoadFail"));
                    ErrorManager.getDefault().notify((Throwable)safeException);
                    if (!windowManagerImpl.isCreated()) {
                        WindowManagerImpl.createFromScratch();
                    }
                }
            } else {
                if ((by & SAVE_WORKSPACES) != 0) {
                    NbObjectInputStream.skipSafely((ObjectInput)objectInputStream);
                }
                if (!windowManagerImpl.isCreated()) {
                    WindowManagerImpl.createFromScratch();
                }
            }
            try {
                if ((by & SAVE_SERVICES) != 0) {
                    NbObjectInputStream.readSafely((ObjectInput)objectInputStream);
                }
            }
            catch (SafeException safeException) {
                ErrorManager.getDefault().notify(1, (Throwable)safeException);
            }
            Object var7_9 = null;
            if (objectInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (objectInputStream == null) throw throwable;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
    }

    public void projectSave() throws IOException {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
        windowManagerImpl.persistenceManager().writeXML();
    }

    public void projectClose() throws IOException {
    }

    public synchronized Node projectDesktop() {
        return null;
    }

    private static FileObject getSerializedProjectFile(boolean bl) throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.find("", SERIALIZED_PROJECT_NAME, SERIALIZED_PROJECT_EXT);
        if (fileObject == null && bl) {
            fileObject = fileSystem.getRoot().createData(SERIALIZED_PROJECT_NAME, SERIALIZED_PROJECT_EXT);
        }
        return fileObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

