/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.netbeans.core.NonGui;
import org.openide.ErrorManager;
import org.openide.loaders.XMLDataObject;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class NbTheme
extends MetalTheme
implements DocumentHandler {
    public static final String THEMEFILE_NAME = "Themes.xml";
    private static final String MAIN_TAG = "MetalTheme";
    private static final String MAIN_ACTIVATE_TAG = "activate";
    private static final String THEME_TAG = "Theme";
    private static final String THEME_NAME_TAG = "name";
    private static final String R_TAG = "R";
    private static final String G_TAG = "G";
    private static final String B_TAG = "B";
    private static final String PRIMARY1_TAG = "primary1";
    private static final String PRIMARY2_TAG = "primary2";
    private static final String PRIMARY3_TAG = "primary3";
    private static final String SECONDARY1_TAG = "secondary1";
    private static final String SECONDARY2_TAG = "secondary2";
    private static final String SECONDARY3_TAG = "secondary3";
    private static final String FONTNAME_TAG = "name";
    private static final String FONTSTYLE_TAG = "style";
    private static final String FONTSTYLE_PLAIN = "Plain";
    private static final String FONTSTYLE_BOLD = "Bold";
    private static final String FONTSTYLE_ITALIC = "Italic";
    private static final String FONTSIZE_TAG = "size";
    private static final String CONTROLFONT_TAG = "controlFont";
    private static final String SYSTEMFONT_TAG = "systemFont";
    private static final String USERFONT_TAG = "userFont";
    private static final String SUBFONT_TAG = "subFont";
    private static final String MENUFONT_TAG = "menuFont";
    private static final String WINDOWTITLEFONT_TAG = "windowTitleFont";
    private ColorUIResource primary1 = new ColorUIResource(102, 102, 153);
    private ColorUIResource primary2 = new ColorUIResource(153, 153, 204);
    private ColorUIResource primary3 = new ColorUIResource(204, 204, 255);
    private ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
    private ColorUIResource secondary2 = new ColorUIResource(153, 153, 153);
    private ColorUIResource secondary3 = new ColorUIResource(204, 204, 204);
    private FontUIResource controlFont;
    private FontUIResource systemFont;
    private FontUIResource userFont;
    private FontUIResource subFont;
    private FontUIResource menuFont;
    private FontUIResource windowTitleFont;
    private String activeTag = "";
    private boolean activeTagFlag = false;

    public String getName() {
        return "NetBeans";
    }

    public NbTheme() {
        try {
            this.controlFont = new FontUIResource(new Font("Dialog", 0, 11));
            this.systemFont = new FontUIResource(new Font("Dialog", 0, 11));
            this.userFont = new FontUIResource(new Font("Dialog", 0, 11));
            this.menuFont = new FontUIResource(new Font("Dialog", 0, 11));
            this.windowTitleFont = new FontUIResource(new Font("Dialog", 0, 11));
            this.subFont = new FontUIResource(new Font("Dialog", 0, 10));
            UIManager.getDefaults().put("List.font", this.controlFont);
            UIManager.getDefaults().put("Tree.font", this.controlFont);
            UIManager.getDefaults().put("Panel.font", this.controlFont);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        this.parseTheme();
    }

    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    public FontUIResource getControlTextFont() {
        return this.controlFont;
    }

    public FontUIResource getSystemTextFont() {
        return this.systemFont;
    }

    public FontUIResource getUserTextFont() {
        return this.userFont;
    }

    public FontUIResource getMenuTextFont() {
        return this.menuFont;
    }

    public FontUIResource getWindowTitleFont() {
        return this.windowTitleFont;
    }

    public FontUIResource getSubTextFont() {
        return this.subFont;
    }

    private void parseTheme() {
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(this);
        File file = new File(NonGui.getSystemDir() + File.separator + THEMEFILE_NAME);
        FileReader fileReader = null;
        boolean bl = false;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        if (!bl) {
            InputSource inputSource = new InputSource(fileReader);
            try {
                parser.parse(inputSource);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        int n4 = 0;
        int n5 = 0;
        if (string.equals(MAIN_TAG) && attributeList.getLength() == 1 && attributeList.getName(0).equals(MAIN_ACTIVATE_TAG)) {
            this.activeTag = attributeList.getValue(0);
        } else {
            if (string.equals(THEME_TAG) && attributeList.getLength() == 1 && attributeList.getName(0).equals("name") && attributeList.getValue(0).equals(this.activeTag)) {
                this.activeTagFlag = true;
            }
            if (this.activeTagFlag) {
                int n6 = 0;
                while (n6 < attributeList.getLength()) {
                    if (attributeList.getName(n6).equals(R_TAG)) {
                        n = Integer.valueOf(attributeList.getValue(n6));
                    }
                    if (attributeList.getName(n6).equals(G_TAG)) {
                        n2 = Integer.valueOf(attributeList.getValue(n6));
                    }
                    if (attributeList.getName(n6).equals(B_TAG)) {
                        n3 = Integer.valueOf(attributeList.getValue(n6));
                    }
                    if (attributeList.getName(n6).equals("name")) {
                        string2 = attributeList.getValue(n6);
                    }
                    if (attributeList.getName(n6).equals(FONTSTYLE_TAG)) {
                        if (attributeList.getValue(n6).equals(FONTSTYLE_PLAIN)) {
                            n4 = 0;
                        }
                        if (attributeList.getValue(n6).equals(FONTSTYLE_BOLD)) {
                            n4 = 1;
                        }
                        if (attributeList.getValue(n6).equals(FONTSTYLE_ITALIC)) {
                            n4 = 2;
                        }
                    }
                    if (attributeList.getName(n6).equals(FONTSIZE_TAG)) {
                        n5 = Integer.valueOf(attributeList.getValue(n6));
                    }
                    ++n6;
                }
                if (string.equals(PRIMARY1_TAG)) {
                    this.primary1 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(PRIMARY2_TAG)) {
                    this.primary2 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(PRIMARY3_TAG)) {
                    this.primary3 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(SECONDARY1_TAG)) {
                    this.secondary1 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(SECONDARY2_TAG)) {
                    this.secondary2 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(SECONDARY3_TAG)) {
                    this.secondary3 = new ColorUIResource(n, n2, n3);
                }
                if (string.equals(CONTROLFONT_TAG)) {
                    this.controlFont = new FontUIResource(new Font(string2, n4, n5));
                    UIManager.getDefaults().put("List.font", this.controlFont);
                    UIManager.getDefaults().put("Tree.font", this.controlFont);
                    UIManager.getDefaults().put("Panel.font", this.controlFont);
                }
                if (string.equals(SYSTEMFONT_TAG)) {
                    this.systemFont = new FontUIResource(new Font(string2, n4, n5));
                }
                if (string.equals(USERFONT_TAG)) {
                    this.userFont = new FontUIResource(new Font(string2, n4, n5));
                }
                if (string.equals(SUBFONT_TAG)) {
                    this.subFont = new FontUIResource(new Font(string2, n4, n5));
                }
                if (string.equals(MENUFONT_TAG)) {
                    this.menuFont = new FontUIResource(new Font(string2, n4, n5));
                }
                if (string.equals(WINDOWTITLEFONT_TAG)) {
                    this.windowTitleFont = new FontUIResource(new Font(string2, n4, n5));
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void endElement(String string) throws SAXException {
        if (string.equals(THEME_TAG)) {
            this.activeTagFlag = false;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }
}

