/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.netbeans.core.NbErrorManager;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.output.OutputTabTerm;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NotifyException
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 3680397500573480127L;
    private static NotifyException INSTANCE = null;
    private static final int MAXIMUM_TEXT_WIDTH = 40;
    private static final int SIZE_PREFERRED_WIDTH = 550;
    private static final int SIZE_PREFERRED_HEIGHT = 250;
    private static ArrayListPos exceptions;
    private NbErrorManager.Exc current;
    private DialogDescriptor descriptor;
    private Dialog dialog;
    private JButton next;
    private JButton previous;
    private JButton details;
    private OutputTabTerm.OutTermPane output;
    private boolean showDetails;
    static /* synthetic */ Class class$org$netbeans$core$NotifyException;

    private NotifyException() {
        this.setPreferredSize(new Dimension(550, 250));
        exceptions = new ArrayListPos();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException));
        this.next = new JButton(resourceBundle.getString("CTL_NextException"));
        this.previous = new JButton(resourceBundle.getString("CTL_PreviousException"));
        this.details = new JButton();
        this.output = new OutputTabTerm.OutTermPane();
        this.output.getTerm().setScrollOnOutput(false);
        this.output.getTerm().setTrackCursor(false);
        this.setLayout(new BorderLayout());
        this.add(this.output);
        this.setBorder(new BevelBorder(1));
        this.next.setMnemonic(resourceBundle.getString("CTL_NextException_Mnemonic").charAt(0));
        this.previous.setMnemonic(resourceBundle.getString("CTL_PreviousException_Mnemonic").charAt(0));
        this.next.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NextException"));
        this.previous.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_PreviousException"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NotifyExceptionPanel"));
        this.descriptor = new DialogDescriptor((Object)"", "");
        this.descriptor.setModal(false);
        this.descriptor.setMessageType(0);
        this.descriptor.setOptions(new Object[]{this.previous, this.next, NotifyDescriptor.OK_OPTION});
        this.descriptor.setAdditionalOptions(new Object[]{this.details});
        this.descriptor.setClosingOptions(new Object[0]);
        this.descriptor.setButtonListener((ActionListener)this);
        this.dialog = TopManager.getDefault().createDialog(this.descriptor);
    }

    public static void notify(final NbErrorManager.Exc exc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = exc.getLocalizedMessage();
                int n = exc.getSeverity();
                if (n == 16 && string != null && !string.equals("")) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
                } else if (n == 256 && string != null && !string.equals("")) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
                } else if (n == 65536 && string != null && !string.equals("")) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                } else {
                    if (INSTANCE == null) {
                        INSTANCE = new NotifyException();
                    }
                    INSTANCE.updateState(exc);
                }
            }
        });
    }

    private void updateState(NbErrorManager.Exc exc) {
        exceptions.add(exc);
        if (!exceptions.existsNextElement()) {
            boolean bl;
            boolean bl2 = bl = NbPresenter.currentModalDialog != null;
            if (this.descriptor.isModal() != bl) {
                this.descriptor.setModal(bl);
                this.dialog = TopManager.getDefault().createDialog(this.descriptor);
            }
            this.current = exc;
            this.update();
        } else {
            this.next.setVisible(true);
        }
        this.ensurePreferredSize();
        this.dialog.show();
    }

    private void ensurePreferredSize() {
        Dimension dimension;
        Dimension dimension2 = this.dialog.getSize();
        if (!dimension2.equals(dimension = this.dialog.getPreferredSize())) {
            ((Component)this.dialog).setSize(dimension.width, dimension.height);
            this.dialog.validate();
            this.dialog.repaint();
        }
    }

    private void update() {
        String string = this.current.getLocalizedMessage();
        String string2 = this.current.getMessage();
        boolean bl = this.current.isLocalized();
        this.next.setVisible(exceptions.existsNextElement());
        this.previous.setVisible(exceptions.existsPreviousElement());
        if (this.showDetails) {
            this.details.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Hide_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Hide_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("ACSD_Exception_Hide_Details"));
        } else {
            this.details.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Show_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Show_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("ACSD_Exception_Show_Details"));
        }
        String string3 = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Title_Exception");
        if (this.showDetails) {
            this.descriptor.setMessage((Object)this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        NotifyException.this.output.getOut().reset();
                        NotifyException.this.current.printStackTrace((PrintWriter)NotifyException.this.output.getOut());
                        NotifyException.this.output.requestFocus();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        } else if (bl) {
            String string4 = this.current.getLocalizedMessage();
            if (string4 != null) {
                string4 = Utilities.wrapString((String)string4, (int)40, (BreakIterator)BreakIterator.getCharacterInstance(), (boolean)false);
                this.descriptor.setMessage((Object)string4);
            }
        } else {
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException));
            if (this.current.getSeverity() == 16) {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionWarning"), this.current.getClassName()));
                string3 = resourceBundle.getString("NTF_ExceptionWarningTitle");
            } else {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionalException"), this.current.getClassName(), new File(System.getProperty("netbeans.user"), "system")));
                string3 = resourceBundle.getString("NTF_ExceptionalExceptionTitle");
            }
        }
        this.descriptor.setTitle(string3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.next && exceptions.setNextElement() || actionEvent.getSource() == this.previous && exceptions.setPreviousElement()) {
            this.current = (NbErrorManager.Exc)exceptions.get();
            this.update();
            this.ensurePreferredSize();
            return;
        }
        if (actionEvent.getSource() == this.details) {
            this.showDetails = !this.showDetails;
            this.update();
            this.ensurePreferredSize();
            return;
        }
        if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
            exceptions.removeAll();
            this.dialog.dispose();
            INSTANCE = null;
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ArrayListPos
    extends ArrayList {
        protected int position = 0;

        protected ArrayListPos() {
        }

        protected boolean existsElement() {
            return this.size() > 0;
        }

        protected boolean existsNextElement() {
            return this.position + 1 < this.size();
        }

        protected boolean existsPreviousElement() {
            return this.position > 0 && this.size() > 0;
        }

        protected boolean setNextElement() {
            if (!this.existsNextElement()) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected boolean setPreviousElement() {
            if (!this.existsPreviousElement()) {
                return false;
            }
            --this.position;
            return true;
        }

        protected Object get() {
            return this.existsElement() ? this.get(this.position) : null;
        }

        protected void removeAll() {
            this.clear();
            this.position = 0;
        }
    }
}

