/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.core.PackageChildren;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

final class Packages
implements RepositoryListener,
Comparator,
FileChangeListener,
PropertyChangeListener {
    private static final int MIN_LIMIT = 8;
    private static final int MUL_LIMIT = 2;
    private static final int PRIORITY_WRITE = 2;
    private static final int PRIORITY_READ = 3;
    private static Reference ref = new WeakReference<Object>(null);
    public static final String PROP_LIST = "list";
    public static final String PROP_NAME = "name";
    private FileChangeListener weakFCL = WeakListener.fileChange((FileChangeListener)this, null);
    private PropertyChangeListener weakPCL = WeakListener.propertyChange((PropertyChangeListener)this, null);
    private TreeSet fileFolders;
    private Map indexOfFileSystem;
    private RequestProcessor PROCESSOR = new RequestProcessor("All packages processor");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.Packages");

    private Packages() {
    }

    protected void finalize() {
        this.PROCESSOR.stop();
        this.err.log("finalized");
    }

    private void initialize() {
        if (this.fileFolders == null) {
            Packages packages = this;
            synchronized (packages) {
                if (this.fileFolders == null) {
                    this.err.log("Initializing");
                    this.fileFolders = new TreeSet(this);
                    Repository repository = Repository.getDefault();
                    repository.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)repository));
                    this.putPackages(null);
                    Enumeration enumeration = repository.fileSystems();
                    while (enumeration.hasMoreElements()) {
                        FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                        fileSystem.addPropertyChangeListener(this.weakPCL);
                    }
                    this.err.log("Initialized");
                }
            }
        }
    }

    public static synchronized Packages getDefault() {
        Packages packages = (Packages)ref.get();
        if (packages == null) {
            packages = new Packages();
            ref = new WeakReference<Packages>(packages);
        }
        return packages;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void update(final PackageChildren packageChildren) {
        this.initialize();
        this.err.log("posting update for: " + packageChildren);
        this.PROCESSOR.post(new Runnable(){

            public void run() {
                Packages.this.err.log("updating children: " + packageChildren);
                packageChildren.updatePackages(Packages.this.fileFolders);
                Packages.this.err.log("updating finished");
            }
        }, 0, 3);
    }

    private void postTask(Runnable runnable) {
        this.PROCESSOR.post(runnable, 0, 2);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.putPackages(fileEvent.getFile());
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(final FileEvent fileEvent) {
        if (fileEvent.getFile() != fileEvent.getSource()) {
            return;
        }
        this.postTask(new Runnable(){

            public void run() {
                Packages.this.err.log("fileDeleted: " + fileEvent.getFile());
                Packages.this.fileFolders.remove(fileEvent.getFile());
                Packages.this.pcs.firePropertyChange(Packages.PROP_LIST, null, null);
                Packages.this.err.log("fileDeleted finished");
            }
        });
    }

    public void fileRenamed(final FileRenameEvent fileRenameEvent) {
        if (fileRenameEvent.getFile() != fileRenameEvent.getSource()) {
            return;
        }
        this.postTask(new Runnable(){

            public void run() {
                Packages.this.err.log("fileRenamed: " + fileRenameEvent.getFile());
                Packages.this.pcs.firePropertyChange(Packages.PROP_NAME, null, fileRenameEvent.getFile());
                Packages.this.err.log("fileRenamed finished");
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        if (fileSystem.isHidden()) {
            return;
        }
        this.putPackages(fileSystem.getRoot());
        fileSystem.addPropertyChangeListener(this.weakPCL);
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        this.removeFileSystemPackages(fileSystem);
        fileSystem.addPropertyChangeListener(this.weakPCL);
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        this.postTask(new Runnable(){

            public void run() {
                Packages.this.err.log("reordered");
                ArrayList arrayList = new ArrayList(Packages.this.fileFolders);
                Packages.this.indexOfFileSystem = null;
                Packages.this.fileFolders.clear();
                Packages.this.fileFolders.addAll(arrayList);
                Packages.this.err.log("end reordered");
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("hidden".equals(propertyChangeEvent.getPropertyName())) {
            FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
            this.err.log("propertyChange: hidden: " + fileSystem.getSystemName());
            if (fileSystem.isHidden()) {
                this.removeFileSystemPackages(fileSystem);
            } else {
                this.putPackages(fileSystem.getRoot());
            }
        }
    }

    private static Enumeration createSubFolders(FileObject fileObject) {
        return new SequenceEnumeration((Enumeration)new SingletonEnumeration((Object)fileObject), fileObject.getFolders(true));
    }

    private static Enumeration createFolders() {
        return new SequenceEnumeration((Enumeration)new AlterEnumeration(Repository.getDefault().getFileSystems()){

            protected Object alter(Object object) {
                FileSystem fileSystem = (FileSystem)object;
                if (fileSystem.isHidden() || !fileSystem.isValid()) {
                    return EmptyEnumeration.EMPTY;
                }
                return Packages.createSubFolders(fileSystem.getRoot());
            }
        });
    }

    private void putPackages(FileObject fileObject) {
        Enumeration enumeration = fileObject == null ? Packages.createFolders() : Packages.createSubFolders(fileObject);
        this.postTask(this.processPackages(enumeration, 8));
    }

    private Runnable processPackages(final Enumeration enumeration, final int n) {
        return new Runnable(){
            private int limit;
            {
                this.limit = n;
            }

            public void run() {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                Packages.this.err.log("processing packages. limit: " + this.limit);
                int n2 = 0;
                boolean bl = true;
                while (enumeration.hasMoreElements() && n2++ < this.limit) {
                    FileObject fileObject;
                    block6: {
                        fileObject = (FileObject)enumeration.nextElement();
                        try {
                            if (!fileObject.isValid() || !fileObject.getFileSystem().isValid()) {
                                bl = false;
                            }
                            break block6;
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            bl = false;
                        }
                        break;
                    }
                    fileObject.addFileChangeListener(Packages.this.weakFCL);
                    Packages.this.fileFolders.add(fileObject);
                }
                Packages.this.pcs.firePropertyChange(Packages.PROP_LIST, null, null);
                this.limit *= 2;
                if (bl && enumeration.hasMoreElements()) {
                    Packages.this.postTask(this);
                }
                Packages.this.err.log("finished packages. continue: " + bl);
            }
        };
    }

    private void removeFileSystemPackages(final FileSystem fileSystem) {
        this.postTask(new Runnable(){

            public void run() {
                Packages.this.err.log("Removing packages: " + fileSystem.getSystemName());
                Iterator iterator = Packages.this.fileFolders.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject = (FileObject)iterator.next();
                    try {
                        if (!fileObject.getFileSystem().equals(fileSystem)) continue;
                        iterator.remove();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        iterator.remove();
                    }
                }
                Packages.this.pcs.firePropertyChange(Packages.PROP_LIST, null, null);
                Packages.this.err.log("End of packages");
            }
        });
    }

    private int indexOf(FileSystem fileSystem) {
        Object object;
        HashMap hashMap = this.indexOfFileSystem;
        if (hashMap == null) {
            object = this;
            synchronized (object) {
                hashMap = this.indexOfFileSystem;
                if (hashMap == null) {
                    Repository repository = Repository.getDefault();
                    FileSystem[] fileSystemArray = repository.toArray();
                    hashMap = this.indexOfFileSystem = new HashMap((int)((double)fileSystemArray.length * 1.3));
                    int n = 0;
                    while (n < fileSystemArray.length) {
                        this.indexOfFileSystem.put(fileSystemArray[n], new Integer(n));
                        ++n;
                    }
                }
            }
        }
        return (object = (Integer)hashMap.get(fileSystem)) == null ? -1 : (Integer)object;
    }

    public int compare(Object object, Object object2) {
        try {
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = (FileObject)object2;
            FileSystem fileSystem = fileObject.getFileSystem();
            FileSystem fileSystem2 = fileObject2.getFileSystem();
            if (fileSystem.equals(fileSystem2)) {
                return fileObject.getPackageName('.').compareTo(fileObject2.getPackageName('.'));
            }
            return this.indexOf(fileSystem) - this.indexOf(fileSystem2);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return 0;
        }
    }
}

