/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ShortcutsFolder
extends FolderInstance {
    static ShortcutsFolder shortcutsFolder = null;
    public static final String PROPERTIES_FILE = "Shortcuts";
    public static final String DEFAULT_KEYS_FILE = "Default";
    public static final String USER_KEYS_FILE = "UserDefined";
    private static final String KEYS_EXT = "keys";
    static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String XML_SHORTCUTS = "Shortcuts";
    private static final String XML_DESCRIPTION = "Description";
    private static final String XML_BINDING = "Binding";
    private static final String ATTR_DESCRIPTION_NAME = "name";
    private static final String ATTR_BINDING_KEY = "key";
    private static final String ATTR_BINDING_ACTION = "action";
    private static final String PROP_CURRENT_KEYFILE = "current";

    public ShortcutsFolder(DataFolder dataFolder) {
        super(dataFolder);
        this.recreate();
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Action> hashMap = new HashMap<Object, Action>(80);
        int n = 0;
        while (n < instanceCookieArray.length) {
            object3 = instanceCookieArray[n].instanceName();
            object2 = Utilities.stringToKey((String)object3);
            if (object2 == null) {
                ErrorManager.getDefault().getInstance("org.netbeans.core.ShortcutsFolder").log("Warning: unparsable keystroke: " + (String)object3);
            } else {
                object = (Action)instanceCookieArray[n].instanceCreate();
                hashMap.put(object2, (Action)object);
            }
            ++n;
        }
        object3 = TopManager.getDefault().getGlobalKeymap();
        object3.removeBindings();
        if (object3 instanceof NbKeymap) {
            ((NbKeymap)object3).addActionForKeyStrokeMap(hashMap);
        } else {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (KeyStroke)object2.next();
                object3.addActionForKeyStroke((KeyStroke)object, (Action)hashMap.get(object));
            }
        }
        return null;
    }

    protected InstanceCookie acceptDataObject(DataObject dataObject) {
        InstanceCookie instanceCookie = super.acceptDataObject(dataObject);
        if (instanceCookie != null) {
            try {
                Object object = instanceCookie.instanceCreate();
                if (object instanceof Action) {
                    KeyActionPair keyActionPair = new KeyActionPair(dataObject.getName(), (Action)object);
                    return keyActionPair;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
            }
        }
        return null;
    }

    static String getKeyStrokeName(KeyStroke keyStroke) {
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action action = keymap.getAction(keyStroke);
        if (action instanceof SystemAction) {
            String string = ((SystemAction)action).getName();
            string = Utilities.replaceString((String)string, (String)"&", (String)"");
            string = Utilities.replaceString((String)string, (String)"...", (String)"");
            return ShortcutsFolder.getKeyText(keyStroke) + " [" + string + "]";
        }
        if (action == null) {
            return ShortcutsFolder.getKeyText(keyStroke);
        }
        return ShortcutsFolder.getKeyText(keyStroke) + " [" + action.getValue("Name") + "]";
    }

    static String getActionName(SystemAction systemAction) {
        String string = Utilities.replaceString((String)systemAction.getName(), (String)"&", (String)"");
        string = Utilities.replaceString((String)string, (String)"...", (String)"");
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction((Action)systemAction);
        if (keyStrokeArray.length > 0) {
            string = string + " [";
            int n = 0;
            while (n < keyStrokeArray.length) {
                string = string + ShortcutsFolder.getKeyText(keyStrokeArray[n]);
                if (n != keyStrokeArray.length - 1) {
                    string = string + ", ";
                }
                ++n;
            }
            return string + "]";
        }
        return string;
    }

    static String getKeyText(int n, int n2) {
        String string = KeyEvent.getKeyModifiersText(n2);
        if ("".equals(string)) {
            return KeyEvent.getKeyText(n);
        }
        if (n == 18 || n == 65406 || n == 17 || n == 16) {
            return string + "+";
        }
        return string + "+" + KeyEvent.getKeyText(n);
    }

    static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    static Document parseKeysFile(URL uRL) throws SAXException, IOException {
        return XMLDataObject.parse((URL)uRL, (ErrorHandler)new ErrorHandler(){

            public void error(SAXParseException sAXParseException) {
            }

            public void warning(SAXParseException sAXParseException) {
            }

            public void fatalError(SAXParseException sAXParseException) {
            }
        });
    }

    private static void transformOldFiles() {
        try {
            Object object;
            FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
            boolean bl = false;
            HashMap<Object, FileObject> hashMap = new HashMap<Object, FileObject>(11);
            FileObject fileObject = fileSystem.find("Shortcuts", USER_KEYS_FILE, KEYS_EXT);
            if (fileObject == null) {
                bl = true;
                fileObject = fileSystem.find("Shortcuts", DEFAULT_KEYS_FILE, KEYS_EXT);
            }
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)"Shortcuts");
            FileObject[] fileObjectArray = fileObject2.getChildren();
            int n = 0;
            while (n < fileObjectArray.length) {
                object = fileObjectArray[n].getName();
                if (fileObjectArray[n].hasExt(KEYS_EXT) && !((String)object).equals(DEFAULT_KEYS_FILE) && !((String)object).equals(USER_KEYS_FILE)) {
                    hashMap.put(object, fileObjectArray[n]);
                }
                ++n;
            }
            if (!bl && (object = fileSystem.find("Shortcuts", "Shortcuts", "properties")) != null) {
                Properties properties = new Properties();
                try {
                    properties.load(object.getInputStream());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                Enumeration enumeration = ((Hashtable)properties).keys();
                while (enumeration.hasMoreElements()) {
                    hashMap.remove(enumeration.nextElement());
                }
            }
            object = ShortcutsFolder.processKeysFiles(fileObject, hashMap.values());
            ShortcutsFolder.installBindings((HashMap)object);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public static void installBindings(HashMap hashMap) throws IOException {
        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Shortcuts");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            KeyStroke keyStroke = (KeyStroke)iterator.next();
            Action action = (Action)hashMap.get(keyStroke);
            String string = Utilities.keyToString((KeyStroke)keyStroke);
            InstanceDataObject instanceDataObject = InstanceDataObject.find((DataFolder)dataFolder, (String)string, clazz = action.getClass());
            if (instanceDataObject != null) continue;
            InstanceDataObject.create((DataFolder)dataFolder, (String)string, clazz);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap processKeysFiles(FileObject fileObject, Collection collection) {
        FileLock fileLock;
        HashMap hashMap;
        block11: {
            hashMap = new HashMap(79);
            fileLock = null;
            if (fileObject != null) {
                try {
                    Object var6_4;
                    try {
                        fileLock = fileObject.lock();
                        ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(fileObject.getURL()), hashMap);
                        fileObject.delete(fileLock);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        var6_4 = null;
                        fileLock.releaseLock();
                        break block11;
                    }
                    var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
            }
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object var8_11;
            try {
                try {
                    FileObject fileObject2 = (FileObject)iterator.next();
                    fileLock = fileObject2.lock();
                    ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(fileObject2.getURL()), hashMap);
                    fileObject2.delete(fileLock);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    var8_11 = null;
                    fileLock.releaseLock();
                    continue;
                }
                var8_11 = null;
            }
            catch (Throwable throwable) {
                var8_11 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
        }
        return hashMap;
    }

    private static void addBindings(Document document, HashMap hashMap) {
        NodeList nodeList = document.getElementsByTagName(XML_BINDING);
        int n = 0;
        while (n < nodeList.getLength()) {
            block5: {
                String string = "<unknown>";
                try {
                    String string2 = nodeList.item(n).getAttributes().getNamedItem(ATTR_BINDING_KEY).getNodeValue();
                    string = nodeList.item(n).getAttributes().getNamedItem(ATTR_BINDING_ACTION).getNodeValue();
                    KeyStroke keyStroke = Utilities.stringToKey((String)string2);
                    SystemAction systemAction = SystemAction.get(Class.forName(string, true, TopManager.getDefault().systemClassLoader()));
                    hashMap.put(keyStroke, systemAction);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        System.err.println("Warning: action " + string + " not found to add key binding for.");
                    }
                }
                catch (Exception exception) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    public static void initShortcuts() {
        ShortcutsFolder.transformOldFiles();
        DataFolder dataFolder = NbPlaces.findSessionFolder("Shortcuts");
        shortcutsFolder = new ShortcutsFolder(dataFolder);
        shortcutsFolder.recreate();
    }

    public static void refreshGlobalMap() {
        if (shortcutsFolder != null) {
            shortcutsFolder.recreate();
        }
    }

    public static void applyChanges(List list) {
        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Shortcuts");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ChangeRequest changeRequest = (ChangeRequest)listIterator.next();
            try {
                if (changeRequest.add) {
                    if (InstanceDataObject.find((DataFolder)dataFolder, (String)changeRequest.instanceName(), (Class)changeRequest.instanceClass()) != null) continue;
                    InstanceDataObject.create((DataFolder)dataFolder, (String)changeRequest.instanceName(), (Class)changeRequest.instanceClass());
                    continue;
                }
                InstanceDataObject.remove((DataFolder)dataFolder, (String)changeRequest.instanceName(), (Class)changeRequest.instanceClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    static class ChangeRequest
    extends KeyActionPair {
        public boolean add;

        public ChangeRequest(KeyStroke keyStroke, Action action, boolean bl) {
            super(Utilities.keyToString((KeyStroke)keyStroke), action);
            this.add = bl;
        }
    }

    private static class KeyActionPair
    implements InstanceCookie {
        private String name;
        private Action action;

        public KeyActionPair(String string, Action action) {
            this.name = string;
            this.action = action;
        }

        public String instanceName() {
            return this.name;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.action.getClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.action;
        }
    }
}

