/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.netbeans.core.NonGui;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.util.NbBundle;

public class TopLogging {
    public static final String LOG_FILE_NAME = "ide.log";
    private static boolean disabledConsole = true;
    private PrintStream logPrintStream;
    private static TopLogging topLogging;
    private static final long LOG_MAX_SIZE;
    private static final int LOG_COUNT;
    static /* synthetic */ Class class$org$netbeans$core$TopLogging;

    public TopLogging(String string) throws IOException {
        topLogging = this;
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot make directory to contain log file");
        }
        File file2 = TopLogging.createLogFile(file, LOG_FILE_NAME);
        if (file2.exists() && !file2.canWrite() || file2.isDirectory()) {
            throw new IOException("Cannot write to file");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        Date date = new Date();
        disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
        this.logPrintStream = new PrintStream(new StreamDemultiplexor(System.err, randomAccessFile));
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        this.logPrintStream.println(">Log Session: " + dateFormat.format(date));
        this.logPrintStream.println(">System Info: ");
        TopLogging.printSystemInfo(this.logPrintStream);
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        System.setErr(this.logPrintStream);
    }

    private static TopLogging getDefault() {
        if (topLogging == null) {
            try {
                new TopLogging(NonGui.getSystemDir());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return topLogging;
    }

    private static File createLogFile(File file, String string) {
        long l = 0L;
        File file2 = null;
        File file3 = new File(file, string);
        if (!file3.exists() || file3.length() < LOG_MAX_SIZE) {
            return file3;
        }
        int n = 1;
        while (n < LOG_COUNT) {
            String string2 = string + "." + n;
            File file4 = new File(file, string2);
            if (!file4.exists()) {
                file2 = file4;
                break;
            }
            long l2 = file4.lastModified();
            if ((l == 0L || l2 < l) && l2 > 0L) {
                l = l2;
                file2 = file4;
            }
            ++n;
        }
        if (file2 != null) {
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
        }
        return file3;
    }

    private static String extractJITName() {
        String string = System.getProperty("java.compiler");
        if (string == null || "".equals(string)) {
            return null;
        }
        if (string.equals("symcjit")) {
            String string2 = System.getProperty("file.separator");
            String string3 = System.getProperty("java.home") + string2;
            String string4 = string3 + "bin" + string2 + "java nonexistent";
            String[] stringArray = new String[]{"JAVA_COMPCMD=FORCE_SIGNON"};
            try {
                Process process = Runtime.getRuntime().exec(string4, stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                process.waitFor();
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                if (string5 != null) {
                    String string6 = "Symantec Java! JustInTime Compiler Version ";
                    string = string5.startsWith(string6) ? "Symantec, version " + string5.substring(string6.length()) : string5;
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void printSystemInfo(PrintStream printStream) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$TopLogging == null ? (class$org$netbeans$core$TopLogging = TopLogging.class$("org.netbeans.core.TopLogging")) : class$org$netbeans$core$TopLogging));
        String string = System.getProperty("netbeans.buildnumber");
        String string2 = new MessageFormat(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$TopLogging == null ? (class$org$netbeans$core$TopLogging = TopLogging.class$("org.netbeans.core.TopLogging")) : class$org$netbeans$core$TopLogging).getClassLoader()).getString("currentVersion")).format(new Object[]{string});
        printStream.println("  Product Version       = " + string2);
        printStream.println("  IDE Versioning        = " + System.getProperty("org.openide.major.version") + " spec=" + System.getProperty("org.openide.specification.version") + " impl=" + System.getProperty("org.openide.version"));
        printStream.println("  Operating System      = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor      = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        printStream.println("  Java Home             = " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encod. = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        String string4 = TopLogging.extractJITName();
        if (string4 != null) {
            printStream.println("  JIT                   = " + string4);
        }
        printStream.println("  Home Dir; Current Dir = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        printStream.println("  IDE Install; User Dir = " + NonGui.getHomeDir() + "; " + NonGui.getUserDir());
        printStream.println("  CLASSPATH             = " + System.getProperty("java.class.path", "unknown"));
        printStream.println("  Boot & ext classpath  = " + NbClassPath.createBootClassPath().getClassPath());
    }

    public void finalize() throws Throwable {
        this.logPrintStream.flush();
        this.logPrintStream.close();
    }

    static PrintStream getLogOutputStream() {
        return TopLogging.getDefault().logPrintStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOG_MAX_SIZE = Long.getLong("org.netbeans.core.TopLogging.LOG_MAX_SIZE", 262144L);
        LOG_COUNT = Integer.getInteger("org.netbeans.core.TopLogging.LOG_COUNT", 3);
    }

    class StreamDemultiplexor
    extends OutputStream {
        private PrintStream stderr;
        private RandomAccessFile log;

        StreamDemultiplexor(PrintStream printStream, RandomAccessFile randomAccessFile) {
            this.stderr = printStream;
            this.log = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.log.write(n);
            if (!disabledConsole) {
                this.stderr.write(n);
            }
        }

        public void write(byte[] byArray) throws IOException {
            this.log.write(byArray);
            if (!disabledConsole) {
                ((FilterOutputStream)this.stderr).write(byArray);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.log.write(byArray, n, n2);
            if (!disabledConsole) {
                this.stderr.write(byArray, n, n2);
            }
        }

        public void flush() throws IOException {
            this.log.getFD().sync();
            this.stderr.flush();
        }

        public void close() throws IOException {
            this.log.close();
            this.stderr.close();
        }
    }
}

