/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.awt.ButtonBarButton;
import org.openide.util.NbBundle;

public class ButtonBar
extends JPanel {
    static final long serialVersionUID = -5909692079369563652L;
    public static final int EMPTY = 0;
    public static final int OK_CANCEL = 1;
    public static final int CLOSE = 2;
    public static final int YES_NO = 3;
    public static final int YES_NO_CANCEL = 4;
    public static final int DETAILS_CLOSE = 5;
    public static final Color DEFAULT_FOREGROUND = new Color(200, 200, 255);
    public static final Color DEFAULT_BACKGROUND = Color.blue.darker().darker();
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 18);
    public static final int SINGLE_RIGHT = 0;
    public static final int SINGLE_LEFT = 1;
    public static final int SINGLE_CENTER = 2;
    public static final int BUTTONS_GAP = 6;
    public static final int SECTIONS_GAP = 40;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private ButtonBarButton defaultButton;
    private boolean peerExist;
    private int orientation;
    private ButtonBarButton[] rightButtons;
    private ButtonBarButton[] leftButtons;
    private int singleMode = 0;
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$org$netbeans$core$awt$ButtonBar;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int n) {
        this(n, 0);
    }

    public ButtonBar(int n, int n2) {
        this.orientation = n2;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = "";
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$awt$ButtonBar == null ? (class$org$netbeans$core$awt$ButtonBar = ButtonBar.class$("org.netbeans.core.awt.ButtonBar")) : class$org$netbeans$core$awt$ButtonBar));
        switch (n) {
            case 1: {
                stringArray2 = new String[]{resourceBundle.getString("OKButton"), resourceBundle.getString("CancelButton")};
                string = stringArray2[0];
                break;
            }
            case 2: {
                stringArray2 = new String[]{resourceBundle.getString("CloseButton")};
                string = stringArray2[0];
                break;
            }
            case 3: {
                stringArray2 = new String[]{resourceBundle.getString("YesButton"), resourceBundle.getString("NoButton")};
                string = stringArray2[0];
                break;
            }
            case 4: {
                stringArray2 = new String[]{resourceBundle.getString("YesButton"), resourceBundle.getString("NoButton"), resourceBundle.getString("CancelButton")};
                string = stringArray2[0];
                break;
            }
            case 5: {
                stringArray = new String[]{resourceBundle.getString("DetailsButton")};
                stringArray2 = new String[]{resourceBundle.getString("CloseButton")};
                string = stringArray2[0];
                break;
            }
        }
        this.initButtons(stringArray, stringArray2, string);
    }

    public ButtonBar(String[] stringArray, String[] stringArray2) {
        this(stringArray, stringArray2, "", 0);
    }

    public ButtonBar(String[] stringArray, String[] stringArray2, String string) {
        this(stringArray, stringArray2, string, 0);
    }

    public ButtonBar(String[] stringArray, String[] stringArray2, String string, int n) {
        this.orientation = n;
        this.initButtons(stringArray, stringArray2, string);
    }

    public ButtonBar(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2) {
        this(buttonBarButtonArray, buttonBarButtonArray2, 0);
    }

    public ButtonBar(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2, int n) {
        this.orientation = n;
        this.initButtons(buttonBarButtonArray, buttonBarButtonArray2);
    }

    public ButtonBar(ButtonBarButton[] buttonBarButtonArray) {
        this(null, buttonBarButtonArray, 0);
    }

    private void initButtons(String[] stringArray, String[] stringArray2, String string) {
        int n;
        ButtonBarButton[] buttonBarButtonArray = null;
        ButtonBarButton[] buttonBarButtonArray2 = null;
        if (stringArray != null) {
            buttonBarButtonArray = new ButtonBarButton[stringArray.length];
            n = 0;
            while (n < stringArray.length) {
                buttonBarButtonArray[n] = new ButtonBarButton(stringArray[n]);
                if (stringArray[n].equals(string)) {
                    this.setDefaultButton(buttonBarButtonArray[n]);
                }
                ++n;
            }
        }
        if (stringArray2 != null) {
            buttonBarButtonArray2 = new ButtonBarButton[stringArray2.length];
            n = 0;
            while (n < stringArray2.length) {
                buttonBarButtonArray2[n] = new ButtonBarButton(stringArray2[n]);
                if (stringArray2[n].equals(string)) {
                    this.setDefaultButton(buttonBarButtonArray2[n]);
                }
                ++n;
            }
        }
        this.initButtons(buttonBarButtonArray, buttonBarButtonArray2);
    }

    private void initButtons(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2) {
        int n;
        this.setBorder(new EmptyBorder(17, 12, 11, 11));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ButtonBarLayout());
        if (buttonBarButtonArray == null || buttonBarButtonArray.length == 0) {
            this.leftButtons = new ButtonBarButton[0];
        } else {
            this.leftButtons = new ButtonBarButton[buttonBarButtonArray.length];
            n = 0;
            while (n < buttonBarButtonArray.length) {
                this.leftButtons[n] = buttonBarButtonArray[n];
                this.leftButtons[n].attachButton(this);
                jPanel.add(this.leftButtons[n]);
                ++n;
            }
        }
        if (buttonBarButtonArray2 == null || buttonBarButtonArray2.length == 0) {
            this.rightButtons = new ButtonBarButton[0];
        } else {
            this.rightButtons = new ButtonBarButton[buttonBarButtonArray2.length];
            n = 0;
            while (n < buttonBarButtonArray2.length) {
                this.rightButtons[n] = buttonBarButtonArray2[n];
                this.rightButtons[n].attachButton(this);
                jPanel.add(this.rightButtons[n]);
                ++n;
            }
        }
        this.add((Component)jPanel, "Center");
    }

    public void setButtons(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2) {
        this.setButtons(buttonBarButtonArray, buttonBarButtonArray2, 0);
    }

    public void setButtons(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2, int n) {
        this.orientation = n;
        this.initButtons(buttonBarButtonArray, buttonBarButtonArray2);
        this.invalidate();
        this.repaint();
    }

    public void setButtons(String[] stringArray, String[] stringArray2) {
        this.setButtons(stringArray, stringArray2, 0);
    }

    public void setButtons(String[] stringArray, String[] stringArray2, int n) {
        this.orientation = n;
        this.initButtons(stringArray, stringArray2, "");
        this.invalidate();
        this.repaint();
    }

    public synchronized void addButtonBarListener(ButtonBarListener buttonBarListener) {
        this.listeners.addElement(buttonBarListener);
    }

    public synchronized void removeButtonBarListener(ButtonBarListener buttonBarListener) {
        this.listeners.removeElement(buttonBarListener);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        super.paint(graphics);
    }

    public int getButtonIndex(ButtonBarButton buttonBarButton) {
        if (buttonBarButton == null) {
            return -1;
        }
        int n = 0;
        while (n < this.leftButtons.length) {
            if (this.leftButtons[n].equals(buttonBarButton)) {
                return n;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.rightButtons.length) {
            if (this.rightButtons[n2].equals(buttonBarButton)) {
                return this.leftButtons.length + n2;
            }
            ++n2;
        }
        return -1;
    }

    public ButtonBarButton getButton(int n) {
        if (n < 0 || n >= this.leftButtons.length + this.rightButtons.length) {
            return null;
        }
        return n >= this.leftButtons.length ? this.rightButtons[n - this.leftButtons.length] : this.leftButtons[n];
    }

    public void setDefaultButton(int n) {
        this.setDefaultButton(this.getButton(n));
    }

    public void setDefaultButton(final ButtonBarButton buttonBarButton) {
        if (!this.peerExist) {
            this.defaultButton = buttonBarButton;
            return;
        }
        if (this.defaultButton != buttonBarButton) {
            ButtonBarButton buttonBarButton2 = this.defaultButton;
            this.defaultButton = buttonBarButton;
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof JRootPane) {
                    ((JRootPane)container).setDefaultButton(buttonBarButton);
                    break;
                }
                container = container.getParent();
            }
            if (container == null) {
                container = this;
            }
            if (buttonBarButton2 != null) {
                ((JComponent)container).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
                ((JComponent)container).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            }
            if (buttonBarButton != null) {
                final boolean[] blArray = new boolean[]{true};
                ((JComponent)container).registerKeyboardAction(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (buttonBarButton.isEnabled() && blArray[0]) {
                            ButtonBar.this.buttonPressed(buttonBarButton, 0);
                        }
                    }
                }, KeyStroke.getKeyStroke(10, 0, true), 2);
            }
            this.repaint();
        }
    }

    protected void buttonPressed(ButtonBarButton buttonBarButton, int n) {
        Vector vector;
        ButtonBarEvent buttonBarEvent = new ButtonBarEvent(this, buttonBarButton, 1001, buttonBarButton.getText(), n);
        ButtonBar buttonBar = this;
        synchronized (buttonBar) {
            vector = (Vector)this.listeners.clone();
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            ((ButtonBarListener)vector.elementAt(n3)).buttonPressed(buttonBarEvent);
            ++n3;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.peerExist = true;
        if (this.defaultButton != null) {
            ButtonBarButton buttonBarButton = this.defaultButton;
            this.defaultButton = null;
            this.setDefaultButton(buttonBarButton);
        }
    }

    public void removeNotify() {
        if (this.defaultButton != null) {
            ButtonBarButton buttonBarButton = this.defaultButton;
            this.setDefaultButton(null);
            this.defaultButton = buttonBarButton;
        }
        super.removeNotify();
        this.peerExist = false;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ButtonBarEvent
    extends ActionEvent {
        static final long serialVersionUID = 5361326502523278662L;
        private ButtonBarButton sourceButton;

        public ButtonBarEvent(ButtonBar buttonBar, ButtonBarButton buttonBarButton, int n, String string, int n2) {
            super(buttonBar, n, string, n2);
            this.sourceButton = buttonBarButton;
        }

        public ButtonBarButton getButton() {
            return this.sourceButton;
        }
    }

    public static interface ButtonBarListener {
        public void buttonPressed(ButtonBarEvent var1);
    }

    class ButtonBarLayout
    implements LayoutManager {
        ButtonBarLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            if (ButtonBar.this.leftButtons.length == 0 && ButtonBar.this.rightButtons.length == 0) {
                return dimension;
            }
            Dimension dimension2 = this.countMaxSize(ButtonBar.this.leftButtons, ButtonBar.this.rightButtons);
            if (ButtonBar.this.orientation == 0) {
                dimension.height = dimension2.height;
                dimension.width += dimension2.width * (ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length);
                if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                    dimension.width += 40;
                }
                if (ButtonBar.this.leftButtons.length > 1) {
                    dimension.width += 6 * (ButtonBar.this.leftButtons.length - 1);
                }
                if (ButtonBar.this.rightButtons.length > 1) {
                    dimension.width += 6 * (ButtonBar.this.rightButtons.length - 1);
                }
            } else {
                dimension.height = dimension2.height * (ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length);
                dimension.width += dimension2.width;
                if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                    dimension.height += 40;
                }
                if (ButtonBar.this.rightButtons.length > 1) {
                    dimension.height += 6 * (ButtonBar.this.rightButtons.length - 1);
                }
                if (ButtonBar.this.leftButtons.length > 1) {
                    dimension.height += 6 * (ButtonBar.this.leftButtons.length - 1);
                }
            }
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            if (ButtonBar.this.leftButtons.length == 0 && ButtonBar.this.rightButtons.length == 0) {
                return;
            }
            Dimension dimension = container.getSize();
            Dimension dimension2 = this.countMaxSize(ButtonBar.this.leftButtons, ButtonBar.this.rightButtons);
            int n = ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length;
            if (ButtonBar.this.orientation == 0) {
                if (dimension2.width * n + 6 * (n - 1) > dimension.width) {
                    dimension2.width = (dimension.width - 6 * (n - 1)) / n;
                }
            } else if (dimension2.height * n + 6 * (n - 1) > dimension.height) {
                dimension2.height = (dimension.height - 6 * (n - 1)) / n;
            }
            int n2 = 6 + (ButtonBar.this.orientation == 0 ? dimension2.width : dimension2.height);
            if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                if (ButtonBar.this.orientation == 0) {
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < ButtonBar.this.leftButtons.length) {
                        ButtonBar.this.leftButtons[n4].setBounds(new Rectangle(n3, 0, dimension2.width, dimension2.height));
                        ButtonBar.this.leftButtons[n4].setSize(dimension2);
                        n3 += n2;
                        ++n4;
                    }
                    n3 = dimension.width - dimension2.width;
                    int n5 = ButtonBar.this.rightButtons.length - 1;
                    while (n5 >= 0) {
                        ButtonBar.this.rightButtons[n5].setBounds(new Rectangle(n3, 0, dimension2.width, dimension2.height));
                        ButtonBar.this.rightButtons[n5].setSize(dimension2);
                        n3 -= n2;
                        --n5;
                    }
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < ButtonBar.this.rightButtons.length) {
                        ButtonBar.this.rightButtons[n7].setBounds(new Rectangle(0, n6, dimension2.width, dimension2.height));
                        ButtonBar.this.rightButtons[n7].setSize(dimension2);
                        n6 += n2;
                        ++n7;
                    }
                    n6 = dimension.height - dimension2.height;
                    int n8 = ButtonBar.this.leftButtons.length - 1;
                    while (n8 >= 0) {
                        ButtonBar.this.leftButtons[n8].setBounds(new Rectangle(0, n6, dimension2.width, dimension2.height));
                        ButtonBar.this.leftButtons[n8].setSize(dimension2);
                        n6 -= n2;
                        --n8;
                    }
                }
            } else {
                ButtonBarButton[] buttonBarButtonArray;
                ButtonBarButton[] buttonBarButtonArray2 = buttonBarButtonArray = ButtonBar.this.leftButtons.length > 0 ? ButtonBar.this.leftButtons : ButtonBar.this.rightButtons;
                if (ButtonBar.this.singleMode == 2) {
                    if (ButtonBar.this.orientation == 0) {
                        int n9 = (dimension.width - (n2 * buttonBarButtonArray.length - 6)) / 2;
                        int n10 = 0;
                        while (n10 < buttonBarButtonArray.length) {
                            buttonBarButtonArray[n10].setBounds(new Rectangle(n9, 0, dimension2.width, dimension2.height));
                            n9 += n2;
                            ++n10;
                        }
                    } else {
                        int n11 = (dimension.height - (n2 * buttonBarButtonArray.length - 6)) / 2;
                        int n12 = 0;
                        while (n12 < buttonBarButtonArray.length) {
                            buttonBarButtonArray[n12].setBounds(new Rectangle(0, n11, dimension2.width, dimension2.height));
                            n11 += n2;
                            ++n12;
                        }
                    }
                } else if (ButtonBar.this.singleMode == 1) {
                    if (ButtonBar.this.orientation == 0) {
                        int n13 = 0;
                        int n14 = 0;
                        while (n14 < buttonBarButtonArray.length) {
                            buttonBarButtonArray[n14].setBounds(new Rectangle(n13, 0, dimension2.width, dimension2.height));
                            buttonBarButtonArray[n14].setSize(dimension2);
                            n13 += n2;
                            ++n14;
                        }
                    } else {
                        int n15 = dimension.height - dimension2.height;
                        int n16 = buttonBarButtonArray.length - 1;
                        while (n16 >= 0) {
                            buttonBarButtonArray[n16].setBounds(new Rectangle(0, n15, dimension2.width, dimension2.height));
                            buttonBarButtonArray[n16].setSize(dimension2);
                            n15 -= n2;
                            --n16;
                        }
                    }
                } else if (ButtonBar.this.orientation == 0) {
                    int n17 = dimension.width - dimension2.width;
                    int n18 = buttonBarButtonArray.length - 1;
                    while (n18 >= 0) {
                        buttonBarButtonArray[n18].setBounds(new Rectangle(n17, 0, dimension2.width, dimension2.height));
                        buttonBarButtonArray[n18].setSize(dimension2);
                        n17 -= n2;
                        --n18;
                    }
                } else {
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < buttonBarButtonArray.length) {
                        buttonBarButtonArray[n20].setBounds(new Rectangle(0, n19, dimension2.width, dimension2.height));
                        buttonBarButtonArray[n20].setSize(dimension2);
                        n19 += n2;
                        ++n20;
                    }
                }
            }
        }

        private Dimension countMaxSize(ButtonBarButton[] buttonBarButtonArray, ButtonBarButton[] buttonBarButtonArray2) {
            Dimension dimension = this.countMaxSize(buttonBarButtonArray);
            Dimension dimension2 = this.countMaxSize(buttonBarButtonArray2);
            return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        }

        private Dimension countMaxSize(ButtonBarButton[] buttonBarButtonArray) {
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            while (n < buttonBarButtonArray.length) {
                Dimension dimension2 = buttonBarButtonArray[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            return dimension;
        }
    }
}

