/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.core.awt.TabControl;

public class PageControl
extends Panel
implements Serializable {
    static final long serialVersionUID = 4648659103970803518L;
    protected static final int margin = 1;
    protected Vector pages;
    protected TabControl tab;
    private Dimension dimLast = null;
    private transient Vector indexListeners = new Vector();
    PageFocusListener focusListener = new PageFocusListener();

    public PageControl() {
        this.setLayout(new BorderLayout());
        this.tab = new TabControl();
        this.add((Component)this.tab, "North");
        this.validate();
        this.pages = new Vector();
        this.dimLast = new Dimension(0, 0);
        this.tab.addIndexChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedIndex")) {
                    int n = (Integer)propertyChangeEvent.getOldValue();
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    int n3 = 0;
                    while (n3 < PageControl.this.tab.getTabCount()) {
                        if (n3 == n2) {
                            ((Component)PageControl.this.pages.elementAt(n3)).setVisible(true);
                        } else {
                            ((Component)PageControl.this.pages.elementAt(n3)).setVisible(false);
                        }
                        ++n3;
                    }
                    PageControl.this.fireIndexChange(n, n2);
                }
            }
        });
    }

    public synchronized void setSelectedIndex(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = this.tab.getSelectedIndex();
        if (n2 != n) {
            this.tab.setSelectedIndex(n);
            ((Component)this.pages.elementAt(n2)).setVisible(false);
            ((Component)this.pages.elementAt(n)).setVisible(true);
        }
        this.fireIndexChange(n2, n);
    }

    public int getSelectedIndex() {
        return this.tab.getSelectedIndex();
    }

    public int getTabCount() {
        return this.tab.getTabCount();
    }

    public String getTabLabel(int n) throws ArrayIndexOutOfBoundsException {
        return this.tab.getTabLabel(n);
    }

    public synchronized void addPage(String string, Component component) {
        int n = this.tab.getTabCount();
        this.addPageAt(string, component, n);
    }

    public synchronized void addPageAt(String string, Component component, int n) throws ArrayIndexOutOfBoundsException {
        this.pages.insertElementAt(component, n);
        this.add(component, "Center");
        this.tab.addTabAt(string, n);
        this.validate();
        this.countSizes();
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            this.setSelectedIndex(n);
            n2 = n;
        }
        int n3 = 0;
        while (n3 < this.tab.getTabCount()) {
            if (n3 != n2) {
                ((Component)this.pages.elementAt(n3)).setVisible(false);
            } else {
                ((Component)this.pages.elementAt(n3)).setVisible(true);
            }
            ++n3;
        }
        this.registerListeners(component);
    }

    public synchronized int getIndexOfPage(Component component) {
        int n = 0;
        while (n < this.tab.getTabCount()) {
            if (component.equals(this.pages.elementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Component getPageAt(int n) throws ArrayIndexOutOfBoundsException {
        return (Component)this.pages.elementAt(n);
    }

    public synchronized void removePageAt(int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        boolean bl = false;
        if (n == this.tab.getSelectedIndex()) {
            bl = true;
        }
        Component component = (Component)this.pages.elementAt(n);
        this.remove(component);
        this.unregisterListeners(component);
        this.pages.removeElementAt(n);
        this.tab.removeTabAt(n);
        if (bl && (n2 = this.getSelectedIndex()) != -1) {
            ((Component)this.pages.elementAt(n2)).setVisible(true);
        }
        this.repaint();
    }

    public synchronized void removeAllPages() {
        this.tab.removeAllTabs();
        int n = 0;
        while (n < this.pages.size()) {
            Component component = (Component)this.pages.elementAt(n);
            this.remove(component);
            this.unregisterListeners(component);
            ++n;
        }
        this.pages.removeAllElements();
        this.repaint();
    }

    public void setDirection(boolean bl) {
        if (this.tab.getDirection() != bl) {
            this.tab.setDirection(bl);
            this.remove(this.tab);
            if (this.tab.getDirection()) {
                this.add((Component)this.tab, "North");
            } else {
                this.add((Component)this.tab, "South");
            }
            this.countSizes();
            this.repaint();
        }
    }

    public boolean getDirection() {
        return this.tab.getDirection();
    }

    private void countSizes() {
        int n;
        int n2;
        Dimension dimension;
        Dimension dimension2 = this.tab.getPreferredSize();
        this.dimLast = dimension = this.getSize();
        Dimension dimension3 = this.tab.getSize();
        if (dimension3 != dimension2) {
            this.tab.setSize(dimension.width, dimension2.height);
        }
        if (this.tab.getDirection()) {
            if (this.tab.getLocation().x != 0 || this.tab.getLocation().y != 0) {
                this.tab.setLocation(0, 0);
            }
            n2 = 1;
            n = dimension2.height;
        } else {
            if (this.tab.getLocation().x != 0 || this.tab.getLocation().y != dimension.height - dimension2.height) {
                this.tab.setLocation(0, dimension.height - dimension2.height);
            }
            n2 = 1;
            n = 1;
        }
        int n3 = dimension.width - 2;
        int n4 = dimension.height - dimension2.height - 2;
        int n5 = 0;
        while (n5 < this.getTabCount()) {
            Component component = (Component)this.pages.elementAt(n5);
            component.setBounds(n2, n, n3, n4);
            component.validate();
            ++n5;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension != this.dimLast) {
            this.countSizes();
        }
        if (this.tab.getTabCount() > 0) {
            int n = 0;
            int n2 = dimension.width - 1;
            int n3 = dimension.height - this.tab.getSize().height + 1 - 1;
            int n4 = 0;
            if (this.tab.getDirection()) {
                n4 = this.tab.getSize().height - 1;
            }
            graphics.setColor(SystemColor.controlHighlight);
            int n5 = 0;
            while (n5 < 1) {
                graphics.draw3DRect(n, n4, n2, n3, true);
                ++n;
                ++n4;
                n2 -= 2;
                n3 -= 2;
                ++n5;
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.countSizes();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.countSizes();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.countSizes();
    }

    public Dimension getMinimumSize() {
        return this.countSize(true);
    }

    public Dimension getPreferredSize() {
        return this.countSize(false);
    }

    private Dimension countSize(boolean bl) {
        Dimension dimension = bl ? this.tab.getMinimumSize() : this.tab.getPreferredSize();
        Dimension dimension2 = new Dimension(0, 0);
        int n = 0;
        while (n < this.tab.getTabCount()) {
            Dimension dimension3;
            Component component = (Component)this.pages.elementAt(n);
            Dimension dimension4 = dimension3 = bl ? component.getMinimumSize() : component.getPreferredSize();
            if (dimension2.width < dimension3.width) {
                dimension2.width = dimension3.width;
            }
            if (dimension2.height < dimension3.height) {
                dimension2.height = dimension3.height;
            }
            ++n;
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
    }

    public void addIndexChangeListener(PropertyChangeListener propertyChangeListener) {
        this.indexListeners.addElement(propertyChangeListener);
    }

    public void removeIndexChangeListener(PropertyChangeListener propertyChangeListener) {
        this.indexListeners.removeElement(propertyChangeListener);
    }

    protected void fireIndexChange(int n, int n2) {
        Vector vector = (Vector)this.indexListeners.clone();
        Enumeration enumeration = vector.elements();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "selectedIndex", new Integer(n), new Integer(n2));
        while (enumeration.hasMoreElements()) {
            ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
        }
    }

    private void registerListeners(Component component) {
        component.addFocusListener(this.focusListener);
    }

    private void unregisterListeners(Component component) {
        component.removeFocusListener(this.focusListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.pages);
        objectOutputStream.writeObject(this.tab);
        objectOutputStream.writeObject(this.dimLast);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.pages = (Vector)objectInputStream.readObject();
            this.tab = (TabControl)objectInputStream.readObject();
            this.dimLast = (Dimension)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
        this.indexListeners = new Vector();
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.tab.addIndexChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedIndex")) {
                    int n = (Integer)propertyChangeEvent.getOldValue();
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    int n3 = 0;
                    while (n3 < PageControl.this.tab.getTabCount()) {
                        if (n3 == n2) {
                            ((Component)PageControl.this.pages.elementAt(n3)).setVisible(true);
                        } else {
                            ((Component)PageControl.this.pages.elementAt(n3)).setVisible(false);
                        }
                        ++n3;
                    }
                    PageControl.this.fireIndexChange(n, n2);
                }
            }
        });
    }

    private class PageFocusListener
    implements FocusListener {
        private PageFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            int n = PageControl.this.getIndexOfPage(component);
            if (n != -1) {
                PageControl.this.setSelectedIndex(n);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

