/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.netbeans.core.execution.ExecutionEngine;

final class WriterPrintStream
extends PrintStream {
    private boolean stdOut;
    private static String newLine;

    public WriterPrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream, true);
        this.stdOut = bl;
    }

    public void close() {
    }

    public void flush() {
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().flush();
            } else {
                ExecutionEngine.getTaskIOs().getErr().flush();
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private void write(String string) {
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().write(string);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(string);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().write(c);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(c);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().write(cArray);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(cArray);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.print(WriterPrintStream.getNewLine());
    }

    public void println(boolean bl) {
        String string = bl ? "true" : "false";
        this.write(string.concat(WriterPrintStream.getNewLine()));
    }

    public void println(char c) {
        String string = WriterPrintStream.getNewLine();
        int n = string.length();
        char[] cArray = new char[n + 1];
        cArray[0] = c;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2 + 1] = string.charAt(n2);
            ++n2;
        }
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().write(cArray);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(cArray);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void println(int n) {
        this.write(String.valueOf(n).concat(WriterPrintStream.getNewLine()));
    }

    public void println(long l) {
        this.write(String.valueOf(l).concat(WriterPrintStream.getNewLine()));
    }

    public void println(float f) {
        this.write(String.valueOf(f).concat(WriterPrintStream.getNewLine()));
    }

    public void println(double d) {
        this.write(String.valueOf(d).concat(WriterPrintStream.getNewLine()));
    }

    public void println(char[] cArray) {
        String string = WriterPrintStream.getNewLine();
        int n = string.length();
        char[] cArray2 = new char[cArray.length + n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        int n2 = 0;
        while (n2 < n) {
            cArray2[cArray.length + n2] = string.charAt(n2);
            ++n2;
        }
        cArray = null;
        try {
            if (this.stdOut) {
                ExecutionEngine.getTaskIOs().getOut().write(cArray2);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(cArray2);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void println(String string) {
        if (string == null) {
            string = "null";
        }
        this.print(string.concat(WriterPrintStream.getNewLine()));
    }

    public void println(Object object) {
        if (object == null) {
            this.print("null".concat(WriterPrintStream.getNewLine()));
        } else {
            String string = object.toString();
            if (string == null) {
                this.print("<null>".concat(WriterPrintStream.getNewLine()));
            } else {
                this.print(string.concat(WriterPrintStream.getNewLine()));
            }
        }
    }

    private static String getNewLine() {
        if (newLine == null) {
            newLine = System.getProperty("line.separator");
        }
        return newLine;
    }
}

