/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleManager;
import org.openide.util.Utilities;

final class ChangeFirer
extends Thread {
    private final ModuleManager mgr;
    private final Set changes = new HashSet(100);
    private final Set modulesCreated = new HashSet(100);
    private final Set modulesDeleted = new HashSet(10);
    private boolean stop = false;
    private final Runnable doFiring = new DoFiring();

    public ChangeFirer(ModuleManager moduleManager) {
        this.mgr = moduleManager;
        this.setDaemon(true);
    }

    public synchronized void change(Change change) {
        if (this.stop) {
            throw new IllegalStateException("Call to change() while stopped");
        }
        this.changes.add(change);
        this.notify();
        if (!this.isAlive()) {
            this.start();
        }
    }

    public synchronized void created(Module module) {
        if (this.stop) {
            throw new IllegalStateException("Call to created() while stopped");
        }
        this.modulesCreated.add(module);
        this.notify();
        if (!this.isAlive()) {
            this.start();
        }
    }

    public synchronized void deleted(Module module) {
        if (this.stop) {
            throw new IllegalStateException("Call to deleted() while stopped");
        }
        if (!this.modulesCreated.remove((Object)module)) {
            this.modulesDeleted.add(module);
            this.notify();
            if (!this.isAlive()) {
                this.start();
            }
        }
    }

    public synchronized void stopFiring() {
        if (!this.stop) {
            this.stop = true;
            this.notify();
        }
    }

    public void run() {
        while (!this.stop) {
            this.mgr.mutex().readAccess(this.doFiring);
            try {
                ChangeFirer changeFirer = this;
                synchronized (changeFirer) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static final class Change {
        private static int globalCount = 0;
        public final String prop;
        public final Object source;
        public final Object old;
        public final Object nue;
        final int count;

        public Change(Object object, String string, Object object2, Object object3) {
            this.source = object;
            this.prop = string;
            this.old = object2;
            this.nue = object3;
            this.count = globalCount++;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Change)) {
                return false;
            }
            Change change = (Change)object;
            return Utilities.compareObjects((Object)this.prop, (Object)change.prop) && Utilities.compareObjects((Object)this.source, (Object)change.source) && Utilities.compareObjects((Object)this.old, (Object)change.old) && Utilities.compareObjects((Object)this.nue, (Object)change.nue);
        }

        public int hashCode() {
            return this.source.hashCode() ^ (this.prop == null ? 0 : this.prop.hashCode());
        }

        public String toString() {
            return "Change[" + this.source + ":" + this.prop + ";" + this.old + "->" + this.nue + "]";
        }
    }

    private final class DoFiring
    implements Runnable,
    Comparator {
        private DoFiring() {
        }

        public void run() {
            ChangeFirer changeFirer = ChangeFirer.this;
            synchronized (changeFirer) {
                TreeSet treeSet = new TreeSet(this);
                treeSet.addAll(ChangeFirer.this.changes);
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    Change change = (Change)iterator.next();
                    if (change.source instanceof Module) {
                        ((Module)((Object)change.source)).firePropertyChange0(change.prop, change.old, change.nue);
                        continue;
                    }
                    if (change.source == ChangeFirer.this.mgr) {
                        ChangeFirer.this.mgr.firePropertyChange(change.prop, change.old, change.nue);
                        continue;
                    }
                    throw new IllegalStateException("Strange source: " + change.source);
                }
                ChangeFirer.this.changes.clear();
                if (!ChangeFirer.this.modulesCreated.isEmpty() || !ChangeFirer.this.modulesDeleted.isEmpty()) {
                    ChangeFirer.this.mgr.fireModulesCreatedDeleted(ChangeFirer.this.modulesCreated, ChangeFirer.this.modulesDeleted);
                }
                ChangeFirer.this.modulesCreated.clear();
                ChangeFirer.this.modulesDeleted.clear();
            }
        }

        public int compare(Object object, Object object2) {
            Change change = (Change)object;
            Change change2 = (Change)object2;
            int n = change.count - change2.count;
            if (n != 0) {
                return n;
            }
            return System.identityHashCode(change) - System.identityHashCode(change2);
        }
    }
}

