/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.core.projects.FixedFileSystem;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class HelpHelper {
    private static final String menudir = "Menu/Help/HelpShortcuts/";
    private static final String actiondir = "Actions/Help/";
    private static final String helpsetdir = "Services/JavaHelp/";

    private HelpHelper() {
    }

    public static void addHelpSet(String string, ClassLoader classLoader) {
        block9: {
            if (string == null) {
                throw new NullPointerException();
            }
            String string2 = HelpHelper.computeHCFilename(string);
            FixedFileSystem fixedFileSystem = FixedFileSystem.getDefault();
            try {
                Object object;
                XMLReader xMLReader = XMLUtil.createXMLReader();
                HelpSetHandler helpSetHandler = new HelpSetHandler();
                xMLReader.setContentHandler(helpSetHandler);
                xMLReader.setErrorHandler(helpSetHandler);
                xMLReader.setEntityResolver(helpSetHandler);
                xMLReader.setDTDHandler(helpSetHandler);
                URL uRL = HelpHelper.findHelpSet(string, classLoader);
                if (uRL == null) {
                    throw new FileNotFoundException(string);
                }
                xMLReader.parse(new InputSource(uRL.toString()));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                try {
                    object = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
                    ((PrintWriter)object).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    ((PrintWriter)object).println("<!DOCTYPE helpsetref PUBLIC \"-//NetBeans//DTD JavaHelp Help Set Reference 1.0//EN\" \"http://www.netbeans.org/dtds/helpsetref-1_0.dtd\">");
                    ((PrintWriter)object).print("<helpsetref url=\"");
                    ((PrintWriter)object).print(XMLUtil.toAttributeValue((String)("nbdocs:/" + string)));
                    ((PrintWriter)object).println("\" merge=\"true\"/>");
                    ((PrintWriter)object).flush();
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    byteArrayOutputStream.close();
                    throw throwable;
                }
                byteArrayOutputStream.close();
                object = byteArrayOutputStream.toByteArray();
                fixedFileSystem.add(helpsetdir + string2, new FixedFileSystem.Instance(false, "text/xml", (byte[])object, helpSetHandler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/empty.gif")));
                if (helpSetHandler.homeID == null) break block9;
                byteArrayOutputStream = new ByteArrayOutputStream(1000);
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
                    printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    printWriter.println("<!DOCTYPE helpctx PUBLIC \"-//NetBeans//DTD Help Context 1.0//EN\" \"http://www.netbeans.org/dtds/helpcontext-1_0.dtd\">");
                    printWriter.print("<helpctx id=\"");
                    printWriter.print(XMLUtil.toAttributeValue((String)helpSetHandler.homeID));
                    printWriter.println("\" showmaster=\"false\"/>");
                    printWriter.flush();
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    byteArrayOutputStream.close();
                    throw throwable;
                }
                byteArrayOutputStream.close();
                object = byteArrayOutputStream.toByteArray();
                fixedFileSystem.add(menudir + string2, new FixedFileSystem.Instance(false, "text/xml", (byte[])object, helpSetHandler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/empty.gif")));
                fixedFileSystem.add(actiondir + string2, new FixedFileSystem.Instance(false, "text/xml", (byte[])object, helpSetHandler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/help.gif")));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
        }
    }

    private static String computeHCFilename(String string) {
        if (string.endsWith(".hs")) {
            string = string.substring(0, string.length() - 3);
        }
        return string.replace('/', '-') + ".xml";
    }

    public static void removeHelpSet(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = HelpHelper.computeHCFilename(string);
        String string3 = "nbdocs:/" + string;
        FixedFileSystem fixedFileSystem = FixedFileSystem.getDefault();
        fixedFileSystem.remove(helpsetdir + string2);
        fixedFileSystem.remove(menudir + string2);
        fixedFileSystem.remove(actiondir + string2);
    }

    public static boolean validateHelpSet(String string, ClassLoader classLoader) {
        return HelpHelper.findHelpSet(string, classLoader) != null;
    }

    private static URL findHelpSet(String string, ClassLoader classLoader) {
        URL uRL = classLoader.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        URL uRL2 = HelpHelper.findHelpSetInDocs(string, System.getProperty("netbeans.home"));
        if (uRL2 != null) {
            return uRL2;
        }
        return HelpHelper.findHelpSetInDocs(string, System.getProperty("netbeans.user"));
    }

    private static URL findHelpSetInDocs(String string, String string2) {
        File file;
        File file2;
        if (string2 != null && (file2 = new File(string2, "docs")).isDirectory() && (file = new File(file2, string.replace('/', File.separatorChar))).isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                return null;
            }
        }
        return null;
    }

    static final class HelpSetHandler
    extends DefaultHandler {
        private String title = null;
        private String homeID = null;
        private boolean inTitle = false;
        private boolean inHomeID = false;
        private StringBuffer pcdata = new StringBuffer();

        HelpSetHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("title")) {
                this.inTitle = true;
            } else if (string3.equals("homeID")) {
                this.inHomeID = true;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.inTitle) {
                this.title = this.pcdata.toString();
            } else if (this.inHomeID) {
                this.homeID = this.pcdata.toString();
            }
            this.pcdata.setLength(0);
            this.inTitle = false;
            this.inHomeID = false;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inTitle || this.inHomeID) {
                this.pcdata.append(cArray, n, n2);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if ("-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN".equals(string)) {
                return new InputSource("nbres:/org/netbeans/modules/javahelp/resources/helpset_1_0.dtd");
            }
            return null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

